/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.wafv2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.wafv2.model.FieldToMatch;
import com.amazonaws.services.wafv2.model.SensitivityLevel;
import com.amazonaws.services.wafv2.model.TextTransformation;
import com.amazonaws.services.wafv2.model.transform.SqliMatchStatementMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SqliMatchStatement
implements Serializable,
Cloneable,
StructuredPojo {
    private FieldToMatch fieldToMatch;
    private List<TextTransformation> textTransformations;
    private String sensitivityLevel;

    public void setFieldToMatch(FieldToMatch fieldToMatch) {
        this.fieldToMatch = fieldToMatch;
    }

    public FieldToMatch getFieldToMatch() {
        return this.fieldToMatch;
    }

    public SqliMatchStatement withFieldToMatch(FieldToMatch fieldToMatch) {
        this.setFieldToMatch(fieldToMatch);
        return this;
    }

    public List<TextTransformation> getTextTransformations() {
        return this.textTransformations;
    }

    public void setTextTransformations(Collection<TextTransformation> textTransformations) {
        if (textTransformations == null) {
            this.textTransformations = null;
            return;
        }
        this.textTransformations = new ArrayList<TextTransformation>(textTransformations);
    }

    public SqliMatchStatement withTextTransformations(TextTransformation ... textTransformations) {
        if (this.textTransformations == null) {
            this.setTextTransformations(new ArrayList<TextTransformation>(textTransformations.length));
        }
        for (TextTransformation ele : textTransformations) {
            this.textTransformations.add(ele);
        }
        return this;
    }

    public SqliMatchStatement withTextTransformations(Collection<TextTransformation> textTransformations) {
        this.setTextTransformations(textTransformations);
        return this;
    }

    public void setSensitivityLevel(String sensitivityLevel) {
        this.sensitivityLevel = sensitivityLevel;
    }

    public String getSensitivityLevel() {
        return this.sensitivityLevel;
    }

    public SqliMatchStatement withSensitivityLevel(String sensitivityLevel) {
        this.setSensitivityLevel(sensitivityLevel);
        return this;
    }

    public SqliMatchStatement withSensitivityLevel(SensitivityLevel sensitivityLevel) {
        this.sensitivityLevel = sensitivityLevel.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFieldToMatch() != null) {
            sb.append("FieldToMatch: ").append(this.getFieldToMatch()).append(",");
        }
        if (this.getTextTransformations() != null) {
            sb.append("TextTransformations: ").append(this.getTextTransformations()).append(",");
        }
        if (this.getSensitivityLevel() != null) {
            sb.append("SensitivityLevel: ").append(this.getSensitivityLevel());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SqliMatchStatement)) {
            return false;
        }
        SqliMatchStatement other = (SqliMatchStatement)obj;
        if (other.getFieldToMatch() == null ^ this.getFieldToMatch() == null) {
            return false;
        }
        if (other.getFieldToMatch() != null && !other.getFieldToMatch().equals(this.getFieldToMatch())) {
            return false;
        }
        if (other.getTextTransformations() == null ^ this.getTextTransformations() == null) {
            return false;
        }
        if (other.getTextTransformations() != null && !other.getTextTransformations().equals(this.getTextTransformations())) {
            return false;
        }
        if (other.getSensitivityLevel() == null ^ this.getSensitivityLevel() == null) {
            return false;
        }
        return other.getSensitivityLevel() == null || other.getSensitivityLevel().equals(this.getSensitivityLevel());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFieldToMatch() == null ? 0 : this.getFieldToMatch().hashCode());
        hashCode = 31 * hashCode + (this.getTextTransformations() == null ? 0 : this.getTextTransformations().hashCode());
        hashCode = 31 * hashCode + (this.getSensitivityLevel() == null ? 0 : this.getSensitivityLevel().hashCode());
        return hashCode;
    }

    public SqliMatchStatement clone() {
        try {
            return (SqliMatchStatement)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SqliMatchStatementMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

