/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.wafv2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.wafv2.model.Condition;
import com.amazonaws.services.wafv2.model.FilterBehavior;
import com.amazonaws.services.wafv2.model.FilterRequirement;
import com.amazonaws.services.wafv2.model.transform.FilterMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Filter
implements Serializable,
Cloneable,
StructuredPojo {
    private String behavior;
    private String requirement;
    private List<Condition> conditions;

    public void setBehavior(String behavior) {
        this.behavior = behavior;
    }

    public String getBehavior() {
        return this.behavior;
    }

    public Filter withBehavior(String behavior) {
        this.setBehavior(behavior);
        return this;
    }

    public Filter withBehavior(FilterBehavior behavior) {
        this.behavior = behavior.toString();
        return this;
    }

    public void setRequirement(String requirement) {
        this.requirement = requirement;
    }

    public String getRequirement() {
        return this.requirement;
    }

    public Filter withRequirement(String requirement) {
        this.setRequirement(requirement);
        return this;
    }

    public Filter withRequirement(FilterRequirement requirement) {
        this.requirement = requirement.toString();
        return this;
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public void setConditions(Collection<Condition> conditions) {
        if (conditions == null) {
            this.conditions = null;
            return;
        }
        this.conditions = new ArrayList<Condition>(conditions);
    }

    public Filter withConditions(Condition ... conditions) {
        if (this.conditions == null) {
            this.setConditions(new ArrayList<Condition>(conditions.length));
        }
        for (Condition ele : conditions) {
            this.conditions.add(ele);
        }
        return this;
    }

    public Filter withConditions(Collection<Condition> conditions) {
        this.setConditions(conditions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBehavior() != null) {
            sb.append("Behavior: ").append(this.getBehavior()).append(",");
        }
        if (this.getRequirement() != null) {
            sb.append("Requirement: ").append(this.getRequirement()).append(",");
        }
        if (this.getConditions() != null) {
            sb.append("Conditions: ").append(this.getConditions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Filter)) {
            return false;
        }
        Filter other = (Filter)obj;
        if (other.getBehavior() == null ^ this.getBehavior() == null) {
            return false;
        }
        if (other.getBehavior() != null && !other.getBehavior().equals(this.getBehavior())) {
            return false;
        }
        if (other.getRequirement() == null ^ this.getRequirement() == null) {
            return false;
        }
        if (other.getRequirement() != null && !other.getRequirement().equals(this.getRequirement())) {
            return false;
        }
        if (other.getConditions() == null ^ this.getConditions() == null) {
            return false;
        }
        return other.getConditions() == null || other.getConditions().equals(this.getConditions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBehavior() == null ? 0 : this.getBehavior().hashCode());
        hashCode = 31 * hashCode + (this.getRequirement() == null ? 0 : this.getRequirement().hashCode());
        hashCode = 31 * hashCode + (this.getConditions() == null ? 0 : this.getConditions().hashCode());
        return hashCode;
    }

    public Filter clone() {
        try {
            return (Filter)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FilterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

