/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.inference;

import com.azure.ai.inference.EmbeddingsClientBuilder;
import com.azure.ai.inference.implementation.EmbeddingsClientImpl;
import com.azure.ai.inference.implementation.models.EmbedRequest;
import com.azure.ai.inference.models.EmbeddingEncodingFormat;
import com.azure.ai.inference.models.EmbeddingInputType;
import com.azure.ai.inference.models.EmbeddingsResult;
import com.azure.ai.inference.models.ExtraParameters;
import com.azure.ai.inference.models.ModelInfo;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.BinaryData;
import com.azure.core.util.FluxUtil;
import java.util.List;
import reactor.core.publisher.Mono;

@ServiceClient(builder=EmbeddingsClientBuilder.class, isAsync=true)
public final class EmbeddingsAsyncClient {
    private final EmbeddingsClientImpl serviceClient;

    EmbeddingsAsyncClient(EmbeddingsClientImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<Response<BinaryData>> embedWithResponse(BinaryData embedRequest, RequestOptions requestOptions) {
        return this.serviceClient.embedWithResponseAsync(embedRequest, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<Response<BinaryData>> getModelInfoWithResponse(RequestOptions requestOptions) {
        return this.serviceClient.getModelInfoWithResponseAsync(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<EmbeddingsResult>> embedWithResponse(List<String> input, Integer dimensions, EmbeddingEncodingFormat encodingFormat, EmbeddingInputType inputType, String model, ExtraParameters extraParams) {
        RequestOptions requestOptions = new RequestOptions();
        EmbedRequest embedRequestObj = new EmbedRequest(input).setDimensions(dimensions).setEncodingFormat(encodingFormat).setInputType(inputType).setModel(model);
        BinaryData embedRequest = BinaryData.fromObject((Object)embedRequestObj);
        if (extraParams != null) {
            requestOptions.setHeader(HttpHeaderName.fromString((String)"extra-parameters"), extraParams.toString());
        }
        return this.embedWithResponse(embedRequest, requestOptions).map(protocolMethodData -> new SimpleResponse(protocolMethodData, (Object)((EmbeddingsResult)((BinaryData)protocolMethodData.getValue()).toObject(EmbeddingsResult.class))));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<EmbeddingsResult> embed(List<String> input, Integer dimensions, EmbeddingEncodingFormat encodingFormat, EmbeddingInputType inputType, String model, ExtraParameters extraParams) {
        RequestOptions requestOptions = new RequestOptions();
        EmbedRequest embedRequestObj = new EmbedRequest(input).setDimensions(dimensions).setEncodingFormat(encodingFormat).setInputType(inputType).setModel(model);
        BinaryData embedRequest = BinaryData.fromObject((Object)embedRequestObj);
        if (extraParams != null) {
            requestOptions.setHeader(HttpHeaderName.fromString((String)"extra-parameters"), extraParams.toString());
        }
        return this.embedWithResponse(embedRequest, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (EmbeddingsResult)protocolMethodData.toObject(EmbeddingsResult.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<EmbeddingsResult>> embedWithResponse(List<String> input) {
        RequestOptions requestOptions = new RequestOptions();
        EmbedRequest embedRequestObj = new EmbedRequest(input);
        BinaryData embedRequest = BinaryData.fromObject((Object)embedRequestObj);
        return this.embedWithResponse(embedRequest, requestOptions).map(protocolMethodData -> new SimpleResponse(protocolMethodData, (Object)((EmbeddingsResult)((BinaryData)protocolMethodData.getValue()).toObject(EmbeddingsResult.class))));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<EmbeddingsResult> embed(List<String> input) {
        RequestOptions requestOptions = new RequestOptions();
        EmbedRequest embedRequestObj = new EmbedRequest(input);
        BinaryData embedRequest = BinaryData.fromObject((Object)embedRequestObj);
        return this.embedWithResponse(embedRequest, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (EmbeddingsResult)protocolMethodData.toObject(EmbeddingsResult.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<ModelInfo> getModelInfo() {
        RequestOptions requestOptions = new RequestOptions();
        return this.getModelInfoWithResponse(requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (ModelInfo)protocolMethodData.toObject(ModelInfo.class));
    }
}

