/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.inference;

import com.azure.ai.inference.EmbeddingsClientBuilder;
import com.azure.ai.inference.implementation.EmbeddingsClientImpl;
import com.azure.ai.inference.implementation.models.EmbedRequest;
import com.azure.ai.inference.models.EmbeddingEncodingFormat;
import com.azure.ai.inference.models.EmbeddingInputType;
import com.azure.ai.inference.models.EmbeddingsResult;
import com.azure.ai.inference.models.ExtraParameters;
import com.azure.ai.inference.models.ModelInfo;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.BinaryData;
import java.util.List;

@ServiceClient(builder=EmbeddingsClientBuilder.class)
public final class EmbeddingsClient {
    private final EmbeddingsClientImpl serviceClient;

    EmbeddingsClient(EmbeddingsClientImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Response<BinaryData> embedWithResponse(BinaryData embedRequest, RequestOptions requestOptions) {
        return this.serviceClient.embedWithResponse(embedRequest, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Response<BinaryData> getModelInfoWithResponse(RequestOptions requestOptions) {
        return this.serviceClient.getModelInfoWithResponse(requestOptions);
    }

    public Response<EmbeddingsResult> embedWithResponse(List<String> input, Integer dimensions, EmbeddingEncodingFormat encodingFormat, EmbeddingInputType inputType, String model, ExtraParameters extraParams) {
        RequestOptions requestOptions = new RequestOptions();
        EmbedRequest embedRequestObj = new EmbedRequest(input).setDimensions(dimensions).setEncodingFormat(encodingFormat).setInputType(inputType).setModel(model);
        BinaryData embedRequest = BinaryData.fromObject((Object)embedRequestObj);
        if (extraParams != null) {
            requestOptions.setHeader(HttpHeaderName.fromString((String)"extra-parameters"), extraParams.toString());
        }
        Response<BinaryData> response = this.embedWithResponse(embedRequest, requestOptions);
        return new SimpleResponse(response, (Object)((EmbeddingsResult)((BinaryData)response.getValue()).toObject(EmbeddingsResult.class)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public EmbeddingsResult embed(List<String> input, Integer dimensions, EmbeddingEncodingFormat encodingFormat, EmbeddingInputType inputType, String model, ExtraParameters extraParams) {
        RequestOptions requestOptions = new RequestOptions();
        EmbedRequest embedRequestObj = new EmbedRequest(input).setDimensions(dimensions).setEncodingFormat(encodingFormat).setInputType(inputType).setModel(model);
        BinaryData embedRequest = BinaryData.fromObject((Object)embedRequestObj);
        if (extraParams != null) {
            requestOptions.setHeader(HttpHeaderName.fromString((String)"extra-parameters"), extraParams.toString());
        }
        return (EmbeddingsResult)((BinaryData)this.embedWithResponse(embedRequest, requestOptions).getValue()).toObject(EmbeddingsResult.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public EmbeddingsResult embed(List<String> input) {
        RequestOptions requestOptions = new RequestOptions();
        EmbedRequest embedRequestObj = new EmbedRequest(input);
        BinaryData embedRequest = BinaryData.fromObject((Object)embedRequestObj);
        return (EmbeddingsResult)((BinaryData)this.embedWithResponse(embedRequest, requestOptions).getValue()).toObject(EmbeddingsResult.class);
    }

    public Response<EmbeddingsResult> embedWithResponse(List<String> input) {
        RequestOptions requestOptions = new RequestOptions();
        EmbedRequest embedRequestObj = new EmbedRequest(input);
        BinaryData embedRequest = BinaryData.fromObject((Object)embedRequestObj);
        Response<BinaryData> response = this.embedWithResponse(embedRequest, requestOptions);
        return new SimpleResponse(response, (Object)((EmbeddingsResult)((BinaryData)response.getValue()).toObject(EmbeddingsResult.class)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    ModelInfo getModelInfo() {
        RequestOptions requestOptions = new RequestOptions();
        return (ModelInfo)((BinaryData)this.getModelInfoWithResponse(requestOptions).getValue()).toObject(ModelInfo.class);
    }
}

