/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.inference.models;

import com.azure.ai.inference.models.ChatCompletionsToolDefinition;
import com.azure.ai.inference.models.FunctionDefinition;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ChatCompletionsFunctionToolDefinition
extends ChatCompletionsToolDefinition {
    private String type = "function";
    private FunctionDefinition function;

    public ChatCompletionsFunctionToolDefinition(FunctionDefinition function) {
        super(function);
        this.function = function;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public FunctionDefinition getFunction() {
        return this.function;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("function", (JsonSerializable)this.function);
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    public static ChatCompletionsFunctionToolDefinition fromJson(JsonReader jsonReader) throws IOException {
        return (ChatCompletionsFunctionToolDefinition)jsonReader.readObject(reader -> {
            FunctionDefinition function = null;
            String type = "function";
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("function".equals(fieldName)) {
                    function = FunctionDefinition.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            ChatCompletionsFunctionToolDefinition deserializedChatCompletionsFunctionToolDefinition = new ChatCompletionsFunctionToolDefinition(function);
            deserializedChatCompletionsFunctionToolDefinition.type = type;
            return deserializedChatCompletionsFunctionToolDefinition;
        });
    }
}

