/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.inference.models;

import com.azure.ai.inference.models.ChatCompletionsToolCall;
import com.azure.ai.inference.models.ChatRequestMessage;
import com.azure.ai.inference.models.ChatRole;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class ChatRequestAssistantMessage
extends ChatRequestMessage {
    private ChatRole role = ChatRole.ASSISTANT;
    private String content;
    private List<ChatCompletionsToolCall> toolCalls;

    public ChatRequestAssistantMessage() {
    }

    public ChatRequestAssistantMessage(String content) {
        this.content = content;
    }

    @Override
    public ChatRole getRole() {
        return this.role;
    }

    public String getContent() {
        return this.content;
    }

    public ChatRequestAssistantMessage setContent(String content) {
        this.content = content;
        return this;
    }

    public List<ChatCompletionsToolCall> getToolCalls() {
        return this.toolCalls;
    }

    public ChatRequestAssistantMessage setToolCalls(List<ChatCompletionsToolCall> toolCalls) {
        this.toolCalls = toolCalls;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("role", this.role == null ? null : this.role.toString());
        jsonWriter.writeStringField("content", this.content);
        jsonWriter.writeArrayField("tool_calls", this.toolCalls, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ChatRequestAssistantMessage fromJson(JsonReader jsonReader) throws IOException {
        return (ChatRequestAssistantMessage)jsonReader.readObject(reader -> {
            ChatRequestAssistantMessage deserializedChatRequestAssistantMessage = new ChatRequestAssistantMessage();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("role".equals(fieldName)) {
                    deserializedChatRequestAssistantMessage.role = ChatRole.fromString(reader.getString());
                    continue;
                }
                if ("content".equals(fieldName)) {
                    deserializedChatRequestAssistantMessage.content = reader.getString();
                    continue;
                }
                if ("tool_calls".equals(fieldName)) {
                    List toolCalls;
                    deserializedChatRequestAssistantMessage.toolCalls = toolCalls = reader.readArray(reader1 -> ChatCompletionsToolCall.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedChatRequestAssistantMessage;
        });
    }
}

