/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.serializer.json.jackson;

import com.azure.core.serializer.json.jackson.implementation.ObjectMapperShim;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.JsonSerializer;
import com.azure.core.util.serializer.MemberNameConverter;
import com.azure.core.util.serializer.TypeReference;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.Member;
import reactor.core.publisher.Mono;

public final class JacksonJsonSerializer
implements JsonSerializer,
MemberNameConverter {
    private static final ClientLogger LOGGER = new ClientLogger(JacksonJsonSerializer.class);
    private final ObjectMapperShim mapper;

    JacksonJsonSerializer(ObjectMapperShim mapper) {
        this.mapper = mapper;
    }

    ObjectMapperShim getMapper() {
        return this.mapper;
    }

    public <T> T deserializeFromBytes(byte[] data, TypeReference<T> typeReference) {
        if (data == null) {
            return null;
        }
        try {
            return this.mapper.readValue(data, typeReference.getJavaType());
        }
        catch (IOException ex) {
            throw LOGGER.logExceptionAsError((RuntimeException)new UncheckedIOException(ex));
        }
    }

    public <T> T deserialize(InputStream stream, TypeReference<T> typeReference) {
        if (stream == null) {
            return null;
        }
        try {
            return this.mapper.readValue(stream, typeReference.getJavaType());
        }
        catch (IOException ex) {
            throw LOGGER.logExceptionAsError((RuntimeException)new UncheckedIOException(ex));
        }
    }

    public <T> Mono<T> deserializeFromBytesAsync(byte[] data, TypeReference<T> typeReference) {
        return Mono.fromCallable(() -> this.deserializeFromBytes(data, typeReference));
    }

    public <T> Mono<T> deserializeAsync(InputStream stream, TypeReference<T> typeReference) {
        return Mono.fromCallable(() -> this.deserialize(stream, typeReference));
    }

    public byte[] serializeToBytes(Object value) {
        try {
            return this.mapper.writeValueAsBytes(value);
        }
        catch (IOException ex) {
            throw LOGGER.logExceptionAsError((RuntimeException)new UncheckedIOException(ex));
        }
    }

    public void serialize(OutputStream stream, Object value) {
        try {
            this.mapper.writeValue(stream, value);
        }
        catch (IOException ex) {
            throw LOGGER.logExceptionAsError((RuntimeException)new UncheckedIOException(ex));
        }
    }

    public Mono<byte[]> serializeToBytesAsync(Object value) {
        return Mono.fromCallable(() -> this.serializeToBytes(value));
    }

    public Mono<Void> serializeAsync(OutputStream stream, Object value) {
        return Mono.fromRunnable(() -> this.serialize(stream, value));
    }

    public String convertMemberName(Member member) {
        return this.mapper.convertMemberName(member);
    }
}

