/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.serializer.json.jackson.implementation;

import com.azure.core.serializer.json.jackson.implementation.JacksonJsonReader;
import com.azure.core.serializer.json.jackson.implementation.JacksonJsonWriter;
import com.azure.json.JsonOptions;
import com.azure.json.JsonReader;
import com.azure.json.JsonWriter;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.core.json.JsonWriteFeature;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Objects;

public final class AzureJsonUtils {
    private static final JsonFactory FACTORY = JsonFactory.builder().build();

    public static JsonReader createReader(byte[] json, JsonOptions options) throws IOException {
        Objects.requireNonNull(json, "JSON source cannot be null when creating a JsonReader.");
        return new JacksonJsonReader(AzureJsonUtils.configureParser(FACTORY.createParser(json), options), json, null, true, options);
    }

    public static JsonReader createReader(String json, JsonOptions options) throws IOException {
        Objects.requireNonNull(json, "JSON source cannot be null when creating a JsonReader.");
        return new JacksonJsonReader(AzureJsonUtils.configureParser(FACTORY.createParser(json), options), null, json, true, options);
    }

    public static JsonReader createReader(InputStream json, JsonOptions options) throws IOException {
        Objects.requireNonNull(json, "JSON source cannot be null when creating a JsonReader.");
        return new JacksonJsonReader(AzureJsonUtils.configureParser(FACTORY.createParser(json), options), null, null, false, options);
    }

    public static JsonReader createReader(Reader json, JsonOptions options) throws IOException {
        Objects.requireNonNull(json, "JSON source cannot be null when creating a JsonReader.");
        return new JacksonJsonReader(AzureJsonUtils.configureParser(FACTORY.createParser(json), options), null, null, false, options);
    }

    private static JsonParser configureParser(JsonParser parser, JsonOptions options) {
        boolean nonNumericSupported = options == null || options.isNonNumericNumbersSupported();
        boolean commentsSupported = options != null && options.isJsoncSupported();
        return parser.configure(JsonReadFeature.ALLOW_NON_NUMERIC_NUMBERS.mappedFeature(), nonNumericSupported).configure(JsonParser.Feature.ALLOW_COMMENTS, commentsSupported);
    }

    public static JsonReader createReader(JsonParser parser) {
        return new JacksonJsonReader(parser, null, null, false, null);
    }

    public static JsonWriter createWriter(OutputStream json, JsonOptions options) throws IOException {
        Objects.requireNonNull(json, "JSON target cannot be null when creating a JsonWriter.");
        return new JacksonJsonWriter(AzureJsonUtils.configureGenerator(FACTORY.createGenerator(json), options));
    }

    public static JsonWriter createWriter(Writer json, JsonOptions options) throws IOException {
        Objects.requireNonNull(json, "JSON target cannot be null when creating a JsonWriter.");
        return new JacksonJsonWriter(AzureJsonUtils.configureGenerator(FACTORY.createGenerator(json), options));
    }

    private static JsonGenerator configureGenerator(JsonGenerator generator, JsonOptions options) {
        boolean nonNumericSupported = options == null || options.isNonNumericNumbersSupported();
        return generator.configure(JsonWriteFeature.WRITE_NAN_AS_STRINGS.mappedFeature(), nonNumericSupported);
    }

    public static JsonWriter createWriter(JsonGenerator generator) {
        return new JacksonJsonWriter(generator);
    }

    private AzureJsonUtils() {
    }
}

