/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.CosmosItemSerializer;
import com.azure.cosmos.implementation.Document;
import com.azure.cosmos.implementation.Resource;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class InternalObjectNode
extends Resource {
    private static final ObjectMapper MAPPER = Utils.getSimpleObjectMapper();

    public InternalObjectNode() {
    }

    public InternalObjectNode(byte[] bytes) {
        super(bytes);
    }

    public InternalObjectNode(ByteBuffer byteBuffer) {
        super(byteBuffer);
    }

    @Override
    public InternalObjectNode setId(String id) {
        super.setId(id);
        return this;
    }

    public InternalObjectNode(String jsonString) {
        super(jsonString);
    }

    public InternalObjectNode(ObjectNode propertyBag) {
        super(propertyBag);
    }

    public static InternalObjectNode fromObjectToInternalObjectNode(Object cosmosItem) {
        if (cosmosItem instanceof InternalObjectNode) {
            return (InternalObjectNode)cosmosItem;
        }
        if (cosmosItem instanceof byte[]) {
            return new InternalObjectNode((byte[])cosmosItem);
        }
        if (cosmosItem instanceof ObjectNode) {
            return new InternalObjectNode((ObjectNode)cosmosItem);
        }
        try {
            return new InternalObjectNode(MAPPER.writeValueAsString(cosmosItem));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Can't serialize the object into the json string", e);
        }
    }

    public static Document fromObject(Object cosmosItem) {
        if (cosmosItem instanceof InternalObjectNode) {
            return new Document(((InternalObjectNode)cosmosItem).toJson());
        }
        if (cosmosItem instanceof byte[]) {
            return new Document((byte[])cosmosItem);
        }
        if (cosmosItem instanceof ObjectNode) {
            return new Document(new InternalObjectNode((ObjectNode)cosmosItem).toJson());
        }
        try {
            return new Document(MAPPER.writeValueAsString(cosmosItem));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Can't serialize the object into the json string", e);
        }
    }

    public static ByteBuffer serializeJsonToByteBuffer(Object cosmosItem, CosmosItemSerializer itemSerializer, String trackingId) {
        Preconditions.checkNotNull(itemSerializer, "Argument 'itemSerializer' must not be null.");
        if (cosmosItem instanceof InternalObjectNode) {
            InternalObjectNode internalObjectNode = (InternalObjectNode)cosmosItem;
            Consumer<Map<String, Object>> onAfterSerialization = null;
            if (trackingId != null) {
                onAfterSerialization = node -> node.put("_trackingId", trackingId);
            }
            return internalObjectNode.serializeJsonToByteBuffer(itemSerializer, onAfterSerialization);
        }
        if (cosmosItem instanceof Document) {
            Document doc = (Document)cosmosItem;
            Consumer<Map<String, Object>> onAfterSerialization = null;
            if (trackingId != null) {
                onAfterSerialization = node -> node.put("_trackingId", trackingId);
            }
            return doc.serializeJsonToByteBuffer(itemSerializer, onAfterSerialization);
        }
        if (cosmosItem instanceof ObjectNode) {
            ObjectNode objectNode = (ObjectNode)cosmosItem;
            Consumer<Map<String, Object>> onAfterSerialization = null;
            if (trackingId != null) {
                onAfterSerialization = node -> node.put("_trackingId", trackingId);
            }
            return new InternalObjectNode(objectNode).serializeJsonToByteBuffer(itemSerializer, onAfterSerialization);
        }
        if (cosmosItem instanceof byte[]) {
            if (trackingId != null) {
                InternalObjectNode internalObjectNode = new InternalObjectNode((byte[])cosmosItem);
                return internalObjectNode.serializeJsonToByteBuffer(itemSerializer, node -> node.put("_trackingId", trackingId));
            }
            return ByteBuffer.wrap((byte[])cosmosItem);
        }
        Consumer<Map<String, Object>> onAfterSerialization = null;
        if (trackingId != null) {
            onAfterSerialization = node -> node.put("_trackingId", trackingId);
        }
        return Utils.serializeJsonToByteBuffer(itemSerializer, cosmosItem, onAfterSerialization);
    }

    static <T> List<T> getTypedResultsFromV2Results(List<Document> results, Class<T> klass) {
        return results.stream().map(document -> document.toObject(klass)).collect(Collectors.toList());
    }

    public <T> T getObject(Class<T> klass) throws IOException {
        if (klass == ObjectNode.class) {
            return (T)this.getPropertyBag();
        }
        return (T)MAPPER.treeToValue((TreeNode)this.getPropertyBag(), klass);
    }
}

