/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.CosmosAsyncClient;
import com.azure.cosmos.implementation.CosmosPagedFluxOptions;
import com.azure.cosmos.implementation.FeedOperationState;
import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.OperationType;
import com.azure.cosmos.implementation.RequestOptions;
import com.azure.cosmos.implementation.ResourceType;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.models.CosmosQueryRequestOptions;
import com.azure.cosmos.models.ModelBridgeInternal;

public final class QueryFeedOperationState
extends FeedOperationState {
    private static final ImplementationBridgeHelpers.CosmosQueryRequestOptionsHelper.CosmosQueryRequestOptionsAccessor qryOptAccessor = ImplementationBridgeHelpers.CosmosQueryRequestOptionsHelper.getCosmosQueryRequestOptionsAccessor();
    private final CosmosQueryRequestOptions options;
    private final RequestOptions requestOptions;

    public QueryFeedOperationState(CosmosAsyncClient cosmosAsyncClient, String spanName, String dbName, String containerName, ResourceType resourceType, OperationType operationType, String operationId, CosmosQueryRequestOptions queryRequestOptions, CosmosPagedFluxOptions fluxOptions) {
        super(cosmosAsyncClient, spanName, dbName, containerName, resourceType, Preconditions.checkNotNull(operationType, "Argument 'operationType' must not be null."), operationId, clientAccessor.getEffectiveConsistencyLevel(cosmosAsyncClient, operationType, queryRequestOptions.getConsistencyLevel()), clientAccessor.getEffectiveDiagnosticsThresholds(cosmosAsyncClient, qryOptAccessor.getImpl(Preconditions.checkNotNull(queryRequestOptions, "Argument 'queryRequestOptions' must not be null.")).getThresholds()), fluxOptions, QueryFeedOperationState.getEffectiveMaxItemCount(fluxOptions, queryRequestOptions));
        Integer maxItemCountFromRequestOptions;
        String requestOptionsContinuation = qryOptAccessor.getRequestContinuation(queryRequestOptions);
        if (requestOptionsContinuation != null && (fluxOptions == null || fluxOptions.getRequestContinuation() == null)) {
            this.setRequestContinuation(requestOptionsContinuation);
            if (fluxOptions != null) {
                fluxOptions.setRequestContinuation(requestOptionsContinuation);
            }
        }
        if ((maxItemCountFromRequestOptions = qryOptAccessor.getMaxItemCount(queryRequestOptions)) != null && (fluxOptions == null || fluxOptions.getMaxItemCount() == null)) {
            this.setMaxItemCount(maxItemCountFromRequestOptions);
            if (fluxOptions != null) {
                fluxOptions.setMaxItemCount(maxItemCountFromRequestOptions);
            }
        }
        this.options = qryOptAccessor.clone(queryRequestOptions);
        this.setMaxItemCountCore(this.getMaxItemCount());
        this.setRequestContinuationCore(this.getRequestContinuation());
        this.requestOptions = qryOptAccessor.toRequestOptions(this.options);
    }

    public RequestOptions toRequestOptions() {
        return this.requestOptions;
    }

    public CosmosQueryRequestOptions getQueryOptions() {
        return this.options;
    }

    @Override
    public void setRequestContinuation(String requestContinuation) {
        super.setRequestContinuation(requestContinuation);
        this.setRequestContinuationCore(requestContinuation);
    }

    private void setRequestContinuationCore(String requestContinuation) {
        if (this.options != null) {
            ModelBridgeInternal.setQueryRequestOptionsContinuationToken(this.options, requestContinuation);
        }
    }

    @Override
    public void setMaxItemCount(Integer maxItemCount) {
        super.setMaxItemCount(maxItemCount);
        this.setMaxItemCountCore(maxItemCount);
    }

    private void setMaxItemCountCore(Integer maxItemCount) {
        if (this.options != null) {
            ModelBridgeInternal.setQueryRequestOptionsMaxItemCount(this.options, maxItemCount);
        }
    }

    private static Integer getEffectiveMaxItemCount(CosmosPagedFluxOptions pagedFluxOptions, CosmosQueryRequestOptions queryOptions) {
        if (pagedFluxOptions != null && pagedFluxOptions.getMaxItemCount() != null) {
            return pagedFluxOptions.getMaxItemCount();
        }
        if (queryOptions == null) {
            return null;
        }
        return qryOptAccessor.getMaxItemCount(queryOptions);
    }
}

