/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.batch;

import com.azure.cosmos.CosmosItemSerializer;
import com.azure.cosmos.implementation.JsonSerializable;
import com.azure.cosmos.implementation.RequestOptions;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.implementation.batch.CosmosItemOperationBase;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.implementation.patch.PatchUtil;
import com.azure.cosmos.models.CosmosItemOperationType;
import com.azure.cosmos.models.CosmosPatchOperations;
import com.azure.cosmos.models.ModelBridgeInternal;
import com.azure.cosmos.models.PartitionKey;

public final class ItemBatchOperation<TInternal>
extends CosmosItemOperationBase {
    private final TInternal item;
    private final String id;
    private final PartitionKey partitionKey;
    private final CosmosItemOperationType operationType;
    private final RequestOptions requestOptions;
    private CosmosItemSerializer effectiveItemSerializerForResult;

    public ItemBatchOperation(CosmosItemOperationType operationType, String id, PartitionKey partitionKey, RequestOptions requestOptions, TInternal item) {
        Preconditions.checkNotNull(operationType, "expected non-null operationType");
        this.operationType = operationType;
        this.partitionKey = partitionKey;
        this.id = id;
        this.item = item;
        this.requestOptions = requestOptions;
    }

    @Override
    public CosmosItemSerializer getEffectiveItemSerializerForResult() {
        return this.effectiveItemSerializerForResult != null ? this.effectiveItemSerializerForResult : CosmosItemSerializer.DEFAULT_SERIALIZER;
    }

    @Override
    JsonSerializable getSerializedOperationInternal(CosmosItemSerializer effectiveItemSerializer) {
        JsonSerializable jsonSerializable = new JsonSerializable();
        this.effectiveItemSerializerForResult = effectiveItemSerializer;
        jsonSerializable.set("operationType", ModelBridgeInternal.getOperationValueForCosmosItemOperationType(this.getOperationType()), CosmosItemSerializer.DEFAULT_SERIALIZER);
        if (StringUtils.isNotEmpty(this.getId())) {
            jsonSerializable.set("id", this.getId(), CosmosItemSerializer.DEFAULT_SERIALIZER);
        }
        if (this.getItemInternal() != null) {
            if (this.getOperationType() == CosmosItemOperationType.PATCH) {
                jsonSerializable.set("resourceBody", PatchUtil.serializableBatchPatchOperation((CosmosPatchOperations)this.getItemInternal(), this.getRequestOptions()), CosmosItemSerializer.DEFAULT_SERIALIZER);
            } else {
                jsonSerializable.set("resourceBody", this.getItemInternal(), effectiveItemSerializer, true);
            }
        }
        if (this.getRequestOptions() != null) {
            RequestOptions requestOptions = this.getRequestOptions();
            if (StringUtils.isNotEmpty(requestOptions.getIfMatchETag())) {
                jsonSerializable.set("ifMatch", requestOptions.getIfMatchETag(), CosmosItemSerializer.DEFAULT_SERIALIZER);
            }
            if (StringUtils.isNotEmpty(requestOptions.getIfNoneMatchETag())) {
                jsonSerializable.set("ifNoneMatch", requestOptions.getIfNoneMatchETag(), CosmosItemSerializer.DEFAULT_SERIALIZER);
            }
        }
        return jsonSerializable;
    }

    TInternal getItemInternal() {
        return this.item;
    }

    @Override
    public <T> T getItem() {
        return (T)this.item;
    }

    @Override
    public <T> T getContext() {
        return null;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public PartitionKey getPartitionKeyValue() {
        return this.partitionKey;
    }

    @Override
    public CosmosItemOperationType getOperationType() {
        return this.operationType;
    }

    public RequestOptions getRequestOptions() {
        return this.requestOptions;
    }
}

