/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.directconnectivity;

import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.directconnectivity.StorePayload;
import com.fasterxml.jackson.databind.JsonNode;
import io.netty.buffer.ByteBufInputStream;
import java.io.IOException;
import java.io.InputStream;

public class JsonNodeStorePayload
implements StorePayload<JsonNode> {
    private final int responsePayloadSize;
    private final JsonNode jsonValue;

    public JsonNodeStorePayload(ByteBufInputStream bufferStream, int readableBytes) {
        if (readableBytes > 0) {
            this.responsePayloadSize = readableBytes;
            this.jsonValue = JsonNodeStorePayload.fromJson(bufferStream);
        } else {
            this.responsePayloadSize = 0;
            this.jsonValue = null;
        }
    }

    private static JsonNode fromJson(ByteBufInputStream bufferStream) {
        try {
            return Utils.getSimpleObjectMapper().readTree((InputStream)bufferStream);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to parse JSON.", e);
        }
    }

    @Override
    public int getResponsePayloadSize() {
        return this.responsePayloadSize;
    }

    @Override
    public JsonNode getPayload() {
        return this.jsonValue;
    }
}

