/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.query;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosItemSerializer;
import com.azure.cosmos.implementation.DistinctClientSideRequestStatisticsCollection;
import com.azure.cosmos.implementation.Document;
import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.QueryMetrics;
import com.azure.cosmos.implementation.Strings;
import com.azure.cosmos.implementation.query.IDocumentQueryExecutionComponent;
import com.azure.cosmos.implementation.query.PipelinedDocumentQueryParams;
import com.azure.cosmos.implementation.query.QueryInfo;
import com.azure.cosmos.models.FeedResponse;
import com.azure.cosmos.models.ModelBridgeInternal;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import reactor.core.publisher.Flux;

public class DCountDocumentQueryExecutionContext
implements IDocumentQueryExecutionComponent<Document> {
    private static final ImplementationBridgeHelpers.CosmosDiagnosticsHelper.CosmosDiagnosticsAccessor diagnosticsAccessor = ImplementationBridgeHelpers.CosmosDiagnosticsHelper.getCosmosDiagnosticsAccessor();
    private final IDocumentQueryExecutionComponent<Document> component;
    private final QueryInfo info;
    private long count;
    private final ConcurrentMap<String, QueryMetrics> queryMetricsMap = new ConcurrentHashMap<String, QueryMetrics>();

    private DCountDocumentQueryExecutionContext(IDocumentQueryExecutionComponent<Document> component, QueryInfo info, long count) {
        if (component == null) {
            throw new IllegalArgumentException("documentQueryExecutionComponent cannot be null");
        }
        this.component = component;
        this.count = count;
        this.info = info;
    }

    public static Flux<IDocumentQueryExecutionComponent<Document>> createAsync(BiFunction<String, PipelinedDocumentQueryParams<Document>, Flux<IDocumentQueryExecutionComponent<Document>>> createSourceComponentFunction, QueryInfo info, String continuationToken, PipelinedDocumentQueryParams<Document> documentQueryParams) {
        return createSourceComponentFunction.apply(continuationToken, documentQueryParams).map(component -> new DCountDocumentQueryExecutionContext((IDocumentQueryExecutionComponent<Document>)component, info, 0L));
    }

    @Override
    public Flux<FeedResponse<Document>> drainAsync(int maxPageSize) {
        return this.component.drainAsync(maxPageSize).collectList().map(superList -> {
            double requestCharge = 0.0;
            HashMap<String, String> headers = new HashMap<String, String>();
            DistinctClientSideRequestStatisticsCollection diagnostics = new DistinctClientSideRequestStatisticsCollection();
            for (FeedResponse page : superList) {
                diagnostics.addAll(diagnosticsAccessor.getClientSideRequestStatisticsForQueryPipelineAggregations(page.getCosmosDiagnostics()));
                this.count += (long)page.getResults().size();
                requestCharge += page.getRequestCharge();
                QueryMetrics.mergeQueryMetricsMap(this.queryMetricsMap, BridgeInternal.queryMetricsFromFeedResponse(page));
            }
            Document result = new Document();
            if (Strings.isNullOrEmpty(this.info.getDCountAlias())) {
                if (this.info.hasSelectValue()) {
                    result.set("_value", this.count, CosmosItemSerializer.DEFAULT_SERIALIZER);
                } else {
                    result.set("$1", this.count, CosmosItemSerializer.DEFAULT_SERIALIZER);
                }
            } else {
                result.set(this.info.getDCountAlias(), this.count, CosmosItemSerializer.DEFAULT_SERIALIZER);
            }
            headers.put("x-ms-request-charge", Double.toString(requestCharge));
            FeedResponse<Document> frp = BridgeInternal.createFeedResponseWithQueryMetrics(Collections.singletonList(result), headers, this.queryMetricsMap, null, false, false, null);
            diagnosticsAccessor.addClientSideDiagnosticsToFeed(frp.getCosmosDiagnostics(), diagnostics);
            return BridgeInternal.createFeedResponseWithQueryMetrics(Collections.singletonList(result), headers, BridgeInternal.queryMetricsFromFeedResponse(frp), ModelBridgeInternal.getQueryPlanDiagnosticsContext(frp), false, false, frp.getCosmosDiagnostics());
        }).flux();
    }
}

