/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.core.util.MetricsOptions;
import com.azure.cosmos.implementation.Configs;
import com.azure.cosmos.implementation.CosmosMicrometerMetricsConfig;
import com.azure.cosmos.implementation.clienttelemetry.CosmosMeterOptions;
import com.azure.cosmos.implementation.clienttelemetry.MetricCategory;
import com.azure.cosmos.implementation.clienttelemetry.TagName;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.models.CosmosMetricCategory;
import com.azure.cosmos.models.CosmosMetricName;
import com.azure.cosmos.models.CosmosMetricTagName;
import com.azure.cosmos.models.CosmosMicrometerMeterOptions;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import java.util.AbstractCollection;
import java.util.EnumSet;
import java.util.concurrent.ConcurrentHashMap;

public final class CosmosMicrometerMetricsOptions
extends MetricsOptions {
    private MeterRegistry clientMetricRegistry = Metrics.globalRegistry;
    private EnumSet<MetricCategory> metricCategories;
    private EnumSet<TagName> defaultTagNames;
    private double[] defaultPercentiles;
    private boolean defaultShouldPublishHistograms;
    private boolean defaultApplyDiagnosticThresholdsForTransportLevelMeters;
    private final ConcurrentHashMap<CosmosMetricName, CosmosMeterOptions> effectiveOptions = new ConcurrentHashMap();

    public CosmosMicrometerMetricsOptions() {
        CosmosMicrometerMetricsConfig metricsConfig = Configs.getMetricsConfig();
        this.setMetricCategoriesFromConfig(metricsConfig.getMetricCategories());
        this.setTagNamesFromConfig(metricsConfig.getTagNames());
        this.configureDefaultPercentiles(metricsConfig.getPercentiles());
        this.defaultShouldPublishHistograms = metricsConfig.getEnableHistograms();
        this.defaultApplyDiagnosticThresholdsForTransportLevelMeters = metricsConfig.getApplyDiagnosticThresholdsForTransportLevelMeters();
    }

    MeterRegistry getClientMetricRegistry() {
        return this.clientMetricRegistry;
    }

    public CosmosMicrometerMetricsOptions meterRegistry(MeterRegistry clientMetricMeterRegistry) {
        this.clientMetricRegistry = clientMetricMeterRegistry == null ? Metrics.globalRegistry : clientMetricMeterRegistry;
        return this;
    }

    public CosmosMicrometerMetricsOptions configureDefaultTagNames(CosmosMetricTagName ... tags) {
        if (tags == null || tags.length == 0) {
            this.defaultTagNames = TagName.DEFAULT_TAGS.clone();
        } else {
            Object newTagNames = TagName.MINIMUM_TAGS.clone();
            for (CosmosMetricTagName t : tags) {
                for (TagName tagName : t.getTagNames()) {
                    ((AbstractCollection)newTagNames).add(tagName);
                }
            }
            this.defaultTagNames = newTagNames;
        }
        return this;
    }

    CosmosMicrometerMetricsOptions setTagNamesFromConfig(EnumSet<TagName> tags) {
        if (tags == null || tags.size() == 0) {
            this.defaultTagNames = TagName.DEFAULT_TAGS.clone();
        } else {
            Object newTagNames = TagName.MINIMUM_TAGS.clone();
            ((AbstractCollection)newTagNames).addAll(tags);
            this.defaultTagNames = newTagNames;
        }
        return this;
    }

    public CosmosMicrometerMetricsOptions configureDefaultPercentiles(double ... percentiles) {
        if (percentiles == null || percentiles.length == 0) {
            this.defaultPercentiles = null;
        } else {
            for (double p : percentiles) {
                if (!(p < 0.0) && !(p > 1.0)) continue;
                throw new IllegalArgumentException(String.format("Percentile '%d' is outside of valid range.", p));
            }
            this.defaultPercentiles = (double[])percentiles.clone();
        }
        return this;
    }

    public CosmosMicrometerMetricsOptions enableHistogramsByDefault(boolean publishHistograms) {
        this.defaultShouldPublishHistograms = publishHistograms;
        return this;
    }

    public CosmosMicrometerMetricsOptions applyDiagnosticThresholdsForTransportLevelMeters(boolean isEnabled) {
        this.defaultApplyDiagnosticThresholdsForTransportLevelMeters = isEnabled;
        return this;
    }

    public CosmosMicrometerMetricsOptions setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        return this;
    }

    public CosmosMicrometerMetricsOptions setMetricCategories(CosmosMetricCategory ... categories) {
        if (categories == null || categories.length == 0) {
            this.metricCategories = MetricCategory.DEFAULT_CATEGORIES.clone();
        } else {
            Object newMetricCategories = MetricCategory.MINIMAL_CATEGORIES.clone();
            for (CosmosMetricCategory c : categories) {
                for (MetricCategory metricCategory : c.getCategories()) {
                    ((AbstractCollection)newMetricCategories).add(metricCategory);
                }
            }
            this.metricCategories = newMetricCategories;
        }
        return this;
    }

    CosmosMicrometerMetricsOptions setMetricCategoriesFromConfig(EnumSet<MetricCategory> categories) {
        if (categories == null || categories.size() == 0) {
            this.metricCategories = MetricCategory.DEFAULT_CATEGORIES.clone();
        } else {
            Object newMetricCategories = MetricCategory.MINIMAL_CATEGORIES.clone();
            ((AbstractCollection)newMetricCategories).addAll(categories);
            this.metricCategories = newMetricCategories;
        }
        return this;
    }

    public CosmosMicrometerMetricsOptions addMetricCategories(CosmosMetricCategory ... categories) {
        if (categories == null || categories.length == 0) {
            return this;
        }
        Object newMetricCategories = this.metricCategories.clone();
        for (CosmosMetricCategory c : categories) {
            for (MetricCategory metricCategory : c.getCategories()) {
                ((AbstractCollection)newMetricCategories).add(metricCategory);
            }
        }
        this.metricCategories = newMetricCategories;
        return this;
    }

    public CosmosMicrometerMetricsOptions removeMetricCategories(CosmosMetricCategory ... categories) {
        if (categories == null || categories.length == 0) {
            return this;
        }
        Object newMetricCategories = this.metricCategories.clone();
        for (CosmosMetricCategory c : categories) {
            for (MetricCategory metricCategory : c.getCategories()) {
                ((AbstractCollection)newMetricCategories).remove((Object)metricCategory);
            }
        }
        for (MetricCategory metricCategory : CosmosMetricCategory.MINIMUM.getCategories()) {
            ((AbstractCollection)newMetricCategories).add(metricCategory);
        }
        this.metricCategories = newMetricCategories;
        return this;
    }

    public CosmosMicrometerMetricsOptions configureMeter(CosmosMetricName meterName, CosmosMicrometerMeterOptions options) {
        this.effectiveOptions.compute(meterName, (name, valueBeforeUpdate) -> {
            if (valueBeforeUpdate == null) {
                return new CosmosMeterOptions((CosmosMetricName)name, options.getIsEnabled() != null ? options.getIsEnabled() : true, options.getPercentiles() != null ? options.getPercentiles() : this.defaultPercentiles, options.getIsHistogramPublishingEnabled() != null ? options.getIsHistogramPublishingEnabled() : this.defaultShouldPublishHistograms, options.getSuppressedTagNames() != null ? options.getSuppressedTagNames() : EnumSet.noneOf(TagName.class), options.getApplyDiagnosticThresholdsEnabled() != null ? options.getApplyDiagnosticThresholdsEnabled() : this.defaultApplyDiagnosticThresholdsForTransportLevelMeters && (meterName.getCategory() == CosmosMetricCategory.REQUEST_SUMMARY || meterName.getCategory() == CosmosMetricCategory.REQUEST_DETAILS));
            }
            return new CosmosMeterOptions((CosmosMetricName)name, options.getIsEnabled() != null ? options.getIsEnabled().booleanValue() : valueBeforeUpdate.isEnabled(), options.getPercentiles() != null ? options.getPercentiles() : valueBeforeUpdate.getPercentiles(), options.getIsHistogramPublishingEnabled() != null ? options.getIsHistogramPublishingEnabled().booleanValue() : valueBeforeUpdate.isHistogramPublishingEnabled(), options.getSuppressedTagNames() != null ? options.getSuppressedTagNames() : valueBeforeUpdate.getSuppressedTagNames(), valueBeforeUpdate.isDiagnosticThresholdsFilteringEnabled());
        });
        return this;
    }

    CosmosMeterOptions getMeterOptions(CosmosMetricName meterName) {
        Preconditions.checkNotNull(meterName, "Argument 'meterName' must not be null.");
        return this.effectiveOptions.computeIfAbsent(meterName, name -> new CosmosMeterOptions((CosmosMetricName)name, true, this.defaultPercentiles, this.defaultShouldPublishHistograms, EnumSet.noneOf(TagName.class), this.defaultApplyDiagnosticThresholdsForTransportLevelMeters));
    }

    EnumSet<MetricCategory> getMetricCategories() {
        return this.metricCategories;
    }

    EnumSet<TagName> getDefaultTagNames() {
        return this.defaultTagNames;
    }

    void configureDefaultTagNames(EnumSet<TagName> newTagNames) {
        this.defaultTagNames = newTagNames;
    }

    double[] getDefaultPercentiles() {
        return this.defaultPercentiles;
    }

    boolean shouldPublishHistograms() {
        return this.defaultShouldPublishHistograms;
    }

    boolean shouldApplyDiagnosticThresholdsForTransportLevelMeters() {
        return this.defaultApplyDiagnosticThresholdsForTransportLevelMeters;
    }
}

