/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.implementation.models.NGramTokenFilterV1;
import com.azure.search.documents.indexes.implementation.models.NGramTokenFilterV2;
import com.azure.search.documents.indexes.models.TokenFilter;
import java.io.IOException;

public final class NGramTokenFilter
extends TokenFilter {
    private final NGramTokenFilterV1 v1Filter;
    private final NGramTokenFilterV2 v2Filter;

    NGramTokenFilter(NGramTokenFilterV1 v1Filter) {
        super(v1Filter.getName());
        this.v1Filter = v1Filter;
        this.v2Filter = null;
    }

    NGramTokenFilter(NGramTokenFilterV2 v2Filter) {
        super(v2Filter.getName());
        this.v1Filter = null;
        this.v2Filter = v2Filter;
    }

    public NGramTokenFilter(String name) {
        super(name);
        this.v1Filter = null;
        this.v2Filter = new NGramTokenFilterV2(name);
    }

    public Integer getMinGram() {
        return this.v1Filter != null ? this.v1Filter.getMinGram() : this.v2Filter.getMinGram();
    }

    public NGramTokenFilter setMinGram(Integer minGram) {
        if (this.v1Filter != null) {
            this.v1Filter.setMinGram(minGram);
        } else {
            this.v2Filter.setMinGram(minGram);
        }
        return this;
    }

    public Integer getMaxGram() {
        return this.v1Filter != null ? this.v1Filter.getMaxGram() : this.v2Filter.getMaxGram();
    }

    public NGramTokenFilter setMaxGram(Integer maxGram) {
        if (this.v1Filter != null) {
            this.v1Filter.setMaxGram(maxGram);
        } else {
            this.v2Filter.setMaxGram(maxGram);
        }
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        return this.v1Filter != null ? this.v1Filter.toJson(jsonWriter) : this.v2Filter.toJson(jsonWriter);
    }
}

