/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.models.VectorQuery;
import com.azure.search.documents.models.VectorQueryKind;
import java.io.IOException;
import java.util.List;

public final class VectorizedQuery
extends VectorQuery {
    private VectorQueryKind kind = VectorQueryKind.VECTOR;
    private final List<Float> vector;

    public VectorizedQuery(List<Float> vector) {
        this.vector = vector;
    }

    @Override
    public VectorQueryKind getKind() {
        return this.kind;
    }

    public List<Float> getVector() {
        return this.vector;
    }

    @Override
    public VectorizedQuery setKNearestNeighborsCount(Integer kNearestNeighborsCount) {
        super.setKNearestNeighborsCount(kNearestNeighborsCount);
        return this;
    }

    @Override
    public VectorizedQuery setFields(String ... fields) {
        super.setFields(fields);
        return this;
    }

    @Override
    public VectorizedQuery setExhaustive(Boolean exhaustive) {
        super.setExhaustive(exhaustive);
        return this;
    }

    @Override
    public VectorizedQuery setOversampling(Double oversampling) {
        super.setOversampling(oversampling);
        return this;
    }

    @Override
    public VectorizedQuery setWeight(Float weight) {
        super.setWeight(weight);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("k", (Number)this.getKNearestNeighborsCount());
        jsonWriter.writeStringField("fields", this.getFields());
        jsonWriter.writeBooleanField("exhaustive", this.isExhaustive());
        jsonWriter.writeNumberField("oversampling", (Number)this.getOversampling());
        jsonWriter.writeNumberField("weight", (Number)this.getWeight());
        jsonWriter.writeArrayField("vector", this.vector, (writer, element) -> writer.writeFloat(element.floatValue()));
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        return jsonWriter.writeEndObject();
    }

    public static VectorizedQuery fromJson(JsonReader jsonReader) throws IOException {
        return (VectorizedQuery)jsonReader.readObject(reader -> {
            Integer kNearestNeighborsCount = null;
            String fields = null;
            Boolean exhaustive = null;
            Double oversampling = null;
            Float weight = null;
            boolean vectorFound = false;
            List vector = null;
            VectorQueryKind kind = VectorQueryKind.VECTOR;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("k".equals(fieldName)) {
                    kNearestNeighborsCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("fields".equals(fieldName)) {
                    fields = reader.getString();
                    continue;
                }
                if ("exhaustive".equals(fieldName)) {
                    exhaustive = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("oversampling".equals(fieldName)) {
                    oversampling = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("weight".equals(fieldName)) {
                    weight = (Float)reader.getNullable(JsonReader::getFloat);
                    continue;
                }
                if ("vector".equals(fieldName)) {
                    vector = reader.readArray(reader1 -> Float.valueOf(reader1.getFloat()));
                    vectorFound = true;
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    kind = VectorQueryKind.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            if (vectorFound) {
                VectorizedQuery deserializedVectorizedQuery = new VectorizedQuery(vector);
                deserializedVectorizedQuery.setKNearestNeighborsCount(kNearestNeighborsCount);
                deserializedVectorizedQuery.setFields(fields);
                deserializedVectorizedQuery.setExhaustive(exhaustive);
                deserializedVectorizedQuery.setOversampling(oversampling);
                deserializedVectorizedQuery.setWeight(weight);
                deserializedVectorizedQuery.kind = kind;
                return deserializedVectorizedQuery;
            }
            throw new IllegalStateException("Missing required property: vector");
        });
    }
}

