/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.spring.boot.autoconfigure;

import com.baidu.brpc.spring.annotation.RpcExporter;
import com.baidu.brpc.spring.boot.autoconfigure.AbstractRegister;
import java.util.Collection;
import java.util.HashMap;
import java.util.stream.Collectors;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.context.annotation.AnnotationBeanNameGenerator;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.ClassUtils;

public class RpcExporterRegister
extends AbstractRegister
implements ImportBeanDefinitionRegistrar {
    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        HashMap<Class, String> serviceExporterMap = new HashMap<Class, String>();
        AnnotationBeanNameGenerator beanNameGenerator = new AnnotationBeanNameGenerator();
        Collection<BeanDefinition> candidates = this.getCandidates(this.resourceLoader);
        for (BeanDefinition candidate : candidates) {
            Class<?> clazz = this.getClass(candidate.getBeanClassName());
            Class[] interfaces = ClassUtils.getAllInterfacesForClass(clazz);
            if (interfaces.length != 1) {
                throw new BeanInitializationException("bean interface num must equal 1, " + clazz.getName());
            }
            String serviceBeanName = beanNameGenerator.generateBeanName(candidate, registry);
            String old = serviceExporterMap.putIfAbsent(interfaces[0], serviceBeanName);
            if (old != null) {
                throw new RuntimeException("interface already be exported by bean name:" + old);
            }
            registry.registerBeanDefinition(serviceBeanName, candidate);
        }
    }

    private Collection<BeanDefinition> getCandidates(ResourceLoader resourceLoader) {
        ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false, this.environment);
        scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(RpcExporter.class));
        scanner.setResourceLoader(resourceLoader);
        return AutoConfigurationPackages.get((BeanFactory)this.beanFactory).stream().flatMap(basePackage -> scanner.findCandidateComponents(basePackage).stream()).collect(Collectors.toSet());
    }
}

