/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.spring.boot.autoconfigure;

import com.baidu.bjf.remoting.protobuf.utils.JDKCompilerHelper;
import com.baidu.bjf.remoting.protobuf.utils.compiler.Compiler;
import com.baidu.brpc.client.RpcClientOptions;
import com.baidu.brpc.interceptor.Interceptor;
import com.baidu.brpc.naming.NamingServiceFactory;
import com.baidu.brpc.server.RpcServerOptions;
import com.baidu.brpc.spring.RpcProxyFactoryBean;
import com.baidu.brpc.spring.RpcServiceExporter;
import com.baidu.brpc.spring.annotation.AbstractAnnotationParserCallback;
import com.baidu.brpc.spring.annotation.RpcAnnotationResolverListener;
import com.baidu.brpc.spring.annotation.RpcExporter;
import com.baidu.brpc.spring.annotation.RpcProxy;
import com.baidu.brpc.spring.boot.autoconfigure.config.BrpcConfig;
import com.baidu.brpc.spring.boot.autoconfigure.config.BrpcProperties;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.core.PriorityOrdered;
import org.springframework.util.ClassUtils;

public class SpringBootAnnotationResolver
extends AbstractAnnotationParserCallback
implements InitializingBean,
PriorityOrdered {
    private static final Logger log = LoggerFactory.getLogger(SpringBootAnnotationResolver.class);
    private BrpcProperties brpcProperties;
    private List<RpcProxyFactoryBean> rpcClients = new ArrayList<RpcProxyFactoryBean>();
    private Map<Integer, RpcServiceExporter> portMappingExporters = new HashMap<Integer, RpcServiceExporter>();
    private Compiler compiler;
    private String namingServiceUrl;
    private NamingServiceFactory namingServiceFactory;
    private RpcAnnotationResolverListener protobufRpcAnnotationResolverListener;
    private int order = 0x7FFFFFFC;

    public Object annotationAtField(Annotation t, Object value, String beanName, PropertyValues pvs, DefaultListableBeanFactory beanFactory, Field field) throws BeansException {
        if (t instanceof RpcProxy) {
            try {
                log.info("Annotation 'BrpcProxy' on field '" + field.getName() + "' for target '" + beanName + "' created");
                return this.parseRpcProxyAnnotation((RpcProxy)t, field.getType(), beanFactory);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return value;
    }

    public Object annotationAtMethod(Annotation t, Object bean, String beanName, PropertyValues pvs, DefaultListableBeanFactory beanFactory, Method method) throws BeansException {
        if (t instanceof RpcProxy) {
            try {
                log.info("Annotation 'BrpcProxy' on method '" + method.getName() + "' for target '" + beanName + "' created");
                return this.parseRpcProxyAnnotation((RpcProxy)t, method.getParameterTypes()[0], beanFactory);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return null;
    }

    public Object annotationAtType(Annotation t, Object bean, String beanName, ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (t instanceof RpcExporter) {
            log.info("Annotation 'RpcExporter' for target '" + beanName + "' created");
            this.parseRpcExporterAnnotation((RpcExporter)t, beanFactory, beanFactory.getBean(beanName));
        }
        return bean;
    }

    public void annotationAtTypeAfterStarted(Annotation t, Object bean, String beanName, ConfigurableListableBeanFactory beanFactory) throws BeansException {
        Collection<RpcServiceExporter> values = this.portMappingExporters.values();
        for (RpcServiceExporter rpcServiceExporter : values) {
            try {
                rpcServiceExporter.afterPropertiesSet();
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    public void destroy() throws Exception {
        if (this.rpcClients != null) {
            for (RpcProxyFactoryBean bean : this.rpcClients) {
                try {
                    bean.destroy();
                }
                catch (Exception e) {
                    log.error(e.getMessage(), e.getCause());
                }
            }
        }
        if (this.portMappingExporters != null) {
            Collection<RpcServiceExporter> exporters = this.portMappingExporters.values();
            for (RpcServiceExporter rpcServiceExporter : exporters) {
                try {
                    rpcServiceExporter.destroy();
                }
                catch (Exception e) {
                    log.error(e.getMessage(), e.getCause());
                }
            }
        }
        if (this.protobufRpcAnnotationResolverListener != null) {
            this.protobufRpcAnnotationResolverListener.destroy();
        }
    }

    public Class<? extends Annotation> getTypeAnnotation() {
        return RpcExporter.class;
    }

    public List<Class<? extends Annotation>> getMethodFieldAnnotation() {
        ArrayList<Class<? extends Annotation>> list = new ArrayList<Class<? extends Annotation>>();
        list.add(RpcProxy.class);
        return list;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.compiler != null) {
            JDKCompilerHelper.setCompiler((Compiler)this.compiler);
        }
    }

    public int getOrder() {
        return this.order;
    }

    public void setCompiler(Compiler compiler) {
        this.compiler = compiler;
    }

    private void parseRpcExporterAnnotation(RpcExporter rpcExporter, ConfigurableListableBeanFactory beanFactory, Object bean) {
        Class serviceClass = AopUtils.getTargetClass((Object)bean);
        Class[] interfaces = ClassUtils.getAllInterfacesForClass((Class)serviceClass);
        if (interfaces.length != 1) {
            throw new RuntimeException("service interface num must equal 1, " + serviceClass.getName());
        }
        Class serviceInterface = interfaces[0];
        BrpcConfig brpcConfig = this.getServiceConfig((ListableBeanFactory)beanFactory, serviceInterface);
        Integer port = brpcConfig.getServer().getPort();
        RpcServiceExporter rpcServiceExporter = this.portMappingExporters.get(port);
        if (rpcServiceExporter == null) {
            rpcServiceExporter = new RpcServiceExporter();
            this.portMappingExporters.put(port, rpcServiceExporter);
            rpcServiceExporter.setServicePort(port.intValue());
            rpcServiceExporter.copyFrom((RpcServerOptions)brpcConfig.getServer());
            if (brpcConfig.getNaming() != null) {
                rpcServiceExporter.setNamingServiceUrl(brpcConfig.getNaming().getNamingServiceUrl());
            }
        }
        if (brpcConfig.getServer() != null && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{brpcConfig.getServer().getInterceptorBeanNames()})) {
            String[] interceptorNameArray;
            for (String interceptorBeanName : interceptorNameArray = brpcConfig.getServer().getInterceptorBeanNames().trim().split(",")) {
                Interceptor interceptor = (Interceptor)beanFactory.getBean(interceptorBeanName.trim(), Interceptor.class);
                if (rpcServiceExporter.getInterceptors().contains(interceptor)) continue;
                rpcServiceExporter.getInterceptors().add(interceptor);
            }
        }
        rpcServiceExporter.getServiceNamingOptions().put(bean, brpcConfig.getNaming());
        if (brpcConfig.getServer() != null && brpcConfig.getServer().isUseSharedThreadPool()) {
            rpcServiceExporter.getCustomOptionsServiceMap().put(brpcConfig.getServer(), bean);
        } else {
            rpcServiceExporter.getRegisterServices().add(bean);
        }
        if (this.protobufRpcAnnotationResolverListener != null) {
            this.protobufRpcAnnotationResolverListener.onRpcExporterAnnotationParsered(rpcExporter, port.intValue(), bean, rpcServiceExporter.getRegisterServices());
        }
    }

    private Object parseRpcProxyAnnotation(RpcProxy rpcProxy, Class serviceInterface, DefaultListableBeanFactory beanFactory) throws Exception {
        RpcProxyFactoryBean rpcProxyFactoryBean;
        String factoryBeanName = "&" + serviceInterface.getSimpleName();
        try {
            rpcProxyFactoryBean = (RpcProxyFactoryBean)beanFactory.getBean(factoryBeanName, RpcProxyFactoryBean.class);
            if (rpcProxyFactoryBean != null) {
                return rpcProxyFactoryBean.getObject();
            }
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
        rpcProxyFactoryBean = this.createRpcProxyFactoryBean(rpcProxy, beanFactory, serviceInterface);
        this.rpcClients.add(rpcProxyFactoryBean);
        Object object = rpcProxyFactoryBean.getObject();
        if (this.protobufRpcAnnotationResolverListener != null) {
            this.protobufRpcAnnotationResolverListener.onRpcProxyAnnotationParsed(rpcProxy, rpcProxyFactoryBean, rpcProxyFactoryBean.getObject());
        }
        return object;
    }

    private RpcProxyFactoryBean createRpcProxyFactoryBean(RpcProxy rpcProxy, DefaultListableBeanFactory beanFactory, Class serviceInterface) {
        String interceptorNames;
        GenericBeanDefinition beanDef = new GenericBeanDefinition();
        beanDef.setBeanClass(RpcProxyFactoryBean.class);
        beanDef.setDependsOn(new String[]{"brpcApplicationContextUtils"});
        MutablePropertyValues values = new MutablePropertyValues();
        BrpcConfig brpcConfig = this.getServiceConfig((ListableBeanFactory)beanFactory, serviceInterface);
        for (Field field : RpcClientOptions.class.getDeclaredFields()) {
            try {
                if (field.getType().equals(Logger.class)) continue;
                field.setAccessible(true);
                values.addPropertyValue(field.getName(), field.get((Object)brpcConfig.getClient()));
            }
            catch (Exception ex) {
                log.warn("field not exist:", (Throwable)ex);
            }
        }
        values.addPropertyValue("serviceInterface", (Object)serviceInterface);
        values.addPropertyValue("serviceId", (Object)rpcProxy.name());
        if (brpcConfig.getNaming() != null) {
            values.addPropertyValue("namingServiceUrl", (Object)brpcConfig.getNaming().getNamingServiceUrl());
            values.addPropertyValue("group", (Object)brpcConfig.getNaming().getGroup());
            values.addPropertyValue("version", (Object)brpcConfig.getNaming().getVersion());
            values.addPropertyValue("ignoreFailOfNamingService", (Object)brpcConfig.getNaming().isIgnoreFailOfNamingService());
        }
        if (!StringUtils.isBlank((CharSequence)(interceptorNames = brpcConfig.getClient().getInterceptorBeanNames()))) {
            String[] interceptorNameArray;
            ArrayList<Interceptor> customInterceptors = new ArrayList<Interceptor>();
            for (String interceptorBeanName : interceptorNameArray = interceptorNames.split(",")) {
                Interceptor interceptor = (Interceptor)beanFactory.getBean(interceptorBeanName, Interceptor.class);
                customInterceptors.add(interceptor);
            }
            values.addPropertyValue("interceptors", Arrays.asList(customInterceptors));
        }
        beanDef.setPropertyValues(values);
        String serviceInterfaceBeanName = serviceInterface.getSimpleName();
        beanFactory.registerBeanDefinition(serviceInterfaceBeanName, (BeanDefinition)beanDef);
        return (RpcProxyFactoryBean)beanFactory.getBean("&" + serviceInterfaceBeanName, RpcProxyFactoryBean.class);
    }

    private BrpcConfig getServiceConfig(ListableBeanFactory beanFactory, Class<?> serviceInterface) {
        if (this.brpcProperties == null) {
            this.brpcProperties = (BrpcProperties)beanFactory.getBean(BrpcProperties.class);
            if (this.brpcProperties == null) {
                throw new RuntimeException("bean of BrpcProperties is null");
            }
        }
        return this.brpcProperties.getServiceConfig(serviceInterface);
    }

    public void setBrpcProperties(BrpcProperties brpcProperties) {
        this.brpcProperties = brpcProperties;
    }

    public void setRpcClients(List<RpcProxyFactoryBean> rpcClients) {
        this.rpcClients = rpcClients;
    }

    public void setPortMappingExporters(Map<Integer, RpcServiceExporter> portMappingExporters) {
        this.portMappingExporters = portMappingExporters;
    }

    public void setNamingServiceUrl(String namingServiceUrl) {
        this.namingServiceUrl = namingServiceUrl;
    }

    public void setNamingServiceFactory(NamingServiceFactory namingServiceFactory) {
        this.namingServiceFactory = namingServiceFactory;
    }

    public void setProtobufRpcAnnotationResolverListener(RpcAnnotationResolverListener protobufRpcAnnotationResolverListener) {
        this.protobufRpcAnnotationResolverListener = protobufRpcAnnotationResolverListener;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public BrpcProperties getBrpcProperties() {
        return this.brpcProperties;
    }

    public List<RpcProxyFactoryBean> getRpcClients() {
        return this.rpcClients;
    }

    public Map<Integer, RpcServiceExporter> getPortMappingExporters() {
        return this.portMappingExporters;
    }

    public Compiler getCompiler() {
        return this.compiler;
    }

    public String getNamingServiceUrl() {
        return this.namingServiceUrl;
    }

    public NamingServiceFactory getNamingServiceFactory() {
        return this.namingServiceFactory;
    }

    public RpcAnnotationResolverListener getProtobufRpcAnnotationResolverListener() {
        return this.protobufRpcAnnotationResolverListener;
    }
}

