/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.springcloud.client.cluster.route.label;

import com.baidu.cloud.starlight.api.rpc.RpcContext;
import com.baidu.cloud.starlight.springcloud.client.cluster.ClusterSelector;
import com.baidu.cloud.starlight.springcloud.client.cluster.route.label.match.LabelParser;
import com.baidu.cloud.starlight.springcloud.client.cluster.route.label.match.LabelSelector;
import com.baidu.cloud.starlight.springcloud.client.cluster.route.label.match.LabelSelectorRequirement;
import com.baidu.cloud.starlight.springcloud.client.ribbon.StarlightRibbonServer;
import com.baidu.cloud.thirdparty.apache.commons.lang3.StringUtils;
import com.netflix.loadbalancer.Server;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LabelClusterSelector
extends ClusterSelector<StarlightRibbonServer> {
    private static final Logger LOG = LoggerFactory.getLogger(LabelClusterSelector.class);
    private LabelParser labelParser = new LabelParser();

    @Override
    public List<StarlightRibbonServer> selectorClusterInstances(List<StarlightRibbonServer> originList) {
        String labelSelector = (String)RpcContext.getContext().get("request_label_selector_route");
        RpcContext.getContext().remove("request_label_selector_route");
        if (originList == null || originList.isEmpty()) {
            return originList;
        }
        if (StringUtils.isEmpty((CharSequence)labelSelector)) {
            labelSelector = this.getMeta().get("label_selector_route");
        }
        if (StringUtils.isEmpty((CharSequence)labelSelector)) {
            return originList;
        }
        List<StarlightRibbonServer> result = originList;
        try {
            LabelSelector selector = this.labelParser.parse(labelSelector);
            if (selector.getMatchExpressions() != null) {
                result = originList.stream().filter(server -> this.matchLabels((StarlightRibbonServer)((Object)server), selector.getMatchExpressions())).collect(Collectors.toList());
                this.recordSelectorResult(labelSelector, originList, result);
            }
        }
        catch (Throwable e) {
            LOG.error("[LABEL_ROUTE]LabelClusterSelector#selectorClusterInstances failed, service: {}, label: {}", new Object[]{this.getServiceId(), labelSelector, e});
        }
        if (result == null || result.isEmpty()) {
            this.recordSelectorEmptyResult(labelSelector, originList);
        }
        return result;
    }

    private boolean matchLabels(StarlightRibbonServer server, List<LabelSelectorRequirement> expressions) {
        for (LabelSelectorRequirement expression : expressions) {
            if (this.matchLabel(server, expression)) continue;
            return false;
        }
        return true;
    }

    private boolean matchLabel(StarlightRibbonServer server, LabelSelectorRequirement expression) {
        if ("namespace".equals(expression.getKey())) {
            return true;
        }
        Map<String, String> meta = server.getMetadata();
        String value = meta != null ? meta.get(expression.getKey()) : null;
        return expression.labelValueMatch(value);
    }

    private void recordSelectorEmptyResult(String labelSelector, List<StarlightRibbonServer> origin) {
        LOG.info("[LABEL_ROUTE]The filtered servers is empty, serviceId:{}, label:{}, originServers:{}", new Object[]{this.getServiceId(), labelSelector, origin});
    }

    private void recordSelectorResult(String labelSelector, List<StarlightRibbonServer> origin, List<StarlightRibbonServer> result) {
        LOG.debug("[LABEL_ROUTE]Filter servers of service: {} by label: {}, servers: {}/{}, {}", new Object[]{this.getServiceId(), labelSelector, origin.size(), result.size(), result.stream().map(Server::getId).collect(Collectors.joining(","))});
    }
}

