/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.springcloud.client.ribbon;

import com.baidu.cloud.starlight.springcloud.client.properties.StarlightClientProperties;
import com.netflix.client.ClientFactory;
import com.netflix.client.config.CommonClientConfigKey;
import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.AbstractServerList;
import com.netflix.loadbalancer.AbstractServerListFilter;
import com.netflix.loadbalancer.BaseLoadBalancer;
import com.netflix.loadbalancer.IPing;
import com.netflix.loadbalancer.IRule;
import com.netflix.loadbalancer.Server;
import com.netflix.loadbalancer.ServerList;
import com.netflix.loadbalancer.ServerListFilter;
import com.netflix.loadbalancer.ServerListUpdater;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StarlightAwareDynamicLoadBalancer<T extends Server>
extends BaseLoadBalancer {
    private static final Logger LOGGER = LoggerFactory.getLogger(StarlightAwareDynamicLoadBalancer.class);
    protected AtomicBoolean serverListUpdateInProgress = new AtomicBoolean(false);
    volatile ServerList<T> serverListImpl;
    volatile ServerListFilter<T> filter;
    private StarlightClientProperties clientProperties;
    protected final ServerListUpdater.UpdateAction updateAction = new ServerListUpdater.UpdateAction(){

        public void doUpdate() {
            StarlightAwareDynamicLoadBalancer.this.updateListOfServers();
        }
    };
    protected volatile ServerListUpdater serverListUpdater;

    public StarlightAwareDynamicLoadBalancer(IClientConfig clientConfig, IRule rule, IPing ping, ServerList<T> serverList, ServerListFilter<T> filter, ServerListUpdater serverListUpdater, StarlightClientProperties clientProperties) {
        super(clientConfig, rule, ping);
        this.clientProperties = clientProperties;
        this.serverListImpl = serverList;
        this.filter = filter;
        this.serverListUpdater = serverListUpdater;
        if (filter instanceof AbstractServerListFilter) {
            ((AbstractServerListFilter)filter).setLoadBalancerStats(this.getLoadBalancerStats());
        }
        this.restOfInit(clientConfig);
    }

    public void initWithNiwsConfig(IClientConfig clientConfig) {
        try {
            ServerList niwsServerListImpl;
            super.initWithNiwsConfig(clientConfig);
            String niwsServerListClassName = clientConfig.getPropertyAsString(CommonClientConfigKey.NIWSServerListClassName, "com.netflix.loadbalancer.ConfigurationBasedServerList");
            this.serverListImpl = niwsServerListImpl = (ServerList)ClientFactory.instantiateInstanceWithClientConfig((String)niwsServerListClassName, (IClientConfig)clientConfig);
            if (niwsServerListImpl instanceof AbstractServerList) {
                AbstractServerListFilter niwsFilter = ((AbstractServerList)niwsServerListImpl).getFilterImpl(clientConfig);
                niwsFilter.setLoadBalancerStats(this.getLoadBalancerStats());
                this.filter = niwsFilter;
            }
            String serverListUpdaterClassName = clientConfig.getPropertyAsString(CommonClientConfigKey.ServerListUpdaterClassName, "com.netflix.loadbalancer.PollingServerListUpdater");
            this.serverListUpdater = (ServerListUpdater)ClientFactory.instantiateInstanceWithClientConfig((String)serverListUpdaterClassName, (IClientConfig)clientConfig);
            this.restOfInit(clientConfig);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while initializing NIWSDiscoveryLoadBalancer:" + clientConfig.getClientName() + ", niwsClientConfig:" + clientConfig, e);
        }
    }

    void restOfInit(IClientConfig clientConfig) {
        boolean primeConnection = this.isEnablePrimingConnections();
        this.setEnablePrimingConnections(false);
        this.enableAndInitLearnNewServersFeature();
        if (this.clientProperties.getFetchInstancesWhenInitEnabled(this.getName()).booleanValue()) {
            this.updateListOfServers();
        }
        if (primeConnection && this.getPrimeConnections() != null) {
            this.getPrimeConnections().primeConnections(this.getReachableServers());
        }
        this.setEnablePrimingConnections(primeConnection);
        LOGGER.info("DynamicServerListLoadBalancer for client {} initialized: {}", (Object)clientConfig.getClientName(), (Object)this.toString());
    }

    public void setServersList(List lsrv) {
        super.setServersList(lsrv);
        List serverList = lsrv;
        HashMap<String, List<Server>> serversInZones = new HashMap<String, List<Server>>();
        for (Server server : serverList) {
            this.getLoadBalancerStats().getSingleServerStat(server);
            String zone = server.getZone();
            if (zone == null) continue;
            ArrayList<Server> servers = (ArrayList<Server>)serversInZones.get(zone = zone.toLowerCase());
            if (servers == null) {
                servers = new ArrayList<Server>();
                serversInZones.put(zone, servers);
            }
            servers.add(server);
        }
        this.setServerListForZones(serversInZones);
    }

    protected void setServerListForZones(Map<String, List<Server>> zoneServersMap) {
        LOGGER.debug("Setting server list for zones: {}", zoneServersMap);
        this.getLoadBalancerStats().updateZoneServerMapping(zoneServersMap);
    }

    public ServerList<T> getServerListImpl() {
        return this.serverListImpl;
    }

    public void setServerListImpl(ServerList<T> niwsServerList) {
        this.serverListImpl = niwsServerList;
    }

    public ServerListFilter<T> getFilter() {
        return this.filter;
    }

    public void setFilter(ServerListFilter<T> filter) {
        this.filter = filter;
    }

    public ServerListUpdater getServerListUpdater() {
        return this.serverListUpdater;
    }

    public void setServerListUpdater(ServerListUpdater serverListUpdater) {
        this.serverListUpdater = serverListUpdater;
    }

    public void forceQuickPing() {
    }

    public void enableAndInitLearnNewServersFeature() {
        if (this.serverListUpdater != null) {
            LOGGER.info("Using serverListUpdater {}", (Object)this.serverListUpdater.getClass().getSimpleName());
            this.serverListUpdater.start(this.updateAction);
        }
    }

    private String getIdentifier() {
        return this.getClientConfig().getClientName();
    }

    public void stopServerListRefreshing() {
        if (this.serverListUpdater != null) {
            this.serverListUpdater.stop();
        }
    }

    public void updateListOfServers() {
        List servers = new ArrayList();
        if (this.serverListImpl != null) {
            servers = this.serverListImpl.getUpdatedListOfServers();
            LOGGER.debug("List of Servers for {} obtained from Discovery client: {}", (Object)this.getIdentifier(), servers);
            if (this.filter != null) {
                servers = this.filter.getFilteredListOfServers(servers);
                LOGGER.debug("Filtered List of Servers for {} obtained from Discovery client: {}", (Object)this.getIdentifier(), servers);
            }
        }
        this.updateAllServerList(servers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateAllServerList(List<T> ls) {
        if (this.serverListUpdateInProgress.compareAndSet(false, true)) {
            try {
                for (Server s : ls) {
                    s.setAlive(true);
                }
                this.setServersList(ls);
                super.forceQuickPing();
            }
            finally {
                this.serverListUpdateInProgress.set(false);
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DynamicServerListLoadBalancer:");
        sb.append(super.toString());
        sb.append("ServerList:" + String.valueOf(this.serverListImpl));
        return sb.toString();
    }

    public void shutdown() {
        super.shutdown();
        this.stopServerListRefreshing();
    }

    public StarlightClientProperties getClientProperties() {
        return this.clientProperties;
    }

    public void setClientProperties(StarlightClientProperties clientProperties) {
        this.clientProperties = clientProperties;
    }
}

