/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.springcloud.client.ribbon;

import com.baidu.cloud.starlight.springcloud.client.cluster.SingleStarlightClientManager;
import com.baidu.cloud.starlight.springcloud.client.cluster.route.RoutableServerListFilter;
import com.baidu.cloud.starlight.springcloud.client.outlier.OutlierEjectServerListFilter;
import com.baidu.cloud.starlight.springcloud.client.properties.StarlightClientProperties;
import com.baidu.cloud.starlight.springcloud.client.properties.StarlightRouteProperties;
import com.baidu.cloud.starlight.springcloud.client.ribbon.StarlightActiveLoadBalancer;
import com.baidu.cloud.starlight.springcloud.client.ribbon.StarlightServerListFilter;
import com.baidu.cloud.starlight.springcloud.client.shutdown.ShutdownServerListFilter;
import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.IPing;
import com.netflix.loadbalancer.IRule;
import com.netflix.loadbalancer.Server;
import com.netflix.loadbalancer.ServerList;
import com.netflix.loadbalancer.ServerListFilter;
import com.netflix.loadbalancer.ServerListUpdater;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class StarlightRibbonConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public OutlierEjectServerListFilter outlierEjectServerListFilter(IClientConfig config, SingleStarlightClientManager clientManager, StarlightClientProperties clientProperties) {
        return new OutlierEjectServerListFilter(clientManager, clientProperties, config.getClientName());
    }

    @Bean
    @ConditionalOnMissingBean
    public ShutdownServerListFilter shutdownServerListFilter(SingleStarlightClientManager clientManager, StarlightClientProperties clientProperties) {
        return new ShutdownServerListFilter(clientManager, clientProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    public RoutableServerListFilter routableServerListFilter(IClientConfig config, SingleStarlightClientManager clientManager, StarlightRouteProperties routeProperties) {
        return new RoutableServerListFilter(clientManager, routeProperties, config.getClientName());
    }

    @Bean(destroyMethod="destroy")
    @ConditionalOnMissingBean
    public StarlightActiveLoadBalancer starlightActiveLoadBalancer(SingleStarlightClientManager clientManager, IClientConfig config, ServerList<Server> serverList, ServerListFilter<Server> serverListFilter, IRule rule, IPing ping, ServerListUpdater serverListUpdater, List<StarlightServerListFilter> starlightFilters, StarlightClientProperties clientProperties) {
        StarlightActiveLoadBalancer starlightActiveLoadBalancer = new StarlightActiveLoadBalancer(clientManager, config, rule, ping, serverList, serverListFilter, serverListUpdater, clientProperties);
        starlightActiveLoadBalancer.setStarlightServerListFilters(starlightFilters);
        return starlightActiveLoadBalancer;
    }
}

