/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.springcloud.common;

import com.baidu.cloud.starlight.api.transport.PeerStatus;
import com.baidu.cloud.starlight.springcloud.client.outlier.OutlierDetectEvent;
import com.netflix.loadbalancer.Server;
import org.slf4j.Logger;

public class ClusterLogUtils {
    public static void logOutlierInstanceEject(Logger logger, String clientName, Server server, PeerStatus status) {
        String outlierReason = "unknow";
        if (status.getStatusReason() instanceof OutlierDetectEvent) {
            outlierReason = ((OutlierDetectEvent)status.getStatusReason()).outlierReason();
        }
        logger.info("[OUTLIER] Outlier instance eject: remoteName {}, instance {}, outlierTime {}, reason {}", new Object[]{clientName, server.getHostPort(), status.getStatusRecordTime(), outlierReason});
    }

    public static void logOutlierAppEject(Logger logger, String clientName, Integer originSize, Integer ejectCount, Integer maxEjectCount) {
        logger.info("[OUTLIER] Outlier app eject: remoteName {}, instanceNum {}, ejectNum {}, maxEjectNum {}", new Object[]{clientName, originSize, ejectCount, maxEjectCount});
    }

    public static void logOutlierRecoverySucc(Logger logger, String clientName, Server server, String recoveryReason, Integer lastEjectTime) {
        logger.info("[OUTLIER] Outlier recover succ: remoteName {}, instance {}, reason {}, lastEjectTime {}s", new Object[]{clientName, server.getHostPort(), recoveryReason, lastEjectTime});
    }

    public static void logOutlierRecoveryFail(Logger logger, String clientName, Server server, String failReason, Integer lastEjectTime, Integer nextEjectTime) {
        logger.info("[OUTLIER] Outlier recover fail: remoteName {}, instance {}, reason {}, lastEjectTime {}s, nextEjectTime {}s", new Object[]{clientName, server.getHostPort(), failReason, lastEjectTime, nextEjectTime});
    }
}

