/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.springcloud.server;

import com.baidu.cloud.starlight.api.rpc.StarlightServer;
import com.baidu.cloud.starlight.core.rpc.DefaultStarlightServer;
import com.baidu.cloud.starlight.springcloud.common.ApplicationContextUtils;
import com.baidu.cloud.starlight.springcloud.server.annotation.RpcService;
import com.baidu.cloud.starlight.springcloud.server.properties.StarlightServerProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={RpcService.class})
@EnableConfigurationProperties(value={StarlightServerProperties.class})
@ConditionalOnProperty(value={"starlight.server.enable"})
public class StarlightServerAutoConfiguration {
    @Bean(name={"StarlightServer"})
    public StarlightServer starlightServer(StarlightServerProperties serverProperties) {
        DefaultStarlightServer starlightServer = new DefaultStarlightServer(serverProperties.getHost(), ApplicationContextUtils.getServerPort(), serverProperties.transportConfig());
        starlightServer.init();
        starlightServer.serve();
        return starlightServer;
    }
}

