/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.springcloud.server.service;

import com.baidu.cloud.starlight.api.rpc.StarlightServer;
import com.baidu.cloud.starlight.api.rpc.config.ServiceConfig;
import com.baidu.cloud.starlight.springcloud.server.annotation.RpcService;
import com.baidu.cloud.starlight.springcloud.server.properties.StarlightServerProperties;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

public class RpcServiceBean
implements InitializingBean {
    private StarlightServer starlightServer;
    private Object target;
    private Class<?> targetInterfaceClass;
    @Autowired
    private StarlightServerProperties properties;
    private RpcService annotation;
    private com.baidu.cloud.starlight.api.rpc.RpcService rpcService;

    public void afterPropertiesSet() throws Exception {
        ServiceConfig serviceConfig = this.serviceConfig(this.annotation, this.properties);
        this.rpcService = new com.baidu.cloud.starlight.api.rpc.RpcService(this.targetInterfaceClass, this.target, serviceConfig);
        this.starlightServer.export(this.rpcService);
    }

    private ServiceConfig serviceConfig(RpcService annotation, StarlightServerProperties properties) {
        String filters;
        if (annotation == null && properties == null) {
            return null;
        }
        ServiceConfig serviceConfig = new ServiceConfig();
        if (properties != null) {
            serviceConfig.setFilters(properties.getFilters());
        }
        if (annotation != null) {
            if (!StringUtils.isEmpty((Object)annotation.filters())) {
                serviceConfig.setFilters(annotation.filters());
            }
            if (!StringUtils.isEmpty((Object)annotation.protocol())) {
                serviceConfig.setProtocol(annotation.protocol());
            }
            if (!StringUtils.isEmpty((Object)annotation.serviceId())) {
                serviceConfig.setServiceId(annotation.serviceId());
            }
        }
        filters = (filters = serviceConfig.getFilters()) != null && !filters.isEmpty() ? "servercontext,generic,servermonitor," + filters.trim() : "servercontext,generic,servermonitor";
        serviceConfig.setFilters(filters);
        return serviceConfig;
    }

    public void setStarlightServer(StarlightServer starlightServer) {
        this.starlightServer = starlightServer;
    }

    public void setTarget(Object target) {
        this.target = target;
    }

    public void setProperties(StarlightServerProperties properties) {
        this.properties = properties;
    }

    public void setTargetInterfaceClass(Class<?> targetInterfaceClass) {
        this.targetInterfaceClass = targetInterfaceClass;
    }

    public void setAnnotation(RpcService annotation) {
        this.annotation = annotation;
    }
}

