/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.springcloud.server.service;

import com.baidu.cloud.starlight.springcloud.server.annotation.RpcService;
import com.baidu.cloud.starlight.springcloud.server.service.RpcServiceBean;
import java.util.LinkedHashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.SingletonBeanRegistry;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.AnnotationBeanNameGenerator;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class RpcServicePostProcessor
implements BeanDefinitionRegistryPostProcessor,
ApplicationContextAware,
EnvironmentAware,
ResourceLoaderAware,
BeanClassLoaderAware,
Ordered {
    private static final Logger LOGGER = LoggerFactory.getLogger(RpcServicePostProcessor.class);
    private static final String RPC_SERVICE_BEAN_NAME_SUFFIX = "RpcService";
    private ApplicationContext applicationContext;
    private Environment environment;
    private ResourceLoader resourceLoader;
    private ClassLoader classLoader;
    private final Set<String> packagesToScan;

    public RpcServicePostProcessor(Set<String> packagesToScan) {
        this.packagesToScan = packagesToScan;
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        Set<String> resolvedPackagesToScan = this.resolvePackagesToScan(this.packagesToScan);
        if (!resolvedPackagesToScan.isEmpty()) {
            this.registerRpcServiceBean(resolvedPackagesToScan, registry);
        } else {
            LOGGER.warn("Register RpcService Bean has been ignored: packagesToScan is empty!");
        }
    }

    private void registerRpcServiceBean(Set<String> packagesToScan, BeanDefinitionRegistry registry) {
        ClassPathBeanDefinitionScanner scanner = new ClassPathBeanDefinitionScanner(registry, false, this.environment, this.resourceLoader);
        scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(RpcService.class));
        String[] stringPackages = new String[packagesToScan.size()];
        stringPackages = packagesToScan.toArray(stringPackages);
        scanner.scan(stringPackages);
        Set<BeanDefinitionHolder> definitionHolders = this.findRpcServiceBeanHolder(packagesToScan, scanner, registry);
        for (BeanDefinitionHolder definitionHolder : definitionHolders) {
            BeanDefinition beanDefinition = definitionHolder.getBeanDefinition();
            Class targetClass = ClassUtils.resolveClassName((String)beanDefinition.getBeanClassName(), (ClassLoader)this.classLoader);
            if (targetClass.getInterfaces().length == 0) {
                throw new IllegalArgumentException("@RpcService should be written on the implementation class, but is on {" + targetClass.getName() + "}");
            }
            Class<?> targetInterfaceClass = targetClass.getInterfaces()[0];
            RpcService rpcService = (RpcService)AnnotationUtils.findAnnotation((Class)targetClass, RpcService.class);
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(RpcServiceBean.class);
            builder.addPropertyReference("starlightServer", "StarlightServer");
            builder.addPropertyValue("targetInterfaceClass", targetInterfaceClass);
            builder.addPropertyReference("target", definitionHolder.getBeanName());
            builder.addPropertyValue("annotation", (Object)rpcService);
            AbstractBeanDefinition serviceBeanDefinition = builder.getBeanDefinition();
            String serviceBeanName = this.generateServiceBeanName(rpcService, targetInterfaceClass);
            registry.registerBeanDefinition(serviceBeanName, (BeanDefinition)serviceBeanDefinition);
        }
    }

    private Set<BeanDefinitionHolder> findRpcServiceBeanHolder(Set<String> packagesToScan, ClassPathBeanDefinitionScanner scanner, BeanDefinitionRegistry registry) {
        BeanNameGenerator beanNameGenerator = this.resolveBeanNameGenerator(registry);
        LinkedHashSet<BeanDefinitionHolder> beanDefinitions = new LinkedHashSet<BeanDefinitionHolder>();
        for (String basePackage : packagesToScan) {
            Set candidates = scanner.findCandidateComponents(basePackage);
            for (BeanDefinition candidate : candidates) {
                String beanName = beanNameGenerator.generateBeanName(candidate, registry);
                BeanDefinitionHolder definitionHolder = new BeanDefinitionHolder(candidate, beanName);
                beanDefinitions.add(definitionHolder);
            }
        }
        return beanDefinitions;
    }

    private BeanNameGenerator resolveBeanNameGenerator(BeanDefinitionRegistry registry) {
        BeanNameGenerator beanNameGenerator = null;
        if (registry instanceof SingletonBeanRegistry) {
            SingletonBeanRegistry singletonBeanRegistry = (SingletonBeanRegistry)SingletonBeanRegistry.class.cast(registry);
            beanNameGenerator = (BeanNameGenerator)singletonBeanRegistry.getSingleton("org.springframework.context.annotation.internalConfigurationBeanNameGenerator");
        }
        if (beanNameGenerator == null) {
            LOGGER.info("BeanNameGenerator bean can't be found in BeanFactory with name [org.springframework.context.annotation.internalConfigurationBeanNameGenerator]");
            LOGGER.info("BeanNameGenerator will be a instance of " + AnnotationBeanNameGenerator.class.getName() + " , it maybe a potential problem on bean name generation.");
            beanNameGenerator = new AnnotationBeanNameGenerator();
        }
        return beanNameGenerator;
    }

    private String generateServiceBeanName(RpcService rpcService, Class<?> targetInterfaceClass) {
        StringBuilder nameBuilder = new StringBuilder();
        nameBuilder.append(targetInterfaceClass.getName());
        nameBuilder.append(":");
        nameBuilder.append(RPC_SERVICE_BEAN_NAME_SUFFIX);
        return nameBuilder.toString();
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    private Set<String> resolvePackagesToScan(Set<String> packagesToScan) {
        LinkedHashSet<String> resolvedPackagesToScan = new LinkedHashSet<String>(packagesToScan.size());
        for (String packageToScan : packagesToScan) {
            if (!StringUtils.hasText((String)packageToScan)) continue;
            String resolvedPackageToScan = this.environment.resolvePlaceholders(packageToScan.trim());
            resolvedPackagesToScan.add(resolvedPackageToScan);
        }
        return resolvedPackagesToScan;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

