/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.springcloud.server.service;

import com.baidu.cloud.starlight.api.utils.StringUtils;
import com.baidu.cloud.starlight.springcloud.server.annotation.StarlightScan;
import com.baidu.cloud.starlight.springcloud.server.service.RpcServicePostProcessor;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.ClassUtils;

public class RpcServicesRegistrar
implements ImportBeanDefinitionRegistrar,
EnvironmentAware {
    private static final String STARLIGHT_SERVER_ENABLE_KEY = "starlight.server.enable";
    private static final String SERVER_ENABLE = "true";
    private Environment environment;

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        Map selfBasePackages;
        String serverEnable = this.environment.getProperty(STARLIGHT_SERVER_ENABLE_KEY);
        if (!StringUtils.hasText((String)serverEnable) || !serverEnable.trim().equalsIgnoreCase(SERVER_ENABLE)) {
            return;
        }
        HashSet<String> packagesToScan = new HashSet<String>();
        if (importingClassMetadata.hasAnnotation(StarlightScan.class.getName()) && (selfBasePackages = importingClassMetadata.getAnnotationAttributes(StarlightScan.class.getName())) != null && selfBasePackages.size() > 0) {
            packagesToScan.addAll(Arrays.asList((String[])selfBasePackages.get("basePackages")));
        }
        packagesToScan.add(ClassUtils.getPackageName((String)importingClassMetadata.getClassName()));
        this.registerRpcServicePostProcessor(packagesToScan, registry);
    }

    private void registerRpcServicePostProcessor(Set<String> packageToScan, BeanDefinitionRegistry registry) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(RpcServicePostProcessor.class);
        builder.addConstructorArgValue(packageToScan);
        AbstractBeanDefinition beanDefinition = builder.getBeanDefinition();
        BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)beanDefinition, (BeanDefinitionRegistry)registry);
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

