/*
 * Copyright (C) 2016 Baidu, Inc. All Rights Reserved.
 */
package com.baidubce.services.eip.model;

import com.baidubce.auth.BceCredentials;
import com.baidubce.model.AbstractBceRequest;
import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * The request for renewing eip.
 */
public class PurchaseReservedEipRequest extends AbstractBceRequest {
    /**
     * If the clientToken is not specified by the user, a random String generated by default algorithm will be used.
     * See more detail at
     * <a href = "https://bce.baidu.com/doc/EIP/API.html#.E9.80.9A.E7.94.A8.E8.AF.B4.E6.98.8E">
     *   BCE API doc</a>
     */
    @JsonIgnore
    private String clientToken;
    /**
     * eip address to be renewed
     */
    @JsonIgnore
    private String eip;
    /**
     * billing information.
     * just providing Reservation is enough
     */
    private Billing billing;

    public String getClientToken() {
        return clientToken;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getEip() {
        return eip;
    }

    public void setEip(String eip) {
        this.eip = eip;
    }

    public Billing getBilling() {
        return billing;
    }

    public void setBilling(Billing billing) {
        this.billing = billing;
    }

    public PurchaseReservedEipRequest withClientToken(String clientToken) {
        this.clientToken = clientToken;
        return this;
    }

    public PurchaseReservedEipRequest withEip(String eip) {
        this.eip = eip;
        return this;
    }

    public PurchaseReservedEipRequest withBilling(Billing billing) {
        this.billing = billing;
        return this;
    }

    public PurchaseReservedEipRequest withRequestCredentials(BceCredentials credentials) {
        this.setRequestCredentials(credentials);
        return this;
    }
}
