/*
 * Copyright (c) 2014 Baidu.com, Inc. All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
package com.baidubce.services.eipgroup.model;

import com.baidubce.auth.BceCredentials;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.services.eip.model.Billing;
import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * The request for purchaseReserving eip group.
 */
public class PurchaseReservedEipGroupRequest extends AbstractBceRequest {
    /**
     * An ASCII string whose length is less than 64.
     *
     * The request will be idempotent if clientToken is provided.
     * If the clientToken is not specified by the user, a random String generated by default algorithm will be used.
     * See more detail at
     * <a href = "https://bce.baidu.com/doc/BCC/API.html#.E5.B9.82.E7.AD.89.E6.80.A7">
     *     BCE API doc</a>
     */
    @JsonIgnore
    private String clientToken;

    /**
     * The id of eip group.
     */
    @JsonIgnore
    private String id;

    /**
     * The billing of eip group that will be purchaseReserved.
     */
    private Billing billing;

    /**
     * Configure billing for the request.
     *
     * @param billing The spec of PurchaseReservedEipGroupRequest
     * @return PurchaseReservedEipGroupRequest with specific billing
     */
    public PurchaseReservedEipGroupRequest withBilling(Billing billing) {
        this.billing = billing;
        return this;
    }

    /**
     * Configure id for the request.
     *
     * @param id The id of the eip group.
     * @return PurchaseReservedNatRequest with specific id
     */
    public PurchaseReservedEipGroupRequest withId(String id) {
        this.id = id;
        return this;
    }

    public String getClientToken() {
        return clientToken;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Billing getBilling() {
        return billing;
    }

    public void setBilling(Billing billing) {
        this.billing = billing;
    }

    @Override
    public AbstractBceRequest withRequestCredentials(BceCredentials credentials) {
        this.setRequestCredentials(credentials);
        return this;
    }
}
