/*
 * Copyright (C) 2020 Baidu, Inc. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
package com.baidubce.services.iotdmp.model.service.rulechain;

import com.baidubce.model.GenericAccountRequest;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;

@Data
@NoArgsConstructor
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class TopicEncodeRequest extends GenericAccountRequest {

    @NotNull
    private String productKey;
    @NotNull
    private String deviceName;
    @NotNull
    private BlinkDataType dataType;
    @NotNull
    private BlinkTopicInfo subDataType;
    private String typeName;
    private String description;

    public TopicEncodeRequest(String productKey, String deviceName,
                              BlinkDataType dataType, BlinkTopicInfo subDataType) {
        this.productKey = productKey;
        this.deviceName = deviceName;
        this.dataType = dataType;
        this.subDataType = subDataType;
    }
}
