/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.plugins.pagination;

import com.baomidou.mybatisplus.enums.DBType;
import com.baomidou.mybatisplus.exceptions.MybatisPlusException;
import com.baomidou.mybatisplus.plugins.pagination.IDialect;
import com.baomidou.mybatisplus.plugins.pagination.PageHelper;
import com.baomidou.mybatisplus.plugins.pagination.Pagination;
import com.baomidou.mybatisplus.plugins.pagination.dialects.DB2Dialect;
import com.baomidou.mybatisplus.plugins.pagination.dialects.H2Dialect;
import com.baomidou.mybatisplus.plugins.pagination.dialects.HSQLDialect;
import com.baomidou.mybatisplus.plugins.pagination.dialects.MariaDBDialect;
import com.baomidou.mybatisplus.plugins.pagination.dialects.MySqlDialect;
import com.baomidou.mybatisplus.plugins.pagination.dialects.OracleDialect;
import com.baomidou.mybatisplus.plugins.pagination.dialects.PostgreDialect;
import com.baomidou.mybatisplus.plugins.pagination.dialects.SQLServer2005Dialect;
import com.baomidou.mybatisplus.plugins.pagination.dialects.SQLServerDialect;
import com.baomidou.mybatisplus.plugins.pagination.dialects.SQLiteDialect;
import com.baomidou.mybatisplus.toolkit.StringUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ibatis.session.RowBounds;

public class DialectFactory {
    private static final Map<String, IDialect> dialectCache = new ConcurrentHashMap<String, IDialect>();

    public static String buildPaginationSql(Pagination page, String buildSql, DBType dbType, String dialectClazz) throws Exception {
        return DialectFactory.getDialect(dbType, dialectClazz).buildPaginationSql(buildSql, PageHelper.offsetCurrent((Pagination)page), page.getSize());
    }

    public static String buildPaginationSql(RowBounds rowBounds, String buildSql, DBType dbType, String dialectClazz) throws Exception {
        return DialectFactory.getDialect(dbType, dialectClazz).buildPaginationSql(buildSql, rowBounds.getOffset(), rowBounds.getLimit());
    }

    /*
     * Unable to fully structure code
     */
    private static IDialect getDialect(DBType dbType, String dialectClazz) throws Exception {
        dialect = DialectFactory.dialectCache.get(dbType.getDb());
        if (null == dialect) {
            if (StringUtils.isNotEmpty((CharSequence)dialectClazz)) {
                dialect = DialectFactory.dialectCache.get(dialectClazz);
                if (null != dialect) {
                    return dialect;
                }
                try {
                    clazz = Class.forName(dialectClazz);
                    if (!IDialect.class.isAssignableFrom(clazz)) ** GOTO lbl19
                    dialect = (IDialect)clazz.newInstance();
                    DialectFactory.dialectCache.put(dialectClazz, dialect);
                }
                catch (ClassNotFoundException e) {
                    throw new MybatisPlusException("Class :" + dialectClazz + " is not found");
                }
            } else {
                dialect = DialectFactory.getDialectByDbType(dbType);
                DialectFactory.dialectCache.put(dbType.getDb(), dialect);
            }
lbl19:
            // 3 sources

            if (dialect == null) {
                throw new MybatisPlusException("The value of the dialect property in mybatis configuration.xml is not defined.");
            }
        }
        return dialect;
    }

    private static IDialect getDialectByDbType(DBType dbType) {
        if (dbType == DBType.MYSQL) {
            return new MySqlDialect();
        }
        if (dbType == DBType.MARIADB) {
            return new MariaDBDialect();
        }
        if (dbType == DBType.ORACLE) {
            return new OracleDialect();
        }
        if (dbType == DBType.DB2) {
            return new DB2Dialect();
        }
        if (dbType == DBType.H2) {
            return new H2Dialect();
        }
        if (dbType == DBType.SQLSERVER) {
            return new SQLServerDialect();
        }
        if (dbType == DBType.SQLSERVER2005) {
            return new SQLServer2005Dialect();
        }
        if (dbType == DBType.POSTGRE) {
            return new PostgreDialect();
        }
        if (dbType == DBType.HSQL) {
            return new HSQLDialect();
        }
        if (dbType == DBType.SQLITE) {
            return new SQLiteDialect();
        }
        throw new MybatisPlusException("The Database's Not Supported! DBType:" + dbType);
    }
}

