/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.plugins;

import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.SystemClock;
import com.baomidou.mybatisplus.core.toolkit.sql.SqlUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Properties;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.session.ResultHandler;

@Intercepts(value={@Signature(type=StatementHandler.class, method="query", args={Statement.class, ResultHandler.class}), @Signature(type=StatementHandler.class, method="update", args={Statement.class}), @Signature(type=StatementHandler.class, method="batch", args={Statement.class})})
public class PerformanceInterceptor
implements Interceptor {
    private static final Log logger = LogFactory.getLog(PerformanceInterceptor.class);
    private static final String DruidPooledPreparedStatement = "com.alibaba.druid.pool.DruidPooledPreparedStatement";
    private static final String T4CPreparedStatement = "oracle.jdbc.driver.T4CPreparedStatement";
    private static final String OraclePreparedStatementWrapper = "oracle.jdbc.driver.OraclePreparedStatementWrapper";
    private long maxTime = 0L;
    private boolean format = false;
    private boolean writeInLog = false;
    private Method oracleGetOriginalSqlMethod;
    private Method druidGetSQLMethod;

    public Object intercept(Invocation invocation) throws Throwable {
        int index;
        Object stmtSql;
        Class<?> clazz;
        Object firstArg = invocation.getArgs()[0];
        Statement statement = Proxy.isProxyClass(firstArg.getClass()) ? (Statement)SystemMetaObject.forObject((Object)firstArg).getValue("h.statement") : (Statement)firstArg;
        MetaObject stmtMetaObj = SystemMetaObject.forObject((Object)statement);
        try {
            statement = (Statement)stmtMetaObj.getValue("stmt.statement");
        }
        catch (Exception e) {
            // empty catch block
        }
        if (stmtMetaObj.hasGetter("delegate")) {
            try {
                statement = (Statement)stmtMetaObj.getValue("delegate");
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        String originalSql = null;
        String stmtClassName = statement.getClass().getName();
        if (DruidPooledPreparedStatement.equals(stmtClassName)) {
            try {
                if (this.druidGetSQLMethod == null) {
                    clazz = Class.forName(DruidPooledPreparedStatement);
                    this.druidGetSQLMethod = clazz.getMethod("getSql", new Class[0]);
                }
                if ((stmtSql = this.druidGetSQLMethod.invoke((Object)statement, new Object[0])) instanceof String) {
                    originalSql = (String)stmtSql;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (T4CPreparedStatement.equals(stmtClassName) || OraclePreparedStatementWrapper.equals(stmtClassName)) {
            try {
                if (this.oracleGetOriginalSqlMethod != null) {
                    stmtSql = this.oracleGetOriginalSqlMethod.invoke((Object)statement, new Object[0]);
                    if (stmtSql instanceof String) {
                        originalSql = (String)stmtSql;
                    }
                } else {
                    clazz = Class.forName(stmtClassName);
                    this.oracleGetOriginalSqlMethod = this.getMethodRegular(clazz, "getOriginalSql");
                    if (this.oracleGetOriginalSqlMethod != null) {
                        Object stmtSql2;
                        this.oracleGetOriginalSqlMethod.setAccessible(true);
                        if (null != this.oracleGetOriginalSqlMethod && (stmtSql2 = this.oracleGetOriginalSqlMethod.invoke((Object)statement, new Object[0])) instanceof String) {
                            originalSql = (String)stmtSql2;
                        }
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (originalSql == null) {
            originalSql = statement.toString();
        }
        if ((index = this.indexOfSqlStart(originalSql = originalSql.replaceAll("[\\s]+", " "))) > 0) {
            originalSql = originalSql.substring(index);
        }
        long start = SystemClock.now();
        Object result = invocation.proceed();
        long timing = SystemClock.now() - start;
        Object target = PluginUtils.realTarget((Object)invocation.getTarget());
        MetaObject metaObject = SystemMetaObject.forObject((Object)target);
        MappedStatement ms = (MappedStatement)metaObject.getValue("delegate.mappedStatement");
        StringBuilder formatSql = new StringBuilder().append(" Time\uff1a").append(timing).append(" ms - ID\uff1a").append(ms.getId()).append("\n").append("Execute SQL\uff1a").append(SqlUtils.sqlFormat((String)originalSql, (boolean)this.format)).append("\n");
        if (this.isWriteInLog()) {
            if (this.getMaxTime() >= 1L && timing > this.getMaxTime()) {
                logger.error(formatSql.toString());
            } else {
                logger.debug(formatSql.toString());
            }
        } else {
            System.err.println(formatSql.toString());
            Assert.isFalse((this.getMaxTime() >= 1L && timing > this.getMaxTime() ? 1 : 0) != 0, (String)" The SQL execution time is too large, please optimize ! ", (Object[])new Object[0]);
        }
        return result;
    }

    public Object plugin(Object target) {
        if (target instanceof StatementHandler) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties prop) {
        String maxTime = prop.getProperty("maxTime");
        String format = prop.getProperty("format");
        if (StringUtils.isNotEmpty((CharSequence)maxTime)) {
            this.maxTime = Long.parseLong(maxTime);
        }
        if (StringUtils.isNotEmpty((CharSequence)format)) {
            this.format = Boolean.valueOf(format);
        }
    }

    public Method getMethodRegular(Class<?> clazz, String methodName) {
        if (Object.class.equals(clazz)) {
            return null;
        }
        for (Method method : clazz.getDeclaredMethods()) {
            if (!method.getName().equals(methodName)) continue;
            return method;
        }
        return this.getMethodRegular(clazz.getSuperclass(), methodName);
    }

    private int indexOfSqlStart(String sql) {
        String upperCaseSql = sql.toUpperCase();
        HashSet<Integer> set = new HashSet<Integer>();
        set.add(upperCaseSql.indexOf("SELECT "));
        set.add(upperCaseSql.indexOf("UPDATE "));
        set.add(upperCaseSql.indexOf("INSERT "));
        set.add(upperCaseSql.indexOf("DELETE "));
        set.remove(-1);
        if (CollectionUtils.isEmpty(set)) {
            return -1;
        }
        ArrayList list = new ArrayList(set);
        list.sort(Comparator.naturalOrder());
        return (Integer)list.get(0);
    }

    public PerformanceInterceptor setMaxTime(long maxTime) {
        this.maxTime = maxTime;
        return this;
    }

    public long getMaxTime() {
        return this.maxTime;
    }

    public PerformanceInterceptor setFormat(boolean format) {
        this.format = format;
        return this;
    }

    public boolean isFormat() {
        return this.format;
    }

    public PerformanceInterceptor setWriteInLog(boolean writeInLog) {
        this.writeInLog = writeInLog;
        return this;
    }

    public boolean isWriteInLog() {
        return this.writeInLog;
    }
}

