/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.generator.config.converts;

import com.baomidou.mybatisplus.generator.config.GlobalConfig;
import com.baomidou.mybatisplus.generator.config.ITypeConvert;
import com.baomidou.mybatisplus.generator.config.converts.TypeConverts;
import com.baomidou.mybatisplus.generator.config.rules.DbColumnType;
import com.baomidou.mybatisplus.generator.config.rules.IColumnType;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class DmTypeConvert
implements ITypeConvert {
    public static final DmTypeConvert INSTANCE = new DmTypeConvert();

    @Override
    public IColumnType processTypeConvert(@NotNull GlobalConfig config, @NotNull String fieldType) {
        return TypeConverts.use(fieldType).test(TypeConverts.containsAny("char", "text").then(DbColumnType.STRING)).test(TypeConverts.contains("number").then((IColumnType)((Object)((Function<String, IColumnType>)DmTypeConvert::toNumberType)))).test(TypeConverts.containsAny("numeric", "dec", "money").then(DbColumnType.BIG_DECIMAL)).test(TypeConverts.containsAny("bit", "bool").then(DbColumnType.BOOLEAN)).test(TypeConverts.contains("bigint").then(DbColumnType.BIG_INTEGER)).test(TypeConverts.containsAny("int", "byte").then(DbColumnType.INTEGER)).test(TypeConverts.contains("binary").then(DbColumnType.BYTE_ARRAY)).test(TypeConverts.contains("float").then(DbColumnType.FLOAT)).test(TypeConverts.containsAny("double", "real").then(DbColumnType.DOUBLE)).test(TypeConverts.containsAny("date", "time").then(DbColumnType.DATE)).test(TypeConverts.contains("clob").then(DbColumnType.CLOB)).test(TypeConverts.contains("blob").then(DbColumnType.BLOB)).test(TypeConverts.contains("image").then(DbColumnType.BYTE_ARRAY)).or(DbColumnType.STRING);
    }

    private static IColumnType toNumberType(String typeName) {
        if (typeName.matches("number\\([0-9]\\)")) {
            return DbColumnType.INTEGER;
        }
        if (typeName.matches("number\\(1[0-8]\\)")) {
            return DbColumnType.LONG;
        }
        return DbColumnType.BIG_DECIMAL;
    }
}

