/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.generator.config.converts;

import com.baomidou.mybatisplus.generator.config.GlobalConfig;
import com.baomidou.mybatisplus.generator.config.ITypeConvert;
import com.baomidou.mybatisplus.generator.config.converts.TypeConverts;
import com.baomidou.mybatisplus.generator.config.rules.DateType;
import com.baomidou.mybatisplus.generator.config.rules.DbColumnType;
import com.baomidou.mybatisplus.generator.config.rules.IColumnType;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class KingbaseESTypeConvert
implements ITypeConvert {
    public static final KingbaseESTypeConvert INSTANCE = new KingbaseESTypeConvert();

    @Override
    public IColumnType processTypeConvert(@NotNull GlobalConfig globalConfig, @NotNull String fieldType) {
        return TypeConverts.use(fieldType).test(TypeConverts.containsAny("char", "text", "json", "enum").then(DbColumnType.STRING)).test(TypeConverts.contains("bigint").then(DbColumnType.LONG)).test(TypeConverts.contains("int").then(DbColumnType.INTEGER)).test(TypeConverts.containsAny("date", "time").then((IColumnType)((Object)((Function<String, IColumnType>)p -> this.toDateType(globalConfig, (String)p))))).test(TypeConverts.containsAny("bit", "boolean").then(DbColumnType.BOOLEAN)).test(TypeConverts.containsAny("decimal", "numeric").then(DbColumnType.BIG_DECIMAL)).test(TypeConverts.contains("clob").then(DbColumnType.CLOB)).test(TypeConverts.contains("blob").then(DbColumnType.BYTE_ARRAY)).test(TypeConverts.contains("float").then(DbColumnType.FLOAT)).test(TypeConverts.contains("double").then(DbColumnType.DOUBLE)).or(DbColumnType.STRING);
    }

    private IColumnType toDateType(GlobalConfig config, String type) {
        DateType dateType = config.getDateType();
        if (dateType == DateType.SQL_PACK) {
            switch (type) {
                case "date": {
                    return DbColumnType.DATE_SQL;
                }
                case "time": {
                    return DbColumnType.TIME;
                }
            }
            return DbColumnType.TIMESTAMP;
        }
        if (dateType == DateType.TIME_PACK) {
            switch (type) {
                case "date": {
                    return DbColumnType.LOCAL_DATE;
                }
                case "time": {
                    return DbColumnType.LOCAL_TIME;
                }
            }
            return DbColumnType.LOCAL_DATE_TIME;
        }
        return DbColumnType.DATE;
    }
}

