/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.generator.config.builder;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.core.handlers.AnnotationHandler;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.generator.IFill;
import com.baomidou.mybatisplus.generator.ITemplate;
import com.baomidou.mybatisplus.generator.config.INameConvert;
import com.baomidou.mybatisplus.generator.config.StrategyConfig;
import com.baomidou.mybatisplus.generator.config.builder.BaseBuilder;
import com.baomidou.mybatisplus.generator.config.po.TableInfo;
import com.baomidou.mybatisplus.generator.config.rules.NamingStrategy;
import com.baomidou.mybatisplus.generator.function.ConverterFileName;
import com.baomidou.mybatisplus.generator.util.ClassUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Entity
implements ITemplate {
    private final AnnotationHandler annotationHandler = new AnnotationHandler(){};
    private static final Logger LOGGER = LoggerFactory.getLogger(Entity.class);
    private String javaTemplate = "/templates/entity.java";
    private String kotlinTemplate = "/templates/entity.kt";
    private INameConvert nameConvert;
    private String superClass;
    private final Set<String> superEntityColumns = new HashSet<String>();
    private final Set<String> ignoreColumns = new HashSet<String>();
    private boolean serialVersionUID = true;
    private boolean columnConstant;
    private boolean chain;
    private boolean lombok;
    private boolean booleanColumnRemoveIsPrefix;
    private boolean tableFieldAnnotationEnable;
    private String versionColumnName;
    private String versionPropertyName;
    private String logicDeleteColumnName;
    private String logicDeletePropertyName;
    private final List<IFill> tableFillList = new ArrayList<IFill>();
    private NamingStrategy naming = NamingStrategy.underline_to_camel;
    private NamingStrategy columnNaming = null;
    private boolean activeRecord;
    private IdType idType;
    private ConverterFileName converterFileName = entityName -> entityName;
    private boolean fileOverride;
    private boolean generate = true;

    private Entity() {
    }

    public void convertSuperEntityColumns(Class<?> clazz) {
        List fields = TableInfoHelper.getAllFields(clazz, (AnnotationHandler)this.annotationHandler);
        this.superEntityColumns.addAll(fields.stream().map(field -> {
            TableId tableId = (TableId)this.annotationHandler.getAnnotation(field, TableId.class);
            if (tableId != null && StringUtils.isNotBlank((CharSequence)tableId.value())) {
                return tableId.value();
            }
            TableField tableField = (TableField)this.annotationHandler.getAnnotation(field, TableField.class);
            if (tableField != null && StringUtils.isNotBlank((CharSequence)tableField.value())) {
                return tableField.value();
            }
            if (null == this.columnNaming || this.columnNaming == NamingStrategy.no_change) {
                return field.getName();
            }
            return StringUtils.camelToUnderline((String)field.getName());
        }).collect(Collectors.toSet()));
    }

    @NotNull
    public NamingStrategy getColumnNaming() {
        return Optional.ofNullable(this.columnNaming).orElse(this.naming);
    }

    public boolean matchSuperEntityColumns(String fieldName) {
        return this.superEntityColumns.stream().anyMatch(e -> e.equalsIgnoreCase(fieldName));
    }

    public boolean matchIgnoreColumns(String fieldName) {
        return this.ignoreColumns.stream().anyMatch(e -> e.equalsIgnoreCase(fieldName));
    }

    @NotNull
    public INameConvert getNameConvert() {
        return this.nameConvert;
    }

    @Nullable
    public String getSuperClass() {
        return this.superClass;
    }

    @Nullable
    public String getVersionColumnName() {
        return this.versionColumnName;
    }

    @Nullable
    public String getVersionPropertyName() {
        return this.versionPropertyName;
    }

    @Nullable
    public String getLogicDeleteColumnName() {
        return this.logicDeleteColumnName;
    }

    @Nullable
    public String getLogicDeletePropertyName() {
        return this.logicDeletePropertyName;
    }

    @NotNull
    public List<IFill> getTableFillList() {
        return this.tableFillList;
    }

    @NotNull
    public NamingStrategy getNaming() {
        return this.naming;
    }

    @Nullable
    public IdType getIdType() {
        return this.idType;
    }

    @NotNull
    public ConverterFileName getConverterFileName() {
        return this.converterFileName;
    }

    @Override
    @NotNull
    public Map<String, Object> renderData(@NotNull TableInfo tableInfo) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("idType", this.idType == null ? null : this.idType.toString());
        data.put("logicDeleteFieldName", this.logicDeleteColumnName);
        data.put("versionFieldName", this.versionColumnName);
        data.put("activeRecord", this.activeRecord);
        data.put("entitySerialVersionUID", this.serialVersionUID);
        data.put("entityColumnConstant", this.columnConstant);
        data.put("entityBuilderModel", this.chain);
        data.put("chainModel", this.chain);
        data.put("entityLombokModel", this.lombok);
        data.put("entityBooleanColumnRemoveIsPrefix", this.booleanColumnRemoveIsPrefix);
        data.put("superEntityClass", ClassUtils.getSimpleName(this.superClass));
        return data;
    }

    public String getJavaTemplate() {
        return this.javaTemplate;
    }

    public String getKotlinTemplate() {
        return this.kotlinTemplate;
    }

    public Set<String> getSuperEntityColumns() {
        return this.superEntityColumns;
    }

    public boolean isSerialVersionUID() {
        return this.serialVersionUID;
    }

    public boolean isColumnConstant() {
        return this.columnConstant;
    }

    public boolean isChain() {
        return this.chain;
    }

    public boolean isLombok() {
        return this.lombok;
    }

    public boolean isBooleanColumnRemoveIsPrefix() {
        return this.booleanColumnRemoveIsPrefix;
    }

    public boolean isTableFieldAnnotationEnable() {
        return this.tableFieldAnnotationEnable;
    }

    public boolean isActiveRecord() {
        return this.activeRecord;
    }

    public boolean isFileOverride() {
        return this.fileOverride;
    }

    public boolean isGenerate() {
        return this.generate;
    }

    public static class Builder
    extends BaseBuilder {
        private final Entity entity = new Entity();

        public Builder(StrategyConfig strategyConfig) {
            super(strategyConfig);
            this.entity.nameConvert = new INameConvert.DefaultNameConvert(strategyConfig);
        }

        public Builder nameConvert(INameConvert nameConvert) {
            this.entity.nameConvert = nameConvert;
            return this;
        }

        public Builder superClass(@NotNull Class<?> clazz) {
            return this.superClass(clazz.getName());
        }

        public Builder superClass(String superEntityClass) {
            this.entity.superClass = superEntityClass;
            return this;
        }

        public Builder disableSerialVersionUID() {
            this.entity.serialVersionUID = false;
            return this;
        }

        public Builder enableColumnConstant() {
            this.entity.columnConstant = true;
            return this;
        }

        public Builder enableChainModel() {
            this.entity.chain = true;
            return this;
        }

        public Builder enableLombok() {
            this.entity.lombok = true;
            return this;
        }

        public Builder enableRemoveIsPrefix() {
            this.entity.booleanColumnRemoveIsPrefix = true;
            return this;
        }

        public Builder enableTableFieldAnnotation() {
            this.entity.tableFieldAnnotationEnable = true;
            return this;
        }

        public Builder enableActiveRecord() {
            this.entity.activeRecord = true;
            return this;
        }

        public Builder versionColumnName(String versionColumnName) {
            this.entity.versionColumnName = versionColumnName;
            return this;
        }

        public Builder versionPropertyName(String versionPropertyName) {
            this.entity.versionPropertyName = versionPropertyName;
            return this;
        }

        public Builder logicDeleteColumnName(String logicDeleteColumnName) {
            this.entity.logicDeleteColumnName = logicDeleteColumnName;
            return this;
        }

        public Builder logicDeletePropertyName(String logicDeletePropertyName) {
            this.entity.logicDeletePropertyName = logicDeletePropertyName;
            return this;
        }

        public Builder naming(NamingStrategy namingStrategy) {
            this.entity.naming = namingStrategy;
            return this;
        }

        public Builder columnNaming(NamingStrategy namingStrategy) {
            this.entity.columnNaming = namingStrategy;
            return this;
        }

        public Builder addSuperEntityColumns(String ... superEntityColumns) {
            return this.addSuperEntityColumns(Arrays.asList(superEntityColumns));
        }

        public Builder addSuperEntityColumns(@NotNull List<String> superEntityColumnList) {
            this.entity.superEntityColumns.addAll(superEntityColumnList);
            return this;
        }

        public Builder addIgnoreColumns(String ... ignoreColumns) {
            return this.addIgnoreColumns(Arrays.asList(ignoreColumns));
        }

        public Builder addIgnoreColumns(@NotNull List<String> ignoreColumnList) {
            this.entity.ignoreColumns.addAll(ignoreColumnList);
            return this;
        }

        public Builder addTableFills(IFill ... tableFills) {
            return this.addTableFills(Arrays.asList(tableFills));
        }

        public Builder addTableFills(@NotNull List<IFill> tableFillList) {
            this.entity.tableFillList.addAll(tableFillList);
            return this;
        }

        public Builder idType(IdType idType) {
            this.entity.idType = idType;
            return this;
        }

        public Builder convertFileName(@NotNull ConverterFileName converter) {
            this.entity.converterFileName = converter;
            return this;
        }

        public Builder formatFileName(String format) {
            return this.convertFileName(entityName -> String.format(format, entityName));
        }

        @Deprecated
        public Builder fileOverride() {
            LOGGER.warn("fileOverride\u65b9\u6cd5\u540e\u7eed\u4f1a\u5220\u9664\uff0c\u66ff\u4ee3\u65b9\u6cd5\u4e3aenableFileOverride\u65b9\u6cd5");
            this.entity.fileOverride = true;
            return this;
        }

        public Builder enableFileOverride() {
            this.entity.fileOverride = true;
            return this;
        }

        public Builder javaTemplate(String template) {
            this.entity.javaTemplate = template;
            return this;
        }

        public Builder kotlinTemplatePath(String template) {
            this.entity.kotlinTemplate = template;
            return this;
        }

        public Builder disable() {
            this.entity.generate = false;
            return this;
        }

        public Entity get() {
            String superClass = this.entity.superClass;
            if (StringUtils.isNotBlank((CharSequence)superClass)) {
                this.tryLoadClass(superClass).ifPresent(this.entity::convertSuperEntityColumns);
            } else if (!this.entity.superEntityColumns.isEmpty()) {
                LOGGER.warn("Forgot to set entity supper class ?");
            }
            return this.entity;
        }

        private Optional<Class<?>> tryLoadClass(String className) {
            try {
                return Optional.of(ClassUtils.toClassConfident(className));
            }
            catch (Exception exception) {
                return Optional.empty();
            }
        }
    }
}

