/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.service.impl;

import com.baomidou.mybatisplus.entity.TableInfo;
import com.baomidou.mybatisplus.enums.SqlMethod;
import com.baomidou.mybatisplus.exceptions.MybatisPlusException;
import com.baomidou.mybatisplus.mapper.BaseMapper;
import com.baomidou.mybatisplus.mapper.Condition;
import com.baomidou.mybatisplus.mapper.SqlHelper;
import com.baomidou.mybatisplus.mapper.Wrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.IService;
import com.baomidou.mybatisplus.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.toolkit.GlobalConfigUtils;
import com.baomidou.mybatisplus.toolkit.MapUtils;
import com.baomidou.mybatisplus.toolkit.ReflectionKit;
import com.baomidou.mybatisplus.toolkit.StringUtils;
import com.baomidou.mybatisplus.toolkit.TableInfoHelper;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class ServiceImpl<M extends BaseMapper<T>, T>
implements IService<T> {
    @Autowired
    protected M baseMapper;

    protected static boolean retBool(Integer result) {
        return SqlHelper.retBool(result);
    }

    protected Class<T> currentModelClass() {
        return ReflectionKit.getSuperClassGenricType(this.getClass(), 1);
    }

    protected SqlSession sqlSessionBatch() {
        return SqlHelper.sqlSessionBatch(this.currentModelClass());
    }

    protected void closeSqlSession(SqlSession sqlSession) {
        SqlSessionUtils.closeSqlSession((SqlSession)sqlSession, (SqlSessionFactory)GlobalConfigUtils.currentSessionFactory(this.currentModelClass()));
    }

    protected String sqlStatement(SqlMethod sqlMethod) {
        return SqlHelper.table(this.currentModelClass()).getSqlStatement(sqlMethod.getMethod());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean insert(T entity) {
        return ServiceImpl.retBool(this.baseMapper.insert(entity));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean insertAllColumn(T entity) {
        return ServiceImpl.retBool(this.baseMapper.insertAllColumn(entity));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean insertBatch(List<T> entityList) {
        return this.insertBatch(entityList, 30);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean insertBatch(List<T> entityList, int batchSize) {
        if (CollectionUtils.isEmpty(entityList)) {
            throw new IllegalArgumentException("Error: entityList must not be empty");
        }
        SqlSession batchSqlSession = this.sqlSessionBatch();
        try {
            int size = entityList.size();
            String sqlStatement = this.sqlStatement(SqlMethod.INSERT_ONE);
            for (int i = 0; i < size; ++i) {
                batchSqlSession.insert(sqlStatement, entityList.get(i));
                if (i < 1 || i % batchSize != 0) continue;
                batchSqlSession.flushStatements();
            }
            batchSqlSession.flushStatements();
        }
        finally {
            this.closeSqlSession(batchSqlSession);
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean insertOrUpdate(T entity) {
        if (null != entity) {
            Class<?> cls = entity.getClass();
            TableInfo tableInfo = TableInfoHelper.getTableInfo(cls);
            if (null != tableInfo && StringUtils.isNotEmpty(tableInfo.getKeyProperty())) {
                Object idVal = ReflectionKit.getMethodValue(cls, entity, tableInfo.getKeyProperty());
                if (StringUtils.checkValNull(idVal)) {
                    return this.insert(entity);
                }
                return this.updateById(entity) || this.insert(entity);
            }
            throw new MybatisPlusException("Error:  Can not execute. Could not find @TableId.");
        }
        return false;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean insertOrUpdateAllColumn(T entity) {
        if (null != entity) {
            Class<?> cls = entity.getClass();
            TableInfo tableInfo = TableInfoHelper.getTableInfo(cls);
            if (null != tableInfo && StringUtils.isNotEmpty(tableInfo.getKeyProperty())) {
                Object idVal = ReflectionKit.getMethodValue(cls, entity, tableInfo.getKeyProperty());
                if (StringUtils.checkValNull(idVal)) {
                    return this.insertAllColumn(entity);
                }
                return this.updateAllColumnById(entity) || this.insertAllColumn(entity);
            }
            throw new MybatisPlusException("Error:  Can not execute. Could not find @TableId.");
        }
        return false;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean insertOrUpdateBatch(List<T> entityList) {
        return this.insertOrUpdateBatch(entityList, 30);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean insertOrUpdateBatch(List<T> entityList, int batchSize) {
        return this.insertOrUpdateBatch(entityList, batchSize, true);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean insertOrUpdateAllColumnBatch(List<T> entityList) {
        return this.insertOrUpdateBatch(entityList, 30, false);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean insertOrUpdateAllColumnBatch(List<T> entityList, int batchSize) {
        return this.insertOrUpdateBatch(entityList, batchSize, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean insertOrUpdateBatch(List<T> entityList, int batchSize, boolean selective) {
        if (CollectionUtils.isEmpty(entityList)) {
            throw new IllegalArgumentException("Error: entityList must not be empty");
        }
        SqlSession batchSqlSession = this.sqlSessionBatch();
        try {
            int size = entityList.size();
            Class<?> cls = null;
            TableInfo tableInfo = null;
            for (int i = 0; i < size; ++i) {
                T entity = entityList.get(i);
                if (i == 0) {
                    cls = entity.getClass();
                    tableInfo = TableInfoHelper.getTableInfo(cls);
                }
                if (null != tableInfo && StringUtils.isNotEmpty(tableInfo.getKeyProperty())) {
                    String sqlStatement;
                    Object idVal = ReflectionKit.getMethodValue(cls, entity, tableInfo.getKeyProperty());
                    if (StringUtils.checkValNull(idVal)) {
                        sqlStatement = this.sqlStatement(selective ? SqlMethod.INSERT_ONE : SqlMethod.INSERT_ONE_ALL_COLUMN);
                        batchSqlSession.insert(sqlStatement, entity);
                    } else {
                        sqlStatement = this.sqlStatement(selective ? SqlMethod.UPDATE_BY_ID : SqlMethod.UPDATE_ALL_COLUMN_BY_ID);
                        MapperMethod.ParamMap param = new MapperMethod.ParamMap();
                        param.put((Object)"et", entity);
                        batchSqlSession.update(sqlStatement, (Object)param);
                    }
                } else {
                    throw new MybatisPlusException("Error:  Can not execute. Could not find @TableId.");
                }
                if (i < 1 || i % batchSize != 0) continue;
                batchSqlSession.flushStatements();
            }
            batchSqlSession.flushStatements();
        }
        finally {
            this.closeSqlSession(batchSqlSession);
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean deleteById(Serializable id) {
        return SqlHelper.delBool(this.baseMapper.deleteById(id));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean deleteByMap(Map<String, Object> columnMap) {
        if (MapUtils.isEmpty(columnMap)) {
            throw new MybatisPlusException("deleteByMap columnMap is empty.");
        }
        return SqlHelper.delBool(this.baseMapper.deleteByMap(columnMap));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean delete(Wrapper<T> wrapper) {
        return SqlHelper.delBool(this.baseMapper.delete(wrapper));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean deleteBatchIds(Collection<? extends Serializable> idList) {
        return SqlHelper.delBool(this.baseMapper.deleteBatchIds(idList));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateById(T entity) {
        return ServiceImpl.retBool(this.baseMapper.updateById(entity));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateAllColumnById(T entity) {
        return ServiceImpl.retBool(this.baseMapper.updateAllColumnById(entity));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean update(T entity, Wrapper<T> wrapper) {
        return ServiceImpl.retBool(this.baseMapper.update(entity, wrapper));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateForSet(String setStr, Wrapper<T> wrapper) {
        return ServiceImpl.retBool(this.baseMapper.updateForSet(setStr, wrapper));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateBatchById(List<T> entityList) {
        return this.updateBatchById(entityList, 30);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateBatchById(List<T> entityList, int batchSize) {
        return this.updateBatchById(entityList, batchSize, true);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateAllColumnBatchById(List<T> entityList) {
        return this.updateAllColumnBatchById(entityList, 30);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateAllColumnBatchById(List<T> entityList, int batchSize) {
        return this.updateBatchById(entityList, batchSize, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateBatchById(List<T> entityList, int batchSize, boolean selective) {
        if (CollectionUtils.isEmpty(entityList)) {
            throw new IllegalArgumentException("Error: entityList must not be empty");
        }
        SqlSession batchSqlSession = this.sqlSessionBatch();
        try {
            int size = entityList.size();
            SqlMethod sqlMethod = selective ? SqlMethod.UPDATE_BY_ID : SqlMethod.UPDATE_ALL_COLUMN_BY_ID;
            String sqlStatement = this.sqlStatement(sqlMethod);
            for (int i = 0; i < size; ++i) {
                MapperMethod.ParamMap param = new MapperMethod.ParamMap();
                param.put((Object)"et", entityList.get(i));
                batchSqlSession.update(sqlStatement, (Object)param);
                if (i < 1 || i % batchSize != 0) continue;
                batchSqlSession.flushStatements();
            }
            batchSqlSession.flushStatements();
        }
        finally {
            this.closeSqlSession(batchSqlSession);
        }
        return true;
    }

    @Override
    public T selectById(Serializable id) {
        return this.baseMapper.selectById(id);
    }

    @Override
    public List<T> selectBatchIds(Collection<? extends Serializable> idList) {
        return this.baseMapper.selectBatchIds(idList);
    }

    @Override
    public List<T> selectByMap(Map<String, Object> columnMap) {
        return this.baseMapper.selectByMap(columnMap);
    }

    @Override
    public T selectOne(Wrapper<T> wrapper) {
        return SqlHelper.getObject(this.baseMapper.selectList(wrapper));
    }

    @Override
    public Map<String, Object> selectMap(Wrapper<T> wrapper) {
        return SqlHelper.getObject(this.baseMapper.selectMaps(wrapper));
    }

    @Override
    public Object selectObj(Wrapper<T> wrapper) {
        return SqlHelper.getObject(this.baseMapper.selectObjs(wrapper));
    }

    @Override
    public int selectCount(Wrapper<T> wrapper) {
        return SqlHelper.retCount(this.baseMapper.selectCount(wrapper));
    }

    @Override
    public List<T> selectList(Wrapper<T> wrapper) {
        return this.baseMapper.selectList(wrapper);
    }

    @Override
    public Page<T> selectPage(Page<T> page) {
        return this.selectPage(page, Condition.EMPTY);
    }

    @Override
    public List<Map<String, Object>> selectMaps(Wrapper<T> wrapper) {
        return this.baseMapper.selectMaps(wrapper);
    }

    @Override
    public List<Object> selectObjs(Wrapper<T> wrapper) {
        return this.baseMapper.selectObjs(wrapper);
    }

    @Override
    public Page<Map<String, Object>> selectMapsPage(Page page, Wrapper<T> wrapper) {
        wrapper = SqlHelper.fillWrapper(page, wrapper);
        page.setRecords(this.baseMapper.selectMapsPage(page, wrapper));
        return page;
    }

    @Override
    public Page<T> selectPage(Page<T> page, Wrapper<T> wrapper) {
        wrapper = SqlHelper.fillWrapper(page, wrapper);
        page.setRecords(this.baseMapper.selectPage(page, wrapper));
        return page;
    }
}

