/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.mapper;

import com.baomidou.mybatisplus.enums.SqlLike;
import com.baomidou.mybatisplus.exceptions.MybatisPlusException;
import com.baomidou.mybatisplus.mapper.SqlPlus;
import com.baomidou.mybatisplus.toolkit.ArrayUtils;
import com.baomidou.mybatisplus.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.toolkit.MapUtils;
import com.baomidou.mybatisplus.toolkit.SqlUtils;
import com.baomidou.mybatisplus.toolkit.StringUtils;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Wrapper<T>
implements Serializable {
    private static final String PLACE_HOLDER = "{%s}";
    private static final String MYBATIS_PLUS_TOKEN = "#{%s.paramNameValuePairs.%s}";
    private static final String MP_GENERAL_PARAMNAME = "MPGENVAL";
    private static final String DEFAULT_PARAM_ALIAS = "ew";
    private Map<String, Object> paramNameValuePairs = new HashMap<String, Object>(4);
    private AtomicInteger paramNameSeq = new AtomicInteger(0);
    protected String paramAlias = null;
    protected String sqlSelect = null;
    protected SqlPlus sql = new SqlPlus();
    protected Boolean isWhere;
    protected String AND_OR = "AND";

    public T getEntity() {
        return null;
    }

    public String getSqlSelect() {
        if (StringUtils.isEmpty(this.sqlSelect)) {
            return null;
        }
        return this.stripSqlInjection(this.sqlSelect);
    }

    public Wrapper<T> setSqlSelect(String sqlSelect) {
        if (StringUtils.isNotEmpty(sqlSelect)) {
            this.sqlSelect = sqlSelect;
        }
        return this;
    }

    public abstract String getSqlSegment();

    public String toString() {
        String sqlSegment = this.getSqlSegment();
        if (StringUtils.isNotEmpty(sqlSegment)) {
            sqlSegment = sqlSegment.replaceAll("#\\{" + this.getParamAlias() + ".paramNameValuePairs.MPGENVAL[0-9]+\\}", "\\?");
        }
        return sqlSegment;
    }

    public Wrapper<T> where(String sqlWhere, Object ... params) {
        this.sql.WHERE(this.formatSql(sqlWhere, params));
        return this;
    }

    public Wrapper<T> eq(String column, Object params) {
        this.sql.WHERE(this.formatSql(String.format("%s = {0}", column), params));
        return this;
    }

    public Wrapper<T> ne(String column, Object params) {
        this.sql.WHERE(this.formatSql(String.format("%s <> {0}", column), params));
        return this;
    }

    public Wrapper<T> allEq(Map<String, Object> params) {
        if (MapUtils.isNotEmpty(params)) {
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                Object value = entry.getValue();
                if (!StringUtils.checkValNotNull(value)) continue;
                this.sql.WHERE(this.formatSql(String.format("%s = {0}", entry.getKey()), entry.getValue()));
            }
        }
        return this;
    }

    public Wrapper<T> gt(String column, Object params) {
        this.sql.WHERE(this.formatSql(String.format("%s > {0}", column), params));
        return this;
    }

    public Wrapper<T> ge(String column, Object params) {
        this.sql.WHERE(this.formatSql(String.format("%s >= {0}", column), params));
        return this;
    }

    public Wrapper<T> lt(String column, Object params) {
        this.sql.WHERE(this.formatSql(String.format("%s < {0}", column), params));
        return this;
    }

    public Wrapper<T> le(String column, Object params) {
        this.sql.WHERE(this.formatSql(String.format("%s <= {0}", column), params));
        return this;
    }

    public Wrapper<T> and(String sqlAnd, Object ... params) {
        ((SqlPlus)this.sql.AND()).WHERE(this.formatSql(sqlAnd, params));
        return this;
    }

    public Wrapper<T> andNew(String sqlAnd, Object ... params) {
        ((SqlPlus)this.sql.AND_NEW()).WHERE(this.formatSql(sqlAnd, params));
        return this;
    }

    public Wrapper<T> and() {
        this.sql.AND_NEW();
        return this;
    }

    public Wrapper<T> or() {
        this.sql.OR_NEW();
        return this;
    }

    public Wrapper<T> or(String sqlOr, Object ... params) {
        if (StringUtils.isEmpty(this.sql.toString())) {
            this.AND_OR = "OR";
        }
        ((SqlPlus)this.sql.OR()).WHERE(this.formatSql(sqlOr, params));
        return this;
    }

    public Wrapper<T> orNew(String sqlOr, Object ... params) {
        if (StringUtils.isEmpty(this.sql.toString())) {
            this.AND_OR = "OR";
        }
        ((SqlPlus)this.sql.OR_NEW()).WHERE(this.formatSql(sqlOr, params));
        return this;
    }

    public Wrapper<T> groupBy(String columns) {
        this.sql.GROUP_BY(columns);
        return this;
    }

    public Wrapper<T> having(String sqlHaving, Object ... params) {
        this.sql.HAVING(this.formatSql(sqlHaving, params));
        return this;
    }

    public Wrapper<T> orderBy(String columns) {
        this.sql.ORDER_BY(columns);
        return this;
    }

    public Wrapper<T> orderBy(String columns, boolean isAsc) {
        if (StringUtils.isNotEmpty(columns)) {
            this.sql.ORDER_BY(columns + (isAsc ? " ASC" : " DESC"));
        }
        return this;
    }

    public Wrapper<T> like(String column, String value) {
        this.handerLike(column, value, SqlLike.DEFAULT, false);
        return this;
    }

    public Wrapper<T> notLike(String column, String value) {
        this.handerLike(column, value, SqlLike.DEFAULT, true);
        return this;
    }

    private void handerLike(String column, String value, SqlLike type, boolean isNot) {
        if (StringUtils.isNotEmpty(column) && StringUtils.isNotEmpty(value)) {
            StringBuilder inSql = new StringBuilder();
            inSql.append(column);
            if (isNot) {
                inSql.append(" NOT");
            }
            inSql.append(" LIKE {0}");
            this.sql.WHERE(this.formatSql(inSql.toString(), SqlUtils.concatLike(value, type)));
        }
    }

    public Wrapper<T> like(String column, String value, SqlLike type) {
        this.handerLike(column, value, type, false);
        return this;
    }

    public Wrapper<T> notLike(String column, String value, SqlLike type) {
        this.handerLike(column, value, type, true);
        return this;
    }

    public Wrapper<T> isNotNull(String columns) {
        this.sql.IS_NOT_NULL(columns);
        return this;
    }

    public Wrapper<T> isNull(String columns) {
        this.sql.IS_NULL(columns);
        return this;
    }

    public Wrapper<T> exists(String value) {
        this.sql.EXISTS(value);
        return this;
    }

    public Wrapper<T> notExists(String value) {
        this.sql.NOT_EXISTS(value);
        return this;
    }

    public Wrapper<T> in(String column, String value) {
        if (StringUtils.isNotEmpty(value)) {
            this.in(column, StringUtils.splitWorker(value, ",", -1, false));
        }
        return this;
    }

    public Wrapper<T> notIn(String column, String value) {
        if (StringUtils.isNotEmpty(value)) {
            this.notIn(column, StringUtils.splitWorker(value, ",", -1, false));
        }
        return this;
    }

    public Wrapper<T> in(String column, Collection<?> value) {
        if (CollectionUtils.isNotEmpty(value)) {
            this.sql.WHERE(this.formatSql(this.inExpression(column, value, false), value.toArray()));
        }
        return this;
    }

    public Wrapper<T> notIn(String column, Collection<?> value) {
        if (CollectionUtils.isNotEmpty(value)) {
            this.sql.WHERE(this.formatSql(this.inExpression(column, value, true), value.toArray()));
        }
        return this;
    }

    public Wrapper<T> in(String column, Object[] value) {
        if (ArrayUtils.isNotEmpty(value)) {
            this.sql.WHERE(this.formatSql(this.inExpression(column, Arrays.asList(value), false), value));
        }
        return this;
    }

    public Wrapper<T> notIn(String column, Object ... value) {
        if (ArrayUtils.isNotEmpty(value)) {
            this.sql.WHERE(this.formatSql(this.inExpression(column, Arrays.asList(value), true), value));
        }
        return this;
    }

    private String inExpression(String column, Collection<?> value, boolean isNot) {
        if (StringUtils.isNotEmpty(column) && CollectionUtils.isNotEmpty(value)) {
            StringBuilder inSql = new StringBuilder();
            inSql.append(column);
            if (isNot) {
                inSql.append(" NOT");
            }
            inSql.append(" IN ");
            inSql.append("(");
            int size = value.size();
            for (int i = 0; i < size; ++i) {
                inSql.append(String.format(PLACE_HOLDER, i));
                if (i + 1 >= size) continue;
                inSql.append(",");
            }
            inSql.append(")");
            return inSql.toString();
        }
        return null;
    }

    public Wrapper<T> between(String column, Object val1, Object val2) {
        this.sql.WHERE(this.formatSql(String.format("%s BETWEEN {0} AND {1}", column), val1, val2));
        return this;
    }

    public Wrapper<T> notBetween(String column, Object val1, Object val2) {
        this.sql.WHERE(this.formatSql(String.format("%s NOT BETWEEN {0} AND {1}", column), val1, val2));
        return this;
    }

    public Wrapper<T> addFilter(String sqlWhere, Object ... params) {
        return this.and(sqlWhere, params);
    }

    public Wrapper<T> addFilterIfNeed(boolean need, String sqlWhere, Object ... params) {
        return need ? this.where(sqlWhere, params) : this;
    }

    protected String stripSqlInjection(String value) {
        return value.replaceAll("('.+--)|(--)|(\\|)|(%7C)", "");
    }

    protected String formatSql(String sqlStr, Object ... params) {
        return this.formatSqlIfNeed(true, sqlStr, params);
    }

    protected String formatSqlIfNeed(boolean need, String sqlStr, Object ... params) {
        if (!need || StringUtils.isEmpty(sqlStr)) {
            return null;
        }
        if (ArrayUtils.isNotEmpty(params)) {
            for (int i = 0; i < params.length; ++i) {
                String genParamName = MP_GENERAL_PARAMNAME + this.paramNameSeq.incrementAndGet();
                sqlStr = sqlStr.replace(String.format(PLACE_HOLDER, i), String.format(MYBATIS_PLUS_TOKEN, this.getParamAlias(), genParamName));
                this.paramNameValuePairs.put(genParamName, params[i]);
            }
        }
        return sqlStr;
    }

    public Wrapper<T> isWhere(Boolean bool) {
        this.isWhere = bool;
        return this;
    }

    public Map<String, Object> getParamNameValuePairs() {
        return this.paramNameValuePairs;
    }

    public String getParamAlias() {
        return StringUtils.isEmpty(this.paramAlias) ? DEFAULT_PARAM_ALIAS : this.paramAlias;
    }

    public Wrapper<T> setParamAlias(String paramAlias) {
        if (StringUtils.isNotEmpty(this.getSqlSegment())) {
            throw new MybatisPlusException("Error: Please call this method when initializing!");
        }
        if (StringUtils.isNotEmpty(this.paramAlias)) {
            throw new MybatisPlusException("Error: Please do not call the method repeatedly!");
        }
        this.paramAlias = paramAlias;
        return this;
    }
}

