/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.plugins;

import com.baomidou.mybatisplus.entity.CountOptimize;
import com.baomidou.mybatisplus.plugins.PaginationInterceptor;
import com.baomidou.mybatisplus.plugins.pagination.DialectFactory;
import com.baomidou.mybatisplus.plugins.pagination.Pagination;
import com.baomidou.mybatisplus.toolkit.PluginUtils;
import com.baomidou.mybatisplus.toolkit.SqlUtils;
import com.baomidou.mybatisplus.toolkit.StringUtils;
import java.sql.Connection;
import java.util.Properties;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
public class CachePaginationInterceptor
extends PaginationInterceptor
implements Interceptor {
    private String optimizeType = "default";
    private String dialectType;
    private String dialectClazz;

    public Object intercept(Invocation invocation) throws Throwable {
        Object target = invocation.getTarget();
        if (target instanceof StatementHandler) {
            StatementHandler statementHandler = (StatementHandler)PluginUtils.realTarget(invocation.getTarget());
            MetaObject metaStatementHandler = SystemMetaObject.forObject((Object)statementHandler);
            RowBounds rowBounds = (RowBounds)metaStatementHandler.getValue("delegate.rowBounds");
            if (rowBounds == null || rowBounds == RowBounds.DEFAULT) {
                return invocation.proceed();
            }
            BoundSql boundSql = (BoundSql)metaStatementHandler.getValue("delegate.boundSql");
            String originalSql = boundSql.getSql();
            if (rowBounds instanceof Pagination) {
                Pagination page = (Pagination)rowBounds;
                boolean orderBy = true;
                if (page.isSearchCount()) {
                    CountOptimize countOptimize = SqlUtils.getCountOptimize(originalSql, this.optimizeType, this.dialectType, page.isOptimizeCount());
                    orderBy = countOptimize.isOrderBy();
                }
                String buildSql = SqlUtils.concatOrderBy(originalSql, page, orderBy);
                originalSql = DialectFactory.buildPaginationSql(page, buildSql, this.dialectType, this.dialectClazz);
            } else {
                originalSql = DialectFactory.buildPaginationSql(rowBounds, originalSql, this.dialectType, this.dialectClazz);
            }
            metaStatementHandler.setValue("delegate.boundSql.sql", (Object)originalSql);
            metaStatementHandler.setValue("delegate.rowBounds.offset", (Object)0);
            metaStatementHandler.setValue("delegate.rowBounds.limit", (Object)Integer.MAX_VALUE);
        } else {
            Pagination page;
            MappedStatement mappedStatement = (MappedStatement)invocation.getArgs()[0];
            Object parameterObject = invocation.getArgs()[1];
            RowBounds rowBounds = (RowBounds)invocation.getArgs()[2];
            if (rowBounds == null || rowBounds == RowBounds.DEFAULT) {
                return invocation.proceed();
            }
            BoundSql boundSql = mappedStatement.getBoundSql(parameterObject);
            String originalSql = boundSql.getSql();
            if (rowBounds instanceof Pagination && (page = (Pagination)rowBounds).isSearchCount()) {
                CountOptimize countOptimize = SqlUtils.getCountOptimize(originalSql, this.optimizeType, this.dialectType, page.isOptimizeCount());
                super.count(countOptimize.getCountSQL(), mappedStatement, boundSql, page);
                if (page.getTotal() <= 0) {
                    return invocation.proceed();
                }
            }
        }
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        if (target instanceof Executor) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        if (target instanceof StatementHandler) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties prop) {
        String dialectType = prop.getProperty("dialectType");
        String dialectClazz = prop.getProperty("dialectClazz");
        if (StringUtils.isNotEmpty(dialectType)) {
            this.dialectType = dialectType;
        }
        if (StringUtils.isNotEmpty(dialectClazz)) {
            this.dialectClazz = dialectClazz;
        }
    }

    public void setDialectType(String dialectType) {
        this.dialectType = dialectType;
    }

    public void setOptimizeType(String optimizeType) {
        this.optimizeType = optimizeType;
    }
}

