/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.plugins;

import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.annotations.Version;
import com.baomidou.mybatisplus.plugins.VersionHandler;
import com.baomidou.mybatisplus.toolkit.ArrayUtils;
import com.baomidou.mybatisplus.toolkit.StringUtils;
import java.lang.reflect.Field;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.update.Update;
import org.apache.ibatis.builder.StaticSqlSource;
import org.apache.ibatis.exceptions.ExceptionFactory;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.TypeException;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public final class OptimisticLockerInterceptor
implements Interceptor {
    private static final Map<Class<?>, VersionCache> versionCache = new ConcurrentHashMap();
    private static final Map<Class<?>, VersionHandler> typeHandlers = new HashMap();

    public Object intercept(Invocation invocation) throws Exception {
        MappedStatement ms = (MappedStatement)invocation.getArgs()[0];
        Object parameterObject = invocation.getArgs()[1];
        if (parameterObject == null || !ms.getSqlCommandType().equals((Object)SqlCommandType.UPDATE)) {
            return invocation.proceed();
        }
        Class<?> parameterClass = parameterObject.getClass();
        VersionCache versionPo = versionCache.get(parameterClass);
        if (versionPo != null) {
            if (versionPo.isVersionControl.booleanValue()) {
                this.processChangeSql(ms, parameterObject, versionPo);
            }
        } else {
            String versionColumn = null;
            Field versionField = null;
            for (Field field : parameterClass.getDeclaredFields()) {
                if (!field.isAnnotationPresent(Version.class)) continue;
                if (!typeHandlers.containsKey(field.getType())) {
                    throw new TypeException("\u4e50\u89c2\u9501\u4e0d\u652f\u6301" + field.getType().getName() + "\u7c7b\u578b,\u8bf7\u81ea\u5b9a\u4e49\u5b9e\u73b0");
                }
                versionField = field;
                TableName tableName = field.getAnnotation(TableName.class);
                if (tableName != null) {
                    versionColumn = tableName.value();
                    break;
                }
                versionColumn = field.getName();
                break;
            }
            if (versionField != null) {
                versionField.setAccessible(true);
                VersionCache cachePo = new VersionCache(true, versionColumn, versionField);
                versionCache.put(parameterClass, cachePo);
                this.processChangeSql(ms, parameterObject, cachePo);
            } else {
                versionCache.put(parameterClass, new VersionCache(false));
            }
        }
        return invocation.proceed();
    }

    private void processChangeSql(MappedStatement ms, Object parameterObject, VersionCache versionPo) throws Exception {
        Field versionField = versionPo.versionField;
        String versionColumn = versionPo.versionColumn;
        Object versionValue = versionField.get(parameterObject);
        if (versionValue != null) {
            BinaryExpression expression;
            Configuration configuration = ms.getConfiguration();
            BoundSql boundSql = ms.getBoundSql(parameterObject);
            String originalSql = boundSql.getSql();
            Update parse = (Update)CCJSqlParserUtil.parse((String)originalSql);
            List columns = parse.getColumns();
            ArrayList<String> columnNames = new ArrayList<String>();
            for (Column column : columns) {
                columnNames.add(column.getColumnName());
            }
            if (!columnNames.contains(versionColumn)) {
                columns.add(new Column(versionColumn));
                parse.setColumns(columns);
            }
            if ((expression = (BinaryExpression)parse.getWhere()) != null && !expression.toString().contains(versionColumn)) {
                EqualsTo equalsTo = new EqualsTo();
                equalsTo.setLeftExpression((Expression)new Column(versionColumn));
                VersionHandler targetHandler = typeHandlers.get(versionField.getType());
                Expression rightExpression = targetHandler.getRightExpression(versionValue);
                Expression plusExpression = targetHandler.getPlusExpression(versionValue);
                equalsTo.setRightExpression(rightExpression);
                parse.setWhere((Expression)new AndExpression((Expression)equalsTo, (Expression)expression));
                List expressions = parse.getExpressions();
                expressions.add(plusExpression);
                parse.setExpressions(expressions);
            }
            MetaObject metaObject = SystemMetaObject.forObject((Object)ms);
            metaObject.setValue("sqlSource", (Object)new StaticSqlSource(configuration, parse.toString(), boundSql.getParameterMappings()));
        }
    }

    public Object plugin(Object target) {
        if (target instanceof Executor) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties properties) {
        String versionHandlers = properties.getProperty("versionHandlers");
        if (StringUtils.isNotEmpty(versionHandlers)) {
            String[] userHandlers;
            for (String handlerClazz : userHandlers = versionHandlers.split(",")) {
                try {
                    VersionHandler versionHandler = (VersionHandler)Class.forName(handlerClazz).newInstance();
                    OptimisticLockerInterceptor.registerHandler(versionHandler);
                }
                catch (Exception e) {
                    throw ExceptionFactory.wrapException((String)"\u4e50\u89c2\u9501\u63d2\u4ef6\u81ea\u5b9a\u4e49\u5904\u7406\u5668\u6ce8\u518c\u5931\u8d25", (Exception)e);
                }
            }
        }
    }

    private static void registerHandler(VersionHandler versionHandler) {
        Object[] handleType = versionHandler.handleType();
        if (ArrayUtils.isNotEmpty(handleType)) {
            for (Object type : handleType) {
                typeHandlers.put((Class<?>)type, versionHandler);
            }
        }
    }

    static {
        OptimisticLockerInterceptor.registerHandler(new BaseTypeHnadler());
        OptimisticLockerInterceptor.registerHandler(new DateTypeHandler());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DateTypeHandler
    implements VersionHandler {
        private DateTypeHandler() {
        }

        @Override
        public Class<?>[] handleType() {
            return new Class[]{java.util.Date.class, Date.class, Timestamp.class};
        }

        @Override
        public Expression getRightExpression(Object param) {
            String realTime;
            java.util.Date date = (java.util.Date)param;
            String millTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S").format((java.util.Date)param);
            Integer mills = Integer.valueOf(millTime.substring(20, 21));
            if (mills >= 5) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                calendar.add(13, 1);
                realTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(calendar.getTime());
            } else {
                realTime = millTime.substring(0, 19);
            }
            return new StringValue(realTime);
        }

        @Override
        public Expression getPlusExpression(Object param) {
            return new StringValue(new Timestamp(new java.util.Date().getTime()).toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BaseTypeHnadler
    implements VersionHandler {
        private BaseTypeHnadler() {
        }

        @Override
        public Class<?>[] handleType() {
            return new Class[]{Long.class, Long.TYPE, Integer.class, Integer.TYPE, Short.class, Short.TYPE};
        }

        @Override
        public Expression getRightExpression(Object param) {
            return new LongValue(param.toString());
        }

        @Override
        public Expression getPlusExpression(Object param) {
            return new LongValue(param.toString() + 1);
        }
    }

    private class VersionCache {
        private Boolean isVersionControl;
        private String versionColumn;
        private Field versionField;

        public VersionCache(Boolean isVersionControl) {
            this.isVersionControl = isVersionControl;
        }

        public VersionCache(Boolean isVersionControl, String versionColumn, Field versionField) {
            this.isVersionControl = isVersionControl;
            this.versionColumn = versionColumn;
            this.versionField = versionField;
        }
    }
}

