/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.toolkit;

import com.baomidou.mybatisplus.entity.CountOptimize;
import com.baomidou.mybatisplus.enums.Optimize;
import com.baomidou.mybatisplus.enums.SqlLike;
import com.baomidou.mybatisplus.plugins.pagination.Pagination;
import com.baomidou.mybatisplus.toolkit.DruidUtils;
import com.baomidou.mybatisplus.toolkit.JsqlParserUtils;
import com.baomidou.mybatisplus.toolkit.SqlFormatter;
import com.baomidou.mybatisplus.toolkit.StringUtils;

public class SqlUtils {
    private static final SqlFormatter sqlFormatter = new SqlFormatter();
    public static final String SQL_BASE_COUNT = "SELECT COUNT(1) FROM ( %s ) TOTAL";

    public static CountOptimize getCountOptimize(String originalSql, String optimizeType, String dialectType, boolean isOptimizeCount) {
        CountOptimize countOptimize = CountOptimize.newInstance();
        Optimize opType = Optimize.getOptimizeType(optimizeType);
        String tempSql = originalSql.replaceAll("(?i)ORDER[\\s]+BY", "ORDER BY").replaceAll("(?i)GROUP[\\s]+BY", "GROUP BY");
        String indexOfSql = tempSql.toUpperCase();
        int orderByIndex = indexOfSql.lastIndexOf("ORDER BY");
        if (orderByIndex > -1) {
            countOptimize.setOrderBy(false);
        }
        if (!isOptimizeCount && opType.equals((Object)Optimize.DEFAULT)) {
            countOptimize.setCountSQL(String.format(SQL_BASE_COUNT, originalSql));
            return countOptimize;
        }
        switch (opType) {
            case ALI_DRUID: {
                String aliCountSql = DruidUtils.count(originalSql, dialectType);
                countOptimize.setCountSQL(aliCountSql);
                break;
            }
            case JSQLPARSER: {
                JsqlParserUtils.jsqlparserCount(countOptimize, originalSql);
                break;
            }
            default: {
                int formIndex;
                StringBuilder countSql = new StringBuilder("SELECT COUNT(1) ");
                boolean optimize = false;
                if (!indexOfSql.contains("DISTINCT") && !indexOfSql.contains("GROUP BY") && (formIndex = indexOfSql.indexOf("FROM")) > -1) {
                    if (orderByIndex > -1) {
                        tempSql = tempSql.substring(0, orderByIndex);
                        countSql.append(tempSql.substring(formIndex));
                    } else {
                        countSql.append(tempSql.substring(formIndex));
                    }
                    optimize = true;
                }
                if (!optimize) {
                    countSql.append("FROM ( ").append(originalSql).append(" ) TOTAL");
                }
                countOptimize.setCountSQL(countSql.toString());
            }
        }
        return countOptimize;
    }

    public static String concatOrderBy(String originalSql, Pagination page, boolean orderBy) {
        if (orderBy && StringUtils.isNotEmpty(page.getOrderByField()) && page.isOpenSort()) {
            StringBuilder buildSql = new StringBuilder(originalSql);
            buildSql.append(" ORDER BY ").append(page.getOrderByField());
            buildSql.append(page.isAsc() ? " ASC " : " DESC ");
            return buildSql.toString();
        }
        return originalSql;
    }

    public static String sqlFormat(String boundSql, boolean format) {
        if (format) {
            return sqlFormatter.format(boundSql);
        }
        return boundSql.replaceAll("[\\s]+", " ");
    }

    public static String concatLike(String str, SqlLike type) {
        StringBuilder builder = new StringBuilder(str.length() + 3);
        switch (type) {
            case LEFT: {
                builder.append("%").append(str);
                break;
            }
            case RIGHT: {
                builder.append(str).append("%");
                break;
            }
            case CUSTOM: {
                builder.append(str);
                break;
            }
            default: {
                builder.append("%").append(str).append("%");
            }
        }
        return builder.toString();
    }
}

