/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.spi.remote.http;

import com.frameworkset.util.SimpleStringUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.NoRouteToHostException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.io.EmptyInputStream;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;
import org.frameworkset.spi.remote.http.BaseURLResponseHandler;
import org.frameworkset.spi.remote.http.ClientConfiguration;
import org.frameworkset.spi.remote.http.DataSerialType;
import org.frameworkset.spi.remote.http.HttpDeleteWithBody;
import org.frameworkset.spi.remote.http.HttpRequestUtil;
import org.frameworkset.spi.remote.http.StringResponseHandler;
import org.frameworkset.spi.remote.http.URLResponseHandler;
import org.frameworkset.spi.remote.http.proxy.ExceptionWare;
import org.frameworkset.spi.remote.http.proxy.HttpAddress;
import org.frameworkset.spi.remote.http.proxy.HttpProxyRequestException;
import org.frameworkset.spi.remote.http.proxy.HttpServiceHosts;
import org.frameworkset.spi.remote.http.proxy.NoHttpServerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequestProxy {
    private static Logger logger = LoggerFactory.getLogger(HttpRequestProxy.class);

    public static void startHttpPools(String configFile) {
        HttpRequestUtil.startHttpPools(configFile);
    }

    public static void startHttpPools(Map<String, Object> configs) {
        HttpRequestUtil.startHttpPools(configs);
    }

    public static String httpGetforString(String url) throws HttpProxyRequestException {
        return HttpRequestProxy.httpGetforString(url, (String)null, (String)null, (Map<String, String>)null);
    }

    public static <T> T httpGetforObject(String url, final Class<T> resultType) throws HttpProxyRequestException {
        return HttpRequestProxy.httpGetforString("default", url, null, null, null, new BaseURLResponseHandler<T>(){

            public T handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                return HttpRequestProxy.handleResponse(this.url, response, resultType);
            }
        });
    }

    public static String httpGetforString(String poolname, String url) throws HttpProxyRequestException {
        return HttpRequestProxy.httpGetforString(poolname, url, null, null, null);
    }

    public static <T> T httpGetforObject(String poolname, String url, final Class<T> resultType) throws HttpProxyRequestException {
        return HttpRequestProxy.httpGetforString(poolname, url, null, null, null, new BaseURLResponseHandler<T>(){

            public T handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                return HttpRequestProxy.handleResponse(this.url, response, resultType);
            }
        });
    }

    public static <T> List<T> httpGetforList(String url, final Class<T> resultType) throws HttpProxyRequestException {
        return (List)HttpRequestProxy.httpGetforString("default", url, null, null, null, new BaseURLResponseHandler<List<T>>(){

            public List<T> handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                return HttpRequestProxy.handleListResponse(this.url, response, resultType);
            }
        });
    }

    public static <K, T> Map<K, T> httpGetforMap(String url, final Class<K> keyType, final Class<T> resultType) throws HttpProxyRequestException {
        return (Map)HttpRequestProxy.httpGetforString("default", url, null, null, null, new BaseURLResponseHandler<Map<K, T>>(){

            public Map<K, T> handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                return HttpRequestProxy.handleMapResponse(this.url, response, keyType, resultType);
            }
        });
    }

    public static <T> Set<T> httpGetforSet(String url, final Class<T> resultType) throws HttpProxyRequestException {
        return (Set)HttpRequestProxy.httpGetforString("default", url, null, null, null, new BaseURLResponseHandler<Set<T>>(){

            public Set<T> handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                return HttpRequestProxy.handleSetResponse(this.url, response, resultType);
            }
        });
    }

    public static <T> List<T> httpGetforList(String poolName, String url, final Class<T> resultType) throws HttpProxyRequestException {
        return (List)HttpRequestProxy.httpGetforString(poolName, url, null, null, null, new BaseURLResponseHandler<List<T>>(){

            public List<T> handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                return HttpRequestProxy.handleListResponse(this.url, response, resultType);
            }
        });
    }

    public static <K, T> Map<K, T> httpGetforMap(String poolName, String url, final Class<K> keyType, final Class<T> resultType) throws HttpProxyRequestException {
        return (Map)HttpRequestProxy.httpGetforString(poolName, url, null, null, null, new BaseURLResponseHandler<Map<K, T>>(){

            public Map<K, T> handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                return HttpRequestProxy.handleMapResponse(this.url, response, keyType, resultType);
            }
        });
    }

    public static <T> Set<T> httpGetforSet(String poolName, String url, final Class<T> resultType) throws HttpProxyRequestException {
        return (Set)HttpRequestProxy.httpGetforString(poolName, url, null, null, null, new BaseURLResponseHandler<Set<T>>(){

            public Set<T> handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                return HttpRequestProxy.handleSetResponse(this.url, response, resultType);
            }
        });
    }

    public static <T> T httpGet(String poolname, String url, ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        return HttpRequestProxy.httpGetforString(poolname, url, null, null, null, responseHandler);
    }

    public static <T> T httpGet(String poolname, String url, Map<String, String> headers, ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        return HttpRequestProxy.httpGetforString(poolname, url, null, null, headers, responseHandler);
    }

    public static <T> T httpGet(String url, Map<String, String> headers, ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        return HttpRequestProxy.httpGetforString("default", url, null, null, headers, responseHandler);
    }

    public static String httpGetforString(String url, Map<String, String> headers) throws HttpProxyRequestException {
        return HttpRequestProxy.httpGetforString(url, (String)null, (String)null, headers);
    }

    public static String httpGetforString(String poolname, String url, Map<String, String> headers) throws HttpProxyRequestException {
        return HttpRequestProxy.httpGetforString(poolname, url, null, null, headers);
    }

    public static <T> T httpGetforString(String poolname, String url, Map<String, String> headers, ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        return HttpRequestProxy.httpGetforString(poolname, url, null, null, headers, responseHandler);
    }

    public static <T> T httpGetforString(String url, Map<String, String> headers, ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        return HttpRequestProxy.httpGetforString("default", url, null, null, headers, responseHandler);
    }

    public static String httpGetforString(String url, String cookie, String userAgent, Map<String, String> headers) throws HttpProxyRequestException {
        return HttpRequestProxy.httpGetforString("default", url, cookie, userAgent, headers);
    }

    public static String httpGetforString(String poolname, String url, String cookie, String userAgent, Map<String, String> headers) throws HttpProxyRequestException {
        return HttpRequestProxy.httpGetforString(poolname, url, cookie, userAgent, headers, new StringResponseHandler());
    }

    public static <T> T httpGetforString(String poolname, String url, String cookie, String userAgent, Map<String, String> headers, ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        return HttpRequestProxy.httpGet(poolname, url, cookie, userAgent, headers, responseHandler);
    }

    private static Exception getException(ResponseHandler responseHandler, HttpServiceHosts httpServiceHosts) {
        ExceptionWare exceptionWare = httpServiceHosts.getExceptionWare();
        if (exceptionWare != null) {
            return exceptionWare.getExceptionFromResponse(responseHandler);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T httpGet(String poolname, String url, String cookie, String userAgent, Map<String, String> headers, ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        Throwable e;
        Object responseBody;
        block44: {
            HttpClient httpClient = null;
            HttpGet httpGet = null;
            responseBody = null;
            ClientConfiguration config = ClientConfiguration.getClientConfiguration(poolname);
            String endpoint = null;
            e = null;
            int triesCount = 0;
            if (!url.startsWith("http://") && !url.startsWith("https://")) {
                endpoint = url;
                HttpAddress httpAddress = null;
                HttpServiceHosts httpServiceHosts = config.getHttpServiceHosts();
                HttpRequestProxy.assertCheck(httpServiceHosts);
                while (true) {
                    try {
                        httpAddress = httpServiceHosts.getHttpAddress();
                        url = SimpleStringUtil.getPath((String)httpAddress.getAddress(), (String)endpoint);
                        if (logger.isTraceEnabled()) {
                            logger.trace("Get call {}", (Object)url);
                        }
                        httpClient = HttpRequestUtil.getHttpClient(config);
                        httpGet = HttpRequestUtil.getHttpGet(config, url, cookie, userAgent, headers);
                        if (responseHandler != null && responseHandler instanceof URLResponseHandler) {
                            ((URLResponseHandler)responseHandler).setUrl(url);
                        }
                        responseBody = httpClient.execute((HttpUriRequest)httpGet, responseHandler);
                        httpAddress.recover();
                        e = HttpRequestProxy.getException(responseHandler, httpServiceHosts);
                        break block44;
                    }
                    catch (HttpHostConnectException ex) {
                        httpAddress.setStatus(1);
                        e = new NoHttpServerException(ex);
                        if (!httpServiceHosts.reachEnd(triesCount)) {
                            ++triesCount;
                            continue;
                        }
                        break block44;
                    }
                    catch (UnknownHostException ex) {
                        httpAddress.setStatus(1);
                        e = new NoHttpServerException(ex);
                        if (!httpServiceHosts.reachEnd(triesCount)) {
                            ++triesCount;
                            continue;
                        }
                        break block44;
                    }
                    catch (NoRouteToHostException ex) {
                        httpAddress.setStatus(1);
                        e = new NoHttpServerException(ex);
                        if (!httpServiceHosts.reachEnd(triesCount)) {
                            ++triesCount;
                            continue;
                        }
                        break block44;
                    }
                    catch (NoHttpResponseException ex) {
                        httpAddress.setStatus(1);
                        e = new NoHttpServerException(ex);
                        if (!httpServiceHosts.reachEnd(triesCount)) {
                            ++triesCount;
                            continue;
                        }
                        break block44;
                    }
                    catch (ConnectionPoolTimeoutException ex) {
                        e = HttpRequestProxy.handleConnectionPoolTimeOutException(config, ex);
                        break block44;
                    }
                    catch (ConnectTimeoutException connectTimeoutException) {
                        httpAddress.setStatus(1);
                        e = HttpRequestProxy.handleConnectionTimeOutException(config, connectTimeoutException);
                        if (!httpServiceHosts.reachEnd(triesCount)) {
                            ++triesCount;
                            continue;
                        }
                        break block44;
                    }
                    catch (SocketTimeoutException ex) {
                        e = HttpRequestProxy.handleSocketTimeoutException(config, ex);
                        break block44;
                    }
                    catch (NoHttpServerException ex) {
                        e = ex;
                        break block44;
                    }
                    catch (ClientProtocolException ex) {
                        throw new HttpProxyRequestException("Get Request[" + url + "] handle failed: must use http/https protocol port such as 9200,do not use other transport such as 9300.", ex);
                    }
                    catch (Exception ex) {
                        e = ex;
                        break block44;
                    }
                    catch (Throwable ex) {
                        e = ex;
                        break block44;
                    }
                    finally {
                        if (httpGet != null) {
                            httpGet.releaseConnection();
                        }
                        httpClient = null;
                        continue;
                    }
                    break;
                }
            }
            try {
                if (logger.isTraceEnabled()) {
                    logger.trace("Get call {}", (Object)url);
                }
                httpClient = HttpRequestUtil.getHttpClient(config);
                httpGet = HttpRequestUtil.getHttpGet(config, url, cookie, userAgent, headers);
                if (responseHandler != null && responseHandler instanceof URLResponseHandler) {
                    ((URLResponseHandler)responseHandler).setUrl(url);
                }
                responseBody = httpClient.execute((HttpUriRequest)httpGet, responseHandler);
            }
            catch (Exception ex) {
                e = ex;
            }
            finally {
                if (httpGet != null) {
                    httpGet.releaseConnection();
                }
                httpClient = null;
            }
        }
        if (e != null) {
            if (e instanceof HttpProxyRequestException) {
                throw (HttpProxyRequestException)e;
            }
            throw new HttpProxyRequestException("Get request url:" + url, e);
        }
        return (T)responseBody;
    }

    public static <T> T httpHead(String poolname, String url, ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        return HttpRequestProxy.httpHead(poolname, url, null, null, null, responseHandler);
    }

    public static <T> T httpHead(String url, ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        return HttpRequestProxy.httpHead("default", url, null, null, null, responseHandler);
    }

    public static <T> T httpHead(String poolname, String url, Map<String, Object> params, Map<String, String> headers, ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        return HttpRequestProxy.httpHead(poolname, url, null, null, params, headers, responseHandler);
    }

    public static <T> T httpHead(String poolname, String url, String cookie, String userAgent, Map<String, String> headers, ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        return HttpRequestProxy.httpHead(poolname, url, cookie, userAgent, null, headers, responseHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T httpHead(String poolname, String url, String cookie, String userAgent, Map<String, Object> params, Map<String, String> headers, ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        Throwable e;
        Object responseBody;
        block51: {
            HttpClient httpClient = null;
            HttpHead httpHead = null;
            responseBody = null;
            ClientConfiguration config = ClientConfiguration.getClientConfiguration(poolname);
            String endpoint = null;
            e = null;
            int triesCount = 0;
            if (!url.startsWith("http://") && !url.startsWith("https://")) {
                endpoint = url;
                HttpAddress httpAddress = null;
                HttpServiceHosts httpServiceHosts = config.getHttpServiceHosts();
                HttpRequestProxy.assertCheck(httpServiceHosts);
                while (true) {
                    try {
                        httpAddress = httpServiceHosts.getHttpAddress();
                        url = SimpleStringUtil.getPath((String)httpAddress.getAddress(), (String)endpoint);
                        if (logger.isTraceEnabled()) {
                            logger.trace("Head call {}", (Object)url);
                        }
                        httpClient = HttpRequestUtil.getHttpClient(config);
                        httpHead = HttpRequestUtil.getHttpHead(config, url, cookie, userAgent, headers);
                        BasicHttpParams httpParams = null;
                        if (params != null && params.size() > 0) {
                            httpParams = new BasicHttpParams();
                            Iterator<Map.Entry<String, Object>> it = params.entrySet().iterator();
                            Object paramPair_ = null;
                            int i = 0;
                            while (it.hasNext()) {
                                Map.Entry<String, Object> entry = it.next();
                                httpParams.setParameter(entry.getKey(), entry.getValue());
                                ++i;
                            }
                            httpHead.setParams((HttpParams)httpParams);
                        }
                        if (responseHandler != null && responseHandler instanceof URLResponseHandler) {
                            ((URLResponseHandler)responseHandler).setUrl(url);
                        }
                        responseBody = httpClient.execute((HttpUriRequest)httpHead, responseHandler);
                        httpAddress.recover();
                        e = HttpRequestProxy.getException(responseHandler, httpServiceHosts);
                        break block51;
                    }
                    catch (HttpHostConnectException ex) {
                        httpAddress.setStatus(1);
                        e = new NoHttpServerException(ex);
                        if (!httpServiceHosts.reachEnd(triesCount)) {
                            ++triesCount;
                            continue;
                        }
                        break block51;
                    }
                    catch (UnknownHostException ex) {
                        httpAddress.setStatus(1);
                        e = new NoHttpServerException(ex);
                        if (!httpServiceHosts.reachEnd(triesCount)) {
                            ++triesCount;
                            continue;
                        }
                        break block51;
                    }
                    catch (NoRouteToHostException ex) {
                        httpAddress.setStatus(1);
                        e = new NoHttpServerException(ex);
                        if (!httpServiceHosts.reachEnd(triesCount)) {
                            ++triesCount;
                            continue;
                        }
                        break block51;
                    }
                    catch (NoHttpResponseException ex) {
                        httpAddress.setStatus(1);
                        e = new NoHttpServerException(ex);
                        if (!httpServiceHosts.reachEnd(triesCount)) {
                            ++triesCount;
                            continue;
                        }
                        break block51;
                    }
                    catch (ConnectionPoolTimeoutException ex) {
                        e = HttpRequestProxy.handleConnectionPoolTimeOutException(config, ex);
                        break block51;
                    }
                    catch (ConnectTimeoutException connectTimeoutException) {
                        httpAddress.setStatus(1);
                        e = HttpRequestProxy.handleConnectionTimeOutException(config, connectTimeoutException);
                        if (!httpServiceHosts.reachEnd(triesCount)) {
                            ++triesCount;
                            continue;
                        }
                        break block51;
                    }
                    catch (SocketTimeoutException ex) {
                        e = HttpRequestProxy.handleSocketTimeoutException(config, ex);
                        break block51;
                    }
                    catch (NoHttpServerException ex) {
                        e = ex;
                        break block51;
                    }
                    catch (ClientProtocolException ex) {
                        httpAddress.setStatus(1);
                        e = ex;
                        if (logger.isErrorEnabled()) {
                            logger.error("Head Request[" + url + "] handle failed: must use http/https protocol port such as 9200,do not use other transport such as 9300.", (Throwable)ex);
                        }
                        if (!httpServiceHosts.reachEnd(triesCount)) {
                            ++triesCount;
                            continue;
                        }
                        break block51;
                    }
                    catch (Exception ex) {
                        e = ex;
                        break block51;
                    }
                    catch (Throwable ex) {
                        e = ex;
                        break block51;
                    }
                    finally {
                        if (httpHead != null) {
                            httpHead.releaseConnection();
                        }
                        httpClient = null;
                        continue;
                    }
                    break;
                }
            }
            try {
                if (logger.isTraceEnabled()) {
                    logger.trace("Head call {}", (Object)url);
                }
                httpClient = HttpRequestUtil.getHttpClient(config);
                httpHead = HttpRequestUtil.getHttpHead(config, url, cookie, userAgent, headers);
                BasicHttpParams httpParams = null;
                if (params != null && params.size() > 0) {
                    httpParams = new BasicHttpParams();
                    Iterator<Map.Entry<String, Object>> it = params.entrySet().iterator();
                    Object paramPair_ = null;
                    int i = 0;
                    while (it.hasNext()) {
                        Map.Entry<String, Object> entry = it.next();
                        httpParams.setParameter(entry.getKey(), entry.getValue());
                        ++i;
                    }
                    httpHead.setParams((HttpParams)httpParams);
                }
                if (responseHandler != null && responseHandler instanceof URLResponseHandler) {
                    ((URLResponseHandler)responseHandler).setUrl(url);
                }
                responseBody = httpClient.execute((HttpUriRequest)httpHead, responseHandler);
            }
            catch (Exception ex) {
                e = ex;
            }
            finally {
                if (httpHead != null) {
                    httpHead.releaseConnection();
                }
                httpClient = null;
            }
        }
        if (e != null) {
            if (e instanceof HttpProxyRequestException) {
                throw (HttpProxyRequestException)e;
            }
            throw new HttpProxyRequestException("Head request url:" + url, e);
        }
        return (T)responseBody;
    }

    public static String httpPostFileforString(String url, Map<String, Object> params, Map<String, File> files) throws HttpProxyRequestException {
        return HttpRequestProxy.httpPostFileforString("default", url, null, null, params, files);
    }

    public static String httpPostFileforString(String poolname, String url, Map<String, Object> params, Map<String, File> files) throws HttpProxyRequestException {
        return HttpRequestProxy.httpPostFileforString(poolname, url, null, null, params, files);
    }

    public static String httpPostforString(String url, Map<String, Object> params) throws HttpProxyRequestException {
        return HttpRequestProxy.httpPostforString(url, params, (Map<String, String>)null);
    }

    public static <T> T httpPost(String url, Map<String, Object> params, ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        return HttpRequestProxy.httpPostforString(url, params, (Map<String, String>)null, responseHandler);
    }

    public static <T> T httpPostForObject(String url, Map<String, Object> params, final Class<T> resultType) throws HttpProxyRequestException {
        return HttpRequestProxy.httpPostforString(url, params, (Map<String, String>)null, new BaseURLResponseHandler<T>(){

            public T handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                return HttpRequestProxy.handleResponse(this.url, response, resultType);
            }
        });
    }

    public static <T> List<T> httpPostForList(String url, Map<String, Object> params, final Class<T> resultType) throws HttpProxyRequestException {
        return (List)HttpRequestProxy.httpPostforString(url, params, (Map<String, String>)null, new BaseURLResponseHandler<List<T>>(){

            public List<T> handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                return HttpRequestProxy.handleListResponse(this.url, response, resultType);
            }
        });
    }

    public static <T> Set<T> httpPostForSet(String url, Map<String, Object> params, final Class<T> resultType) throws HttpProxyRequestException {
        return (Set)HttpRequestProxy.httpPostforString(url, params, (Map<String, String>)null, new BaseURLResponseHandler<Set<T>>(){

            public Set<T> handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                return HttpRequestProxy.handleSetResponse(this.url, response, resultType);
            }
        });
    }

    public static <K, T> Map<K, T> httpPostForMap(String url, Map<String, Object> params, final Class<K> keyType, final Class<T> resultType) throws HttpProxyRequestException {
        return (Map)HttpRequestProxy.httpPostforString(url, params, (Map<String, String>)null, new BaseURLResponseHandler<Map<K, T>>(){

            public Map<K, T> handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                return HttpRequestProxy.handleMapResponse(this.url, response, keyType, resultType);
            }
        });
    }

    public static <T> T httpPostForObject(String poolName, String url, Map<String, Object> params, final Class<T> resultType) throws HttpProxyRequestException {
        HttpOption httpOption = new HttpOption();
        httpOption.params = params;
        return HttpRequestProxy.httpPost(poolName, url, httpOption, new BaseURLResponseHandler<T>(){

            public T handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                return HttpRequestProxy.handleResponse(this.url, response, resultType);
            }
        });
    }

    public static <T> T httpPostForObject(String poolName, String url, Map<String, Object> params, final Class<T> resultType, DataSerialType dataSerialType) throws HttpProxyRequestException {
        HttpOption httpOption = new HttpOption();
        httpOption.params = params;
        httpOption.dataSerialType = dataSerialType;
        return HttpRequestProxy.httpPost(poolName, url, httpOption, new BaseURLResponseHandler<T>(){

            public T handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                return HttpRequestProxy.handleResponse(this.url, response, resultType);
            }
        });
    }

    public static <T> List<T> httpPostForList(String poolName, String url, Map<String, Object> params, final Class<T> resultType, DataSerialType dataSerialType) throws HttpProxyRequestException {
        HttpOption httpOption = new HttpOption();
        httpOption.params = params;
        httpOption.dataSerialType = dataSerialType;
        return (List)HttpRequestProxy.httpPost(poolName, url, httpOption, new BaseURLResponseHandler<List<T>>(){

            public List<T> handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                return HttpRequestProxy.handleListResponse(this.url, response, resultType);
            }
        });
    }

    public static <T> Set<T> httpPostForSet(String poolName, String url, Map<String, Object> params, final Class<T> resultType, DataSerialType dataSerialType) throws HttpProxyRequestException {
        HttpOption httpOption = new HttpOption();
        httpOption.params = params;
        httpOption.dataSerialType = dataSerialType;
        return (Set)HttpRequestProxy.httpPost(poolName, url, httpOption, new BaseURLResponseHandler<Set<T>>(){

            public Set<T> handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                return HttpRequestProxy.handleSetResponse(this.url, response, resultType);
            }
        });
    }

    public static <K, T> Map<K, T> httpPostForMap(String poolName, String url, Map<String, Object> params, final Class<K> keyType, final Class<T> resultType, DataSerialType dataSerialType) throws HttpProxyRequestException {
        HttpOption httpOption = new HttpOption();
        httpOption.params = params;
        httpOption.dataSerialType = dataSerialType;
        return (Map)HttpRequestProxy.httpPost(poolName, url, httpOption, new BaseURLResponseHandler<Map<K, T>>(){

            public Map<K, T> handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                return HttpRequestProxy.handleMapResponse(this.url, response, keyType, resultType);
            }
        });
    }

    public static <T> List<T> httpPostForList(String poolName, String url, Map<String, Object> params, final Class<T> resultType) throws HttpProxyRequestException {
        return (List)HttpRequestProxy.httpPostforString(poolName, url, params, (Map<String, String>)null, new BaseURLResponseHandler<List<T>>(){

            public List<T> handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                return HttpRequestProxy.handleListResponse(this.url, response, resultType);
            }
        });
    }

    public static <T> List<T> httpPostForList(String poolName, String url, final Class<T> resultType) throws HttpProxyRequestException {
        return (List)HttpRequestProxy.httpPostforString(poolName, url, (Map<String, Object>)null, (Map<String, String>)null, new BaseURLResponseHandler<List<T>>(){

            public List<T> handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                return HttpRequestProxy.handleListResponse(this.url, response, resultType);
            }
        });
    }

    public static <T> List<T> httpPostForList(String url, final Class<T> resultType) throws HttpProxyRequestException {
        return (List)HttpRequestProxy.httpPostforString((String)null, url, (Map<String, Object>)null, (Map<String, String>)null, new BaseURLResponseHandler<List<T>>(){

            public List<T> handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                return HttpRequestProxy.handleListResponse(this.url, response, resultType);
            }
        });
    }

    public static <T> Set<T> httpPostForSet(String poolName, String url, Map<String, Object> params, final Class<T> resultType) throws HttpProxyRequestException {
        return (Set)HttpRequestProxy.httpPostforString(poolName, url, params, (Map<String, String>)null, new BaseURLResponseHandler<Set<T>>(){

            public Set<T> handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                return HttpRequestProxy.handleSetResponse(this.url, response, resultType);
            }
        });
    }

    public static <K, T> Map<K, T> httpPostForMap(String poolName, String url, Map<String, Object> params, final Class<K> keyType, final Class<T> resultType) throws HttpProxyRequestException {
        return (Map)HttpRequestProxy.httpPostforString(poolName, url, params, (Map<String, String>)null, new BaseURLResponseHandler<Map<K, T>>(){

            public Map<K, T> handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                return HttpRequestProxy.handleMapResponse(this.url, response, keyType, resultType);
            }
        });
    }

    public static String httpPostforString(String url, Map<String, Object> params, Map<String, String> headers) throws HttpProxyRequestException {
        return HttpRequestProxy.httpPostFileforString("default", url, null, null, params, null, headers);
    }

    public static String httpPostforString(String poolName, String url, Map<String, Object> params, Map<String, String> headers) throws HttpProxyRequestException {
        return HttpRequestProxy.httpPostFileforString(poolName, url, null, null, params, null, headers);
    }

    public static <T> T httpPost(String url, Map<String, Object> params, Map<String, String> headers, ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        return HttpRequestProxy.httpPost("default", url, null, null, params, null, headers, responseHandler);
    }

    public static <T> T httpPostforString(String url, Map<String, Object> params, Map<String, String> headers, ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        return HttpRequestProxy.httpPost("default", url, null, null, params, null, headers, responseHandler);
    }

    public static <T> T httpPostforString(String poolName, String url, Map<String, Object> params, Map<String, String> headers, ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        return HttpRequestProxy.httpPost(poolName, url, null, null, params, null, headers, responseHandler);
    }

    public static String httpPostforString(String poolname, String url, Map<String, Object> params) throws HttpProxyRequestException {
        HttpOption httpOption = new HttpOption();
        httpOption.params = params;
        return HttpRequestProxy.httpPost(poolname, url, httpOption, new StringResponseHandler());
    }

    public static String httpPostforString(String poolname, String url, Map<String, Object> params, DataSerialType dataSerialType) throws HttpProxyRequestException {
        HttpOption httpOption = new HttpOption();
        httpOption.params = params;
        httpOption.dataSerialType = dataSerialType;
        return HttpRequestProxy.httpPost(poolname, url, httpOption, new StringResponseHandler());
    }

    public static String httpPostforString(String url) throws HttpProxyRequestException {
        return HttpRequestProxy.httpPostforString("default", url);
    }

    public static <T> T httpPost(String url, ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        return HttpRequestProxy.httpPost("default", url, responseHandler);
    }

    public static String httpPostforString(String poolname, String url) throws HttpProxyRequestException {
        return HttpRequestProxy.httpPostFileforString(poolname, url, null, null, null, null);
    }

    public static <T> T httpPost(String poolname, String url, ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        return HttpRequestProxy.httpPost(poolname, url, null, null, null, null, null, responseHandler);
    }

    public static String httpPostforString(String url, String cookie, String userAgent, Map<String, File> files) throws HttpProxyRequestException {
        return HttpRequestProxy.httpPostforString("default", url, cookie, userAgent, files);
    }

    public static String httpPostforString(String poolname, String url, String cookie, String userAgent, Map<String, File> files) throws HttpProxyRequestException {
        return HttpRequestProxy.httpPostFileforString(poolname, url, cookie, userAgent, null, files);
    }

    public static String httpPostforString(String url, String cookie, String userAgent, Map<String, Object> params, Map<String, File> files) throws HttpProxyRequestException {
        return HttpRequestProxy.httpPostFileforString("default", url, cookie, userAgent, params, files);
    }

    public static String httpPostFileforString(String poolname, String url, String cookie, String userAgent, Map<String, Object> params, Map<String, File> files) throws HttpProxyRequestException {
        return HttpRequestProxy.httpPostFileforString(poolname, url, cookie, userAgent, params, files, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T httpPost(String poolname, String url, HttpOption httpOption, ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        Throwable e;
        Object responseBody;
        block65: {
            int i;
            HttpClient httpClient = null;
            HttpPost httpPost = null;
            HttpEntity httpEntity = null;
            ArrayList<BasicNameValuePair> paramPair = null;
            if (httpOption.files != null) {
                MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
                int length = (httpOption.params == null ? 0 : httpOption.params.size()) + (httpOption.files == null ? 0 : httpOption.files.size());
                i = 0;
                boolean hasdata = false;
                if (httpOption.params != null) {
                    for (Map.Entry entry : httpOption.params.entrySet()) {
                        if (entry.getValue() == null) continue;
                        if (httpOption.dataSerialType != DataSerialType.JSON || entry.getValue() instanceof String) {
                            multipartEntityBuilder.addTextBody((String)entry.getKey(), String.valueOf(entry.getValue()), ClientConfiguration.TEXT_PLAIN_UTF_8);
                        } else {
                            multipartEntityBuilder.addTextBody((String)entry.getKey(), SimpleStringUtil.object2json(entry.getValue()), ClientConfiguration.TEXT_PLAIN_UTF_8);
                        }
                        hasdata = true;
                    }
                }
                if (httpOption.files != null) {
                    for (Map.Entry entry : httpOption.files.entrySet()) {
                        File f = new File(String.valueOf(entry.getValue()));
                        if (!f.exists()) continue;
                        FileBody file = new FileBody(f);
                        multipartEntityBuilder.addPart((String)entry.getKey(), (ContentBody)file);
                        hasdata = true;
                    }
                }
                if (hasdata) {
                    httpEntity = multipartEntityBuilder.build();
                }
            } else if (httpOption.params != null && httpOption.params.size() > 0) {
                paramPair = new ArrayList<BasicNameValuePair>();
                Iterator it = httpOption.params.entrySet().iterator();
                BasicNameValuePair paramPair_ = null;
                i = 0;
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    if (entry.getValue() != null) {
                        paramPair_ = httpOption.dataSerialType != DataSerialType.JSON || entry.getValue() instanceof String ? new BasicNameValuePair((String)entry.getKey(), String.valueOf(entry.getValue())) : new BasicNameValuePair((String)entry.getKey(), SimpleStringUtil.object2json(entry.getValue()));
                        paramPair.add(paramPair_);
                    }
                    ++i;
                }
            }
            responseBody = null;
            ClientConfiguration config = ClientConfiguration.getClientConfiguration(poolname);
            String endpoint = null;
            e = null;
            int triesCount = 0;
            if (!url.startsWith("http://") && !url.startsWith("https://")) {
                endpoint = url;
                HttpAddress httpAddress = null;
                HttpServiceHosts httpServiceHosts = config.getHttpServiceHosts();
                HttpRequestProxy.assertCheck(httpServiceHosts);
                while (true) {
                    try {
                        httpAddress = httpServiceHosts.getHttpAddress();
                        url = SimpleStringUtil.getPath((String)httpAddress.getAddress(), (String)endpoint);
                        if (logger.isTraceEnabled()) {
                            logger.trace("Post call {}", (Object)url);
                        }
                        httpClient = HttpRequestUtil.getHttpClient(config);
                        httpPost = HttpRequestUtil.getHttpPost(config, url, httpOption.cookie, httpOption.userAgent, httpOption.headers);
                        if (httpEntity != null) {
                            httpPost.setEntity(httpEntity);
                        } else if (paramPair != null && paramPair.size() > 0) {
                            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(paramPair, Consts.UTF_8);
                            httpPost.setEntity((HttpEntity)entity);
                        }
                        if (responseHandler != null && responseHandler instanceof URLResponseHandler) {
                            ((URLResponseHandler)responseHandler).setUrl(url);
                        }
                        responseBody = httpClient.execute((HttpUriRequest)httpPost, responseHandler);
                        httpAddress.recover();
                        e = HttpRequestProxy.getException(responseHandler, httpServiceHosts);
                        break block65;
                    }
                    catch (HttpHostConnectException ex) {
                        httpAddress.setStatus(1);
                        e = new NoHttpServerException(ex);
                        if (!httpServiceHosts.reachEnd(triesCount)) {
                            ++triesCount;
                            continue;
                        }
                        break block65;
                    }
                    catch (UnknownHostException ex) {
                        httpAddress.setStatus(1);
                        e = new NoHttpServerException(ex);
                        if (!httpServiceHosts.reachEnd(triesCount)) {
                            ++triesCount;
                            continue;
                        }
                        break block65;
                    }
                    catch (NoRouteToHostException ex) {
                        httpAddress.setStatus(1);
                        e = new NoHttpServerException(ex);
                        if (!httpServiceHosts.reachEnd(triesCount)) {
                            ++triesCount;
                            continue;
                        }
                        break block65;
                    }
                    catch (NoHttpResponseException ex) {
                        httpAddress.setStatus(1);
                        e = new NoHttpServerException(ex);
                        if (!httpServiceHosts.reachEnd(triesCount)) {
                            ++triesCount;
                            continue;
                        }
                        break block65;
                    }
                    catch (ConnectionPoolTimeoutException ex) {
                        e = HttpRequestProxy.handleConnectionPoolTimeOutException(config, ex);
                        break block65;
                    }
                    catch (ConnectTimeoutException connectTimeoutException) {
                        httpAddress.setStatus(1);
                        e = HttpRequestProxy.handleConnectionTimeOutException(config, connectTimeoutException);
                        if (!httpServiceHosts.reachEnd(triesCount)) {
                            ++triesCount;
                            continue;
                        }
                        break block65;
                    }
                    catch (SocketTimeoutException ex) {
                        e = HttpRequestProxy.handleSocketTimeoutException(config, ex);
                        break block65;
                    }
                    catch (NoHttpServerException ex) {
                        e = ex;
                        break block65;
                    }
                    catch (ClientProtocolException ex) {
                        httpAddress.setStatus(1);
                        e = ex;
                        if (logger.isErrorEnabled()) {
                            logger.error("Post Request[" + url + "] handle failed: must use http/https protocol port such as 9200,do not use other transport such as 9300.", (Throwable)ex);
                        }
                        if (!httpServiceHosts.reachEnd(triesCount)) {
                            ++triesCount;
                            continue;
                        }
                        break block65;
                    }
                    catch (Exception ex) {
                        e = ex;
                        break block65;
                    }
                    catch (Throwable ex) {
                        e = ex;
                        break block65;
                    }
                    finally {
                        if (httpPost != null) {
                            httpPost.releaseConnection();
                        }
                        httpClient = null;
                        continue;
                    }
                    break;
                }
            }
            try {
                if (logger.isTraceEnabled()) {
                    logger.trace("Post call {}", (Object)url);
                }
                httpClient = HttpRequestUtil.getHttpClient(config);
                httpPost = HttpRequestUtil.getHttpPost(config, url, httpOption.cookie, httpOption.userAgent, httpOption.headers);
                if (httpEntity != null) {
                    httpPost.setEntity(httpEntity);
                } else if (paramPair != null && paramPair.size() > 0) {
                    UrlEncodedFormEntity entity = new UrlEncodedFormEntity(paramPair, Consts.UTF_8);
                    httpPost.setEntity((HttpEntity)entity);
                }
                if (responseHandler != null && responseHandler instanceof URLResponseHandler) {
                    ((URLResponseHandler)responseHandler).setUrl(url);
                }
                responseBody = httpClient.execute((HttpUriRequest)httpPost, responseHandler);
            }
            catch (Exception ex) {
                e = ex;
            }
            finally {
                if (httpPost != null) {
                    httpPost.releaseConnection();
                }
                httpClient = null;
            }
        }
        if (e != null) {
            if (e instanceof HttpProxyRequestException) {
                throw (HttpProxyRequestException)e;
            }
            throw new HttpProxyRequestException("Post Url:" + url, e);
        }
        return (T)responseBody;
    }

    public static <T> T httpPost(String poolname, String url, String cookie, String userAgent, Map<String, Object> params, Map<String, File> files, Map<String, String> headers, ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        HttpOption httpOption = new HttpOption();
        httpOption.cookie = cookie;
        httpOption.userAgent = userAgent;
        httpOption.params = params;
        httpOption.files = files;
        httpOption.headers = headers;
        return HttpRequestProxy.httpPost(poolname, url, httpOption, responseHandler);
    }

    public static String httpPutforString(String poolname, String url, String cookie, String userAgent, Map<String, Object> params, Map<String, File> files, Map<String, String> headers) throws HttpProxyRequestException {
        HttpOption httpOption = new HttpOption();
        httpOption.cookie = cookie;
        httpOption.userAgent = userAgent;
        httpOption.params = params;
        httpOption.files = files;
        httpOption.headers = headers;
        return HttpRequestProxy.httpPut(poolname, url, httpOption, new StringResponseHandler());
    }

    public static String httpPutforString(String url, Map<String, Object> params, Map<String, String> headers) throws HttpProxyRequestException {
        HttpOption httpOption = new HttpOption();
        httpOption.params = params;
        httpOption.headers = headers;
        return HttpRequestProxy.httpPut("default", url, httpOption, new StringResponseHandler());
    }

    public static <T> T httpPutforObject(String url, Map<String, Object> params, Map<String, String> headers, final Class<T> resultType) throws HttpProxyRequestException {
        HttpOption httpOption = new HttpOption();
        httpOption.params = params;
        httpOption.headers = headers;
        return HttpRequestProxy.httpPut("default", url, httpOption, new BaseURLResponseHandler<T>(){

            public T handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                return HttpRequestProxy.handleResponse(this.url, response, resultType);
            }
        });
    }

    public static <T> List<T> httpPutforList(String url, Map<String, Object> params, Map<String, String> headers, final Class<T> resultType) throws HttpProxyRequestException {
        HttpOption httpOption = new HttpOption();
        httpOption.params = params;
        httpOption.headers = headers;
        return (List)HttpRequestProxy.httpPut("default", url, httpOption, new BaseURLResponseHandler<List<T>>(){

            public List<T> handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                return HttpRequestProxy.handleListResponse(this.url, response, resultType);
            }
        });
    }

    public static <T> Set<T> httpPutforSet(String url, Map<String, Object> params, Map<String, String> headers, final Class<T> resultType) throws HttpProxyRequestException {
        HttpOption httpOption = new HttpOption();
        httpOption.params = params;
        httpOption.headers = headers;
        return (Set)HttpRequestProxy.httpPut("default", url, httpOption, new BaseURLResponseHandler<Set<T>>(){

            public Set<T> handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                return HttpRequestProxy.handleSetResponse(this.url, response, resultType);
            }
        });
    }

    public static <K, T> Map<K, T> httpPutforObject(String url, Map<String, Object> params, Map<String, String> headers, final Class<K> keyType, final Class<T> resultType) throws HttpProxyRequestException {
        HttpOption httpOption = new HttpOption();
        httpOption.params = params;
        httpOption.headers = headers;
        return (Map)HttpRequestProxy.httpPut("default", url, httpOption, new BaseURLResponseHandler<Map<K, T>>(){

            public Map<K, T> handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                return HttpRequestProxy.handleMapResponse(this.url, response, keyType, resultType);
            }
        });
    }

    public static <T> T httpPutforObject(String poolName, String url, Map<String, Object> params, Map<String, String> headers, final Class<T> resultType) throws HttpProxyRequestException {
        HttpOption httpOption = new HttpOption();
        httpOption.params = params;
        httpOption.headers = headers;
        return HttpRequestProxy.httpPut(poolName, url, httpOption, new BaseURLResponseHandler<T>(){

            public T handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                return HttpRequestProxy.handleResponse(this.url, response, resultType);
            }
        });
    }

    public static <T> List<T> httpPutforList(String poolName, String url, Map<String, Object> params, Map<String, String> headers, final Class<T> resultType) throws HttpProxyRequestException {
        HttpOption httpOption = new HttpOption();
        httpOption.params = params;
        httpOption.headers = headers;
        return (List)HttpRequestProxy.httpPut(poolName, url, httpOption, new BaseURLResponseHandler<List<T>>(){

            public List<T> handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                return HttpRequestProxy.handleListResponse(this.url, response, resultType);
            }
        });
    }

    public static <T> Set<T> httpPutforSet(String poolName, String url, Map<String, Object> params, Map<String, String> headers, final Class<T> resultType) throws HttpProxyRequestException {
        HttpOption httpOption = new HttpOption();
        httpOption.params = params;
        httpOption.headers = headers;
        return (Set)HttpRequestProxy.httpPut(poolName, url, httpOption, new BaseURLResponseHandler<Set<T>>(){

            public Set<T> handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                return HttpRequestProxy.handleSetResponse(this.url, response, resultType);
            }
        });
    }

    public static <K, T> Map<K, T> httpPutforObject(String poolName, String url, Map<String, Object> params, Map<String, String> headers, final Class<K> keyType, final Class<T> resultType) throws HttpProxyRequestException {
        HttpOption httpOption = new HttpOption();
        httpOption.params = params;
        httpOption.headers = headers;
        return (Map)HttpRequestProxy.httpPut(poolName, url, httpOption, new BaseURLResponseHandler<Map<K, T>>(){

            public Map<K, T> handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                return HttpRequestProxy.handleMapResponse(this.url, response, keyType, resultType);
            }
        });
    }

    public static <T> T httpPutforString(String url, Map<String, Object> params, Map<String, String> headers, ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        HttpOption httpOption = new HttpOption();
        httpOption.params = params;
        httpOption.headers = headers;
        return HttpRequestProxy.httpPut("default", url, httpOption, responseHandler);
    }

    public static String httpPutforString(String poolname, String url, Map<String, Object> params, Map<String, String> headers) throws HttpProxyRequestException {
        HttpOption httpOption = new HttpOption();
        httpOption.params = params;
        httpOption.headers = headers;
        return HttpRequestProxy.httpPut(poolname, url, httpOption, new StringResponseHandler());
    }

    public static <T> T httpPutforString(String poolname, String url, Map<String, Object> params, Map<String, String> headers, ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        HttpOption httpOption = new HttpOption();
        httpOption.params = params;
        httpOption.headers = headers;
        return HttpRequestProxy.httpPut(poolname, url, httpOption, responseHandler);
    }

    public static <T> T httpPut(String url, String cookie, String userAgent, Map<String, Object> params, Map<String, File> files, Map<String, String> headers, ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        HttpOption httpOption = new HttpOption();
        httpOption.cookie = cookie;
        httpOption.userAgent = userAgent;
        httpOption.params = params;
        httpOption.headers = headers;
        httpOption.files = files;
        return HttpRequestProxy.httpPut("default", url, httpOption, responseHandler);
    }

    public static <T> T httpPut(String url, Map<String, Object> params, Map<String, String> headers, ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        return HttpRequestProxy.httpPut(url, null, null, params, null, headers, responseHandler);
    }

    public static <T> T httpPut(String url, Map<String, Object> params, ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        return HttpRequestProxy.httpPut(url, null, null, params, null, null, responseHandler);
    }

    public static <T> T httpPut(String url, ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        return HttpRequestProxy.httpPut(url, null, null, null, null, null, responseHandler);
    }

    public static <T> T httpPut(String url, final Class<T> resultType) throws HttpProxyRequestException {
        return HttpRequestProxy.httpPut(url, null, null, null, null, null, new BaseURLResponseHandler<T>(){

            public T handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                return HttpRequestProxy.handleResponse(this.url, response, resultType);
            }
        });
    }

    public static <T> List<T> httpPutForList(String url, final Class<T> resultType) throws HttpProxyRequestException {
        return (List)HttpRequestProxy.httpPut(url, null, null, null, null, null, new BaseURLResponseHandler<List<T>>(){

            public List<T> handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                return HttpRequestProxy.handleListResponse(this.url, response, resultType);
            }
        });
    }

    public static <T> Set<T> httpPutForSet(String url, final Class<T> resultType) throws HttpProxyRequestException {
        return (Set)HttpRequestProxy.httpPut(url, null, null, null, null, null, new BaseURLResponseHandler<Set<T>>(){

            public Set<T> handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                return HttpRequestProxy.handleSetResponse(this.url, response, resultType);
            }
        });
    }

    public static <K, T> Map<K, T> httpPutForMap(String url, final Class<K> keyType, final Class<T> resultType) throws HttpProxyRequestException {
        return (Map)HttpRequestProxy.httpPut(url, null, null, null, null, null, new BaseURLResponseHandler<Map<K, T>>(){

            public Map<K, T> handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                return HttpRequestProxy.handleMapResponse(this.url, response, keyType, resultType);
            }
        });
    }

    public static <T> T httpPut(String poolName, String url, final Class<T> resultType) throws HttpProxyRequestException {
        HttpOption httpOption = new HttpOption();
        return HttpRequestProxy.httpPut(poolName, url, httpOption, new BaseURLResponseHandler<T>(){

            public T handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                return HttpRequestProxy.handleResponse(this.url, response, resultType);
            }
        });
    }

    public static <T> List<T> httpPutForList(String poolName, String url, final Class<T> resultType) throws HttpProxyRequestException {
        HttpOption httpOption = new HttpOption();
        return (List)HttpRequestProxy.httpPut(poolName, url, httpOption, new BaseURLResponseHandler<List<T>>(){

            public List<T> handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                return HttpRequestProxy.handleListResponse(this.url, response, resultType);
            }
        });
    }

    public static <T> Set<T> httpPutForSet(String poolName, String url, final Class<T> resultType) throws HttpProxyRequestException {
        HttpOption httpOption = new HttpOption();
        return (Set)HttpRequestProxy.httpPut(poolName, url, httpOption, new BaseURLResponseHandler<Set<T>>(){

            public Set<T> handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                return HttpRequestProxy.handleSetResponse(this.url, response, resultType);
            }
        });
    }

    public static <K, T> Map<K, T> httpPutForMap(String poolName, String url, final Class<K> keyType, final Class<T> resultType) throws HttpProxyRequestException {
        HttpOption httpOption = new HttpOption();
        return (Map)HttpRequestProxy.httpPut(poolName, url, httpOption, new BaseURLResponseHandler<Map<K, T>>(){

            public Map<K, T> handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                return HttpRequestProxy.handleMapResponse(this.url, response, keyType, resultType);
            }
        });
    }

    public static <T> T httpPut(String poolname, String url, String cookie, String userAgent, Map<String, Object> params, Map<String, File> files, Map<String, String> headers, ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        HttpOption httpOption = new HttpOption();
        httpOption.cookie = cookie;
        httpOption.userAgent = userAgent;
        httpOption.params = params;
        httpOption.files = files;
        httpOption.headers = headers;
        return HttpRequestProxy.httpPut(poolname, url, httpOption, responseHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T httpPut(String poolname, String url, HttpOption httpOption, ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        Throwable e;
        Object responseBody;
        block65: {
            int i;
            HttpClient httpClient = null;
            HttpPut httpPut = null;
            HttpEntity httpEntity = null;
            ArrayList<BasicNameValuePair> paramPair = null;
            if (httpOption.files != null) {
                MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
                int length = (httpOption.params == null ? 0 : httpOption.params.size()) + (httpOption.files == null ? 0 : httpOption.files.size());
                i = 0;
                boolean hasdata = false;
                if (httpOption.params != null) {
                    for (Map.Entry entry : httpOption.params.entrySet()) {
                        if (entry.getValue() == null) continue;
                        if (httpOption.dataSerialType != DataSerialType.JSON || entry.getValue() instanceof String) {
                            multipartEntityBuilder.addTextBody((String)entry.getKey(), String.valueOf(entry.getValue()), ClientConfiguration.TEXT_PLAIN_UTF_8);
                        } else {
                            multipartEntityBuilder.addTextBody((String)entry.getKey(), SimpleStringUtil.object2json(entry.getValue()), ClientConfiguration.TEXT_PLAIN_UTF_8);
                        }
                        hasdata = true;
                    }
                }
                if (httpOption.files != null) {
                    for (Map.Entry entry : httpOption.files.entrySet()) {
                        File f = new File(String.valueOf(entry.getValue()));
                        if (!f.exists()) continue;
                        FileBody file = new FileBody(f);
                        multipartEntityBuilder.addPart((String)entry.getKey(), (ContentBody)file);
                        hasdata = true;
                    }
                }
                if (hasdata) {
                    httpEntity = multipartEntityBuilder.build();
                }
            } else if (httpOption.params != null && httpOption.params.size() > 0) {
                paramPair = new ArrayList<BasicNameValuePair>();
                Iterator it = httpOption.params.entrySet().iterator();
                BasicNameValuePair paramPair_ = null;
                i = 0;
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    if (entry.getValue() != null) {
                        paramPair_ = httpOption.dataSerialType != DataSerialType.JSON || entry.getValue() instanceof String ? new BasicNameValuePair((String)entry.getKey(), String.valueOf(entry.getValue())) : new BasicNameValuePair((String)entry.getKey(), SimpleStringUtil.object2json(entry.getValue()));
                        paramPair.add(paramPair_);
                    }
                    ++i;
                }
            }
            responseBody = null;
            ClientConfiguration config = ClientConfiguration.getClientConfiguration(poolname);
            String endpoint = null;
            e = null;
            int triesCount = 0;
            if (!url.startsWith("http://") && !url.startsWith("https://")) {
                endpoint = url;
                HttpAddress httpAddress = null;
                HttpServiceHosts httpServiceHosts = config.getHttpServiceHosts();
                HttpRequestProxy.assertCheck(httpServiceHosts);
                while (true) {
                    try {
                        httpAddress = httpServiceHosts.getHttpAddress();
                        url = SimpleStringUtil.getPath((String)httpAddress.getAddress(), (String)endpoint);
                        if (logger.isTraceEnabled()) {
                            logger.trace("Put call {}", (Object)url);
                        }
                        httpClient = HttpRequestUtil.getHttpClient(config);
                        httpPut = HttpRequestUtil.getHttpPut(config, url, httpOption.cookie, httpOption.userAgent, httpOption.headers);
                        if (httpEntity != null) {
                            httpPut.setEntity(httpEntity);
                        } else if (paramPair != null && paramPair.size() > 0) {
                            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(paramPair, Consts.UTF_8);
                            httpPut.setEntity((HttpEntity)entity);
                        }
                        if (responseHandler != null && responseHandler instanceof URLResponseHandler) {
                            ((URLResponseHandler)responseHandler).setUrl(url);
                        }
                        responseBody = httpClient.execute((HttpUriRequest)httpPut, responseHandler);
                        httpAddress.recover();
                        e = HttpRequestProxy.getException(responseHandler, httpServiceHosts);
                        break block65;
                    }
                    catch (HttpHostConnectException ex) {
                        httpAddress.setStatus(1);
                        e = new NoHttpServerException(ex);
                        if (!httpServiceHosts.reachEnd(triesCount)) {
                            ++triesCount;
                            continue;
                        }
                        break block65;
                    }
                    catch (UnknownHostException ex) {
                        httpAddress.setStatus(1);
                        e = new NoHttpServerException(ex);
                        if (!httpServiceHosts.reachEnd(triesCount)) {
                            ++triesCount;
                            continue;
                        }
                        break block65;
                    }
                    catch (NoRouteToHostException ex) {
                        httpAddress.setStatus(1);
                        e = new NoHttpServerException(ex);
                        if (!httpServiceHosts.reachEnd(triesCount)) {
                            ++triesCount;
                            continue;
                        }
                        break block65;
                    }
                    catch (NoHttpResponseException ex) {
                        httpAddress.setStatus(1);
                        e = new NoHttpServerException(ex);
                        if (!httpServiceHosts.reachEnd(triesCount)) {
                            ++triesCount;
                            continue;
                        }
                        break block65;
                    }
                    catch (ConnectionPoolTimeoutException ex) {
                        e = HttpRequestProxy.handleConnectionPoolTimeOutException(config, ex);
                        break block65;
                    }
                    catch (ConnectTimeoutException connectTimeoutException) {
                        httpAddress.setStatus(1);
                        e = HttpRequestProxy.handleConnectionTimeOutException(config, connectTimeoutException);
                        if (!httpServiceHosts.reachEnd(triesCount)) {
                            ++triesCount;
                            continue;
                        }
                        break block65;
                    }
                    catch (SocketTimeoutException ex) {
                        e = HttpRequestProxy.handleSocketTimeoutException(config, ex);
                        break block65;
                    }
                    catch (NoHttpServerException ex) {
                        e = ex;
                        break block65;
                    }
                    catch (ClientProtocolException ex) {
                        httpAddress.setStatus(1);
                        e = ex;
                        if (logger.isErrorEnabled()) {
                            logger.error("Put request[" + url + "] handle failed: must use http/https protocol port such as 9200,do not use other transport such as 9300.", (Throwable)ex);
                        }
                        if (!httpServiceHosts.reachEnd(triesCount)) {
                            ++triesCount;
                            continue;
                        }
                        break block65;
                    }
                    catch (Exception ex) {
                        e = ex;
                        break block65;
                    }
                    catch (Throwable ex) {
                        e = ex;
                        break block65;
                    }
                    finally {
                        if (httpPut != null) {
                            httpPut.releaseConnection();
                        }
                        httpClient = null;
                        continue;
                    }
                    break;
                }
            }
            try {
                if (logger.isTraceEnabled()) {
                    logger.trace("Put call {}", (Object)url);
                }
                httpClient = HttpRequestUtil.getHttpClient(config);
                httpPut = HttpRequestUtil.getHttpPut(config, url, httpOption.cookie, httpOption.userAgent, httpOption.headers);
                if (httpEntity != null) {
                    httpPut.setEntity(httpEntity);
                } else if (paramPair != null && paramPair.size() > 0) {
                    UrlEncodedFormEntity entity = new UrlEncodedFormEntity(paramPair, Consts.UTF_8);
                    httpPut.setEntity((HttpEntity)entity);
                }
                if (responseHandler != null && responseHandler instanceof URLResponseHandler) {
                    ((URLResponseHandler)responseHandler).setUrl(url);
                }
                responseBody = httpClient.execute((HttpUriRequest)httpPut, responseHandler);
            }
            catch (Exception ex) {
                e = ex;
            }
            finally {
                if (httpPut != null) {
                    httpPut.releaseConnection();
                }
                httpClient = null;
            }
        }
        if (e != null) {
            if (e instanceof HttpProxyRequestException) {
                throw (HttpProxyRequestException)e;
            }
            throw new HttpProxyRequestException("Put request Url:" + url, e);
        }
        return (T)responseBody;
    }

    public static String httpPostFileforString(String poolname, String url, String cookie, String userAgent, Map<String, Object> params, Map<String, File> files, Map<String, String> headers) throws HttpProxyRequestException {
        return HttpRequestProxy.httpPost(poolname, url, cookie, userAgent, params, files, headers, new StringResponseHandler());
    }

    public static String httpDelete(String poolname, String url) throws HttpProxyRequestException {
        return HttpRequestProxy.httpDelete(poolname, url, (String)null, (String)null, (Map<String, Object>)null, (Map<String, String>)null);
    }

    public static String httpDelete(String url) throws HttpProxyRequestException {
        return HttpRequestProxy.httpDelete("default", url, (String)null, (String)null, (Map<String, Object>)null, (Map<String, String>)null);
    }

    public static String httpDeleteWithbody(String url, String requestBody) throws HttpProxyRequestException {
        return HttpRequestProxy.httpDelete("default", url, requestBody, null, null, null, null);
    }

    public static String httpDelete(String url, Map<String, String> headers) throws HttpProxyRequestException {
        return HttpRequestProxy.httpDelete("default", url, (String)null, (String)null, (Map<String, Object>)null, headers);
    }

    public static String httpDelete(String url, String requestBody, Map<String, String> headers) throws HttpProxyRequestException {
        return HttpRequestProxy.httpDelete("default", url, requestBody, null, null, null, headers);
    }

    public static String httpDeleteWithbody(String url, String requestBody, Map<String, Object> params, Map<String, String> headers) throws HttpProxyRequestException {
        return HttpRequestProxy.httpDelete("default", url, requestBody, null, null, params, headers);
    }

    public static String httpDelete(String url, Map<String, Object> params, Map<String, String> headers) throws HttpProxyRequestException {
        return HttpRequestProxy.httpDelete("default", url, (String)null, (String)null, params, headers);
    }

    public static <T> T httpDelete(String url, Map<String, Object> params, Map<String, String> headers, ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        return HttpRequestProxy.httpDelete("default", url, null, null, null, params, headers, responseHandler);
    }

    public static <T> T httpDeleteWithBody(String url, String requestBody, Map<String, Object> params, Map<String, String> headers, ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        return HttpRequestProxy.httpDelete("default", url, requestBody, null, null, params, headers, responseHandler);
    }

    public static String httpDelete(String poolname, String url, Map<String, Object> params, Map<String, String> headers) throws HttpProxyRequestException {
        return HttpRequestProxy.httpDelete(poolname, url, (String)null, (String)null, params, headers);
    }

    public static String httpDelete(String poolname, String url, String requestBody, Map<String, Object> params, Map<String, String> headers) throws HttpProxyRequestException {
        return HttpRequestProxy.httpDelete(poolname, url, requestBody, null, null, params, headers);
    }

    public static <T> T httpDelete(String poolname, String url, Map<String, Object> params, Map<String, String> headers, ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        return HttpRequestProxy.httpDelete(poolname, url, null, null, null, params, headers, responseHandler);
    }

    public static <T> T httpDelete(String poolname, String url, String requestBody, Map<String, Object> params, Map<String, String> headers, ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        return HttpRequestProxy.httpDelete(poolname, url, requestBody, null, null, params, headers, responseHandler);
    }

    public static String httpDelete(String poolname, String url, String cookie, String userAgent, Map<String, Object> params, Map<String, String> headers) throws HttpProxyRequestException {
        return HttpRequestProxy.httpDelete(poolname, url, null, cookie, userAgent, params, headers, new StringResponseHandler());
    }

    public static String httpDelete(String poolname, String url, String requestBody, String cookie, String userAgent, Map<String, Object> params, Map<String, String> headers) throws HttpProxyRequestException {
        return HttpRequestProxy.httpDelete(poolname, url, requestBody, cookie, userAgent, params, headers, new StringResponseHandler());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T httpDelete(String poolname, String url, String requestBody, String cookie, String userAgent, Map<String, Object> params, Map<String, String> headers, ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        Throwable e;
        Object responseBody;
        block61: {
            HttpClient httpClient = null;
            HttpDeleteWithBody httpDeleteWithBody = null;
            HttpDelete httpDelete = null;
            responseBody = null;
            ClientConfiguration config = ClientConfiguration.getClientConfiguration(poolname);
            StringEntity httpEntity = requestBody == null ? null : new StringEntity(requestBody, ContentType.APPLICATION_JSON);
            String endpoint = null;
            e = null;
            int triesCount = 0;
            if (!url.startsWith("http://") && !url.startsWith("https://")) {
                endpoint = url;
                HttpAddress httpAddress = null;
                HttpServiceHosts httpServiceHosts = config.getHttpServiceHosts();
                HttpRequestProxy.assertCheck(httpServiceHosts);
                while (true) {
                    try {
                        httpAddress = httpServiceHosts.getHttpAddress();
                        url = SimpleStringUtil.getPath((String)httpAddress.getAddress(), (String)endpoint);
                        if (logger.isTraceEnabled()) {
                            logger.trace("Delete call {}", (Object)url);
                        }
                        httpClient = HttpRequestUtil.getHttpClient(config);
                        BasicHttpParams httpParams = null;
                        if (params != null && params.size() > 0) {
                            httpParams = new BasicHttpParams();
                            Iterator<Map.Entry<String, Object>> it = params.entrySet().iterator();
                            Object paramPair_ = null;
                            int i = 0;
                            while (it.hasNext()) {
                                Map.Entry<String, Object> entry = it.next();
                                httpParams.setParameter(entry.getKey(), entry.getValue());
                                ++i;
                            }
                        }
                        if (httpEntity != null) {
                            httpDeleteWithBody = HttpRequestUtil.getHttpDeleteWithBody(config, url, cookie, userAgent, headers);
                            httpDeleteWithBody.setEntity((HttpEntity)httpEntity);
                            if (httpParams != null) {
                                httpDeleteWithBody.setParams((HttpParams)httpParams);
                            }
                            if (responseHandler != null && responseHandler instanceof URLResponseHandler) {
                                ((URLResponseHandler)responseHandler).setUrl(url);
                            }
                            responseBody = httpClient.execute((HttpUriRequest)httpDeleteWithBody, responseHandler);
                            httpAddress.recover();
                        } else {
                            httpDelete = HttpRequestUtil.getHttpDelete(config, url, cookie, userAgent, headers);
                            if (httpParams != null) {
                                httpDelete.setParams((HttpParams)httpParams);
                            }
                            if (responseHandler != null && responseHandler instanceof URLResponseHandler) {
                                ((URLResponseHandler)responseHandler).setUrl(url);
                            }
                            responseBody = httpClient.execute((HttpUriRequest)httpDelete, responseHandler);
                            httpAddress.recover();
                        }
                        e = HttpRequestProxy.getException(responseHandler, httpServiceHosts);
                        break block61;
                    }
                    catch (HttpHostConnectException ex) {
                        httpAddress.setStatus(1);
                        e = new NoHttpServerException(ex);
                        if (!httpServiceHosts.reachEnd(triesCount)) {
                            ++triesCount;
                            continue;
                        }
                        break block61;
                    }
                    catch (UnknownHostException ex) {
                        httpAddress.setStatus(1);
                        e = new NoHttpServerException(ex);
                        if (!httpServiceHosts.reachEnd(triesCount)) {
                            ++triesCount;
                            continue;
                        }
                        break block61;
                    }
                    catch (NoRouteToHostException ex) {
                        httpAddress.setStatus(1);
                        e = new NoHttpServerException(ex);
                        if (!httpServiceHosts.reachEnd(triesCount)) {
                            ++triesCount;
                            continue;
                        }
                        break block61;
                    }
                    catch (NoHttpResponseException ex) {
                        httpAddress.setStatus(1);
                        e = new NoHttpServerException(ex);
                        if (!httpServiceHosts.reachEnd(triesCount)) {
                            ++triesCount;
                            continue;
                        }
                        break block61;
                    }
                    catch (ConnectionPoolTimeoutException ex) {
                        e = HttpRequestProxy.handleConnectionPoolTimeOutException(config, ex);
                        break block61;
                    }
                    catch (ConnectTimeoutException connectTimeoutException) {
                        httpAddress.setStatus(1);
                        e = HttpRequestProxy.handleConnectionTimeOutException(config, connectTimeoutException);
                        if (!httpServiceHosts.reachEnd(triesCount)) {
                            ++triesCount;
                            continue;
                        }
                        break block61;
                    }
                    catch (SocketTimeoutException ex) {
                        e = HttpRequestProxy.handleSocketTimeoutException(config, ex);
                        break block61;
                    }
                    catch (NoHttpServerException ex) {
                        e = ex;
                        break block61;
                    }
                    catch (ClientProtocolException ex) {
                        httpAddress.setStatus(1);
                        e = ex;
                        if (logger.isErrorEnabled()) {
                            logger.error("Delete request[" + url + "] handle failed: must use http/https protocol port such as 9200,do not use other transport such as 9300.", (Throwable)ex);
                        }
                        if (!httpServiceHosts.reachEnd(triesCount)) {
                            ++triesCount;
                            continue;
                        }
                        break block61;
                    }
                    catch (Exception ex) {
                        e = ex;
                        break block61;
                    }
                    catch (Throwable ex) {
                        e = ex;
                        break block61;
                    }
                    finally {
                        if (httpDelete != null) {
                            httpDelete.releaseConnection();
                        }
                        httpClient = null;
                        continue;
                    }
                    break;
                }
            }
            try {
                if (logger.isTraceEnabled()) {
                    logger.trace("Delete call {}", (Object)url);
                }
                httpClient = HttpRequestUtil.getHttpClient(config);
                BasicHttpParams httpParams = null;
                if (params != null && params.size() > 0) {
                    httpParams = new BasicHttpParams();
                    Iterator<Map.Entry<String, Object>> it = params.entrySet().iterator();
                    Object paramPair_ = null;
                    int i = 0;
                    while (it.hasNext()) {
                        Map.Entry<String, Object> entry = it.next();
                        httpParams.setParameter(entry.getKey(), entry.getValue());
                        ++i;
                    }
                }
                if (httpEntity != null) {
                    httpDeleteWithBody = HttpRequestUtil.getHttpDeleteWithBody(config, url, cookie, userAgent, headers);
                    httpDeleteWithBody.setEntity((HttpEntity)httpEntity);
                    if (httpParams != null) {
                        httpDeleteWithBody.setParams((HttpParams)httpParams);
                    }
                    if (responseHandler != null && responseHandler instanceof URLResponseHandler) {
                        ((URLResponseHandler)responseHandler).setUrl(url);
                    }
                    responseBody = httpClient.execute((HttpUriRequest)httpDeleteWithBody, responseHandler);
                } else {
                    httpDelete = HttpRequestUtil.getHttpDelete(config, url, cookie, userAgent, headers);
                    if (httpParams != null) {
                        httpDelete.setParams((HttpParams)httpParams);
                    }
                    if (responseHandler != null && responseHandler instanceof URLResponseHandler) {
                        ((URLResponseHandler)responseHandler).setUrl(url);
                    }
                    responseBody = httpClient.execute((HttpUriRequest)httpDelete, responseHandler);
                }
            }
            catch (Exception ex) {
                e = ex;
            }
            finally {
                if (httpDelete != null) {
                    httpDelete.releaseConnection();
                }
                httpClient = null;
            }
        }
        if (e != null) {
            if (e instanceof HttpProxyRequestException) {
                throw (HttpProxyRequestException)e;
            }
            throw new HttpProxyRequestException("Delete request Url:" + url, e);
        }
        return (T)responseBody;
    }

    public static String sendStringBody(String poolname, String requestBody, String url, Map<String, String> headers) throws HttpProxyRequestException {
        return HttpRequestProxy.sendBody(poolname, requestBody, url, headers, ContentType.create((String)"text/plain", (Charset)Consts.UTF_8));
    }

    public static String sendJsonBody(String poolname, String requestBody, String url) throws HttpProxyRequestException {
        return HttpRequestProxy.sendBody(poolname, requestBody, url, null, ContentType.APPLICATION_JSON);
    }

    public static <T> T sendJsonBody(String poolname, String requestBody, String url, Class<T> resultType) throws HttpProxyRequestException {
        return HttpRequestProxy.sendBody(poolname, requestBody, url, null, ContentType.APPLICATION_JSON, resultType);
    }

    public static <T> List<T> sendJsonBodyForList(String poolname, String requestBody, String url, Class<T> resultType) throws HttpProxyRequestException {
        return HttpRequestProxy.sendBodyForList(poolname, requestBody, url, null, ContentType.APPLICATION_JSON, resultType);
    }

    public static <T> Set<T> sendJsonBodyForSet(String poolname, String requestBody, String url, Class<T> resultType) throws HttpProxyRequestException {
        return HttpRequestProxy.sendBodyForSet(poolname, requestBody, url, null, ContentType.APPLICATION_JSON, resultType);
    }

    public static <K, T> Map<K, T> sendJsonBodyForMap(String poolname, String requestBody, String url, Class<K> keyType, Class<T> resultType) throws HttpProxyRequestException {
        return HttpRequestProxy.sendBodyForMap(poolname, requestBody, url, null, ContentType.APPLICATION_JSON, keyType, resultType);
    }

    public static String sendJsonBody(String poolname, Object requestBody, String url) throws HttpProxyRequestException {
        return HttpRequestProxy.sendBody(poolname, SimpleStringUtil.object2json((Object)requestBody), url, null, ContentType.APPLICATION_JSON);
    }

    public static <T> T sendJsonBody(String poolname, Object requestBody, String url, Class<T> resultType) throws HttpProxyRequestException {
        return HttpRequestProxy.sendBody(poolname, SimpleStringUtil.object2json((Object)requestBody), url, null, ContentType.APPLICATION_JSON, resultType);
    }

    public static <T> List<T> sendJsonBodyForList(String poolname, Object requestBody, String url, Class<T> resultType) throws HttpProxyRequestException {
        return HttpRequestProxy.sendBodyForList(poolname, SimpleStringUtil.object2json((Object)requestBody), url, null, ContentType.APPLICATION_JSON, resultType);
    }

    public static <T> List<T> sendJsonBodyForList(Object requestBody, String url, Class<T> resultType) throws HttpProxyRequestException {
        return HttpRequestProxy.sendBodyForList(null, SimpleStringUtil.object2json((Object)requestBody), url, null, ContentType.APPLICATION_JSON, resultType);
    }

    public static <T> Set<T> sendJsonBodyForSet(String poolname, Object requestBody, String url, Class<T> resultType) throws HttpProxyRequestException {
        return HttpRequestProxy.sendBodyForSet(poolname, SimpleStringUtil.object2json((Object)requestBody), url, null, ContentType.APPLICATION_JSON, resultType);
    }

    public static <K, T> Map<K, T> sendJsonBodyForMap(String poolname, Object requestBody, String url, Class<K> keyType, Class<T> resultType) throws HttpProxyRequestException {
        return HttpRequestProxy.sendBodyForMap(poolname, SimpleStringUtil.object2json((Object)requestBody), url, null, ContentType.APPLICATION_JSON, keyType, resultType);
    }

    public static String sendStringBody(String poolname, String requestBody, String url) throws HttpProxyRequestException {
        return HttpRequestProxy.sendBody(poolname, requestBody, url, null, ContentType.create((String)"text/plain", (Charset)Consts.UTF_8));
    }

    public static String sendJsonBody(String poolname, Object requestBody, String url, Map<String, String> headers) throws HttpProxyRequestException {
        return HttpRequestProxy.sendBody(poolname, SimpleStringUtil.object2json((Object)requestBody), url, headers, ContentType.APPLICATION_JSON);
    }

    public static String sendJsonBody(String poolname, String requestBody, String url, Map<String, String> headers) throws HttpProxyRequestException {
        return HttpRequestProxy.sendBody(poolname, requestBody, url, headers, ContentType.APPLICATION_JSON);
    }

    public static String sendStringBody(String requestBody, String url, Map<String, String> headers) throws HttpProxyRequestException {
        return HttpRequestProxy.sendBody("default", requestBody, url, headers, ContentType.create((String)"text/plain", (Charset)Consts.UTF_8));
    }

    public static String sendJsonBody(String requestBody, String url) throws HttpProxyRequestException {
        return HttpRequestProxy.sendBody("default", requestBody, url, null, ContentType.APPLICATION_JSON);
    }

    public static <T> T sendJsonBody(String requestBody, String url, Class<T> resultType) throws HttpProxyRequestException {
        return HttpRequestProxy.sendBody("default", requestBody, url, null, ContentType.APPLICATION_JSON, resultType);
    }

    public static String sendJsonBody(String url) throws HttpProxyRequestException {
        return HttpRequestProxy.sendBody("default", null, url, null, ContentType.APPLICATION_JSON);
    }

    public static String sendJsonBodyWithPool(String poolName, String url) throws HttpProxyRequestException {
        return HttpRequestProxy.sendBody(poolName, null, url, null, ContentType.APPLICATION_JSON);
    }

    public static String sendJsonBody(Object requestBody, String url) throws HttpProxyRequestException {
        return HttpRequestProxy.sendBody("default", SimpleStringUtil.object2json((Object)requestBody), url, null, ContentType.APPLICATION_JSON);
    }

    public static <T> T sendJsonBody(Object requestBody, String url, Class<T> resultType) throws HttpProxyRequestException {
        return HttpRequestProxy.sendBody("default", SimpleStringUtil.object2json((Object)requestBody), url, null, ContentType.APPLICATION_JSON, resultType);
    }

    public static String sendStringBody(String requestBody, String url) throws HttpProxyRequestException {
        return HttpRequestProxy.sendBody("default", requestBody, url, null, ContentType.create((String)"text/plain", (Charset)Consts.UTF_8));
    }

    public static String sendStringBody(String requestBody, String url, String mimeType, Charset charSet) throws HttpProxyRequestException {
        return HttpRequestProxy.sendBody("default", requestBody, url, null, ContentType.create((String)mimeType, (Charset)charSet));
    }

    public static String sendJsonBody(String requestBody, String url, Map<String, String> headers) throws HttpProxyRequestException {
        return HttpRequestProxy.sendBody("default", requestBody, url, headers, ContentType.APPLICATION_JSON);
    }

    public static <T> T sendJsonBody(String requestBody, String url, Map<String, String> headers, ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        return HttpRequestProxy.sendBody("default", requestBody, url, headers, ContentType.APPLICATION_JSON, responseHandler);
    }

    public static <T> T sendJsonBody(String poolname, String requestBody, String url, Map<String, String> headers, ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        return HttpRequestProxy.sendBody(poolname, requestBody, url, headers, ContentType.APPLICATION_JSON, responseHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T sendBody(String poolname, String requestBody, String url, Map<String, String> headers, ContentType contentType, ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        Throwable e;
        Object responseBody;
        block49: {
            HttpClient httpClient = null;
            HttpPost httpPost = null;
            StringEntity httpEntity = new StringEntity(requestBody, contentType);
            ClientConfiguration config = ClientConfiguration.getClientConfiguration(poolname);
            responseBody = null;
            String endpoint = null;
            e = null;
            int triesCount = 0;
            if (!url.startsWith("http://") && !url.startsWith("https://")) {
                endpoint = url;
                HttpAddress httpAddress = null;
                HttpServiceHosts httpServiceHosts = config.getHttpServiceHosts();
                HttpRequestProxy.assertCheck(httpServiceHosts);
                while (true) {
                    try {
                        httpAddress = httpServiceHosts.getHttpAddress();
                        url = SimpleStringUtil.getPath((String)httpAddress.getAddress(), (String)endpoint);
                        if (logger.isTraceEnabled()) {
                            logger.trace("sendBody call {}", (Object)url);
                        }
                        httpClient = HttpRequestUtil.getHttpClient(config);
                        httpPost = HttpRequestUtil.getHttpPost(config, url, "", "", headers);
                        if (httpEntity != null) {
                            httpPost.setEntity((HttpEntity)httpEntity);
                        }
                        if (responseHandler != null && responseHandler instanceof URLResponseHandler) {
                            ((URLResponseHandler)responseHandler).setUrl(url);
                        }
                        responseBody = httpClient.execute((HttpUriRequest)httpPost, responseHandler);
                        httpAddress.recover();
                        e = HttpRequestProxy.getException(responseHandler, httpServiceHosts);
                        break block49;
                    }
                    catch (HttpHostConnectException ex) {
                        httpAddress.setStatus(1);
                        e = new NoHttpServerException(ex);
                        if (!httpServiceHosts.reachEnd(triesCount)) {
                            ++triesCount;
                            continue;
                        }
                        break block49;
                    }
                    catch (UnknownHostException ex) {
                        httpAddress.setStatus(1);
                        e = new NoHttpServerException(ex);
                        if (!httpServiceHosts.reachEnd(triesCount)) {
                            ++triesCount;
                            continue;
                        }
                        break block49;
                    }
                    catch (NoRouteToHostException ex) {
                        httpAddress.setStatus(1);
                        e = new NoHttpServerException(ex);
                        if (!httpServiceHosts.reachEnd(triesCount)) {
                            ++triesCount;
                            continue;
                        }
                        break block49;
                    }
                    catch (NoHttpResponseException ex) {
                        httpAddress.setStatus(1);
                        e = new NoHttpServerException(ex);
                        if (!httpServiceHosts.reachEnd(triesCount)) {
                            ++triesCount;
                            continue;
                        }
                        break block49;
                    }
                    catch (ConnectionPoolTimeoutException ex) {
                        e = HttpRequestProxy.handleConnectionPoolTimeOutException(config, ex);
                        break block49;
                    }
                    catch (ConnectTimeoutException connectTimeoutException) {
                        httpAddress.setStatus(1);
                        e = HttpRequestProxy.handleConnectionTimeOutException(config, connectTimeoutException);
                        if (!httpServiceHosts.reachEnd(triesCount)) {
                            ++triesCount;
                            continue;
                        }
                        break block49;
                    }
                    catch (SocketTimeoutException ex) {
                        e = HttpRequestProxy.handleSocketTimeoutException(config, ex);
                        break block49;
                    }
                    catch (NoHttpServerException ex) {
                        e = ex;
                        break block49;
                    }
                    catch (ClientProtocolException ex) {
                        httpAddress.setStatus(1);
                        e = ex;
                        if (logger.isErrorEnabled()) {
                            logger.error("Post request[" + url + "] handle failed: must use http/https protocol port such as 9200,do not use other transport such as 9300.", (Throwable)ex);
                        }
                        if (!httpServiceHosts.reachEnd(triesCount)) {
                            ++triesCount;
                            continue;
                        }
                        break block49;
                    }
                    catch (Exception ex) {
                        e = ex;
                        break block49;
                    }
                    catch (Throwable ex) {
                        e = ex;
                        break block49;
                    }
                    finally {
                        if (httpPost != null) {
                            httpPost.releaseConnection();
                        }
                        httpClient = null;
                        continue;
                    }
                    break;
                }
            }
            try {
                if (logger.isTraceEnabled()) {
                    logger.trace("sendBody call {}", (Object)url);
                }
                httpClient = HttpRequestUtil.getHttpClient(config);
                httpPost = HttpRequestUtil.getHttpPost(config, url, "", "", headers);
                if (httpEntity != null) {
                    httpPost.setEntity((HttpEntity)httpEntity);
                }
                if (responseHandler != null && responseHandler instanceof URLResponseHandler) {
                    ((URLResponseHandler)responseHandler).setUrl(url);
                }
                responseBody = httpClient.execute((HttpUriRequest)httpPost, responseHandler);
            }
            catch (Exception ex) {
                e = ex;
            }
            finally {
                if (httpPost != null) {
                    httpPost.releaseConnection();
                }
                httpClient = null;
            }
        }
        if (e != null) {
            if (e instanceof HttpProxyRequestException) {
                throw (HttpProxyRequestException)e;
            }
            throw new HttpProxyRequestException("Post request Url:" + url, e);
        }
        return (T)responseBody;
    }

    private static HttpRequestBase getHttpEntityEnclosingRequestBase(String action, ClientConfiguration config, String url, Map<String, String> headers) {
        if (action.equals("post")) {
            return HttpRequestUtil.getHttpPost(config, url, null, null, headers);
        }
        if (action.equals("get")) {
            return HttpRequestUtil.getHttpGet(config, url, null, null, headers);
        }
        if (action.equals("put")) {
            return HttpRequestUtil.getHttpPut(config, url, null, null, headers);
        }
        if (action.equals("delete")) {
            return HttpRequestUtil.getHttpDelete(config, url, null, null, headers);
        }
        if (action.equals("head")) {
            return HttpRequestUtil.getHttpHead(config, url, null, null, headers);
        }
        if (action.equals("trace")) {
            return HttpRequestUtil.getHttpTrace(config, url, null, null, headers);
        }
        if (action.equals("options")) {
            return HttpRequestUtil.getHttpOptions(config, url, null, null, headers);
        }
        if (action.equals("patch")) {
            return HttpRequestUtil.getHttpPatch(config, url, null, null, headers);
        }
        throw new IllegalArgumentException("not support http action:" + action);
    }

    private static HttpProxyRequestException handleSocketTimeoutException(ClientConfiguration configuration, SocketTimeoutException ex) {
        if (configuration == null) {
            return new HttpProxyRequestException(ex);
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Socket Timeout for ").append(configuration.getTimeoutSocket()).append("ms.");
        return new HttpProxyRequestException(builder.toString(), ex);
    }

    private static HttpProxyRequestException handleConnectionPoolTimeOutException(ClientConfiguration configuration, ConnectionPoolTimeoutException ex) {
        if (configuration == null) {
            return new HttpProxyRequestException(ex);
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Wait timeout for ").append(configuration.getConnectionRequestTimeout()).append("ms for idle http connection from http connection pool.");
        return new HttpProxyRequestException(builder.toString(), ex);
    }

    private static HttpProxyRequestException handleConnectionTimeOutException(ClientConfiguration configuration, ConnectTimeoutException ex) {
        if (configuration == null) {
            return new HttpProxyRequestException(ex);
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Build a http connection timeout for ").append(configuration.getTimeoutConnection()).append("ms.");
        return new HttpProxyRequestException(builder.toString(), ex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T sendBody(String poolname, String requestBody, String url, Map<String, String> headers, ContentType contentType, ResponseHandler<T> responseHandler, String action) throws HttpProxyRequestException {
        Throwable e;
        Object responseBody;
        block49: {
            HttpClient httpClient = null;
            HttpEntityEnclosingRequestBase httpPost = null;
            StringEntity httpEntity = requestBody != null ? new StringEntity(requestBody, contentType) : null;
            ClientConfiguration config = ClientConfiguration.getClientConfiguration(poolname);
            responseBody = null;
            String endpoint = null;
            e = null;
            int triesCount = 0;
            if (!url.startsWith("http://") && !url.startsWith("https://")) {
                endpoint = url;
                HttpAddress httpAddress = null;
                HttpServiceHosts httpServiceHosts = config.getHttpServiceHosts();
                HttpRequestProxy.assertCheck(httpServiceHosts);
                while (true) {
                    try {
                        httpAddress = httpServiceHosts.getHttpAddress();
                        url = SimpleStringUtil.getPath((String)httpAddress.getAddress(), (String)endpoint);
                        if (logger.isTraceEnabled()) {
                            logger.trace("sendBody call {}", (Object)url);
                        }
                        httpClient = HttpRequestUtil.getHttpClient(config);
                        httpPost = (HttpEntityEnclosingRequestBase)HttpRequestProxy.getHttpEntityEnclosingRequestBase(action, config, url, headers);
                        if (httpEntity != null) {
                            httpPost.setEntity((HttpEntity)httpEntity);
                        }
                        if (responseHandler != null && responseHandler instanceof URLResponseHandler) {
                            ((URLResponseHandler)responseHandler).setUrl(url);
                        }
                        responseBody = httpClient.execute((HttpUriRequest)httpPost, responseHandler);
                        httpAddress.recover();
                        e = HttpRequestProxy.getException(responseHandler, httpServiceHosts);
                        break block49;
                    }
                    catch (HttpHostConnectException ex) {
                        httpAddress.setStatus(1);
                        e = new NoHttpServerException(ex);
                        if (!httpServiceHosts.reachEnd(triesCount)) {
                            ++triesCount;
                            continue;
                        }
                        break block49;
                    }
                    catch (UnknownHostException ex) {
                        httpAddress.setStatus(1);
                        e = new NoHttpServerException(ex);
                        if (!httpServiceHosts.reachEnd(triesCount)) {
                            ++triesCount;
                            continue;
                        }
                        break block49;
                    }
                    catch (NoRouteToHostException ex) {
                        httpAddress.setStatus(1);
                        e = new NoHttpServerException(ex);
                        if (!httpServiceHosts.reachEnd(triesCount)) {
                            ++triesCount;
                            continue;
                        }
                        break block49;
                    }
                    catch (NoHttpResponseException ex) {
                        httpAddress.setStatus(1);
                        e = new NoHttpServerException(ex);
                        if (!httpServiceHosts.reachEnd(triesCount)) {
                            ++triesCount;
                            continue;
                        }
                        break block49;
                    }
                    catch (ConnectionPoolTimeoutException ex) {
                        e = HttpRequestProxy.handleConnectionPoolTimeOutException(config, ex);
                        break block49;
                    }
                    catch (ConnectTimeoutException connectTimeoutException) {
                        httpAddress.setStatus(1);
                        e = HttpRequestProxy.handleConnectionTimeOutException(config, connectTimeoutException);
                        if (!httpServiceHosts.reachEnd(triesCount)) {
                            ++triesCount;
                            continue;
                        }
                        break block49;
                    }
                    catch (SocketTimeoutException ex) {
                        e = HttpRequestProxy.handleSocketTimeoutException(config, ex);
                        break block49;
                    }
                    catch (NoHttpServerException ex) {
                        e = ex;
                        break block49;
                    }
                    catch (ClientProtocolException ex) {
                        httpAddress.setStatus(1);
                        e = ex;
                        if (logger.isErrorEnabled()) {
                            logger.error("Post request[" + url + "] handle failed: must use http/https protocol port such as 9200,do not use other transport such as 9300.", (Throwable)ex);
                        }
                        if (!httpServiceHosts.reachEnd(triesCount)) {
                            ++triesCount;
                            continue;
                        }
                        break block49;
                    }
                    catch (Exception ex) {
                        e = ex;
                        break block49;
                    }
                    catch (Throwable ex) {
                        e = ex;
                        break block49;
                    }
                    finally {
                        if (httpPost != null) {
                            httpPost.releaseConnection();
                        }
                        httpClient = null;
                        continue;
                    }
                    break;
                }
            }
            try {
                if (logger.isTraceEnabled()) {
                    logger.trace("sendBody call {}", (Object)url);
                }
                httpClient = HttpRequestUtil.getHttpClient(config);
                httpPost = (HttpEntityEnclosingRequestBase)HttpRequestProxy.getHttpEntityEnclosingRequestBase(action, config, url, headers);
                if (httpEntity != null) {
                    httpPost.setEntity((HttpEntity)httpEntity);
                }
                if (responseHandler != null && responseHandler instanceof URLResponseHandler) {
                    ((URLResponseHandler)responseHandler).setUrl(url);
                }
                responseBody = httpClient.execute((HttpUriRequest)httpPost, responseHandler);
            }
            catch (Exception ex) {
                e = ex;
            }
            finally {
                if (httpPost != null) {
                    httpPost.releaseConnection();
                }
                httpClient = null;
            }
        }
        if (e != null) {
            if (e instanceof HttpProxyRequestException) {
                throw (HttpProxyRequestException)e;
            }
            throw new HttpProxyRequestException("Post request Url:" + url, e);
        }
        return (T)responseBody;
    }

    public static String sendBody(String poolname, String requestBody, String url, Map<String, String> headers, ContentType contentType) throws HttpProxyRequestException {
        return HttpRequestProxy.sendBody(poolname, requestBody, url, headers, contentType, new BaseURLResponseHandler<String>(){

            public String handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                int status = response.getStatusLine().getStatusCode();
                if (status >= 200 && status < 300) {
                    HttpEntity entity = response.getEntity();
                    return entity != null ? EntityUtils.toString((HttpEntity)entity) : null;
                }
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    return EntityUtils.toString((HttpEntity)entity);
                }
                throw new HttpProxyRequestException("Post request url:" + this.url + ",Unexpected response status: " + status);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T converJson(HttpEntity entity, Class<T> clazz) throws IOException {
        Object var4;
        InputStream inputStream = null;
        try {
            inputStream = entity.getContent();
            if (inputStream instanceof EmptyInputStream) {
                T t = null;
                return t;
            }
            var4 = SimpleStringUtil.json2Object((InputStream)inputStream, clazz);
        }
        finally {
            inputStream.close();
        }
        return (T)var4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<T> converJson2List(HttpEntity entity, Class<T> clazz) throws IOException {
        List var4;
        InputStream inputStream = null;
        try {
            inputStream = entity.getContent();
            var4 = SimpleStringUtil.json2ListObject((InputStream)inputStream, clazz);
        }
        finally {
            inputStream.close();
        }
        return var4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> Set<T> converJson2Set(HttpEntity entity, Class<T> clazz) throws IOException {
        Set var4;
        InputStream inputStream = null;
        try {
            inputStream = entity.getContent();
            var4 = SimpleStringUtil.json2LSetObject((InputStream)inputStream, clazz);
        }
        finally {
            inputStream.close();
        }
        return var4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, T> Map<K, T> converJson2Map(HttpEntity entity, Class<K> keyType, Class<T> beanType) throws IOException {
        Map var4;
        InputStream inputStream = null;
        try {
            inputStream = entity.getContent();
            var4 = SimpleStringUtil.json2LHashObject((InputStream)inputStream, keyType, beanType);
        }
        finally {
            inputStream.close();
        }
        return var4;
    }

    public static <K, T> Map<K, T> handleMapResponse(String url, HttpResponse response, Class<K> keyType, Class<T> beanType) throws ClientProtocolException, IOException {
        int status = response.getStatusLine().getStatusCode();
        if (status >= 200 && status < 300) {
            HttpEntity entity = response.getEntity();
            return entity != null ? HttpRequestProxy.converJson2Map(entity, keyType, beanType) : null;
        }
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Request url:" + url + ",status:" + status);
            }
            throw new HttpProxyRequestException(EntityUtils.toString((HttpEntity)entity));
        }
        throw new HttpProxyRequestException("Request url:" + url + ",Unexpected response status: " + status);
    }

    public static <T> List<T> handleListResponse(String url, HttpResponse response, Class<T> resultType) throws ClientProtocolException, IOException {
        int status = response.getStatusLine().getStatusCode();
        if (status >= 200 && status < 300) {
            HttpEntity entity = response.getEntity();
            return entity != null ? HttpRequestProxy.converJson2List(entity, resultType) : null;
        }
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Request url:" + url + ",status:" + status);
            }
            throw new HttpProxyRequestException(EntityUtils.toString((HttpEntity)entity));
        }
        throw new HttpProxyRequestException("Request url:" + url + ",Unexpected response status: " + status);
    }

    public static <T> Set<T> handleSetResponse(String url, HttpResponse response, Class<T> resultType) throws ClientProtocolException, IOException {
        int status = response.getStatusLine().getStatusCode();
        if (status >= 200 && status < 300) {
            HttpEntity entity = response.getEntity();
            return entity != null ? HttpRequestProxy.converJson2Set(entity, resultType) : null;
        }
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Request url:" + url + ",status:" + status);
            }
            throw new HttpProxyRequestException(EntityUtils.toString((HttpEntity)entity));
        }
        throw new HttpProxyRequestException("Request url:" + url + ",Unexpected response status: " + status);
    }

    public static <T> T handleResponse(String url, HttpResponse response, Class<T> resultType) throws ClientProtocolException, IOException {
        int status = response.getStatusLine().getStatusCode();
        if (status >= 200 && status < 300) {
            HttpEntity entity = response.getEntity();
            return entity != null ? (T)HttpRequestProxy.converJson(entity, resultType) : null;
        }
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Request url:" + url + ",status:" + status);
            }
            throw new HttpProxyRequestException(EntityUtils.toString((HttpEntity)entity));
        }
        throw new HttpProxyRequestException("Request url:" + url + ",Unexpected response status: " + status);
    }

    public static <T> T sendBody(String poolname, String requestBody, String url, Map<String, String> headers, ContentType contentType, final Class<T> resultType) throws HttpProxyRequestException {
        return HttpRequestProxy.sendBody(poolname, requestBody, url, headers, contentType, new BaseURLResponseHandler<T>(){

            public T handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                return HttpRequestProxy.handleResponse(this.url, response, resultType);
            }
        });
    }

    public static <T> List<T> sendBodyForList(String poolname, String requestBody, String url, Map<String, String> headers, ContentType contentType, final Class<T> resultType) throws HttpProxyRequestException {
        return (List)HttpRequestProxy.sendBody(poolname, requestBody, url, headers, contentType, new BaseURLResponseHandler<List<T>>(){

            public List<T> handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                return HttpRequestProxy.handleListResponse(this.url, response, resultType);
            }
        });
    }

    public static <T> Set<T> sendBodyForSet(String poolname, String requestBody, String url, Map<String, String> headers, ContentType contentType, final Class<T> resultType) throws HttpProxyRequestException {
        return (Set)HttpRequestProxy.sendBody(poolname, requestBody, url, headers, contentType, new BaseURLResponseHandler<Set<T>>(){

            public Set<T> handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                return HttpRequestProxy.handleSetResponse(this.url, response, resultType);
            }
        });
    }

    public static <K, T> Map<K, T> sendBodyForMap(String poolname, String requestBody, String url, Map<String, String> headers, ContentType contentType, final Class<K> keyType, final Class<T> resultType) throws HttpProxyRequestException {
        return (Map)HttpRequestProxy.sendBody(poolname, requestBody, url, headers, contentType, new BaseURLResponseHandler<Map<K, T>>(){

            public Map<K, T> handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                return HttpRequestProxy.handleMapResponse(this.url, response, keyType, resultType);
            }
        });
    }

    private static void assertCheck(HttpServiceHosts httpServiceHosts) {
        if (httpServiceHosts == null) {
            if (logger.isWarnEnabled()) {
                logger.warn("Http Request Proxy is not properly initialized, please refer to the document: https://esdoc.bbossgroups.com/#/httpproxy?id=_32-http\u8d1f\u8f7d\u5747\u8861\u5668\u914d\u7f6e\u548c\u542f\u52a8");
            }
            throw new HttpProxyRequestException("Http Request Proxy is not properly initialized, please refer to the document: https://esdoc.bbossgroups.com/#/httpproxy?id=_32-http\u8d1f\u8f7d\u5747\u8861\u5668\u914d\u7f6e\u548c\u542f\u52a8");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T putBody(String poolname, String requestBody, String url, Map<String, String> headers, ContentType contentType, ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        Throwable e;
        Object responseBody;
        block46: {
            HttpClient httpClient = null;
            HttpPut httpPost = null;
            StringEntity httpEntity = new StringEntity(requestBody, contentType);
            ClientConfiguration config = ClientConfiguration.getClientConfiguration(poolname);
            responseBody = null;
            String endpoint = null;
            e = null;
            int triesCount = 0;
            if (!url.startsWith("http://") && !url.startsWith("https://")) {
                endpoint = url;
                HttpAddress httpAddress = null;
                HttpServiceHosts httpServiceHosts = config.getHttpServiceHosts();
                HttpRequestProxy.assertCheck(httpServiceHosts);
                while (true) {
                    try {
                        httpAddress = httpServiceHosts.getHttpAddress();
                        url = SimpleStringUtil.getPath((String)httpAddress.getAddress(), (String)endpoint);
                        if (logger.isTraceEnabled()) {
                            logger.trace("putBody call {}", (Object)url);
                        }
                        httpClient = HttpRequestUtil.getHttpClient(config);
                        httpPost = HttpRequestUtil.getHttpPut(config, url, "", "", headers);
                        if (httpEntity != null) {
                            httpPost.setEntity((HttpEntity)httpEntity);
                        }
                        if (responseHandler != null && responseHandler instanceof URLResponseHandler) {
                            ((URLResponseHandler)responseHandler).setUrl(url);
                        }
                        responseBody = httpClient.execute((HttpUriRequest)httpPost, responseHandler);
                        httpAddress.recover();
                        e = HttpRequestProxy.getException(responseHandler, httpServiceHosts);
                        break block46;
                    }
                    catch (HttpHostConnectException ex) {
                        httpAddress.setStatus(1);
                        e = new NoHttpServerException(ex);
                        if (!httpServiceHosts.reachEnd(triesCount)) {
                            ++triesCount;
                            continue;
                        }
                        break block46;
                    }
                    catch (UnknownHostException ex) {
                        httpAddress.setStatus(1);
                        e = new NoHttpServerException(ex);
                        if (!httpServiceHosts.reachEnd(triesCount)) {
                            ++triesCount;
                            continue;
                        }
                        break block46;
                    }
                    catch (NoRouteToHostException ex) {
                        httpAddress.setStatus(1);
                        e = new NoHttpServerException(ex);
                        if (!httpServiceHosts.reachEnd(triesCount)) {
                            ++triesCount;
                            continue;
                        }
                        break block46;
                    }
                    catch (NoHttpResponseException ex) {
                        httpAddress.setStatus(1);
                        e = new NoHttpServerException(ex);
                        if (!httpServiceHosts.reachEnd(triesCount)) {
                            ++triesCount;
                            continue;
                        }
                        break block46;
                    }
                    catch (ConnectionPoolTimeoutException ex) {
                        e = HttpRequestProxy.handleConnectionPoolTimeOutException(config, ex);
                        break block46;
                    }
                    catch (ConnectTimeoutException connectTimeoutException) {
                        httpAddress.setStatus(1);
                        e = HttpRequestProxy.handleConnectionTimeOutException(config, connectTimeoutException);
                        if (!httpServiceHosts.reachEnd(triesCount)) {
                            ++triesCount;
                            continue;
                        }
                        break block46;
                    }
                    catch (SocketTimeoutException ex) {
                        e = HttpRequestProxy.handleSocketTimeoutException(config, ex);
                        break block46;
                    }
                    catch (NoHttpServerException ex) {
                        e = ex;
                        break block46;
                    }
                    catch (ClientProtocolException ex) {
                        throw new HttpProxyRequestException("Put Request[" + url + "] handle failed: must use http/https protocol port such as 9200,do not use other transport such as 9300.", ex);
                    }
                    catch (Exception ex) {
                        e = ex;
                        break block46;
                    }
                    catch (Throwable ex) {
                        e = ex;
                        break block46;
                    }
                    finally {
                        if (httpPost != null) {
                            httpPost.releaseConnection();
                        }
                        httpClient = null;
                        continue;
                    }
                    break;
                }
            }
            try {
                if (logger.isTraceEnabled()) {
                    logger.trace("putBody call {}", (Object)url);
                }
                httpClient = HttpRequestUtil.getHttpClient(config);
                httpPost = HttpRequestUtil.getHttpPut(config, url, "", "", headers);
                if (httpEntity != null) {
                    httpPost.setEntity((HttpEntity)httpEntity);
                }
                if (responseHandler != null && responseHandler instanceof URLResponseHandler) {
                    ((URLResponseHandler)responseHandler).setUrl(url);
                }
                responseBody = httpClient.execute((HttpUriRequest)httpPost, responseHandler);
            }
            catch (Exception ex) {
                e = ex;
            }
            finally {
                if (httpPost != null) {
                    httpPost.releaseConnection();
                }
                httpClient = null;
            }
        }
        if (e != null) {
            if (e instanceof HttpProxyRequestException) {
                throw (HttpProxyRequestException)e;
            }
            throw new HttpProxyRequestException("Put request url:" + url, e);
        }
        return (T)responseBody;
    }

    public static String putBody(String poolname, String requestBody, String url, Map<String, String> headers, ContentType contentType) throws HttpProxyRequestException {
        return HttpRequestProxy.putBody(poolname, requestBody, url, headers, contentType, new BaseURLResponseHandler<String>(){

            public String handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                int status = response.getStatusLine().getStatusCode();
                if (status >= 200 && status < 300) {
                    HttpEntity entity = response.getEntity();
                    return entity != null ? EntityUtils.toString((HttpEntity)entity) : null;
                }
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("PUT Request url:" + this.url + ",status:" + status);
                    }
                    throw new HttpProxyRequestException(EntityUtils.toString((HttpEntity)entity));
                }
                throw new HttpProxyRequestException("Put request url:" + this.url + ",Unexpected response status: " + status);
            }
        });
    }

    public static <T> T putBody(String requestBody, String url, Map<String, String> headers, ContentType contentType, ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        return HttpRequestProxy.putBody("default", requestBody, url, headers, contentType, responseHandler);
    }

    public static String putBody(String requestBody, String url, Map<String, String> headers, ContentType contentType) throws HttpProxyRequestException {
        return HttpRequestProxy.putBody("default", requestBody, url, headers, contentType);
    }

    public static <T> T putJson(String poolname, String requestBody, String url, Map<String, String> headers, ContentType contentType, ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        return HttpRequestProxy.putJson(poolname, requestBody, url, headers, ContentType.APPLICATION_JSON, responseHandler);
    }

    public static String putJson(String poolname, String requestBody, String url, Map<String, String> headers, ContentType contentType) throws HttpProxyRequestException {
        return HttpRequestProxy.putJson(poolname, requestBody, url, headers, ContentType.APPLICATION_JSON);
    }

    public static <T> T putJson(String requestBody, String url, Map<String, String> headers, ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        return HttpRequestProxy.putBody("default", requestBody, url, headers, ContentType.APPLICATION_JSON, responseHandler);
    }

    public static <T> T putJson(String poolName, String requestBody, String url, Map<String, String> headers, ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        return HttpRequestProxy.putBody(poolName, requestBody, url, headers, ContentType.APPLICATION_JSON, responseHandler);
    }

    public static String putJson(String requestBody, String url, Map<String, String> headers) throws HttpProxyRequestException {
        return HttpRequestProxy.putBody("default", requestBody, url, headers, ContentType.APPLICATION_JSON);
    }

    public static String putJson(String poolName, String requestBody, String url, Map<String, String> headers) throws HttpProxyRequestException {
        return HttpRequestProxy.putBody(poolName, requestBody, url, headers, ContentType.APPLICATION_JSON);
    }

    public static class HttpOption {
        private String cookie;
        private String userAgent;
        private Map<String, Object> params;
        private Map<String, File> files;
        private Map<String, String> headers;
        private DataSerialType dataSerialType = DataSerialType.TEXT;
    }
}

