/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.spi.remote.http.ssl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.frameworkset.spi.remote.http.HttpRuntimeException;
import org.frameworkset.spi.remote.http.ssl.EmptyArrays;
import org.frameworkset.spi.remote.http.ssl.SSLCertificateHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLHelper {
    private static final Logger log = LoggerFactory.getLogger(SSLHelper.class);
    private static final String DEFAULT_STORE_TYPE = "JKS";
    static final String PROTOCOL = "TLS";

    static TrustManagerFactory buildTrustManagerFactory(X509Certificate[] certCollection, TrustManagerFactory trustManagerFactory) throws NoSuchAlgorithmException, CertificateException, KeyStoreException, IOException {
        KeyStore ks = KeyStore.getInstance(DEFAULT_STORE_TYPE);
        ks.load(null, null);
        int i = 1;
        for (X509Certificate cert : certCollection) {
            String alias = Integer.toString(i);
            ks.setCertificateEntry(alias, cert);
            ++i;
        }
        if (trustManagerFactory == null) {
            trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        }
        trustManagerFactory.init(ks);
        return trustManagerFactory;
    }

    static KeyManagerFactory buildKeyManagerFactory(X509Certificate[] certChain, PrivateKey key, String keyPassword, KeyManagerFactory kmf) throws UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        String algorithm = Security.getProperty("ssl.KeyManagerFactory.algorithm");
        if (algorithm == null) {
            algorithm = "SunX509";
        }
        return SSLHelper.buildKeyManagerFactory(certChain, algorithm, key, keyPassword, kmf);
    }

    static KeyStore buildKeyStore(X509Certificate[] certChain, PrivateKey key, char[] keyPasswordChars) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        KeyStore ks = KeyStore.getInstance(DEFAULT_STORE_TYPE);
        ks.load(null, null);
        ks.setKeyEntry("key", key, keyPasswordChars, certChain);
        return ks;
    }

    static KeyManagerFactory buildKeyManagerFactory(X509Certificate[] certChainFile, String keyAlgorithm, PrivateKey key, String keyPassword, KeyManagerFactory kmf) throws KeyStoreException, NoSuchAlgorithmException, IOException, CertificateException, UnrecoverableKeyException {
        char[] keyPasswordChars = keyPassword == null ? EmptyArrays.EMPTY_CHARS : keyPassword.toCharArray();
        KeyStore ks = SSLHelper.buildKeyStore(certChainFile, key, keyPasswordChars);
        if (kmf == null) {
            kmf = KeyManagerFactory.getInstance(keyAlgorithm);
        }
        kmf.init(ks, keyPasswordChars);
        return kmf;
    }

    public static SSLContext newSSLContext(String PROTOCOL, Provider sslContextProvider, X509Certificate[] trustCertCollection, TrustManagerFactory trustManagerFactory, X509Certificate[] keyCertChain, PrivateKey key, String keyPassword, KeyManagerFactory keyManagerFactory, long sessionCacheSize, long sessionTimeout) throws SSLException {
        if (key == null && keyManagerFactory == null) {
            throw new NullPointerException("key, keyManagerFactory");
        }
        try {
            if (trustCertCollection != null) {
                trustManagerFactory = SSLHelper.buildTrustManagerFactory(trustCertCollection, trustManagerFactory);
            }
            if (key != null) {
                keyManagerFactory = SSLHelper.buildKeyManagerFactory(keyCertChain, key, keyPassword, keyManagerFactory);
            }
            SSLContext ctx = sslContextProvider == null ? SSLContext.getInstance(PROTOCOL) : SSLContext.getInstance(PROTOCOL, sslContextProvider);
            ctx.init(keyManagerFactory.getKeyManagers(), trustManagerFactory == null ? null : trustManagerFactory.getTrustManagers(), null);
            SSLSessionContext sessCtx = ctx.getServerSessionContext();
            if (sessionCacheSize > 0L) {
                sessCtx.setSessionCacheSize((int)Math.min(sessionCacheSize, Integer.MAX_VALUE));
            }
            if (sessionTimeout > 0L) {
                sessCtx.setSessionTimeout((int)Math.min(sessionTimeout, Integer.MAX_VALUE));
            }
            return ctx;
        }
        catch (Exception e) {
            if (e instanceof SSLException) {
                throw (SSLException)e;
            }
            throw new SSLException("failed to initialize the server-side SSL context", e);
        }
    }

    public static SSLContext initSSLConfig(String keystore, String keyPassword) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException, KeyManagementException {
        SSLContextBuilder builder = SSLContexts.custom().loadTrustMaterial(new File(keystore), keyPassword.toCharArray(), (TrustStrategy)new TrustSelfSignedStrategy());
        return builder.build();
    }

    public static SSLContext initSSLConfig(String PROTOCOL, String keystoreFilePath, String keystoreType, String keystorePassword, String keystoreAlias, String truststoreFilePath, String truststoreType, String truststorePassword, String truststoreAlias) {
        if (keystoreFilePath != null) {
            try {
                KeyStore ks = KeyStore.getInstance(keystoreType);
                try {
                    FileInputStream fin = new FileInputStream(new File(keystoreFilePath));
                    ks.load(fin, keystorePassword == null || keystorePassword.length() == 0 ? null : keystorePassword.toCharArray());
                }
                catch (Exception e) {
                    throw new HttpRuntimeException(e);
                }
                X509Certificate[] httpKeystoreCert = SSLCertificateHelper.exportServerCertChain(ks, keystoreAlias);
                PrivateKey httpKeystoreKey = SSLCertificateHelper.exportDecryptedKey(ks, keystoreAlias, keystorePassword == null || keystorePassword.length() == 0 ? null : keystorePassword.toCharArray());
                if (httpKeystoreKey == null) {
                    throw new HttpRuntimeException("No key found in " + keystoreFilePath + " with alias " + keystoreAlias);
                }
                if (httpKeystoreCert == null || httpKeystoreCert.length <= 0) {
                    throw new HttpRuntimeException("No certificates found in " + keystoreFilePath + " with alias " + keystoreAlias);
                }
                X509Certificate[] trustedHTTPCertificates = null;
                if (truststoreFilePath != null) {
                    KeyStore ts = KeyStore.getInstance(truststoreType);
                    try {
                        FileInputStream fin = new FileInputStream(new File(truststoreFilePath));
                        ts.load(fin, truststorePassword == null || truststorePassword.length() == 0 ? null : truststorePassword.toCharArray());
                    }
                    catch (Exception e) {
                        throw new HttpRuntimeException(e);
                    }
                    trustedHTTPCertificates = SSLCertificateHelper.exportRootCertificates(ts, truststoreAlias);
                }
                SSLContext sslContext = SSLHelper.newSSLContext(PROTOCOL, null, trustedHTTPCertificates, null, httpKeystoreCert, httpKeystoreKey, keystorePassword, null, 0L, 0L);
                return sslContext;
            }
            catch (Exception e) {
                throw new HttpRuntimeException("Error while initializing HTTP SSL layer: " + e.toString(), e);
            }
        }
        throw new HttpRuntimeException("Error while initializing HTTP SSL layer: keystoreFilePath is null.");
    }

    public static SSLContext initSSLConfig(String PROTOCOL, String pemKey, String pemKeyPassword, String pemCert, String pemtrustCA) {
        if (pemKey != null) {
            try {
                X509Certificate[] httpKeystoreCert = SSLCertificateHelper.toX509Certificates(new File(pemCert));
                PrivateKey httpKeystoreKey = SSLCertificateHelper.toPrivateKey(new File(pemKey), pemKeyPassword);
                if (httpKeystoreKey == null) {
                    throw new HttpRuntimeException("No key found in pemKey " + pemKey + " with pemKeyPassword " + pemKeyPassword);
                }
                if (httpKeystoreCert == null || httpKeystoreCert.length <= 0) {
                    throw new HttpRuntimeException("No certificates found in pemCert " + pemCert);
                }
                X509Certificate[] trustedHTTPCertificates = null;
                if (pemtrustCA != null) {
                    trustedHTTPCertificates = SSLCertificateHelper.toX509Certificates(new File(pemtrustCA));
                }
                SSLContext sslContext = SSLHelper.newSSLContext(PROTOCOL, null, trustedHTTPCertificates, null, httpKeystoreCert, httpKeystoreKey, pemKeyPassword, null, 0L, 0L);
                return sslContext;
            }
            catch (Exception e) {
                throw new HttpRuntimeException("Error while initializing HTTP SSL layer: " + e.toString(), e);
            }
        }
        throw new HttpRuntimeException("Error while initializing HTTP SSL layer: keystoreFilePath is null.");
    }
}

