/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.common.poolman;

import com.frameworkset.common.poolman.NestedSQLException;
import com.frameworkset.common.poolman.NewSQLInfo;
import com.frameworkset.common.poolman.Record;
import com.frameworkset.common.poolman.ResultMap;
import com.frameworkset.common.poolman.StatementInfo;
import com.frameworkset.common.poolman.handle.NullRowHandler;
import com.frameworkset.common.poolman.handle.RowHandler;
import com.frameworkset.common.poolman.handle.ValueExchange;
import com.frameworkset.common.poolman.handle.XMLMark;
import com.frameworkset.common.poolman.sql.PrimaryKey;
import com.frameworkset.common.poolman.sql.PrimaryKeyCacheManager;
import com.frameworkset.common.poolman.sql.UpdateSQL;
import com.frameworkset.common.poolman.util.SQLManager;
import com.frameworkset.common.poolman.util.SQLUtil;
import com.frameworkset.common.poolman.util.StatementParser;
import com.frameworkset.orm.transaction.JDBCTransaction;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBUtil
extends SQLUtil
implements Serializable {
    protected boolean oldcommited = true;
    private static Logger log = LoggerFactory.getLogger(DBUtil.class);
    protected String oraclerownum;
    protected String batchDBName = null;
    protected boolean isRobustQuery = false;
    protected int fetchsize = 0;
    protected int fetchoffset = 0;
    protected int fetcholdrowid = 0;
    protected String fetchdbName = null;
    protected String fetchsql;
    protected Record[] allResults;
    protected List batchSQLS;
    protected long totalSize = 0L;

    public void setBatchConnection(Connection con) {
    }

    public int size() {
        return this.isRobustQuery ? (int)this.totalSize : this.size;
    }

    public long longsize() {
        return this.isRobustQuery ? this.totalSize : (long)this.size;
    }

    public int getTotalSize() {
        return (int)this.totalSize;
    }

    public long getLongTotalSize() {
        return this.totalSize;
    }

    private void assertLoaded(int rowid) throws SQLException {
        if (this.isRobustQuery) {
            if (rowid == this.fetcholdrowid) {
                return;
            }
            int bound = this.fetchoffset + this.fetchsize;
            int newOffset = this.fetchoffset;
            if (this.allResults == null) {
                newOffset = rowid - rowid % this.fetchsize;
            } else if (rowid >= bound) {
                newOffset = rowid - rowid % this.fetchsize;
            } else if (rowid < this.fetchoffset) {
                newOffset = rowid - rowid % this.fetchsize;
            }
            if (newOffset != this.fetchoffset) {
                this.executeSelect(this.fetchdbName, this.fetchsql, newOffset, this.fetchsize);
                this.fetchoffset = newOffset;
            }
            this.fetcholdrowid = rowid;
        }
    }

    private int getTrueRowid(int rowid) {
        if (!this.isRobustQuery) {
            return rowid;
        }
        return rowid - this.fetchoffset;
    }

    public float getFloat(int rowid, int column) throws SQLException {
        this.inrange(rowid, column);
        return this.allResults[this.getTrueRowid(rowid)].getFloat(column);
    }

    public String getValue(int rowid, int column) {
        try {
            this.inrange(rowid, column);
            return this.allResults[this.getTrueRowid(rowid)].getString(column);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return "";
        }
    }

    public String getString(int rowid, int column, String defalueValue) throws SQLException {
        this.inrange(rowid, column);
        String value = this.allResults[this.getTrueRowid(rowid)].getString(column);
        if (value != null) {
            return value;
        }
        return defalueValue;
    }

    public String getValue(int rowid, int column, String defaultValue) throws SQLException {
        this.inrange(rowid, column);
        String value = this.allResults[this.getTrueRowid(rowid)].getString(column);
        return value != null ? value : "";
    }

    public String getString(int rowid, int column) throws SQLException {
        this.inrange(rowid, column);
        return this.allResults[this.getTrueRowid(rowid)].getString(column);
    }

    public void getFile(int rowid, String column, File file) throws SQLException, IOException {
        this.inrange(rowid, column);
        this.allResults[this.getTrueRowid(rowid)].getFile(column, file);
    }

    public void getFile(int rowid, int column, File file) throws SQLException, IOException {
        this.inrange(rowid, column);
        this.allResults[this.getTrueRowid(rowid)].getFile(column, file);
    }

    public String getValue(int rowid, String field) throws SQLException {
        this.inrange(rowid, field);
        return this.allResults[this.getTrueRowid(rowid)].getString(field);
    }

    public String getValue(int rowid, String field, String defaultValue) throws SQLException {
        String value = this.getValue(rowid, field);
        if (value != null) {
            return field;
        }
        return defaultValue;
    }

    public int getInt(int rowid, String field) throws SQLException {
        this.inrange(rowid, field);
        return this.allResults[this.getTrueRowid(rowid)].getInt(field);
    }

    public int getInt(int rowid, int column) throws SQLException {
        this.inrange(rowid, column);
        return this.allResults[this.getTrueRowid(rowid)].getInt(column);
    }

    public float getFloat(int rowid, String field) throws SQLException {
        this.inrange(rowid, field);
        return this.allResults[this.getTrueRowid(rowid)].getFloat(field);
    }

    public double getDouble(int rowid, String field) throws SQLException {
        this.inrange(rowid, field);
        return this.allResults[this.getTrueRowid(rowid)].getDouble(field);
    }

    public double getDouble(int rowid, int column) throws SQLException {
        this.inrange(rowid, column);
        return this.allResults[this.getTrueRowid(rowid)].getDouble(column);
    }

    public long getLong(int rowid, String field) throws SQLException {
        this.inrange(rowid, field);
        return this.allResults[this.getTrueRowid(rowid)].getLong(field);
    }

    public long getLong(int rowid, int column) throws SQLException {
        this.inrange(rowid, column);
        return this.allResults[this.getTrueRowid(rowid)].getLong(column);
    }

    public byte[] getByteArray(int rowid, String field) throws SQLException {
        this.inrange(rowid, field);
        return this.allResults[this.getTrueRowid(rowid)].getBytes(field);
    }

    public byte[] getByteArray(int rowid, int column) throws SQLException {
        this.inrange(rowid, column);
        return this.allResults[this.getTrueRowid(rowid)].getBytes(column);
    }

    public String getString(int rowid, String field) throws SQLException {
        this.inrange(rowid, field);
        String value = this.allResults[this.getTrueRowid(rowid)].getString(field);
        return value != null ? value : "";
    }

    public String getString(int rowid, String field, String defaultValue) throws SQLException {
        Object value = this.getObject(rowid, field);
        if (value != null) {
            return ValueExchange.getStringFromObject(value);
        }
        return defaultValue;
    }

    public Object getObject(int rowid, String field) throws SQLException {
        this.inrange(rowid, field);
        return this.allResults[this.getTrueRowid(rowid)].getObject(field);
    }

    protected void inrange(int rowid, int column) throws SQLException {
        if (rowid >= this.size() || rowid < 0) {
            throw new SQLException("out of row range:" + rowid);
        }
        if (column >= this.meta.getColumnCounts() || column < 0) {
            throw new SQLException("out of column range:" + column);
        }
        this.assertLoaded(rowid);
    }

    protected void inrange(int rowid, String columnName) throws SQLException {
        if (rowid >= this.size() || rowid < 0) {
            throw new SQLException("out of row range: " + rowid);
        }
        if (columnName == null || columnName.trim().equals("")) {
            throw new SQLException("field name error:[field=" + columnName + "]");
        }
        this.assertLoaded(rowid);
        if (!this.check(columnName)) {
            throw new SQLException("Field [" + columnName + "] is not in the query list.");
        }
    }

    protected void inrange(int rowid) throws SQLException {
        if (rowid >= this.size() || rowid < 0) {
            throw new SQLException("out of row range:" + rowid);
        }
        this.assertLoaded(rowid);
    }

    public Object getObject(int rowid, int column) throws SQLException {
        this.inrange(rowid, column);
        Object object = this.allResults[this.getTrueRowid(rowid)].getObject(column);
        return object;
    }

    public Date getDate(int rowid, String field) throws SQLException {
        this.inrange(rowid, field);
        return this.allResults[this.getTrueRowid(rowid)].getDate(field);
    }

    public Date getDate(int rowid, int column) throws SQLException {
        this.inrange(rowid, column);
        return this.allResults[this.getTrueRowid(rowid)].getDate(column);
    }

    private boolean check(String field) {
        return true;
    }

    protected Record[] doJDBC(String dbname, String sql, boolean goNative, long offset, int maxsize, Connection con_, Class objectType, RowHandler rowHandler, int resultType) throws SQLException {
        StatementInfo stmtInfo = null;
        try {
            stmtInfo = new StatementInfo(dbname, new NewSQLInfo(sql), goNative, offset, maxsize, DBUtil.isRobotQuery(dbname), con_, this.oraclerownum);
            Record[] recordArray = this.doJDBC(stmtInfo, objectType, rowHandler);
            return recordArray;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            if (stmtInfo != null) {
                stmtInfo.dofinally();
                stmtInfo = null;
            }
        }
    }

    protected ResultMap innerExecutePagineJDBC(StatementInfo stmtInfo, Class objectType, RowHandler rowhandler, int result_type) throws SQLException {
        ResultMap resultMap = new ResultMap();
        try {
            ResultSet res = null;
            Statement s = null;
            Statement s1 = null;
            ResultSet rs = null;
            stmtInfo.init();
            s = stmtInfo.createStatement(1004, stmtInfo.getCursorType(stmtInfo.getDbname()));
            String count = stmtInfo.countSql();
            s1 = stmtInfo.createStatement(1004, stmtInfo.getCursorType(stmtInfo.getDbname()));
            rs = s1.executeQuery(count);
            stmtInfo.addResultSet(rs);
            if (rs.next()) {
                this.totalSize = rs.getInt(1);
            }
            stmtInfo.rebuildOffset(this.totalSize);
            if (this.totalSize > 0L) {
                String paginesql = stmtInfo.paginesql(false).getSql();
                if (log.isInfoEnabled() && DBUtil.showsql(stmtInfo.getDbname())) {
                    log.info("JDBC pageine origine statement:{}", (Object)stmtInfo.getSql());
                    log.info("JDBC pageine statement:{}", (Object)paginesql);
                }
                s.execute(paginesql);
                res = s.getResultSet();
                stmtInfo.addResultSet(res);
                stmtInfo.absolute(res);
                stmtInfo.cacheResultSetMetaData(res, true);
                this.meta = stmtInfo.getMeta();
                resultMap = stmtInfo.buildResultMap(res, objectType, rowhandler, stmtInfo.getMaxsize(), true, result_type);
                if (resultMap != null) {
                    this.size = resultMap.getSize();
                }
            }
            ResultMap resultMap2 = resultMap;
            return resultMap2;
        }
        catch (SQLException sqle) {
            try {
                log.error(sqle.getMessage(), (Throwable)sqle);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (stmtInfo != null) {
                stmtInfo.errorHandle(sqle);
            }
            throw sqle;
        }
        catch (Exception e) {
            try {
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (stmtInfo != null) {
                stmtInfo.errorHandle(e);
            }
            throw new NestedSQLException(e.getMessage(), (Throwable)e);
        }
        finally {
            if (stmtInfo != null) {
                stmtInfo.dofinally();
            }
        }
    }

    protected Record[] doJDBC(StatementInfo stmtInfo, Class objectType, RowHandler rowHandler) throws SQLException {
        ResultMap resultMap = this.innerExecutePagineJDBC(stmtInfo, objectType, rowHandler, ResultMap.type_maparray);
        return (Record[])resultMap.getCommonresult();
    }

    public Object executeInsert(String dbname, String sql) throws SQLException {
        return this.executeInsert(dbname, sql, null);
    }

    public Object executeInsert(String dbname, String sql, Connection con) throws SQLException {
        return this.doJDBCInsert(sql, dbname, false, con);
    }

    public Object executeInsert(String sql) throws SQLException {
        return this.executeInsert(sql, (Connection)null);
    }

    public Object executeInsert(String sql, Connection con) throws SQLException {
        return this.executeInsert(null, sql, con);
    }

    public Object executeDelete(String sql) throws SQLException {
        return this.executeDelete(SQLManager.getInstance().getDefaultDBName(), sql);
    }

    public Object executeDelete(String dbName, String sql, Connection con) throws SQLException {
        return this.executeSql(dbName, sql, con);
    }

    public Object executeDelete(String dbName, String sql) throws SQLException {
        return this.executeDelete(dbName, sql, (Connection)null);
    }

    public Object executeDelete(String sql, boolean goNative, Connection con) throws SQLException {
        return this.executeDelete(SQLManager.getInstance().getDefaultDBName(), sql, goNative, con);
    }

    public Object executeDelete(String dbName, String sql, boolean goNative, Connection con) throws SQLException {
        return this.doJDBC(dbName, sql, goNative, con);
    }

    public void executeSelect(String dbName, String sql, int fetchsize) throws SQLException {
        this.isRobustQuery = true;
        this.fetchsize = fetchsize;
        this.fetchdbName = dbName;
        this.fetchsql = sql;
        this.executeSelect(dbName, sql, this.fetchoffset, fetchsize);
    }

    public void executeSelect(String sql, int fetchsize) throws SQLException {
        this.executeSelect(null, sql, fetchsize);
    }

    public void resetFetch() {
        this.isRobustQuery = false;
        this.fetchsize = 0;
        this.fetchdbName = null;
        this.fetchsql = null;
        this.totalSize = 0L;
        this.allResults = null;
        this.size = 0;
        this.fetcholdrowid = 0;
    }

    public void resetPager() {
        this.totalSize = 0L;
        this.size = 0;
        this.allResults = null;
    }

    public void resetBatch() {
        this.autocommit = true;
        this.batchautocommit = false;
        if (this.batchSQLS != null) {
            this.batchSQLS.clear();
            this.batchSQLS = null;
        }
        this.setBatchDBName(SQLManager.getInstance().getDefaultDBName());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object doJDBCInsert(String sql_, String dbname_, boolean goNative_, Connection con_) throws SQLException {
        int i;
        StatementInfo stmtInfo = null;
        Statement s = null;
        try {
            stmtInfo = new StatementInfo(dbname_, new NewSQLInfo(sql_), goNative_, con_, false);
            stmtInfo.init();
            boolean autokey = DBUtil.isAutoprimarykey(dbname_);
            s = stmtInfo.createStatement();
            if (autokey) {
                Object[] temp = StatementParser.refactorInsertStatement(stmtInfo.getCon(), stmtInfo.getSql(), stmtInfo.getDbname());
                PrimaryKey primaryKey = (PrimaryKey)temp[3];
                if (temp[1] != null) {
                    try {
                        String changesqlString = (String)temp[0];
                        if (log.isInfoEnabled() && DBUtil.showsql(dbname_)) {
                            log.info("JDBC Insert statement:{}", (Object)stmtInfo.getSql());
                        }
                        s.executeUpdate(changesqlString);
                        if (temp[2] != null && temp[3] != null) {
                            UpdateSQL updateTableinfo = (UpdateSQL)temp[2];
                            DBUtil.execute(stmtInfo.getCon(), updateTableinfo);
                        }
                        stmtInfo.commit();
                        Object object = temp[1];
                        return object;
                    }
                    catch (Exception e) {
                        primaryKey.restoreKey(temp[1]);
                        log.error(String.valueOf(temp[0] != null ? temp[0] : ""), (Throwable)e);
                        throw e;
                    }
                }
            } else {
                if (log.isInfoEnabled() && DBUtil.showsql(dbname_)) {
                    log.info("JDBC Insert statement:{}", (Object)stmtInfo.getSql());
                }
                int i2 = s.executeUpdate(stmtInfo.getSql());
                stmtInfo.commit();
                Integer n = new Integer(i2);
                return n;
            }
            i = s.executeUpdate(stmtInfo.getSql());
        }
        catch (SQLException e) {
            try {
                log.error(stmtInfo.getSql(), (Throwable)e);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (stmtInfo == null) throw e;
            stmtInfo.errorHandle(e);
            throw e;
        }
        catch (Exception e) {
            try {
                log.error(stmtInfo.getSql(), (Throwable)e);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (stmtInfo == null) throw new NestedSQLException(e.getMessage(), (Throwable)e);
            stmtInfo.errorHandle(e);
            throw new NestedSQLException(e.getMessage(), (Throwable)e);
        }
        stmtInfo.commit();
        return new Integer(i);
        finally {
            if (stmtInfo != null) {
                stmtInfo.dofinally();
            }
            stmtInfo = null;
        }
    }

    public HashMap[] executeQuery(String sql) throws SQLException {
        return this.executeQuery(sql, (Connection)null);
    }

    public HashMap[] executeQuery(String sql, Connection con) throws SQLException {
        return this.executeSql(SQLManager.getInstance().getDefaultDBName(), sql, con);
    }

    public void executeQuery(String sql, String[] fields, Connection con) throws SQLException {
        this.allResults = this.executeSql(SQLManager.getInstance().getDefaultDBName(), sql, con);
        this.size = this.allResults == null ? 0 : this.allResults.length;
    }

    public void executeQuery(String sql, String[] fields) throws SQLException {
        this.executeQuery(sql, fields, (Connection)null);
    }

    public void executeSelect(String sql) throws SQLException {
        this.executeSelect(sql, (Connection)null);
    }

    public void executeSelect(String sql, Connection con) throws SQLException {
        this.executeSelect(SQLManager.getInstance().getDefaultDBName(), sql, con);
    }

    public void executeSelectLimit(String sql, int limit) throws SQLException {
        this.executeSelectLimit(SQLManager.getInstance().getDefaultDBName(), sql, limit);
    }

    public void executeSelectLimitForOracle(String sql, int limit, String rownum) throws SQLException {
        this.executeSelectLimitForOracle(SQLManager.getInstance().getDefaultDBName(), sql, limit, rownum);
    }

    public void executeSelectLimit(String dbName, String sql, int limit) throws SQLException {
        this.executeSelectLimit(dbName, sql, limit, null);
    }

    public void executeSelectLimit(String dbName, String sql, int limit, Connection con) throws SQLException {
        sql = DBUtil.getPool(dbName).getDbAdapter().getLimitSelect(sql, limit);
        this.allResults = this.executeSql(dbName, sql, con);
        this.size = this.allResults == null ? 0 : this.allResults.length;
    }

    public void executeSelectLimitForOracle(String dbName, String sql, int limit, String rownum) throws SQLException {
        this.executeSelectLimitForOracle(dbName, sql, limit, rownum, null);
    }

    public void executeSelectLimitForOracle(String dbName, String sql, int limit, String rownum, Connection con) throws SQLException {
        sql = rownum == null || rownum.equals("") ? DBUtil.getPool(dbName).getDbAdapter().getLimitSelect(sql, limit) : DBUtil.getPool(dbName).getDbAdapter().getOracleLimitSelect(sql, limit, rownum);
        this.allResults = this.executeSql(dbName, sql, con);
        this.size = this.allResults == null ? 0 : this.allResults.length;
    }

    public void executeSelect(String dbName, String sql) throws SQLException {
        this.executeSelect(dbName, sql, null);
    }

    public void executeSelect(String dbName, String sql, Connection con) throws SQLException {
        this.allResults = this.executeSql(dbName, sql, con);
        this.size = this.allResults == null ? 0 : this.allResults.length;
    }

    public void clear() {
        this.allResults = null;
    }

    public HashMap[] executeQuery(String dbName, String sql) throws SQLException {
        return this.executeQuery(dbName, sql, (Connection)null);
    }

    public HashMap[] executeQuery(String dbName, String sql, Connection con) throws SQLException {
        return this.executeSql(dbName, sql, con);
    }

    public void executeQuery(String dbName, String sql, String[] fields) throws SQLException {
        this.executeQuery(dbName, sql, fields, (Connection)null);
    }

    public void executeQuery(String dbName, String sql, String[] fields, Connection con) throws SQLException {
        this.allResults = this.executeSql(dbName, sql, con);
        this.size = this.allResults == null ? 0 : this.allResults.length;
    }

    public HashMap[] executeQuery(String sql, int offset, int maxsize) throws SQLException {
        return this.executeQuery(sql, offset, maxsize, (Connection)null);
    }

    public HashMap[] executeQuery(String sql, int offset, int maxsize, Connection con) throws SQLException {
        return this.executeSql(SQLManager.getInstance().getDefaultDBName(), sql, offset, maxsize, con, null, null, ResultMap.type_maparray);
    }

    public void executeQuery(String sql, int offset, int maxsize, String[] fields) throws SQLException {
        this.executeQuery(sql, offset, maxsize, fields, (Connection)null);
    }

    public void executeQuery(String sql, int offset, int maxsize, String[] fields, Connection con) throws SQLException {
        this.allResults = this.executeSql(SQLManager.getInstance().getDefaultDBName(), sql, offset, maxsize, con, null, null, ResultMap.type_maparray);
        this.size = this.allResults == null ? 0 : this.allResults.length;
    }

    public HashMap[] executeQuery(String dbName, String sql, long offset, int maxsize) throws SQLException {
        return this.executeQuery(dbName, sql, offset, maxsize, (Connection)null);
    }

    public HashMap[] executeQuery(String dbName, String sql, long offset, int maxsize, Connection con) throws SQLException {
        return this.executeSql(dbName, sql, offset, maxsize, con, null, null, ResultMap.type_maparray);
    }

    public void executeSelect(String dbName, String sql, long offset, int maxsize) throws SQLException {
        this.executeSelect(dbName, sql, offset, maxsize, null);
    }

    public void executeSelect(String dbName, String sql, long offset, int maxsize, Connection con) throws SQLException {
        this.allResults = this.executeSql(dbName, sql, offset, maxsize, con, null, null, ResultMap.type_maparray);
        this.size = this.allResults == null ? 0 : this.allResults.length;
    }

    public void executeSelect(String dbName, String sql, long offset, int maxsize, boolean robotquery) throws SQLException {
        this.executeSelect(dbName, sql, offset, maxsize, robotquery, null);
    }

    public void executeSelect(String dbName, String sql, long offset, int maxsize, boolean robotquery, Connection con) throws SQLException {
        this.allResults = this.executeSql(dbName, sql, offset, maxsize, robotquery, con, null, null, ResultMap.type_maparray);
        this.size = this.allResults == null ? 0 : this.allResults.length;
    }

    public void executeSelectForOracle(String dbName, String sql, long offset, int maxsize, String rownum) throws SQLException {
        this.executeSelectForOracle(dbName, sql, offset, maxsize, rownum, null);
    }

    public void executeSelectForOracle(String dbName, String sql, long offset, int maxsize, String rownum, Connection con) throws SQLException {
        this.oraclerownum = rownum;
        this.allResults = this.executeSql(dbName, sql, offset, maxsize, con, null, null, ResultMap.type_maparray);
        this.size = this.allResults == null ? 0 : this.allResults.length;
        this.oraclerownum = null;
    }

    public void executeSelectForOracle(String sql, long offset, int maxsize, String rownum) throws SQLException {
        this.executeSelectForOracle(null, sql, offset, maxsize, rownum);
    }

    public void executeSelect(String sql, long offset, int maxsize) throws SQLException {
        this.executeSelect(null, sql, offset, maxsize);
    }

    public void executeQuery(String dbName, String sql, long offset, int maxsize, String[] fields) throws SQLException {
        this.executeQuery(dbName, sql, offset, maxsize, fields, null);
    }

    public void executeQuery(String dbName, String sql, long offset, int maxsize, String[] fields, Connection con) throws SQLException {
        this.allResults = this.executeSql(dbName, sql, offset, maxsize, con, null, null, ResultMap.type_maparray);
        this.size = this.allResults == null ? 0 : this.allResults.length;
    }

    public static void closeConection(Connection connection) throws SQLException {
        DBUtil.closeConection(null, connection);
    }

    public static void closeConection(String dbName, Connection connection) throws SQLException {
        JDBCTransaction tx = DBUtil.getTransaction();
        if (tx == null) {
            SQLManager datab = DBUtil.getSQLManager();
            datab.returnConnection(dbName, connection);
        }
    }

    public static void closeResources(Statement stmt, ResultSet rs) throws SQLException {
        SQLManager.closeResources(stmt, rs);
    }

    public HashMap[] executeUpdate(String updateSql) throws SQLException {
        return this.executeSql(updateSql);
    }

    public HashMap[] executeUpdate(String dbName, String updateSql) throws SQLException {
        return this.executeUpdate(dbName, updateSql, null);
    }

    public HashMap[] executeUpdate(String dbName, String updateSql, Connection con) throws SQLException {
        return this.executeSql(dbName, updateSql, con);
    }

    protected Record[] executeSql(String dbname, String sql, long offset, int maxsize, Connection con, Class objectType, RowHandler rowHandler, int resultType) throws SQLException {
        return this.executeSql(dbname, sql, offset, maxsize, DBUtil.isRobotQuery(dbname), con, objectType, rowHandler, resultType);
    }

    protected Record[] executeSql(String dbname, String sql, long offset, int maxsize, boolean robotquery, Connection con, Class objectType, RowHandler rowHandler, int resultType) throws SQLException {
        Record[] hashResults = null;
        if (this.isRobustQuery) {
            this.totalSize = 0L;
        }
        StatementInfo stmtInfo = null;
        try {
            stmtInfo = new StatementInfo(dbname, new NewSQLInfo(sql), false, offset, maxsize, robotquery, con, this.oraclerownum);
            hashResults = this.doJDBC(stmtInfo, objectType, rowHandler);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new NestedSQLException((Throwable)e);
        }
        finally {
            stmtInfo = null;
        }
        return hashResults;
    }

    public void setBatchSQLS(List sqls) {
        this.batchSQLS = sqls;
    }

    public void addBatch(String sql) throws SQLException {
        if (this.batchSQLS == null) {
            this.batchSQLS = new ArrayList();
        }
        if (sql == null || sql.equals("")) {
            this.batchSQLS.clear();
            throw new SQLException("Add batch SQL failed: sql is [" + sql + "]");
        }
        this.batchSQLS.add(sql);
    }

    private void updateTableInfo(Set batchUpdateSqls, Connection batchCon) throws SQLException {
        if (batchUpdateSqls == null) {
            return;
        }
        try {
            Iterator i = batchUpdateSqls.iterator();
            while (i.hasNext()) {
                DBUtil.execute(batchCon, (UpdateSQL)i.next());
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
    }

    @Override
    public void rollbackTransaction() {
    }

    public Object[] executeBatch() throws SQLException {
        return this.executeBatch((String)null);
    }

    public Object[] executeBatch(Connection con) throws SQLException {
        return this.executeBatch(null, con);
    }

    public Object[] executeBatch(String dbname) throws SQLException {
        return this.executeBatch(dbname, null);
    }

    public Object[] executeBatch(boolean needtransaction) throws SQLException {
        return this.executeBatch(null, needtransaction);
    }

    public Object[] executeBatch(String dbname, boolean needtransaction) throws SQLException {
        return this.executeBatch(dbname, null, needtransaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object[] executeBatch(String dbname, Connection con, boolean needtransaction) throws SQLException {
        try {
            Object[] objectArray = this.executeBatch(this.batchSQLS, dbname == null ? this.batchDBName : dbname, con, needtransaction);
            return objectArray;
        }
        finally {
            if (this.batchSQLS != null) {
                this.batchSQLS.clear();
            }
            this.setBatchDBName(SQLManager.getInstance().getDefaultDBName());
        }
    }

    public static boolean isAutoprimarykey(String dbname) {
        boolean autokey = DBUtil.getSQLManager().getPool(dbname).isAutoprimarykey();
        return autokey;
    }

    protected Object[] executeBatch(List batchSQLS, String dbname_, Connection con_, boolean needtransaction_) throws SQLException {
        if (batchSQLS == null || batchSQLS.size() == 0) {
            log.info("\u6ca1\u6709\u8981\u5904\u7406\u7684\u6279\u5904\u7406\u547d\u4ee4\u884c\uff01");
            return null;
        }
        StatementInfo stmtInfo = null;
        Object[] ret_keys = null;
        ArrayList<Object> batchResult = new ArrayList<Object>();
        TreeSet<Object> batchUpdateSqls = new TreeSet<Object>();
        Statement batchStmt = null;
        if (dbname_ == null) {
            dbname_ = SQLManager.getInstance().getDefaultDBName();
        }
        try {
            stmtInfo = new StatementInfo(dbname_, null, false, con_, needtransaction_);
            stmtInfo.init();
            batchStmt = stmtInfo.createStatement();
            boolean autokey = DBUtil.isAutoprimarykey(dbname_);
            for (int i = 0; i < batchSQLS.size(); ++i) {
                String sql = (String)batchSQLS.get(i);
                sql = DBUtil.getInterceptorInf(dbname_).convertSQL(sql, DBUtil.getDBAdapter(dbname_).getDBTYPE(), dbname_);
                if (autokey) {
                    Object[] objs = StatementParser.refactorInsertStatement(stmtInfo.getCon(), sql, stmtInfo.getDbname());
                    sql = (String)objs[0];
                    if (log.isInfoEnabled() && DBUtil.showsql(stmtInfo.getDbname())) {
                        log.info("Execute JDBC batch statement:{}", (Object)sql);
                    }
                    batchStmt.addBatch(sql);
                    if (objs[1] != null) {
                        batchResult.add(objs[1]);
                    }
                    if (objs[2] == null) continue;
                    batchUpdateSqls.add(objs[2]);
                    continue;
                }
                if (log.isInfoEnabled() && DBUtil.showsql(stmtInfo.getDbname())) {
                    log.info("Execute JDBC batch statement:{}", (Object)sql);
                }
                batchStmt.addBatch(sql);
            }
            int[] ret = batchStmt.executeBatch();
            if (autokey) {
                if (batchUpdateSqls.size() > 0) {
                    this.updateTableInfo(batchUpdateSqls, stmtInfo.getCon());
                }
                if (batchResult != null && batchResult.size() > 0) {
                    ret_keys = new Object[batchResult.size()];
                    for (int i = 0; i < batchResult.size(); ++i) {
                        ret_keys[i] = batchResult.get(i);
                    }
                }
            } else if (ret != null) {
                ret_keys = new Object[ret.length];
                for (int i = 0; i < ret.length; ++i) {
                    ret_keys[i] = new Integer(ret[i]);
                }
            }
            stmtInfo.commit();
        }
        catch (BatchUpdateException e) {
            try {
                log.error("success batch update statements:" + e.getUpdateCounts(), (Throwable)e);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (stmtInfo != null) {
                stmtInfo.errorHandle(e);
            }
            throw e;
        }
        catch (SQLException e) {
            try {
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (stmtInfo != null) {
                stmtInfo.errorHandle(e);
            }
            throw e;
        }
        catch (Exception e) {
            try {
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (stmtInfo != null) {
                stmtInfo.errorHandle(e);
            }
            throw new NestedSQLException(e.getMessage(), (Throwable)e);
        }
        finally {
            if (stmtInfo != null) {
                stmtInfo.dofinally();
            }
            stmtInfo = null;
            if (batchSQLS != null) {
                batchSQLS.clear();
            }
            if (batchResult != null) {
                batchResult.clear();
                batchResult = null;
                batchUpdateSqls.clear();
                batchUpdateSqls = null;
            }
            this.setBatchDBName(SQLManager.getInstance().getDefaultDBName());
        }
        return ret_keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] executeBatch(String dbname, Connection con) throws SQLException {
        try {
            Object[] objectArray = this.executeBatch(this.batchSQLS, dbname == null ? this.batchDBName : dbname, con, !this.isBatchAutoCommit());
            return objectArray;
        }
        finally {
            if (this.batchSQLS != null) {
                this.batchSQLS.clear();
            }
            this.batchautocommit = false;
            this.autocommit = true;
            this.setBatchDBName(SQLManager.getInstance().getDefaultDBName());
        }
    }

    public String getBatchDBName() {
        return this.batchDBName;
    }

    public void setBatchDBName(String batchDBName) {
        this.batchDBName = batchDBName;
    }

    public boolean getBoolean(int rowid, int columnIndex) throws SQLException {
        this.inrange(rowid, columnIndex);
        return this.allResults[this.getTrueRowid(rowid)].getBoolean(columnIndex);
    }

    public byte getByte(int rowid, int columnIndex) throws SQLException {
        this.inrange(rowid, columnIndex);
        return this.allResults[this.getTrueRowid(rowid)].getByte(columnIndex);
    }

    public short getShort(int rowid, int columnIndex) throws SQLException {
        this.inrange(rowid, columnIndex);
        return this.allResults[this.getTrueRowid(rowid)].getShort(columnIndex);
    }

    public Time getTime(int rowid, int columnIndex) throws SQLException {
        this.inrange(rowid, columnIndex);
        return this.allResults[this.getTrueRowid(rowid)].getTime(columnIndex);
    }

    public Timestamp getTimestamp(int rowid, int columnIndex) throws SQLException {
        this.inrange(rowid, columnIndex);
        return this.allResults[this.getTrueRowid(rowid)].getTimestamp(columnIndex);
    }

    public InputStream getAsciiStream(int rowid, int columnIndex) throws SQLException {
        this.inrange(rowid, columnIndex);
        return this.allResults[this.getTrueRowid(rowid)].getAsciiStream(columnIndex);
    }

    public InputStream getUnicodeStream(int rowid, int columnIndex) throws SQLException {
        this.inrange(rowid, columnIndex);
        return this.allResults[this.getTrueRowid(rowid)].getUnicodeStream(columnIndex);
    }

    public InputStream getBinaryStream(int rowid, int columnIndex) throws SQLException {
        this.inrange(rowid, columnIndex);
        return this.allResults[this.getTrueRowid(rowid)].getBinaryStream(columnIndex);
    }

    public boolean getBoolean(int rowid, String colName) throws SQLException {
        this.inrange(rowid, colName);
        return this.allResults[this.getTrueRowid(rowid)].getBoolean(colName);
    }

    public byte getByte(int rowid, String colName) throws SQLException {
        this.inrange(rowid, colName);
        return this.allResults[this.getTrueRowid(rowid)].getByte(colName);
    }

    public short getShort(int rowid, String colName) throws SQLException {
        this.inrange(rowid, colName);
        return this.allResults[this.getTrueRowid(rowid)].getShort(colName);
    }

    public Time getTime(int rowid, String colName) throws SQLException {
        this.inrange(rowid, colName);
        return this.allResults[this.getTrueRowid(rowid)].getTime(colName);
    }

    public Timestamp getTimestamp(int rowid, String colName) throws SQLException {
        this.inrange(rowid, colName);
        return this.allResults[this.getTrueRowid(rowid)].getTimestamp(colName);
    }

    public InputStream getAsciiStream(int rowid, String colName) throws SQLException {
        this.inrange(rowid, colName);
        return this.allResults[this.getTrueRowid(rowid)].getAsciiStream(colName);
    }

    public InputStream getUnicodeStream(int rowid, String colName) throws SQLException {
        this.inrange(rowid, colName);
        return this.allResults[this.getTrueRowid(rowid)].getUnicodeStream(colName);
    }

    public InputStream getBinaryStream(int rowid, String colName) throws SQLException {
        this.inrange(rowid, colName);
        return this.allResults[this.getTrueRowid(rowid)].getBinaryStream(colName);
    }

    public Reader getCharacterStream(int rowid, int columnIndex) throws SQLException {
        this.inrange(rowid, columnIndex);
        return this.allResults[this.getTrueRowid(rowid)].getCharacterStream(columnIndex);
    }

    public Reader getCharacterStream(int rowid, String colName) throws SQLException {
        this.inrange(rowid, colName);
        return this.allResults[this.getTrueRowid(rowid)].getCharacterStream(colName);
    }

    public BigDecimal getBigDecimal(int rowid, int columnIndex) throws SQLException {
        return (BigDecimal)this.getObject(rowid, columnIndex);
    }

    public BigDecimal getBigDecimal(int rowid, String colName) throws SQLException {
        return (BigDecimal)this.getObject(rowid, colName);
    }

    public Blob getBlob(int rowid, int columnIndex) throws SQLException {
        return (Blob)this.getObject(rowid, columnIndex);
    }

    public Clob getClob(int rowid, int columnIndex) throws SQLException {
        this.inrange(rowid, columnIndex);
        return this.allResults[this.getTrueRowid(rowid)].getClob(columnIndex);
    }

    public Array getArray(int rowid, int column) throws SQLException {
        return (Array)this.getObject(rowid, column);
    }

    public Ref getRef(int rowid, String colName) throws SQLException {
        return (Ref)this.getObject(rowid, colName);
    }

    public Blob getBlob(int rowid, String colName) throws SQLException {
        return (Blob)this.getObject(rowid, colName);
    }

    public Clob getClob(int rowid, String colName) throws SQLException {
        this.inrange(rowid, colName);
        return this.allResults[this.getTrueRowid(rowid)].getClob(colName);
    }

    public Array getArray(int rowid, String colName) throws SQLException {
        return (Array)this.getObject(rowid, colName);
    }

    public URL getURL(int rowid, int columnIndex) throws SQLException {
        this.inrange(rowid, columnIndex);
        return this.allResults[this.getTrueRowid(rowid)].getURL(columnIndex);
    }

    public URL getURL(int rowid, String colName) throws SQLException {
        this.inrange(rowid, colName);
        return this.allResults[this.getTrueRowid(rowid)].getURL(colName);
    }

    protected byte[] getBytesFromResultset(ResultSet res, String columnName) throws SQLException {
        try {
            DBUtil.initOracleDB();
            return SQLUtil.oracleDB.getBytesFromResultset(res, columnName);
        }
        catch (Exception e) {
            throw new NestedSQLException((Throwable)e);
        }
    }

    protected byte[] getBytesFromBlob(Blob blob) throws SQLException {
        try {
            DBUtil.initOracleDB();
            return SQLUtil.oracleDB.getBytesFromBlob(blob);
        }
        catch (Exception e) {
            throw new NestedSQLException((Throwable)e);
        }
    }

    protected byte[] getBytesFromClob(Clob clob) {
        try {
            DBUtil.initOracleDB();
            return SQLUtil.oracleDB.getBytesFromClob(clob);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected String getStringFromClob(Clob clob) {
        try {
            DBUtil.initOracleDB();
            return SQLUtil.oracleDB.getStringFromClob(clob);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static long getNextPrimaryKey(String tableName) throws SQLException {
        return DBUtil.getNextPrimaryKey(SQLManager.getInstance().getDefaultDBName(), tableName);
    }

    public static long getNextPrimaryKey(Connection con, String tableName) throws SQLException {
        return DBUtil.getNextPrimaryKey(con, SQLManager.getInstance().getDefaultDBName(), tableName);
    }

    public static long getNextPrimaryKey(String dbName, String tableName) throws SQLException {
        return DBUtil.getNextPrimaryKey(null, dbName, tableName);
    }

    public static void resetPrimaryKeyCache() {
        PrimaryKeyCacheManager.reset();
    }

    public static long getNextPrimaryKey(Connection con, String dbName, String tableName) throws SQLException {
        try {
            PrimaryKey primaryKey = PrimaryKeyCacheManager.getInstance().getPrimaryKeyCache(dbName).getIDTable(tableName.toLowerCase());
            long ret = (Long)primaryKey.generateObjectKey(con).getPrimaryKey();
            return ret;
        }
        catch (SQLException e) {
            throw new NestedSQLException("Get Next long PrimaryKey error for dbName=" + dbName + ",tableName=" + tableName + ":" + e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new NestedSQLException("Get Next long PrimaryKey error for dbName=" + dbName + ",tableName=" + tableName + ":" + e.getMessage(), (Throwable)e);
        }
    }

    public static String getNextStringPrimaryKey(String tableName) throws SQLException {
        return DBUtil.getNextStringPrimaryKey(null, SQLManager.getInstance().getDefaultDBName(), tableName);
    }

    public static String getNextStringPrimaryKey(Connection con, String tableName) throws SQLException {
        return DBUtil.getNextStringPrimaryKey(con, SQLManager.getInstance().getDefaultDBName(), tableName);
    }

    public static String getNextStringPrimaryKey(String dbName, String tableName) throws SQLException {
        return DBUtil.getNextStringPrimaryKey(null, dbName, tableName);
    }

    public static String getNextStringPrimaryKey(Connection con, String dbName, String tableName) throws SQLException {
        try {
            PrimaryKey primaryKey = PrimaryKeyCacheManager.getInstance().getPrimaryKeyCache(dbName).getIDTable(tableName.toLowerCase());
            String key = primaryKey.generateObjectKey(con).getPrimaryKey().toString();
            return key;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new NestedSQLException("Get Next String PrimaryKey error for dbName=" + dbName + ",tableName=" + tableName + ":" + e.getMessage(), (Throwable)e);
        }
    }

    public Record[] getAllResults() {
        return this.allResults;
    }

    public Object executeSelectForObject(String sql, Class objectType) throws SQLException {
        return this.executeSelectForObject(sql, objectType, (Connection)null);
    }

    public Object[] executeSelectForObjectArray(String sql, Class objectType) throws SQLException {
        return this.executeSelectForObjectArray(sql, objectType, (Connection)null);
    }

    public Object[] executeSelectForObjectArray(String dbname, String sql, Class objectType) throws SQLException {
        return this.executeSelectForObjectArray(dbname, sql, objectType, (Connection)null, (RowHandler)null);
    }

    public Object[] executeSelectForObjectArray(String sql, Class objectType, Connection con) throws SQLException {
        return this.executeSelectForObjectArray(sql, objectType, con, null);
    }

    public Object[] executeSelectForObjectArray(String sql, Class objectType, Connection con, RowHandler rowhandler) throws SQLException {
        return this.executeSelectForObjectArray(null, sql, objectType, con, rowhandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] executeSelectForObjectArray(String dbname, String sql, Class objectType, Connection con, RowHandler rowhandler) throws SQLException {
        StatementInfo stmtInfo = null;
        try {
            stmtInfo = new StatementInfo(dbname, new NewSQLInfo(sql), false, con, false);
            ResultMap resultMap = this.innerExecuteJDBC(stmtInfo, objectType, rowhandler, ResultMap.type_objectarray);
            Object[] objectArray = (Object[])resultMap.getCommonresult();
            return objectArray;
        }
        finally {
            if (stmtInfo != null) {
                stmtInfo.dofinally();
                stmtInfo = null;
            }
        }
    }

    public Object[] executeSelectForObjectArray(String sql, long offset, int pagesize, Class objectType) throws SQLException {
        return this.executeSelectForObjectArray(sql, offset, pagesize, objectType, (Connection)null);
    }

    public Object[] executeSelectForObjectArray(String dbname, String sql, long offset, int pagesize, Class objectType) throws SQLException {
        return this.executeSelectForObjectArray(dbname, sql, offset, pagesize, objectType, null, null);
    }

    public Object[] executeSelectForObjectArray(String dbname, String sql, long offset, int pagesize, Class objectType, Connection con) throws SQLException {
        return this.executeSelectForObjectArray(dbname, sql, offset, pagesize, objectType, con, null);
    }

    public Object[] executeSelectForObjectArray(String sql, long offset, int pagesize, Class objectType, Connection con) throws SQLException {
        return this.executeSelectForObjectArray(sql, offset, pagesize, objectType, con, null);
    }

    public Object[] executeSelectForObjectArray(String sql, long offset, int pagesize, Class objectType, Connection con, RowHandler rowhandler) throws SQLException {
        return this.executeSelectForObjectArray(null, sql, offset, pagesize, objectType, con, rowhandler);
    }

    public Object[] executeSelectForObjectArray(String dbname, String sql, long offset, int pagesize, Class objectType, Connection con, RowHandler rowhandler) throws SQLException {
        StatementInfo stmtInfo = new StatementInfo(dbname, new NewSQLInfo(sql), false, offset, pagesize, DBUtil.isRobotQuery(dbname), con, this.oraclerownum);
        ResultMap resultMap = this.innerExecutePagineJDBC(stmtInfo, objectType, rowhandler, ResultMap.type_objectarray);
        return (Object[])resultMap.getCommonresult();
    }

    public Object executeSelectForObject(String sql, Class objectType, Connection con) throws SQLException {
        return this.executeSelectForObject(sql, objectType, con, (RowHandler)null);
    }

    public void executeSelectWithRowHandler(String sql, Connection con, NullRowHandler rowhandler) throws SQLException {
        this.executeSelectWithRowhandler(null, sql, con, rowhandler);
    }

    public void executeSelectWithRowHandler(String sql, NullRowHandler rowhandler) throws SQLException {
        this.executeSelectWithRowhandler(null, sql, null, rowhandler);
    }

    public void executeSelectWithRowHandler(String dbname, String sql, NullRowHandler rowhandler) throws SQLException {
        this.executeSelectWithRowhandler(dbname, sql, null, rowhandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeSelectWithRowhandler(String dbname, String sql, Connection con, NullRowHandler rowhandler) throws SQLException {
        StatementInfo stmtInfo = null;
        try {
            stmtInfo = new StatementInfo(dbname, new NewSQLInfo(sql), false, con, false);
            ResultMap resultMap = this.innerExecuteJDBC(stmtInfo, null, rowhandler, ResultMap.type_null);
        }
        finally {
            if (stmtInfo != null) {
                stmtInfo.dofinally();
                stmtInfo = null;
            }
        }
    }

    public void executeSelectWithRowHandler(String sql, long offset, int pagesize, Connection con, NullRowHandler rowhandler) throws SQLException {
        this.executeSelectWithRowhandler(null, sql, offset, pagesize, con, rowhandler);
    }

    public void executeSelectWithRowHandler(String sql, long offset, int pagesize, NullRowHandler rowhandler) throws SQLException {
        this.executeSelectWithRowhandler(null, sql, offset, pagesize, null, rowhandler);
    }

    public void executeSelectWithRowHandler(String dbname, String sql, long offset, int pagesize, NullRowHandler rowhandler) throws SQLException {
        this.executeSelectWithRowhandler(dbname, sql, offset, pagesize, null, rowhandler);
    }

    public void executeSelectWithRowhandler(String dbname, String sql, long offset, int pagesize, Connection con, NullRowHandler rowhandler) throws SQLException {
        StatementInfo stmtInfo = new StatementInfo(dbname, new NewSQLInfo(sql), false, offset, pagesize, true, con, this.oraclerownum);
        this.innerExecutePagineJDBC(stmtInfo, null, rowhandler, ResultMap.type_null);
    }

    public Object executeSelectForObject(String dbname, String sql, Class objectType) throws SQLException {
        return this.executeSelectForObject(dbname, sql, objectType, (RowHandler)null);
    }

    public Object executeSelectForObject(String dbname, String sql, Connection con, Class objectType) throws SQLException {
        return this.executeSelectForObject(dbname, sql, con, objectType, null);
    }

    public List executeSelectForList(String sql, Class objectType) throws SQLException {
        return this.executeSelectForList(sql, objectType, (Connection)null);
    }

    public List executeSelectForList(String sql, Class objectType, Connection con) throws SQLException {
        return this.executeSelectForList(sql, objectType, con, (RowHandler)null);
    }

    public List executeSelectForList(String dbname, String sql, Class objectType) throws SQLException {
        return this.executeSelectForList(dbname, sql, (Connection)null, objectType);
    }

    public List executeSelectForList(String dbname, String sql, Connection con, Class objectType) throws SQLException {
        return this.executeSelectForList(dbname, sql, con, objectType, (RowHandler)null);
    }

    public List executeSelectForList(String sql, long offset, int pagesize, Class objectType) throws SQLException {
        return this.executeSelectForList((String)null, sql, offset, pagesize, objectType);
    }

    public List executeSelectForList(String dbname, String sql, long offset, int pagesize, Class objectType) throws SQLException {
        return this.executeSelectForList(dbname, sql, offset, pagesize, DBUtil.isRobotQuery(dbname), objectType);
    }

    public List executeSelectForList(String dbname, String sql, long offset, int pagesize, boolean robotquery, Class objectType) throws SQLException {
        return this.executeSelectForList(dbname, sql, offset, pagesize, robotquery, (Connection)null, objectType);
    }

    public List executeSelectForList(String dbname, String sql, long offset, int pagesize, boolean robotquery, Connection con, Class objectType) throws SQLException {
        return this.executeSelectForList(dbname, sql, offset, pagesize, robotquery, con, objectType, null);
    }

    public List executeSelectForList(String dbname, String sql, long offset, int pagesize, Connection con, Class objectType) throws SQLException {
        return this.executeSelectForList(dbname, sql, offset, pagesize, DBUtil.isRobotQuery(dbname), con, objectType);
    }

    public List executeSelectForOracleList(String sql, long offset, int pagesize, String oraclerownum, Class objectType) throws SQLException {
        return this.executeSelectForOracleList((String)null, sql, offset, pagesize, oraclerownum, objectType);
    }

    public List executeSelectForOracleList(String dbname, String sql, long offset, int pagesize, String oraclerownum, Class objectType) throws SQLException {
        return this.executeSelectForOracleList(dbname, sql, offset, pagesize, oraclerownum, (Connection)null, objectType);
    }

    public List executeSelectForOracleList(String dbname, String sql, long offset, int pagesize, String oraclerownum, Connection con, Class objectType) throws SQLException {
        return this.executeSelectForOracleList(dbname, sql, offset, pagesize, oraclerownum, con, objectType, null);
    }

    public Object executeSelectForObject(String sql, Class objectType, RowHandler rowhandler) throws SQLException {
        return this.executeSelectForObject((String)null, sql, objectType, rowhandler);
    }

    public Object executeSelectForObject(String sql, Class objectType, Connection con, RowHandler rowhandler) throws SQLException {
        return this.executeSelectForObject(null, sql, con, objectType, rowhandler);
    }

    public Object executeSelectForObject(String dbname, String sql, Class objectType, RowHandler rowhandler) throws SQLException {
        return this.executeSelectForObject(dbname, sql, null, objectType, rowhandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executeSelectForObject(String dbname, String sql, Connection con, Class objectType, RowHandler rowhandler) throws SQLException {
        StatementInfo stmtInfo = null;
        try {
            stmtInfo = new StatementInfo(dbname, new NewSQLInfo(sql), false, con, false);
            ResultMap resultMap = this.innerExecuteJDBC(stmtInfo, objectType, rowhandler, ResultMap.type_objcet);
            Object object = resultMap.getCommonresult();
            return object;
        }
        finally {
            if (stmtInfo != null) {
                stmtInfo.dofinally();
                stmtInfo = null;
            }
        }
    }

    public List executeSelectForList(String sql, Class objectType, RowHandler rowhandler) throws SQLException {
        return this.executeSelectForList(sql, objectType, (Connection)null, rowhandler);
    }

    public List executeSelectForList(String sql, Class objectType, Connection con, RowHandler rowhandler) throws SQLException {
        return this.executeSelectForList((String)null, sql, con, objectType, rowhandler);
    }

    public List executeSelectForList(String dbname, String sql, Class objectType, RowHandler rowhandler) throws SQLException {
        return this.executeSelectForList(dbname, sql, null, objectType, rowhandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List executeSelectForList(String dbname, String sql, Connection con, Class objectType, RowHandler rowhandler) throws SQLException {
        StatementInfo stmtInfo = null;
        try {
            stmtInfo = new StatementInfo(dbname, new NewSQLInfo(sql), false, con, false);
            ResultMap resultMap = this.innerExecuteJDBC(stmtInfo, objectType, rowhandler, ResultMap.type_list);
            List list = (List)resultMap.getCommonresult();
            return list;
        }
        finally {
            if (stmtInfo != null) {
                stmtInfo.dofinally();
                stmtInfo = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeSelectForXML(String dbname, String sql, Connection con, RowHandler rowhandler) throws SQLException {
        StatementInfo stmtInfo = null;
        try {
            stmtInfo = new StatementInfo(dbname, new NewSQLInfo(sql), false, con, false);
            ResultMap resultMap = this.innerExecuteJDBC(stmtInfo, XMLMark.class, rowhandler, ResultMap.type_xml);
            String string = (String)resultMap.getCommonresult();
            return string;
        }
        finally {
            if (stmtInfo != null) {
                stmtInfo.dofinally();
                stmtInfo = null;
            }
        }
    }

    public String executeSelectForXML(String sql, Connection con, RowHandler rowhandler) throws SQLException {
        return this.executeSelectForXML(null, sql, con, rowhandler);
    }

    public String executeSelectForXML(String sql, RowHandler rowhandler) throws SQLException {
        return this.executeSelectForXML(null, sql, null, rowhandler);
    }

    public String executeSelectForXML(String sql) throws SQLException {
        return this.executeSelectForXML(null, sql, null, null);
    }

    public String executeSelectForXML(String dbname, String sql) throws SQLException {
        return this.executeSelectForXML(dbname, sql, null, null);
    }

    public String executeSelectForXML(String dbname, String sql, Connection con) throws SQLException {
        return this.executeSelectForXML(dbname, sql, con, null);
    }

    public String executeSelectForXML(String dbname, String sql, long offset, int pagesize, Connection con, RowHandler rowhandler) throws SQLException {
        return this.executeSelectForXML(dbname, sql, offset, pagesize, DBUtil.isRobotQuery(dbname), con, rowhandler);
    }

    public String executeSelectForXML(String sql, long offset, int pagesize, Connection con, RowHandler rowhandler) throws SQLException {
        return this.executeSelectForXML(null, sql, offset, pagesize, con, rowhandler);
    }

    public String executeSelectForXML(String sql, long offset, int pagesize, RowHandler rowhandler) throws SQLException {
        return this.executeSelectForXML(null, sql, offset, pagesize, null, rowhandler);
    }

    public String executeSelectForXML(String sql, long offset, int pagesize) throws SQLException {
        return this.executeSelectForXML(null, sql, offset, pagesize, null, null);
    }

    public String executeSelectForXML(String dbname, String sql, long offset, int pagesize) throws SQLException {
        return this.executeSelectForXML(dbname, sql, offset, pagesize, null, null);
    }

    public String executeSelectForXML(String dbname, String sql, long offset, int pagesize, Connection con) throws SQLException {
        return this.executeSelectForXML(dbname, sql, offset, pagesize, con, null);
    }

    public String executeSelectForXML(String dbname, String sql, long offset, int pagesize, boolean robotquery, Connection con, RowHandler rowhandler) throws SQLException {
        StatementInfo stmtInfo = new StatementInfo(dbname, new NewSQLInfo(sql), false, offset, pagesize, robotquery, con, this.oraclerownum);
        ResultMap resultMap = this.innerExecutePagineJDBC(stmtInfo, XMLMark.class, rowhandler, ResultMap.type_xml);
        return (String)resultMap.getCommonresult();
    }

    public String executeSelectForXML(String sql, long offset, int pagesize, boolean robotquery, Connection con, RowHandler rowhandler) throws SQLException {
        return this.executeSelectForXML(null, sql, offset, pagesize, robotquery, con, rowhandler);
    }

    public String executeSelectForXML(String sql, long offset, int pagesize, boolean robotquery, RowHandler rowhandler) throws SQLException {
        return this.executeSelectForXML(null, sql, offset, pagesize, robotquery, null, rowhandler);
    }

    public String executeSelectForXML(String sql, long offset, int pagesize, boolean robotquery) throws SQLException {
        return this.executeSelectForXML(null, sql, offset, pagesize, robotquery, null, null);
    }

    public String executeSelectForXML(String dbname, String sql, long offset, int pagesize, boolean robotquery) throws SQLException {
        return this.executeSelectForXML(dbname, sql, offset, pagesize, robotquery, null, null);
    }

    public String executeSelectForXML(String dbname, String sql, long offset, int pagesize, boolean robotquery, Connection con) throws SQLException {
        return this.executeSelectForXML(dbname, sql, offset, pagesize, robotquery, con, null);
    }

    public List executeSelectForList(String sql, long offset, int pagesize, Class objectType, RowHandler rowhandler) throws SQLException {
        return this.executeSelectForList((String)null, sql, offset, pagesize, objectType, rowhandler);
    }

    public List executeSelectForList(String dbname, String sql, long offset, int pagesize, Class objectType, RowHandler rowhandler) throws SQLException {
        return this.executeSelectForList(dbname, sql, offset, pagesize, DBUtil.isRobotQuery(dbname), objectType, rowhandler);
    }

    public List executeSelectForList(String dbname, String sql, long offset, int pagesize, boolean robotquery, Class objectType, RowHandler rowhandler) throws SQLException {
        return this.executeSelectForList(dbname, sql, offset, pagesize, DBUtil.isRobotQuery(dbname), null, objectType, rowhandler);
    }

    public List executeSelectForList(String dbname, String sql, long offset, int pagesize, boolean robotquery, Connection con, Class objectType, RowHandler rowhandler) throws SQLException {
        StatementInfo stmtInfo = new StatementInfo(dbname, new NewSQLInfo(sql), false, offset, pagesize, robotquery, con, this.oraclerownum);
        ResultMap resultMap = this.innerExecutePagineJDBC(stmtInfo, objectType, rowhandler, ResultMap.type_list);
        return (List)resultMap.getCommonresult();
    }

    public List executeSelectForList(String dbname, String sql, long offset, int pagesize, Connection con, Class objectType, RowHandler rowhandler) throws SQLException {
        return this.executeSelectForList(dbname, sql, offset, pagesize, DBUtil.isRobotQuery(dbname), con, objectType, rowhandler);
    }

    public List executeSelectForOracleList(String sql, long offset, int pagesize, String oraclerownum, Class objectType, RowHandler rowhandler) throws SQLException {
        return this.executeSelectForOracleList((String)null, sql, offset, pagesize, oraclerownum, objectType, rowhandler);
    }

    public List executeSelectForOracleList(String dbname, String sql, long offset, int pagesize, String oraclerownum, Class objectType, RowHandler rowhandler) throws SQLException {
        return this.executeSelectForOracleList(dbname, sql, offset, pagesize, oraclerownum, null, objectType, rowhandler);
    }

    public List executeSelectForOracleList(String dbname, String sql, long offset, int pagesize, String oraclerownum, Connection con, Class objectType, RowHandler rowhandler) throws SQLException {
        StatementInfo stmtInfo = new StatementInfo(dbname, new NewSQLInfo(sql), false, offset, pagesize, DBUtil.isRobotQuery(dbname), con, oraclerownum);
        ResultMap resultMap = this.innerExecutePagineJDBC(stmtInfo, objectType, rowhandler, ResultMap.type_list);
        return (List)resultMap.getCommonresult();
    }

    public Serializable getSerializable(int rowid, String fieldname) throws SQLException {
        this.inrange(rowid, fieldname);
        return this.allResults[this.getTrueRowid(rowid)].getSerializable(fieldname);
    }

    public Serializable getSerializable(int rowid, int columnIndex) throws SQLException {
        this.inrange(rowid, columnIndex);
        return this.allResults[this.getTrueRowid(rowid)].getSerializable(columnIndex);
    }

    public void addBatch(List<String> batchsqls) {
        this.batchSQLS = batchsqls;
    }
}

