/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.common.poolman;

import com.frameworkset.common.poolman.BatchHandler;
import com.frameworkset.common.poolman.GetCUDResult;
import com.frameworkset.common.poolman.ListSQLParams;
import com.frameworkset.common.poolman.PreparedDBUtil;
import com.frameworkset.common.poolman.SQLInfoExecutor;
import com.frameworkset.common.poolman.SQLParams;
import com.frameworkset.common.poolman.SetSQLParamException;
import com.frameworkset.common.poolman.handle.FieldRowHandler;
import com.frameworkset.common.poolman.handle.NullRowHandler;
import com.frameworkset.common.poolman.handle.RowHandler;
import com.frameworkset.util.ListInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.frameworkset.persitent.util.SQLInfo;
import org.frameworkset.persitent.util.SQLUtil;

public class SQLExecutor {
    protected String statement;
    protected String action;
    public static final String ACTION_INSERT = "insert";
    public static final String ACTION_UPDATE = "update";
    public static final String ACTION_DELETE = "delete";
    public static final String BATCH_COMMON = "common";
    public static final String BATCH_PREPARED = "prepared";
    private List<SQLParams> batchsqlparams;
    private List<String> batchsqls;
    private String batchtype = "common";
    protected SQLParams sqlparams;
    private String batchDBName;
    private boolean batchOptimize = false;

    public SQLParams getSQLParams() throws SetSQLParamException {
        if (this.sqlparams != null && (this.getPretoken() == null && this.getEndtoken() != null || this.getPretoken() != null && this.getEndtoken() == null)) {
            throw new SetSQLParamException("\u975e\u6cd5\u7684\u7ed1\u5b9a\u53d8\u91cf\u5206\u5272\u7b26\u8bbe\u7f6e:pretoken = " + this.getPretoken() + "endtoken =" + this.getEndtoken());
        }
        return this.sqlparams;
    }

    public void addSQLParam(String name, String value, String type) throws SetSQLParamException {
        this.addSQLParam(name, value, type, null);
    }

    private void init() {
        if (this.sqlparams == null) {
            this.sqlparams = new SQLParams();
        }
    }

    public void addSQLParam(String name, Object value, String type, String dataformat) throws SetSQLParamException {
        this.init();
        SQLExecutor.addSQLParam(this.sqlparams, name, value, type, dataformat);
    }

    public void addSQLParam(String name, Object value, String type, String dataformat, String charset) throws SetSQLParamException {
        this.init();
        SQLExecutor.addSQLParam(this.sqlparams, name, value, type, dataformat, charset);
    }

    public static void addSQLParam(SQLParams sqlparams, String name, Object value, String type, String dataformat) throws SetSQLParamException {
        sqlparams.addSQLParam(name, value, type, dataformat);
    }

    public static void addSQLParam(SQLParams sqlparams, String name, Object value, String type, String dataformat, String charset) throws SetSQLParamException {
        sqlparams.addSQLParam(name, value, type, dataformat, charset);
    }

    public String getDbname() {
        this.init();
        return this.sqlparams.getDbname();
    }

    public void setDbname(String dbname) {
        this.init();
        this.sqlparams.setDbname(dbname);
    }

    public String getStatement() {
        return this.statement;
    }

    public void setStatement(String statement) {
        this.statement = statement;
    }

    public String getPretoken() {
        this.init();
        return this.sqlparams.getPretoken();
    }

    public void setPretoken(String pretoken) {
        this.init();
        this.sqlparams.setPretoken(pretoken);
    }

    public String getEndtoken() {
        this.init();
        return this.sqlparams.getEndtoken();
    }

    public void setEndtoken(String endtoken) {
        this.init();
        this.sqlparams.setEndtoken(endtoken);
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public Object execute() throws SQLException {
        if (this.batchsqlparams == null && this.batchsqls == null) {
            this.action = this.action.toLowerCase();
            PreparedDBUtil dbutil = new PreparedDBUtil();
            if (this.action.equals(ACTION_INSERT)) {
                if (this.getSQLParams().size() > 0) {
                    dbutil.preparedInsert(this.getSQLParams(), this.getDbname(), SQLUtil.getGlobalSQLUtil().getSQLInfo(this.getStatement(), true, true));
                } else {
                    dbutil.executeInsert(this.getDbname(), this.getStatement());
                }
            } else if (this.action.equals(ACTION_UPDATE)) {
                if (this.getSQLParams().size() > 0) {
                    dbutil.preparedUpdate(this.getSQLParams(), this.getDbname(), SQLUtil.getGlobalSQLUtil().getSQLInfo(this.getStatement(), true, true));
                } else {
                    dbutil.executeUpdate(this.getDbname(), this.getStatement());
                }
            } else if (this.action.equals(ACTION_DELETE)) {
                if (this.getSQLParams().size() > 0) {
                    dbutil.preparedDelete(this.getSQLParams(), this.getDbname(), SQLUtil.getGlobalSQLUtil().getSQLInfo(this.getStatement(), true, true));
                } else {
                    dbutil.executeDelete(this.getDbname(), this.getStatement());
                }
            } else {
                throw new SQLException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u64cd\u4f5c\uff1a" + this.action);
            }
            return dbutil.executePrepared();
        }
        if (this.batchtype.equals(BATCH_PREPARED)) {
            PreparedDBUtil dbutil = new PreparedDBUtil();
            dbutil.setBatchOptimize(this.isBatchOptimize());
            dbutil.setPrepareDBName(this.batchDBName);
            dbutil.addPreparedBatch(new ListSQLParams(this.batchsqlparams, null));
            dbutil.executePreparedBatch();
        } else {
            PreparedDBUtil dbutil = new PreparedDBUtil();
            dbutil.addBatch(this.batchsqls);
            dbutil.executeBatch(this.getBatchDBName());
        }
        return null;
    }

    public void addPreparedBatch() {
        if (this.batchsqlparams == null) {
            this.batchsqlparams = new ArrayList<SQLParams>();
        }
        this.batchsqlparams.add(this.sqlparams);
        SQLInfo old = this.sqlparams.getOldsql();
        String oldendtoken = this.sqlparams.getEndtoken();
        String oldpretoken = this.sqlparams.getPretoken();
        this.sqlparams = this.buildParams();
        this.sqlparams.setOldsql(old);
        this.sqlparams.setEndtoken(oldendtoken);
        this.sqlparams.setPretoken(oldpretoken);
    }

    public void addBatch(String statement) {
        if (this.batchsqls == null) {
            this.batchsqls = new ArrayList<String>();
        }
        this.batchsqls.add(statement);
    }

    private SQLParams buildParams() {
        return new SQLParams();
    }

    public String getBatchDBName() {
        return this.batchDBName;
    }

    public void setBatchDBName(String batchDBName) {
        this.batchDBName = batchDBName;
    }

    public boolean isBatchOptimize() {
        return this.batchOptimize;
    }

    public void setBatchOptimize(boolean batchOptimize) {
        this.batchOptimize = batchOptimize;
    }

    public void init(String statement, String pretoken, String endtoken, String action) {
        this.sqlparams = new SQLParams();
        SQLInfoExecutor.init(this.sqlparams, SQLUtil.getGlobalSQLUtil().getSQLInfo(statement, true, true), pretoken, endtoken, action);
    }

    public String getBatchtype() {
        return this.batchtype;
    }

    public void setBatchtype(String batchtype) {
        this.batchtype = batchtype;
    }

    public static void insertBeans(String dbname, String sql, List beans) throws SQLException {
        if (beans == null || beans.size() == 0) {
            return;
        }
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, true, true);
        SQLInfoExecutor.insertBeans(dbname, sqlinfo, beans);
    }

    public static void insertBeans(String dbname, String sql, List beans, GetCUDResult getCUDResult) throws SQLException {
        if (beans == null || beans.size() == 0) {
            return;
        }
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, true, true);
        SQLInfoExecutor.insertBeans(dbname, sqlinfo, beans, getCUDResult);
    }

    public static Object update(String sql, Object ... fields) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, false, false);
        return SQLInfoExecutor.update(sqlinfo, fields);
    }

    public static Object delete(String sql, Object ... fields) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, false, false);
        return SQLInfoExecutor.delete(sqlinfo, fields);
    }

    public static void deleteByKeys(String sql, int ... fields) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, false, false);
        SQLInfoExecutor.deleteByKeys(sqlinfo, fields);
    }

    public static void deleteByKeysWithDBName(String dbname, String sql, int ... fields) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, false, false);
        SQLInfoExecutor.deleteByKeysWithDBName(dbname, sqlinfo, fields);
    }

    public static void deleteByLongKeys(String sql, long ... fields) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, false, false);
        SQLInfoExecutor.deleteByLongKeys(sqlinfo, fields);
    }

    public static void deleteByLongKeysWithDBName(String dbname, String sql, long ... fields) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, false, false);
        SQLInfoExecutor.deleteByLongKeysWithDBName(dbname, sqlinfo, fields);
    }

    public static <T> void executeBatch(String sql, List<T> datas, int batchsize, BatchHandler<T> batchHandler) throws SQLException {
        SQLExecutor.executeBatch(null, sql, datas, batchsize, batchHandler);
    }

    public static <T> void executeBatch(String dbname, String sql, List<T> datas, int batchsize, BatchHandler<T> batchHandler) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, false, false);
        SQLInfoExecutor.executeBatch(dbname, sqlinfo, datas, batchsize, batchHandler);
    }

    public static void updateByKeys(String sql, int ... fields) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, false, false);
        SQLInfoExecutor.updateByKeys(sqlinfo, fields);
    }

    public static void updateByKeysWithDBName(String dbname, String sql, int ... fields) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, false, false);
        SQLInfoExecutor.updateByKeysWithDBName(dbname, sqlinfo, fields);
    }

    public static void updateByLongKeys(String sql, long ... fields) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, false, false);
        SQLInfoExecutor.updateByLongKeys(sqlinfo, fields);
    }

    public static void updateByLongKeysWithDBName(String dbname, String sql, long ... fields) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, false, false);
        SQLInfoExecutor.updateByLongKeysWithDBName(dbname, sqlinfo, fields);
    }

    public static void updateByKeys(String sql, String ... fields) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, false, false);
        SQLInfoExecutor.updateByKeys(sqlinfo, fields);
    }

    public static void updateByKeysWithDBName(String dbname, String sql, String ... fields) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, false, false);
        SQLInfoExecutor.updateByKeysWithDBName(dbname, sqlinfo, fields);
    }

    public static void deleteByKeys(String sql, String ... fields) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, false, false);
        SQLInfoExecutor.deleteByKeys(sqlinfo, fields);
    }

    public static void deleteByKeysWithDBName(String dbname, String sql, String ... fields) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, false, false);
        SQLInfoExecutor.deleteByKeysWithDBName(dbname, sqlinfo, fields);
    }

    public static void deleteByShortKeys(String sql, short ... fields) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, false, false);
        SQLInfoExecutor.deleteByShortKeys(sqlinfo, fields);
    }

    public static void deleteByShortKeysWithDBName(String dbname, String sql, short ... fields) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, false, false);
        SQLInfoExecutor.deleteByShortKeysWithDBName(dbname, sqlinfo, fields);
    }

    public static void updateByShortKeys(String sql, short ... fields) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, false, false);
        SQLInfoExecutor.updateByShortKeys(sqlinfo, fields);
    }

    public static void updateByShortKeysWithDBName(String dbname, String sql, short ... fields) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, false, false);
        SQLInfoExecutor.updateByShortKeysWithDBName(dbname, sqlinfo, fields);
    }

    public static Object insert(String sql, Object ... fields) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, false, false);
        return SQLInfoExecutor.insert(sqlinfo, fields);
    }

    public static Object updateWithDBName(String dbname, String sql, Object ... fields) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, false, false);
        return SQLInfoExecutor.updateWithDBName(dbname, sqlinfo, fields);
    }

    public static Object deleteWithDBName(String dbname, String sql, Object ... fields) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, false, false);
        return SQLInfoExecutor.deleteWithDBName(dbname, sqlinfo, fields);
    }

    public static Object insertWithDBName(String dbname, String sql, Object ... fields) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, false, false);
        return SQLInfoExecutor.insertWithDBName(dbname, sqlinfo, fields);
    }

    public static void updateBeans(String dbname, String sql, List beans) throws SQLException {
        if (beans == null || beans.size() == 0) {
            return;
        }
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, true, true);
        SQLInfoExecutor.updateBeans(dbname, sqlinfo, beans);
    }

    public static void updateBeans(String dbname, String sql, List beans, GetCUDResult GetCUDResult2) throws SQLException {
        if (beans == null || beans.size() == 0) {
            return;
        }
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, true, true);
        SQLInfoExecutor.updateBeans(dbname, sqlinfo, beans, GetCUDResult2);
    }

    public static void deleteBeans(String dbname, String sql, List beans) throws SQLException {
        if (beans == null || beans.size() == 0) {
            return;
        }
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, true, true);
        SQLInfoExecutor.deleteBeans(dbname, sqlinfo, beans);
    }

    public static void deleteBeans(String dbname, String sql, List beans, GetCUDResult GetCUDResult2) throws SQLException {
        if (beans == null || beans.size() == 0) {
            return;
        }
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, true, true);
        SQLInfoExecutor.deleteBeans(dbname, sqlinfo, beans, GetCUDResult2);
    }

    public static void insertBean(String dbname, String sql, Object bean) throws SQLException {
        if (bean == null) {
            return;
        }
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, true, false);
        SQLInfoExecutor.insertBean(dbname, sqlinfo, bean);
    }

    public static void insertBean(String dbname, String sql, Object bean, GetCUDResult getCUDResult) throws SQLException {
        if (bean == null) {
            return;
        }
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, true, false);
        SQLInfoExecutor.insertBean(dbname, sqlinfo, bean, getCUDResult);
    }

    public static void updateBean(String dbname, String sql, Object bean) throws SQLException {
        if (bean == null) {
            return;
        }
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, true, false);
        SQLInfoExecutor.updateBean(dbname, sqlinfo, bean);
    }

    public static void updateBean(String dbname, String sql, Object bean, GetCUDResult getCUDResult) throws SQLException {
        if (bean == null) {
            return;
        }
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, true, false);
        SQLInfoExecutor.updateBean(dbname, sqlinfo, bean, getCUDResult);
    }

    public static void updateBean(String sql, Object bean, GetCUDResult getCUDResult) throws SQLException {
        SQLExecutor.updateBean(null, sql, bean, getCUDResult);
    }

    public static void deleteBean(String sql, Object bean, GetCUDResult getCUDResult) throws SQLException {
        SQLExecutor.deleteBean(null, sql, bean, getCUDResult);
    }

    public static void deleteBean(String dbname, String sql, Object bean) throws SQLException {
        if (bean == null) {
            return;
        }
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, true, false);
        SQLInfoExecutor.deleteBean(dbname, sqlinfo, bean);
    }

    public static void deleteBean(String dbname, String sql, Object bean, GetCUDResult getCUDResult) throws SQLException {
        if (bean == null) {
            return;
        }
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, true, false);
        SQLInfoExecutor.deleteBean(dbname, sqlinfo, bean, getCUDResult);
    }

    public static void insertBeans(String sql, List beans) throws SQLException {
        SQLExecutor.insertBeans(null, sql, beans);
    }

    public static void insertBeans(String sql, List beans, GetCUDResult getCUDResult) throws SQLException {
        SQLExecutor.insertBeans(null, sql, beans, getCUDResult);
    }

    public static void updateBeans(String sql, List beans) throws SQLException {
        SQLExecutor.updateBeans(null, sql, beans);
    }

    public static void deleteBeans(String sql, List beans) throws SQLException {
        SQLExecutor.deleteBeans(null, sql, beans);
    }

    public static void insertBean(String sql, Object bean) throws SQLException {
        SQLExecutor.insertBean((String)null, sql, bean);
    }

    public static void insertBean(String sql, Object bean, GetCUDResult getCUDResult) throws SQLException {
        SQLExecutor.insertBean(null, sql, bean, getCUDResult);
    }

    public static void updateBean(String sql, Object bean) throws SQLException {
        SQLExecutor.updateBean((String)null, sql, bean);
    }

    public static void deleteBean(String sql, Object bean) throws SQLException {
        SQLExecutor.deleteBean((String)null, sql, bean);
    }

    public static <T> List<T> queryList(Class<T> beanType, String sql, Object ... fields) throws SQLException {
        return SQLExecutor.queryListWithDBName(beanType, null, sql, fields);
    }

    public static ListInfo queryListInfoWithDBName(Class<?> beanType, String dbname, String sql, long offset, int pagesize, Object ... fields) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, false, false);
        return SQLInfoExecutor.queryListInfoWithDBName(beanType, dbname, sqlinfo, offset, pagesize, fields);
    }

    public static ListInfo queryListInfoWithDBName2ndTotalsize(Class<?> beanType, String dbname, String sql, long offset, int pagesize, long totalsize, Object ... fields) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, false, false);
        return SQLInfoExecutor.queryListInfoWithDBName2ndTotalsize(beanType, dbname, sqlinfo, offset, pagesize, totalsize, fields);
    }

    public static ListInfo queryListInfoWithDBName2ndTotalsizesql(Class<?> beanType, String dbname, String sql, long offset, int pagesize, String totalsizesql, Object ... fields) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, false, false);
        SQLInfo totalsizesqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(totalsizesql, false, false);
        return SQLInfoExecutor.queryListInfoWithDBName2ndTotalsizesql(beanType, dbname, sqlinfo, offset, pagesize, totalsizesqlinfo, fields);
    }

    public static ListInfo queryListInfo(Class<?> beanType, String sql, long offset, int pagesize, Object ... fields) throws SQLException {
        return SQLExecutor.queryListInfoWithDBName(beanType, null, sql, offset, pagesize, fields);
    }

    public static ListInfo queryListInfoWithTotalsize(Class<?> beanType, String sql, long offset, int pagesize, long totalsize, Object ... fields) throws SQLException {
        return SQLExecutor.queryListInfoWithDBName2ndTotalsize(beanType, null, sql, offset, pagesize, totalsize, fields);
    }

    public static ListInfo queryListInfoWithTotalsizesql(Class<?> beanType, String sql, long offset, int pagesize, String totalsizesql, Object ... fields) throws SQLException {
        return SQLExecutor.queryListInfoWithDBName2ndTotalsizesql(beanType, null, sql, offset, pagesize, totalsizesql, fields);
    }

    public static <T> T queryObject(Class<T> beanType, String sql, Object ... fields) throws SQLException {
        return SQLExecutor.queryObjectWithDBName(beanType, null, sql, fields);
    }

    public static <T> List<T> queryListWithDBName(Class<T> beanType, String dbname, String sql, Object ... fields) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, false, false);
        return SQLInfoExecutor.queryListWithDBName(beanType, dbname, sqlinfo, fields);
    }

    public static <T> T queryObjectWithDBName(Class<T> beanType, String dbname, String sql, Object ... fields) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, false, false);
        return SQLInfoExecutor.queryObjectWithDBName(beanType, dbname, sqlinfo, fields);
    }

    public static <T> List<T> queryListByRowHandler(RowHandler rowhandler, Class<T> beanType, String sql, Object ... fields) throws SQLException {
        return SQLExecutor.queryListWithDBNameByRowHandler(rowhandler, beanType, null, sql, fields);
    }

    public static ListInfo queryListInfoWithDBNameByRowHandler(RowHandler rowhandler, Class<?> beanType, String dbname, String sql, long offset, int pagesize, Object ... fields) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, false, false);
        return SQLInfoExecutor.queryListInfoWithDBNameByRowHandler(rowhandler, beanType, dbname, sqlinfo, offset, pagesize, fields);
    }

    public static ListInfo queryListInfoWithDBName2ndTotalsizeByRowHandler(RowHandler rowhandler, Class<?> beanType, String dbname, String sql, long offset, int pagesize, long totalsize, Object ... fields) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, false, false);
        return SQLInfoExecutor.queryListInfoWithDBName2ndTotalsizeByRowHandler(rowhandler, beanType, dbname, sqlinfo, offset, pagesize, totalsize, fields);
    }

    public static ListInfo queryListInfoWithDBName2ndTotalsizesqlByRowHandler(RowHandler rowhandler, Class<?> beanType, String dbname, String sql, long offset, int pagesize, String totalsizesql, Object ... fields) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, false, false);
        SQLInfo totalsizesqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(totalsizesql, false, false);
        return SQLInfoExecutor.queryListInfoWithDBName2ndTotalsizesqlByRowHandler(rowhandler, beanType, dbname, sqlinfo, offset, pagesize, totalsizesqlinfo, fields);
    }

    public static ListInfo queryListInfoByRowHandler(RowHandler rowhandler, Class<?> beanType, String sql, long offset, int pagesize, Object ... fields) throws SQLException {
        return SQLExecutor.queryListInfoWithDBNameByRowHandler(rowhandler, beanType, null, sql, offset, pagesize, fields);
    }

    public static ListInfo queryListInfoWithTotalsizeByRowHandler(RowHandler rowhandler, Class<?> beanType, String sql, long offset, int pagesize, long totalsize, Object ... fields) throws SQLException {
        return SQLExecutor.queryListInfoWithDBName2ndTotalsizeByRowHandler(rowhandler, beanType, null, sql, offset, pagesize, totalsize, fields);
    }

    public static ListInfo queryListInfoWithTotalsizesqlByRowHandler(RowHandler rowhandler, Class<?> beanType, String sql, long offset, int pagesize, String totalsizesql, Object ... fields) throws SQLException {
        return SQLExecutor.queryListInfoWithDBName2ndTotalsizesqlByRowHandler(rowhandler, beanType, null, sql, offset, pagesize, totalsizesql, fields);
    }

    public static <T> T queryObjectByRowHandler(RowHandler rowhandler, Class<T> beanType, String sql, Object ... fields) throws SQLException {
        return SQLExecutor.queryObjectWithDBNameByRowHandler(rowhandler, beanType, null, sql, fields);
    }

    public static <T> List<T> queryListWithDBNameByRowHandler(RowHandler rowhandler, Class<T> beanType, String dbname, String sql, Object ... fields) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, false, false);
        return SQLInfoExecutor.queryListWithDBNameByRowHandler(rowhandler, beanType, dbname, sqlinfo, fields);
    }

    public static <T> T queryObjectWithDBNameByRowHandler(RowHandler rowhandler, Class<T> beanType, String dbname, String sql, Object ... fields) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, false, false);
        return SQLInfoExecutor.queryObjectWithDBNameByRowHandler(rowhandler, beanType, dbname, sqlinfo, fields);
    }

    public static void queryByNullRowHandler(NullRowHandler rowhandler, String sql, Object ... fields) throws SQLException {
        SQLExecutor.queryWithDBNameByNullRowHandler(rowhandler, null, sql, fields);
    }

    public static ListInfo queryListInfoWithDBNameByNullRowHandler(NullRowHandler rowhandler, String dbname, String sql, long offset, int pagesize, Object ... fields) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, false, false);
        return SQLInfoExecutor.queryListInfoWithDBNameByNullRowHandler(rowhandler, dbname, sqlinfo, offset, pagesize, fields);
    }

    public static ListInfo queryListInfoWithDBName2ndTotalsizeByNullRowHandler(NullRowHandler rowhandler, String dbname, String sql, long offset, int pagesize, long totalsize, Object ... fields) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, false, false);
        return SQLInfoExecutor.queryListInfoWithDBName2ndTotalsizeByNullRowHandler(rowhandler, dbname, sqlinfo, offset, pagesize, totalsize, fields);
    }

    public static ListInfo queryListInfoWithDBName2ndTotalsizesqlByNullRowHandler(NullRowHandler rowhandler, String dbname, String sql, long offset, int pagesize, String totalsizesql, Object ... fields) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, false, false);
        SQLInfo totalsizesqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(totalsizesql, false, false);
        return SQLInfoExecutor.queryListInfoWithDBName2ndTotalsizesqlByNullRowHandler(rowhandler, dbname, sqlinfo, offset, pagesize, totalsizesqlinfo, fields);
    }

    public static ListInfo queryListInfoByNullRowHandler(NullRowHandler rowhandler, String sql, long offset, int pagesize, Object ... fields) throws SQLException {
        return SQLExecutor.queryListInfoWithDBNameByNullRowHandler(rowhandler, null, sql, offset, pagesize, fields);
    }

    public static ListInfo queryListInfoWithTotalsizeByNullRowHandler(NullRowHandler rowhandler, String sql, long offset, int pagesize, long totalsize, Object ... fields) throws SQLException {
        return SQLExecutor.queryListInfoWithDBName2ndTotalsizeByNullRowHandler(rowhandler, null, sql, offset, pagesize, totalsize, fields);
    }

    public static ListInfo queryListInfoWithTotalsizesqlByNullRowHandler(NullRowHandler rowhandler, String sql, long offset, int pagesize, String totalsizesql, Object ... fields) throws SQLException {
        return SQLExecutor.queryListInfoWithDBName2ndTotalsizesqlByNullRowHandler(rowhandler, null, sql, offset, pagesize, totalsizesql, fields);
    }

    public static void queryWithDBNameByNullRowHandler(NullRowHandler rowhandler, String dbname, String sql, Object ... fields) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, false, false);
        SQLInfoExecutor.queryWithDBNameByNullRowHandler(rowhandler, dbname, sqlinfo, fields);
    }

    public static <T> List<T> queryListBean(Class<T> beanType, String sql, Object bean) throws SQLException {
        return SQLExecutor.queryListBeanWithDBName(beanType, null, sql, bean);
    }

    public static ListInfo queryListInfoBeanWithDBName(Class<?> beanType, String dbname, String sql, long offset, int pagesize, long totalsize, Object bean) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, true, false);
        return SQLInfoExecutor.queryListInfoBeanWithDBName(beanType, dbname, sqlinfo, offset, pagesize, totalsize, bean);
    }

    public static ListInfo queryListInfoBeanWithDBName(Class<?> beanType, String dbname, String sql, long offset, int pagesize, String totalsizesql, Object bean) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, true, false);
        SQLInfo totalsizesqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(totalsizesql, true, false);
        return SQLInfoExecutor.queryListInfoBeanWithDBName(beanType, dbname, sqlinfo, offset, pagesize, totalsizesqlinfo, bean);
    }

    public static ListInfo queryListInfoBeanWithDBName(Class<?> beanType, String dbname, String sql, long offset, int pagesize, Object bean) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, true, false);
        return SQLInfoExecutor.queryListInfoBeanWithDBName(beanType, dbname, sqlinfo, offset, pagesize, bean);
    }

    public static ListInfo queryListInfoBean(Class<?> beanType, String sql, long offset, int pagesize, long totalsize, Object bean) throws SQLException {
        return SQLExecutor.queryListInfoBeanWithDBName(beanType, null, sql, offset, pagesize, totalsize, bean);
    }

    public static ListInfo queryListInfoBean(Class<?> beanType, String sql, long offset, int pagesize, String totalsizesql, Object bean) throws SQLException {
        return SQLExecutor.queryListInfoBeanWithDBName(beanType, null, sql, offset, pagesize, totalsizesql, bean);
    }

    public static ListInfo queryListInfoBean(Class<?> beanType, String sql, long offset, int pagesize, Object bean) throws SQLException {
        return SQLExecutor.queryListInfoBeanWithDBName(beanType, null, sql, offset, pagesize, -1L, bean);
    }

    public static String queryField(String sql, Object ... fields) throws SQLException {
        return SQLExecutor.queryFieldWithDBName(null, sql, fields);
    }

    public static String queryFieldBean(String sql, Object bean) throws SQLException {
        return SQLExecutor.queryFieldBeanWithDBName(null, sql, bean);
    }

    public static String queryFieldBeanWithDBName(String dbname, String sql, Object bean) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, true, false);
        return SQLInfoExecutor.queryFieldBeanWithDBName(dbname, sqlinfo, bean);
    }

    public static String queryFieldWithDBName(String dbname, String sql, Object ... fields) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, false, false);
        return SQLInfoExecutor.queryFieldWithDBName(dbname, sqlinfo, fields);
    }

    public static <T> T queryTField(Class<T> type, String sql, Object ... fields) throws SQLException {
        return SQLExecutor.queryTFieldWithDBName(null, type, sql, fields);
    }

    public static <T> T queryTFieldBean(Class<T> type, String sql, Object bean) throws SQLException {
        return SQLExecutor.queryTFieldBeanWithDBName(null, type, sql, bean);
    }

    public static <T> T queryTFieldBeanWithDBName(String dbname, Class<T> type, String sql, Object bean) throws SQLException {
        return SQLExecutor.queryTFieldBeanWithDBName(dbname, type, null, sql, bean);
    }

    public static <T> T queryTFieldWithDBName(String dbname, Class<T> type, String sql, Object ... fields) throws SQLException {
        return SQLExecutor.queryTFieldWithDBName(dbname, type, (FieldRowHandler)null, sql, fields);
    }

    public static <T> T queryTField(Class<T> type, FieldRowHandler<T> fieldRowHandler, String sql, Object ... fields) throws SQLException {
        return SQLExecutor.queryTFieldWithDBName(null, type, fieldRowHandler, sql, fields);
    }

    public static <T> T queryTFieldBean(Class<T> type, FieldRowHandler<T> fieldRowHandler, String sql, Object bean) throws SQLException {
        return SQLExecutor.queryTFieldBeanWithDBName(null, type, fieldRowHandler, sql, bean);
    }

    public static <T> T queryTFieldBeanWithDBName(String dbname, Class<T> type, FieldRowHandler<T> fieldRowHandler, String sql, Object bean) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, true, false);
        return SQLInfoExecutor.queryTFieldBeanWithDBName(dbname, type, fieldRowHandler, sqlinfo, bean);
    }

    public static <T> T queryTFieldWithDBName(String dbname, Class<T> type, FieldRowHandler<T> fieldRowHandler, String sql, Object ... fields) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, false, false);
        return SQLInfoExecutor.queryTFieldWithDBName(dbname, type, fieldRowHandler, sqlinfo, fields);
    }

    public static <T> T queryObjectBean(Class<T> beanType, String sql, Object bean) throws SQLException {
        return SQLExecutor.queryObjectBeanWithDBName(beanType, null, sql, bean);
    }

    public static <T> List<T> queryListBeanWithDBName(Class<T> beanType, String dbname, String sql, Object bean) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, true, false);
        return SQLInfoExecutor.queryListBeanWithDBName(beanType, dbname, sqlinfo, bean);
    }

    public static <T> T queryObjectBeanWithDBName(Class<T> beanType, String dbname, String sql, Object bean) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, true, false);
        return SQLInfoExecutor.queryObjectBeanWithDBName(beanType, dbname, sqlinfo, bean);
    }

    public static <T> List<T> queryListBeanByRowHandler(RowHandler rowhandler, Class<T> beanType, String sql, Object bean) throws SQLException {
        return SQLExecutor.queryListBeanWithDBNameByRowHandler(rowhandler, beanType, null, sql, bean);
    }

    public static ListInfo queryListInfoBeanWithDBNameByRowHandler(RowHandler rowhandler, Class<?> beanType, String dbname, String sql, long offset, int pagesize, long totalsize, Object bean) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, true, false);
        return SQLInfoExecutor.queryListInfoBeanWithDBNameByRowHandler(rowhandler, beanType, dbname, sqlinfo, offset, pagesize, totalsize, bean);
    }

    public static ListInfo queryListInfoBeanWithDBNameByRowHandler(RowHandler rowhandler, Class<?> beanType, String dbname, String sql, long offset, int pagesize, String totalsizesql, Object bean) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, true, false);
        SQLInfo totalsizesqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(totalsizesql, true, false);
        return SQLInfoExecutor.queryListInfoBeanWithDBNameByRowHandler(rowhandler, beanType, dbname, sqlinfo, offset, pagesize, totalsizesqlinfo, bean);
    }

    public static ListInfo queryListInfoBeanWithDBNameByRowHandler(RowHandler rowhandler, Class<?> beanType, String dbname, String sql, long offset, int pagesize, Object bean) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, true, false);
        return SQLInfoExecutor.queryListInfoBeanWithDBNameByRowHandler(rowhandler, beanType, dbname, sqlinfo, offset, pagesize, bean);
    }

    public static ListInfo queryListInfoBeanByRowHandler(RowHandler rowhandler, Class<?> beanType, String sql, long offset, int pagesize, long totalsize, Object bean) throws SQLException {
        return SQLExecutor.queryListInfoBeanWithDBNameByRowHandler(rowhandler, beanType, null, sql, offset, pagesize, totalsize, bean);
    }

    public static ListInfo queryListInfoBeanByRowHandler(RowHandler rowhandler, Class<?> beanType, String sql, long offset, int pagesize, String totalsizesql, Object bean) throws SQLException {
        return SQLExecutor.queryListInfoBeanWithDBNameByRowHandler(rowhandler, beanType, null, sql, offset, pagesize, totalsizesql, bean);
    }

    public static ListInfo queryListInfoBeanByRowHandler(RowHandler rowhandler, Class<?> beanType, String sql, long offset, int pagesize, Object bean) throws SQLException {
        return SQLExecutor.queryListInfoBeanWithDBNameByRowHandler(rowhandler, beanType, null, sql, offset, pagesize, -1L, bean);
    }

    public static <T> T queryObjectBeanByRowHandler(RowHandler rowhandler, Class<T> beanType, String sql, Object bean) throws SQLException {
        return SQLExecutor.queryObjectBeanWithDBNameByRowHandler(rowhandler, beanType, null, sql, bean);
    }

    public static <T> List<T> queryListBeanWithDBNameByRowHandler(RowHandler rowhandler, Class<T> beanType, String dbname, String sql, Object bean) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, true, false);
        return SQLInfoExecutor.queryListBeanWithDBNameByRowHandler(rowhandler, beanType, dbname, sqlinfo, bean);
    }

    public static <T> T queryObjectBeanWithDBNameByRowHandler(RowHandler rowhandler, Class<T> beanType, String dbname, String sql, Object bean) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, true, false);
        return SQLInfoExecutor.queryObjectBeanWithDBNameByRowHandler(rowhandler, beanType, dbname, sqlinfo, bean);
    }

    public static void queryBeanByNullRowHandler(NullRowHandler rowhandler, String sql, Object bean) throws SQLException {
        SQLExecutor.queryBeanWithDBNameByNullRowHandler(rowhandler, null, sql, bean);
    }

    public static ListInfo queryListInfoBeanWithDBNameByNullRowHandler(NullRowHandler rowhandler, String dbname, String sql, long offset, int pagesize, long totalsize, Object bean) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, true, false);
        return SQLInfoExecutor.queryListInfoBeanWithDBNameByNullRowHandler(rowhandler, dbname, sqlinfo, offset, pagesize, totalsize, bean);
    }

    public static ListInfo queryListInfoBeanWithDBNameByNullRowHandler(NullRowHandler rowhandler, String dbname, String sql, long offset, int pagesize, String totalsizesql, Object bean) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, true, false);
        SQLInfo totalsizesqlsqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(totalsizesql, true, false);
        return SQLInfoExecutor.queryListInfoBeanWithDBNameByNullRowHandler(rowhandler, dbname, sqlinfo, offset, pagesize, totalsizesqlsqlinfo, bean);
    }

    public static ListInfo queryListInfoBeanWithDBNameByNullRowHandler(NullRowHandler rowhandler, String dbname, String sql, long offset, int pagesize, Object bean) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, true, false);
        return SQLInfoExecutor.queryListInfoBeanWithDBNameByNullRowHandler(rowhandler, dbname, sqlinfo, offset, pagesize, bean);
    }

    public static ListInfo queryListInfoBeanByNullRowHandler(NullRowHandler rowhandler, String sql, long offset, int pagesize, long totalsize, Object bean) throws SQLException {
        return SQLExecutor.queryListInfoBeanWithDBNameByNullRowHandler(rowhandler, null, sql, offset, pagesize, totalsize, bean);
    }

    public static ListInfo queryListInfoBeanByNullRowHandler(NullRowHandler rowhandler, String sql, long offset, int pagesize, String totalsizesql, Object bean) throws SQLException {
        return SQLExecutor.queryListInfoBeanWithDBNameByNullRowHandler(rowhandler, null, sql, offset, pagesize, totalsizesql, bean);
    }

    public static ListInfo queryListInfoBeanByNullRowHandler(NullRowHandler rowhandler, String sql, long offset, int pagesize, Object bean) throws SQLException {
        return SQLExecutor.queryListInfoBeanWithDBNameByNullRowHandler(rowhandler, null, sql, offset, pagesize, -1L, bean);
    }

    public static void queryBeanWithDBNameByNullRowHandler(NullRowHandler rowhandler, String dbname, String sql, Object bean) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, true, false);
        SQLInfoExecutor.queryBeanWithDBNameByNullRowHandler(rowhandler, dbname, sqlinfo, bean);
    }

    public static ListInfo moreListInfoWithDBNameByRowHandler(RowHandler rowhandler, Class<?> beanType, String dbname, String sql, long offset, int pagesize, Object ... fields) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, false, false);
        return SQLInfoExecutor.moreListInfoWithDBNameByRowHandler(rowhandler, beanType, dbname, sqlinfo, offset, pagesize, fields);
    }

    public static ListInfo moreListInfoWithDBNameByNullRowHandler(NullRowHandler rowhandler, String dbname, String sql, long offset, int pagesize, Object ... fields) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, false, false);
        return SQLInfoExecutor.moreListInfoWithDBNameByNullRowHandler(rowhandler, dbname, sqlinfo, offset, pagesize, fields);
    }

    public static ListInfo moreListInfoWithDBName(Class<?> beanType, String dbname, String sql, long offset, int pagesize, Object ... fields) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, false, false);
        return SQLInfoExecutor.moreListInfoWithDBName(beanType, dbname, sqlinfo, offset, pagesize, fields);
    }

    public static ListInfo moreListInfoByRowHandler(RowHandler rowhandler, Class<?> beanType, String sql, long offset, int pagesize, Object ... fields) throws SQLException {
        return SQLExecutor.moreListInfoWithDBNameByRowHandler(rowhandler, beanType, null, sql, offset, pagesize, fields);
    }

    public static ListInfo moreListInfoByNullRowHandler(NullRowHandler rowhandler, String sql, long offset, int pagesize, Object ... fields) throws SQLException {
        return SQLExecutor.moreListInfoWithDBNameByNullRowHandler(rowhandler, null, sql, offset, pagesize, fields);
    }

    public static ListInfo moreListInfoBeanWithDBNameByRowHandler(RowHandler rowhandler, Class<?> beanType, String dbname, String sql, long offset, int pagesize, Object bean) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, true, false);
        return SQLInfoExecutor.moreListInfoBeanWithDBNameByRowHandler(rowhandler, beanType, dbname, sqlinfo, offset, pagesize, bean);
    }

    public static ListInfo moreListInfoBeanWithDBNameByNullRowHandler(NullRowHandler rowhandler, String dbname, String sql, long offset, int pagesize, Object bean) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, true, false);
        return SQLInfoExecutor.moreListInfoBeanWithDBNameByNullRowHandler(rowhandler, dbname, sqlinfo, offset, pagesize, bean);
    }

    public static ListInfo moreListInfoBeanWithDBName(Class<?> beanType, String dbname, String sql, long offset, int pagesize, Object bean) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, true, false);
        return SQLInfoExecutor.moreListInfoBeanWithDBName(beanType, dbname, sqlinfo, offset, pagesize, bean);
    }

    public static ListInfo moreListInfoBeanByRowHandler(RowHandler rowhandler, Class<?> beanType, String sql, long offset, int pagesize, Object bean) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, true, false);
        return SQLInfoExecutor.moreListInfoBeanWithDBNameByRowHandler(rowhandler, beanType, null, sqlinfo, offset, pagesize, bean);
    }

    public static ListInfo moreListInfoBeanByNullRowHandler(NullRowHandler rowhandler, String sql, long offset, int pagesize, Object bean) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, true, false);
        return SQLInfoExecutor.moreListInfoBeanWithDBNameByNullRowHandler(rowhandler, null, sqlinfo, offset, pagesize, bean);
    }

    public static ListInfo moreListInfoBean(Class<?> beanType, String sql, long offset, int pagesize, Object bean) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, true, false);
        return SQLInfoExecutor.moreListInfoBeanWithDBName(beanType, null, sqlinfo, offset, pagesize, bean);
    }

    public static ListInfo moreListInfo(Class<?> beanType, String sql, long offset, int pagesize, Object ... fields) throws SQLException {
        return SQLExecutor.moreListInfoWithDBName(beanType, null, sql, offset, pagesize, fields);
    }
}

