/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.common.poolman.management;

import com.frameworkset.common.poolman.management.BaseTableManager;
import com.frameworkset.common.poolman.management.PoolManConfiguration;
import com.frameworkset.common.poolman.management.PoolManDeployer;
import com.frameworkset.common.poolman.util.SQLManager;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.Serializable;
import java.lang.constant.Constable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.management.Attribute;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;

public class JMXPoolDeployer
extends BaseTableManager
implements PoolManDeployer,
Runnable,
Serializable {
    private static MBeanServer server;

    public JMXPoolDeployer(MBeanServer server) {
        if (server != null) {
            JMXPoolDeployer.server = server;
        }
        try {
            Class<?> r = Runtime.getRuntime().getClass();
            Method m = r.getDeclaredMethod("addShutdownHook", Thread.class);
            m.invoke((Object)Runtime.getRuntime(), new Thread(this));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        try {
            BaseTableManager.updateTableInfo();
            ObjectName queryName = new ObjectName("*:*");
            Set<ObjectName> allservices = server.queryNames(queryName, null);
            for (ObjectName objn : allservices) {
                try {
                    server.invoke(objn, "stop", null, null);
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception e) {
            System.out.println("Unable to properly shutdown: " + e);
        }
    }

    @Override
    public void deployConfiguration(PoolManConfiguration config) throws Exception {
        try {
            Properties adminProps;
            ArrayList genericPools;
            if (server == null) {
                server = MBeanServerFactory.createMBeanServer();
            }
            SQLManager manager = SQLManager.getInstance();
            ObjectName loaderName = new ObjectName("DefaultDomain:service=JMXPatchedClassLoader");
            server.createMBean("com.frameworkset.common.poolman.management.JMXClassLoader", loaderName, new Object[]{manager.getClass().getClassLoader()}, new String[]{"java.lang.ClassLoader"});
            ArrayList datasources = config.getDataSources();
            if (datasources != null) {
                for (Properties dbprops : datasources) {
                    ObjectInstance datasource = this.addDataSourceService(dbprops, loaderName);
                    try {
                        server.invoke(datasource.getObjectName(), "start", new Object[0], new String[0]);
                    }
                    catch (RuntimeMBeanException re) {
                        RuntimeException e = re.getTargetException();
                        throw e;
                    }
                }
            }
            if ((genericPools = config.getGenericPools()) != null) {
                for (Properties props : genericPools) {
                    ObjectInstance pooledObject = this.addPooledObjectService(props, loaderName);
                    try {
                        server.invoke(pooledObject.getObjectName(), "start", new Object[0], new String[0]);
                    }
                    catch (RuntimeMBeanException re) {
                        RuntimeException e = re.getTargetException();
                        System.err.println(e.getMessage());
                        e.printStackTrace();
                    }
                }
            }
            if ((adminProps = config.getAdminProperties()) != null) {
                try {
                    Class<?> agentType = Class.forName(adminProps.getProperty("class", "com.sun.jdmk.comm.HtmlAdaptorServer"));
                    Object agentInstance = agentType.newInstance();
                    String compositeName = new String(adminProps.getProperty("name", "Adaptor:name=html") + ",port=" + adminProps.getProperty("port", "8082"));
                    ObjectName agentName = new ObjectName(compositeName);
                    server.registerMBean(agentInstance, agentName);
                    Method startMethod = agentType.getMethod("start", new Class[0]);
                    startMethod.invoke(agentInstance, new Object[0]);
                }
                catch (Exception e) {
                    System.err.println("ERROR: Could not create the Admin Agent: " + e);
                    e.printStackTrace();
                }
            }
        }
        catch (RuntimeOperationsException e) {
            throw e.getTargetException();
        }
        catch (MBeanException e) {
            throw e.getTargetException();
        }
        catch (RuntimeMBeanException e) {
            throw e.getTargetException();
        }
        catch (RuntimeErrorException e) {
            throw e.getTargetError();
        }
        catch (Exception e) {
            throw e;
        }
    }

    private ObjectInstance addDataSourceService(Properties props, ObjectName loaderName) throws Exception {
        String dbname = null;
        try {
            dbname = (String)props.get("dbname");
        }
        catch (NullPointerException npe) {
            throw new Exception("No name found for database!");
        }
        ObjectName objectName = new ObjectName("DefaultDomain:service=PoolManDataSource-" + dbname);
        String className = "com.frameworkset.common.poolman.management.DataSourceService";
        ObjectInstance instance = null;
        try {
            instance = server.createMBean(className, objectName, loaderName);
        }
        catch (Exception ine) {
            ine.printStackTrace();
        }
        MBeanInfo mbeanInfo = server.getMBeanInfo(instance.getObjectName());
        MBeanAttributeInfo[] attributes = mbeanInfo.getAttributes();
        for (int n = 0; n < attributes.length; ++n) {
            String attrName = attributes[n].getName();
            if (!props.containsKey(attrName.toLowerCase())) continue;
            String propsVal = props.getProperty(attrName.toLowerCase());
            String datatype = attributes[n].getType();
            Class<Constable> type = datatype.equals("int") ? Integer.TYPE : (datatype.equals("boolean") ? Boolean.TYPE : Class.forName(datatype));
            PropertyEditor editor = PropertyEditorManager.findEditor(type);
            editor.setAsText(propsVal);
            Object value = editor.getValue();
            Attribute attrValue = new Attribute(attrName, value);
            server.setAttribute(objectName, attrValue);
        }
        return instance;
    }

    private ObjectInstance addPooledObjectService(Properties props, ObjectName loaderName) throws Exception {
        String poolName = null;
        try {
            poolName = (String)props.get("name");
        }
        catch (NullPointerException npe) {
            throw new Exception("No name found for ObjectPool!");
        }
        ObjectName objectName = new ObjectName("DefaultDomain:service=PoolManObjectPool-" + poolName);
        String className = "com.frameworkset.common.poolman.management.GenericPoolService";
        ObjectInstance instance = server.createMBean(className, objectName, loaderName);
        MBeanInfo mbeanInfo = server.getMBeanInfo(instance.getObjectName());
        MBeanAttributeInfo[] attributes = mbeanInfo.getAttributes();
        for (int n = 0; n < attributes.length; ++n) {
            String attrName = attributes[n].getName();
            if (!props.containsKey(attrName.toLowerCase())) continue;
            String propsVal = props.getProperty(attrName.toLowerCase());
            String datatype = attributes[n].getType();
            Class<Serializable> type = datatype.equals("int") ? Integer.TYPE : (datatype.equals("boolean") ? Boolean.TYPE : (datatype.equals("float") ? Float.TYPE : (datatype.equals("long") ? Long.TYPE : (datatype.equals("double") ? Double.TYPE : Class.forName(datatype)))));
            PropertyEditor editor = PropertyEditorManager.findEditor(type);
            editor.setAsText(propsVal);
            Object value = editor.getValue();
            Attribute attrValue = new Attribute(attrName, value);
            server.setAttribute(objectName, attrValue);
        }
        return instance;
    }

    public void removeDataSourceService(String dbname) throws Exception {
    }

    @Override
    public void deployConfiguration(PoolManConfiguration config, Map<String, String> values) throws Exception {
    }

    @Override
    public void deployConfiguration(PoolManConfiguration config, String dbname) throws Exception {
    }
}

