/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.commons.dbcp2;

import com.frameworkset.common.poolman.NestedSQLException;
import com.frameworkset.common.poolman.monitor.AbandonedTraceExt;
import com.frameworkset.commons.dbcp2.DriverConnectionFactory;
import com.frameworkset.commons.dbcp2.StaticDelegateConnection;
import com.frameworkset.commons.pool2.impl.AbandonedConfig;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class NativeDataSource
implements DataSource {
    private StaticCount staticCount;
    private String driver;
    private String url;
    private String user;
    private String password;
    private boolean defaultAutoCommit;
    private boolean defaultReadOnly;
    private int defaultTransactionIsolation;
    private String defaultCatalog;
    private DriverConnectionFactory driverConnectionFactory;
    protected AbandonedConfig abandonedConfig = null;
    protected Properties connectionProperties = new Properties();
    private PrintWriter logWriter;
    private boolean created = false;

    @Override
    public Connection getConnection() throws SQLException {
        this.createDataSource();
        StaticDelegateConnection connection = new StaticDelegateConnection(this.driverConnectionFactory.createConnection(), this.staticCount);
        return connection;
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        throw new UnsupportedOperationException("Not supported by BasicDataSource");
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.logWriter;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.logWriter = out;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
    }

    private void log(String message) {
        if (this.logWriter != null) {
            this.logWriter.println(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataSource createDataSource() throws SQLException {
        if (this.created) {
            return this;
        }
        NativeDataSource nativeDataSource = this;
        synchronized (nativeDataSource) {
            if (this.created) {
                return this;
            }
            if (this.driver != null) {
                try {
                    Class.forName(this.driver);
                }
                catch (Throwable t) {
                    String message = "Cannot load JDBC driver class '" + this.driver + "'";
                    if (this.logWriter != null) {
                        this.logWriter.println(message);
                        t.printStackTrace(this.logWriter);
                    }
                    throw new NestedSQLException(message, t);
                }
            }
            Driver driver = null;
            try {
                driver = DriverManager.getDriver(this.url);
            }
            catch (Throwable t) {
                String message = "Cannot create JDBC driver of class '" + (driver != null ? driver : "") + "' for connect URL '" + this.url + "'";
                if (this.logWriter != null) {
                    this.logWriter.println(message);
                    t.printStackTrace(this.logWriter);
                }
                throw new NestedSQLException(message, t);
            }
            if (this.user != null) {
                this.connectionProperties.put("user", this.user);
            } else {
                this.log("DBCP DataSource configured without a 'username'");
            }
            if (this.password != null) {
                this.connectionProperties.put("password", this.password);
            } else {
                this.log("DBCP DataSource configured without a 'password'");
            }
            this.driverConnectionFactory = new DriverConnectionFactory(driver, this.url, this.connectionProperties);
            this.staticCount = new StaticCount(this.isLogAbandoned());
            this.created = true;
        }
        return this;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isDefaultAutoCommit() {
        return this.defaultAutoCommit;
    }

    public void setDefaultAutoCommit(boolean defaultAutoCommit) {
        this.defaultAutoCommit = defaultAutoCommit;
    }

    public boolean isDefaultReadOnly() {
        return this.defaultReadOnly;
    }

    public void setDefaultReadOnly(boolean defaultReadOnly) {
        this.defaultReadOnly = defaultReadOnly;
    }

    public int getDefaultTransactionIsolation() {
        return this.defaultTransactionIsolation;
    }

    public void setDefaultTransactionIsolation(int defaultTransactionIsolation) {
        this.defaultTransactionIsolation = defaultTransactionIsolation;
    }

    public String getDefaultCatalog() {
        return this.defaultCatalog;
    }

    public void setDefaultCatalog(String defaultCatalog) {
        this.defaultCatalog = defaultCatalog;
    }

    public boolean isLogAbandoned() {
        if (this.abandonedConfig != null) {
            return this.abandonedConfig.getLogAbandoned();
        }
        return false;
    }

    public void setLogAbandoned(boolean logAbandoned) {
        if (this.abandonedConfig == null) {
            this.abandonedConfig = new AbandonedConfig();
        }
        if (logAbandoned) {
            this.abandonedConfig.setLogAbandoned(logAbandoned);
        }
    }

    public void addConnectionProperty(String propertyName, String propertyValue) {
        this.connectionProperties.put(propertyName, propertyValue);
    }

    public int getNumActive() {
        if (this.staticCount != null) {
            return this.staticCount.getActiveConnections();
        }
        return 0;
    }

    public int getMaxNumActive() {
        if (this.staticCount != null) {
            return this.staticCount.getHeapConnections();
        }
        return 0;
    }

    public List getTraces() {
        if (this.staticCount != null) {
            return this.staticCount.getTraceObjects();
        }
        return new ArrayList();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    public List<AbandonedTraceExt> getGoodTraceObjects() {
        return this.staticCount.getTraceObjects();
    }

    public synchronized void close() throws SQLException {
    }

    public static class StaticCount {
        private List<AbandonedTraceExt> traces = new ArrayList<AbandonedTraceExt>();
        private boolean logAbandoned = false;
        private volatile int activeConnections = 0;
        private volatile int heapConnections = 0;
        private Object lock = new Object();

        public StaticCount(boolean logAbandoned) {
            this.logAbandoned = logAbandoned;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void increments(AbandonedTraceExt connection) {
            Object object = this.lock;
            synchronized (object) {
                if (this.logAbandoned) {
                    this.addTraceObject(connection);
                }
                ++this.activeConnections;
                if (this.heapConnections < this.activeConnections) {
                    this.heapConnections = this.activeConnections;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void decrements(AbandonedTraceExt trace) {
            Object object = this.lock;
            synchronized (object) {
                if (this.logAbandoned) {
                    this.removeTraceObject(trace);
                }
                --this.activeConnections;
            }
        }

        protected int getActiveConnections() {
            return this.activeConnections;
        }

        protected int getHeapConnections() {
            return this.heapConnections;
        }

        private void addTraceObject(AbandonedTraceExt trace) {
            this.traces.add(trace);
        }

        private void removeTraceObject(AbandonedTraceExt trace) {
            this.traces.remove(trace);
        }

        public List<AbandonedTraceExt> getTraceObjects() {
            ArrayList<AbandonedTraceExt> dest = new ArrayList<AbandonedTraceExt>();
            try {
                if (this.traces != null) {
                    dest.addAll(this.traces);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return dest;
        }
    }
}

