/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.commons.dbcp2;

import java.lang.management.ManagementFactory;
import java.util.Objects;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ObjectNameWrapper {
    private static final Logger log = LoggerFactory.getLogger(ObjectNameWrapper.class);
    private static MBeanServer MBEAN_SERVER = ObjectNameWrapper.getPlatformMBeanServer();
    private final ObjectName objectName;

    private static MBeanServer getPlatformMBeanServer() {
        try {
            return ManagementFactory.getPlatformMBeanServer();
        }
        catch (LinkageError e) {
            log.debug("Failed to get platform MBeanServer", (Throwable)e);
            return null;
        }
        catch (Exception e) {
            log.debug("Failed to get platform MBeanServer", (Throwable)e);
            return null;
        }
    }

    public static ObjectName unwrap(ObjectNameWrapper wrapper) {
        return wrapper == null ? null : wrapper.unwrap();
    }

    public static ObjectNameWrapper wrap(ObjectName objectName) {
        return new ObjectNameWrapper(objectName);
    }

    public static ObjectNameWrapper wrap(String name) throws MalformedObjectNameException {
        return ObjectNameWrapper.wrap(new ObjectName(name));
    }

    public ObjectNameWrapper(ObjectName objectName) {
        this.objectName = objectName;
    }

    public void registerMBean(Object object) {
        if (MBEAN_SERVER == null || this.objectName == null) {
            return;
        }
        try {
            MBEAN_SERVER.registerMBean(object, this.objectName);
        }
        catch (LinkageError e) {
            log.warn("Failed to complete JMX registration for " + this.objectName, (Throwable)e);
        }
        catch (Exception e) {
            log.warn("Failed to complete JMX registration for " + this.objectName, (Throwable)e);
        }
    }

    public String toString() {
        return Objects.toString(this.objectName);
    }

    public void unregisterMBean() {
        if (MBEAN_SERVER == null || this.objectName == null) {
            return;
        }
        if (MBEAN_SERVER.isRegistered(this.objectName)) {
            try {
                MBEAN_SERVER.unregisterMBean(this.objectName);
            }
            catch (LinkageError e) {
                log.warn("Failed to complete JMX unregistration for " + this.objectName, (Throwable)e);
            }
            catch (Exception e) {
                log.warn("Failed to complete JMX unregistration for " + this.objectName, (Throwable)e);
            }
        }
    }

    public ObjectName unwrap() {
        return this.objectName;
    }
}

