/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.orm.sql;

import com.frameworkset.orm.ORMappingException;
import com.frameworkset.orm.ORMappingManager;
import com.frameworkset.orm.adapter.DBAdapter;
import com.frameworkset.orm.engine.model.Column;
import com.frameworkset.orm.engine.model.Database;
import com.frameworkset.orm.engine.model.SchemaType;
import com.frameworkset.orm.engine.model.Table;
import com.frameworkset.orm.engine.model.TypeMap;
import com.frameworkset.orm.sql.SQLBuildException;
import com.frameworkset.util.SimpleStringUtil;
import com.frameworkset.util.ValueObjectUtil;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLBuilder {
    private static Logger log = LoggerFactory.getLogger(SQLBuilder.class);
    public static final int SQLBUILD_TYPE_INSERT = 0;
    public static final int SQLBUILD_TYPE_DELETE = 1;
    public static final int SQLBUILD_TYPE_UPDATE = 2;
    public static final int SQLBUILD_TYPE_SELECT = 3;
    private static final ORMappingManager ormManager = ORMappingManager.getInstance();

    public String build(Object newObj, String dbName, int type) throws SQLBuildException {
        switch (type) {
            case 3: {
                return "";
            }
            case 1: {
                return this.buildDelete(dbName, newObj);
            }
        }
        return null;
    }

    public String build(Object newObj, int type) throws SQLBuildException {
        return this.build(newObj, null, type);
    }

    public String build(Object newObj) throws SQLBuildException {
        return this.build(newObj, null, 0);
    }

    private String buildDelete(String dbName, Object deleteObject) throws SQLBuildException {
        String className = deleteObject.getClass().getName();
        String deleteSql = "";
        try {
            Database db = ormManager.getDatabase(dbName);
            Table table = db.getTableByJavaName(className);
            List primaryKeys = table.getPrimaryKey();
            String condition = this.getDeleteCondition(dbName, primaryKeys, deleteObject);
            String tableName = table.getName();
            deleteSql = "delete from " + tableName + " where " + condition;
        }
        catch (ORMappingException ex) {
            log.error(ex.getMessage());
            throw new SQLBuildException(ex.getMessage());
        }
        return deleteSql;
    }

    private String getDeleteCondition(String dbName, List primayKeys, Object deleteObject) {
        String ret = "";
        Iterator cols = primayKeys.iterator();
        boolean first = true;
        while (cols.hasNext()) {
            Column col = (Column)cols.next();
            String colName = col.getName();
            String javaName = col.getJavaName();
            String javaType = col.getJavaType();
            SchemaType colType = (SchemaType)col.getType();
            Object value = ValueObjectUtil.getValue((Object)deleteObject, (String)javaName);
            if (value == null) continue;
            String expression = this.getExpression(colName, value, javaType, colType, dbName, 0);
            if (first) {
                ret = expression;
                first = false;
                continue;
            }
            ret = ret + " and " + expression;
        }
        return ret;
    }

    private String getExpression(String colName, Object value, String javaType, SchemaType colType, String dbName, int type) {
        String svalue = "";
        if (TypeMap.isDate(colType)) {
            Date date = null;
            date = value instanceof String ? SimpleStringUtil.stringToDate((String)((String)value)) : (Date)value;
            svalue = DBAdapter.getDateString((Date)value, dbName);
        } else {
            svalue = TypeMap.isTextType(colType) ? DBAdapter.getStringDelimiter(dbName) + "" + value + DBAdapter.getStringDelimiter(dbName) : value.toString();
        }
        return colName + "=" + svalue;
    }
}

