/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.persitent.util;

import com.frameworkset.common.poolman.sql.PoolManResultSetMetaData;
import com.frameworkset.common.poolman.util.JDBCPool;
import com.frameworkset.util.VariableHandler;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.frameworkset.persitent.util.SQLInfo;
import org.frameworkset.persitent.util.SQLUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SQLBaseCache {
    private static final Logger logger = LoggerFactory.getLogger(SQLBaseCache.class);
    protected Lock lock = new ReentrantLock();
    protected Lock metaLock = new ReentrantLock();
    protected Lock vtplLock = new ReentrantLock();
    protected Map<String, VariableHandler.SQLStruction> parserSQLStructions = new HashMap<String, VariableHandler.SQLStruction>();
    protected Map<String, VariableHandler.SQLStruction> parsertotalsizeSQLStructions = new HashMap<String, VariableHandler.SQLStruction>();
    protected long warnInterval = 500L;
    protected int resultMetaCacheSize;
    protected int perKeySqlStructionCacheSize;
    protected String sqlfile;

    public SQLBaseCache(String sqlfile, int resultMetaCacheSize, int perKeySqlStructionCacheSize) {
        this.resultMetaCacheSize = resultMetaCacheSize;
        this.perKeySqlStructionCacheSize = perKeySqlStructionCacheSize;
        this.sqlfile = sqlfile;
    }

    public void clear() {
        this.parserSQLStructions.clear();
        this.parsertotalsizeSQLStructions.clear();
    }

    protected boolean needRefreshMeta(PoolManResultSetMetaData meta, ResultSetMetaData rsmetadata) throws SQLException {
        if (meta.getColumnCount() != rsmetadata.getColumnCount()) {
            return true;
        }
        String[] labels = meta.get_columnLabel();
        int[] coltypes = meta.get_columnType();
        for (int i = 0; i < labels.length; ++i) {
            if (!labels[i].equals(rsmetadata.getColumnLabel(i + 1))) {
                return true;
            }
            if (coltypes[i] == rsmetadata.getColumnType(i + 1)) continue;
            return true;
        }
        return false;
    }

    public abstract PoolManResultSetMetaData getPoolManResultSetMetaData(boolean var1, JDBCPool var2, String var3, String var4, ResultSetMetaData var5) throws SQLException;

    protected void logMetaWarn(Logger logger, String sql, int maxSize, long missing) {
        StringBuilder info = new StringBuilder();
        if (this.sqlfile != null) {
            info.append("\n\r**********************************************************************\r\n").append("*********************************\u8b66\u544a:Missing cache ").append(missing).append(" times of sql file[").append(this.sqlfile).append("]*********************************\r\n").append("**********************************************************************\r\n").append("\u8c03\u7528\u65b9\u6cd5getPoolManResultSetMetaData\u4ecesqlmetacache \u4e2d\u83b7\u53d6sql[").append(sql).append("]\u67e5\u8be2\u5143\u6570\u636e\u4fe1\u606f\u65f6\uff0c\u68c0\u6d4b\u5230\u7f13\u51b2\u533a\u4fe1\u606f\u8bb0\u5f55\u6570\u8d85\u51fameta cache\u533a\u5141\u8bb8\u7684\u6700\u5927cache size:").append(maxSize).append(",\r\n\u5bfc\u81f4\u544a\u8b66\u539f\u56e0\u5206\u6790:").append("\r\n\u672c\u6761sql\u6216\u8005\u672c\u914d\u7f6e\u6587\u4ef6\u4e2d\u5176\u4ed6sql\u8bed\u53e5\u53ef\u80fd\u5b58\u5728\u4e0d\u65ad\u53d8\u5316\u7684\u503c\u53c2\u6570;").append("\r\n\u672c\u6761sql\u6216\u8005\u672c\u914d\u7f6e\u6587\u4ef6\u4e2d\u5176\u4ed6sql\u8bed\u53e5\u53ef\u80fd\u5b58\u5728\u7684$var\u6a21\u5f0f\u7684\u53d8\u91cf\u5e76\u4e14$var\u7684\u503c\u4e0d\u65ad\u53d8\u5316;").append("\r\n\u4f18\u5316\u5efa\u8bae\uff1a\r\n\u5c06sql\u4e2d\u53ef\u80fd\u5b58\u5728\u4e0d\u65ad\u53d8\u5316\u7684\u503c\u53c2\u6570\u8f6c\u5316\u4e3a\u7ed1\u5b9a\u53d8\u91cf\u6216\u8005#[variable]\u53d8\u91cf\uff0c\u6216\u5c06sql\u4e2d\u53ef\u80fd\u5b58\u5728\u7684$var\u6a21\u5f0f\u7684\u53d8\u91cf\u8f6c\u6362\u4e3a#[varibale]\u6a21\u5f0f\u7684\u53d8\u91cf\uff0c\u4ee5\u63d0\u5347\u7cfb\u7edf\u6027\u80fd!").append("\r\n\u6216\u8005\u901a\u8fc7\u5728").append(this.sqlfile).append("\u4e2d\u5bf9\u5e94sql\u914d\u7f6e\u7684property\u5143\u7d20\u589e\u52a0cacheSql=\"false\"\u5c5e\u6027\u6765\u5173\u95edsql\u8bed\u6cd5\u7f13\u5b58\u673a\u5236.").append("\n\r**********************************************************************").append("\n\r**********************************************************************");
        } else {
            info.append("\n\r**********************************************************************\r\n").append("*********************************\u8b66\u544a:Missing cache ").append(missing).append(" times *********************************\r\n").append("**********************************************************************\r\n").append("\u8c03\u7528\u65b9\u6cd5getPoolManResultSetMetaData\u4ecesqlmetacache \u4e2d\u83b7\u53d6\u4ee3\u7801\u4e2d\u786c\u7f16\u7801sql[").append(sql).append("]\u67e5\u8be2\u5143\u6570\u636e\u4fe1\u606f\u65f6\uff0c\u68c0\u6d4b\u5230\u7f13\u51b2\u533a\u4fe1\u606f\u8bb0\u5f55\u6570\u8d85\u51fameta cache\u533a\u5141\u8bb8\u7684\u6700\u5927cache size:").append(maxSize).append("\r\n\u5bfc\u81f4\u544a\u8b66\u539f\u56e0\u5206\u6790:\r\n\u672c\u6761sql\u6216\u8005\u5176\u4ed6sql\u8bed\u53e5\u76f4\u63a5\u786c\u7f16\u7801\u5728\u4ee3\u7801\u4e2d;").append("\r\n\u672c\u6761sql\u6216\u8005\u672c\u6587\u4ef6\u4e2d\u5176\u4ed6sql\u8bed\u53e5\u53ef\u80fd\u5b58\u5728\u4e0d\u65ad\u53d8\u5316\u7684\u503c\u53c2\u6570;").append("\r\n\u672c\u6761sql\u6216\u8005\u672c\u6587\u4ef6\u4e2d\u5176\u4ed6sql\u8bed\u53e5\u53ef\u80fd\u5b58\u5728\u7684$var\u6a21\u5f0f\u7684\u53d8\u91cf\u5e76\u4e14$var\u7684\u503c\u4e0d\u65ad\u53d8\u5316;").append("\r\n\u4f18\u5316\u5efa\u8bae\uff1a\r\n\u5c06sql\u4e2d\u53ef\u80fd\u5b58\u5728\u4e0d\u65ad\u53d8\u5316\u7684\u503c\u53c2\u6570\u8f6c\u5316\u4e3a\u7ed1\u5b9a\u53d8\u91cf\u6216\u8005#[variable]\u53d8\u91cf\uff0c\u6216\u5c06sql\u4e2d\u53ef\u80fd\u5b58\u5728\u7684$var\u6a21\u5f0f\u7684\u53d8\u91cf\u8f6c\u6362\u4e3a#[varibale]\u6a21\u5f0f\u7684\u53d8\u91cf\uff0c\u5e76\u91c7\u7528\u914d\u7f6e\u6587\u4ef6\u6765\u7ba1\u7406sql\u8bed\u53e5\uff0c\u4ee5\u63d0\u5347\u7cfb\u7edf\u6027\u80fd!").append("\r\n\u4f18\u5316\u5efa\u8bae\uff1a\r\n\u5c06sql\u4e2d\u53ef\u80fd\u5b58\u5728\u4e0d\u65ad\u53d8\u5316\u7684\u503c\u53c2\u6570\u8f6c\u5316\u4e3a\u7ed1\u5b9a\u53d8\u91cf\u6216\u8005#[variable]\u53d8\u91cf\uff0c\u6216\u5c06sql\u4e2d\u53ef\u80fd\u5b58\u5728\u7684$var\u6a21\u5f0f\u7684\u53d8\u91cf\u8f6c\u6362\u4e3a#[varibale]\u6a21\u5f0f\u7684\u53d8\u91cf\uff0c\u5e76\u91c7\u7528\u914d\u7f6e\u6587\u4ef6\u6765\u7ba1\u7406sql\u8bed\u53e5\uff0c\u4ee5\u63d0\u5347\u7cfb\u7edf\u6027\u80fd!").append("\n\r**********************************************************************").append("\n\r**********************************************************************");
        }
        logger.warn(info.toString());
    }

    protected void logSqlStructionWarn(Logger logger, String sql, int maxSize, String okey, long missing) {
        StringBuilder info = new StringBuilder();
        if (this.sqlfile != null) {
            info.append("\n\r**********************************************************************\r\n").append("*********************************\u8b66\u544a:Missing cache ").append(missing).append(" times of sql ").append(okey).append("@file[").append(this.sqlfile).append("]*********************************\r\n").append("**********************************************************************\r\n").append("\u8c03\u7528\u65b9\u6cd5_getVTPLSQLStruction\u4ecesql struction cache\u83b7\u53d6[").append(sql).append("]sql struction \u4fe1\u606f\u65f6,\u68c0\u6d4b\u5230\u7f13\u51b2\u533a\u4fe1\u606f\u8bb0\u5f55\u6570\u8d85\u51faSqlStructionCache\u5141\u8bb8\u7684\u6700\u5927cache size:").append(maxSize).append(",\r\n\u5bfc\u81f4\u544a\u8b66\u539f\u56e0\u5206\u6790:").append("\r\n\u672c\u6761sql\u53ef\u80fd\u5b58\u5728\u4e0d\u65ad\u53d8\u5316\u7684\u503c\u53c2\u6570;").append("\r\n\u672c\u6761sql\u53ef\u80fd\u5b58\u5728\u7684$var\u6a21\u5f0f\u7684\u53d8\u91cf\u5e76\u4e14$var\u7684\u503c\u4e0d\u65ad\u53d8\u5316;").append("\r\n\u4f18\u5316\u5efa\u8bae\uff1a\r\n\u5c06sql\u4e2d\u53ef\u80fd\u5b58\u5728\u4e0d\u65ad\u53d8\u5316\u7684\u503c\u53c2\u6570\u8f6c\u5316\u4e3a\u7ed1\u5b9a\u53d8\u91cf\u6216\u8005#[variable]\u53d8\u91cf\uff0c\u6216\u5c06sql\u4e2d\u53ef\u80fd\u5b58\u5728\u7684$var\u6a21\u5f0f\u7684\u53d8\u91cf\u8f6c\u6362\u4e3a#[varibale]\u6a21\u5f0f\u7684\u53d8\u91cf\uff0c\u4ee5\u63d0\u5347\u7cfb\u7edf\u6027\u80fd!").append("\r\n\u6216\u8005\u901a\u8fc7\u5728").append(okey).append("@file[").append(this.sqlfile).append("]\u7684property\u5143\u7d20\u589e\u52a0cacheSql=\"false\"\u5c5e\u6027\u6765\u5173\u95edsql\u8bed\u6cd5\u7f13\u5b58\u673a\u5236.").append("\n\r**********************************************************************").append("\n\r**********************************************************************");
        } else {
            info.append("\n\r**********************************************************************\r\n").append("*********************************\u8b66\u544a Missing cache ").append(missing).append(" times *********************************\r\n").append("**********************************************************************\r\n").append("\u8c03\u7528\u65b9\u6cd5_getVTPLSQLStruction\u4ecesql struction cache\u83b7\u53d6\u4ee3\u7801\u4e2d\u786c\u7f16\u7801[").append(sql).append("]sql struction \u4fe1\u606f\u65f6,\u68c0\u6d4b\u5230\u7f13\u51b2\u533a\u4fe1\u606f\u8bb0\u5f55\u6570\u8d85\u51faSqlStructionCache\u5141\u8bb8\u7684\u6700\u5927cache size:").append(maxSize).append(",\r\n\u5bfc\u81f4\u544a\u8b66\u539f\u56e0\u5206\u6790:\r\n\u672c\u6761sql\u6216\u8005\u5176\u4ed6sql\u8bed\u53e5\u76f4\u63a5\u786c\u7f16\u7801\u5728\u4ee3\u7801\u4e2d;").append("\r\n\u672c\u6761sql\u6216\u8005\u5176\u4ed6sql\u8bed\u53e5\u53ef\u80fd\u5b58\u5728\u4e0d\u65ad\u53d8\u5316\u7684\u503c\u53c2\u6570;").append("\r\n\u672c\u6761sql\u6216\u8005\u5176\u4ed6sql\u8bed\u53e5\u53ef\u80fd\u5b58\u5728\u7684$var\u6a21\u5f0f\u7684\u53d8\u91cf\u5e76\u4e14$var\u7684\u503c\u4e0d\u65ad\u53d8\u5316;").append("\r\n\u4f18\u5316\u5efa\u8bae\uff1a\r\n\u5c06sql\u4e2d\u53ef\u80fd\u5b58\u5728\u4e0d\u65ad\u53d8\u5316\u7684\u503c\u53c2\u6570\u8f6c\u5316\u4e3a\u7ed1\u5b9a\u53d8\u91cf\u6216\u8005#[variable]\u53d8\u91cf\uff0c\u6216\u5c06sql\u4e2d\u53ef\u80fd\u5b58\u5728\u7684$var\u6a21\u5f0f\u7684\u53d8\u91cf\u8f6c\u6362\u4e3a#[varibale]\u6a21\u5f0f\u7684\u53d8\u91cf\uff0c\u5e76\u91c7\u7528\u914d\u7f6e\u6587\u4ef6\u6765\u7ba1\u7406sql\u8bed\u53e5\uff0c\u4ee5\u63d0\u5347\u7cfb\u7edf\u6027\u80fd!").append("\n\r**********************************************************************").append("\n\r**********************************************************************");
        }
        logger.warn(info.toString());
    }

    public VariableHandler.SQLStruction getSQLStruction(SQLInfo sqlinfo, String newsql) {
        if (sqlinfo.getSqlutil() == null || sqlinfo.getSqlutil() == SQLUtil.getGlobalSQLUtil()) {
            return this._getVTPLSQLStruction(false, sqlinfo, newsql, "___GlobalSQLUtil_", this.resultMetaCacheSize);
        }
        if (sqlinfo.istpl()) {
            return this._getVTPLSQLStruction(false, sqlinfo, newsql, sqlinfo.getSqlname(), this.perKeySqlStructionCacheSize);
        }
        return this._getSQLStruction(this.parserSQLStructions, sqlinfo, newsql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected VariableHandler.SQLStruction _getSQLStruction(Map<String, VariableHandler.SQLStruction> parserSQLStructions, SQLInfo sqlinfo, String newsql) {
        String key = sqlinfo.getSqlname();
        VariableHandler.SQLStruction sqlstruction = parserSQLStructions.get(key);
        if (sqlstruction == null) {
            try {
                this.lock.lock();
                sqlstruction = parserSQLStructions.get(key);
                if (sqlstruction == null) {
                    sqlstruction = VariableHandler.parserSQLStruction((String)newsql);
                    parserSQLStructions.put(key, sqlstruction);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return sqlstruction;
    }

    protected abstract VariableHandler.SQLStruction _getVTPLSQLStruction(boolean var1, SQLInfo var2, String var3, String var4, int var5);

    public VariableHandler.SQLStruction getTotalsizeSQLStruction(SQLInfo totalsizesqlinfo, String newtotalsizesql) {
        if (totalsizesqlinfo.getSqlutil() == null || totalsizesqlinfo.getSqlutil() == SQLUtil.getGlobalSQLUtil()) {
            return this._getVTPLSQLStruction(true, totalsizesqlinfo, newtotalsizesql, "___GlobalSQLUtil_", this.resultMetaCacheSize);
        }
        if (totalsizesqlinfo.istpl()) {
            return this._getVTPLSQLStruction(true, totalsizesqlinfo, newtotalsizesql, totalsizesqlinfo.getSqlname(), this.perKeySqlStructionCacheSize);
        }
        return this._getSQLStruction(this.parsertotalsizeSQLStructions, totalsizesqlinfo, newtotalsizesql);
    }
}

