/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.spi.geoip;

import com.frameworkset.util.DaemonThread;
import com.frameworkset.util.ResourceInitial;
import com.maxmind.db.CHMCache;
import com.maxmind.db.InvalidDatabaseException;
import com.maxmind.db.NodeCache;
import com.maxmind.geoip2.DatabaseReader;
import com.maxmind.geoip2.exception.AddressNotFoundException;
import com.maxmind.geoip2.exception.GeoIp2Exception;
import com.maxmind.geoip2.model.AsnResponse;
import com.maxmind.geoip2.model.CityResponse;
import com.maxmind.geoip2.model.CountryResponse;
import com.maxmind.geoip2.model.IspResponse;
import com.maxmind.geoip2.record.City;
import com.maxmind.geoip2.record.Continent;
import com.maxmind.geoip2.record.Country;
import com.maxmind.geoip2.record.Location;
import com.maxmind.geoip2.record.Postal;
import com.maxmind.geoip2.record.Subdivision;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.frameworkset.spi.BaseApplicationContext;
import org.frameworkset.spi.geoip.Fields;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoIPFilter {
    private static final Logger logger = LoggerFactory.getLogger(GeoIPFilter.class);
    private static final String CITY_LITE_DB_TYPE = "GeoLite2-City";
    private static final String COUNTRY_LITE_DB_TYPE = "GeoLite2-Country";
    private static final String ASN_LITE_DB_TYPE = "GeoLite2-ASN";
    private static final String CITY_DB_TYPE = "GeoIP2-City";
    private static final String CITY_AFRICA_DB_TYPE = "GeoIP2-City-Africa";
    private static final String CITY_ASIA_PACIFIC_DB_TYPE = "GeoIP2-City-Asia-Pacific";
    private static final String CITY_EUROPE_DB_TYPE = "GeoIP2-City-Europe";
    private static final String CITY_NORTH_AMERICA_DB_TYPE = "GeoIP2-City-North-America";
    private static final String CITY_SOUTH_AMERICA_DB_TYPE = "GeoIP2-City-South-America";
    private static final String COUNTRY_DB_TYPE = "GeoIP2-Country";
    private static final String ISP_DB_TYPE = "GeoIP2-ISP";
    private final Set<Fields> desiredFields;
    private final Set<Fields> asnDesiredFields;
    private DatabaseReader databaseReader;
    private DatabaseReader asnDatabaseReader;
    private final String databasePath;
    private final String asnDatabasePath;
    private final int cacheSize;
    private final DaemonThread daemonThread;

    public GeoIPFilter(String databasePath, String asnDatabasePath) {
        this(databasePath, asnDatabasePath, 4096);
    }

    public GeoIPFilter(String databasePath, String asnDatabasePath, int cacheSize) {
        this.databasePath = databasePath;
        this.asnDatabasePath = asnDatabasePath;
        this.cacheSize = cacheSize;
        File database = new File(databasePath);
        File asnDatabase = new File(asnDatabasePath);
        try {
            this.databaseReader = new DatabaseReader.Builder(database).withCache((NodeCache)new CHMCache(cacheSize)).build();
            this.asnDatabaseReader = new DatabaseReader.Builder(asnDatabase).withCache((NodeCache)new CHMCache(cacheSize)).build();
            this.daemonThread = new DaemonThread(5000L, "GeoIP-Database-Reload");
            this.daemonThread.addFile(database, new ResourceInitial(){

                public void reinit() {
                    GeoIPFilter.this.resetDatabaseReader();
                }
            });
            this.daemonThread.addFile(asnDatabase, new ResourceInitial(){

                public void reinit() {
                    GeoIPFilter.this.resetAsnDatabaseReader();
                }
            });
            this.daemonThread.start();
            BaseApplicationContext.addShutdownHook((Runnable)new Runnable(){

                @Override
                public void run() {
                    GeoIPFilter.this.daemonThread.stopped();
                }
            });
        }
        catch (InvalidDatabaseException e) {
            throw new IllegalArgumentException("The database provided is invalid or corrupted.", e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("The database provided was not found in the path", e);
        }
        this.desiredFields = this.createDesiredFields();
        this.asnDesiredFields = this.createAsnDesiredFields();
    }

    public void resetDatabaseReader() {
        File database = new File(this.databasePath);
        try {
            DatabaseReader databaseReader = new DatabaseReader.Builder(database).withCache((NodeCache)new CHMCache(this.cacheSize)).build();
            final DatabaseReader temp = this.databaseReader;
            this.databaseReader = databaseReader;
            Thread t = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    4 var1_1 = this;
                    synchronized (var1_1) {
                        block8: {
                            try {
                                4.sleep(60000L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            if (temp != null) {
                                try {
                                    logger.info("Delay 60s and close old geoip city database.");
                                    temp.close();
                                }
                                catch (Exception e) {
                                    if (!logger.isErrorEnabled()) break block8;
                                    logger.error("Reinit geoip city database " + GeoIPFilter.this.databasePath + " failed:", (Throwable)e);
                                }
                            }
                        }
                    }
                }
            };
            t.start();
        }
        catch (InvalidDatabaseException e) {
            throw new IllegalArgumentException("The database provided is invalid or corrupted.", e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("The database provided was not found in the path", e);
        }
    }

    public void resetAsnDatabaseReader() {
        File asnDatabase = new File(this.asnDatabasePath);
        try {
            DatabaseReader asnDatabaseReader = new DatabaseReader.Builder(asnDatabase).withCache((NodeCache)new CHMCache(this.cacheSize)).build();
            final DatabaseReader temp = this.asnDatabaseReader;
            this.asnDatabaseReader = asnDatabaseReader;
            Thread t = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    5 var1_1 = this;
                    synchronized (var1_1) {
                        block8: {
                            try {
                                5.sleep(60000L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            if (temp != null) {
                                try {
                                    logger.info("Delay 60s and close old geoip asn database.");
                                    temp.close();
                                }
                                catch (Exception e) {
                                    if (!logger.isErrorEnabled()) break block8;
                                    logger.error("Reinit geoip asn database " + GeoIPFilter.this.asnDatabasePath + " failed:", (Throwable)e);
                                }
                            }
                        }
                    }
                }
            };
            t.start();
        }
        catch (InvalidDatabaseException e) {
            throw new IllegalArgumentException("The database provided is invalid or corrupted.", e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("The database provided was not found in the path", e);
        }
    }

    private Set<Fields> createDesiredFields() {
        EnumSet<Fields> desiredFields = null;
        String databaseType = this.databaseReader.getMetadata().getDatabaseType();
        if (databaseType.equals(CITY_LITE_DB_TYPE) || databaseType.equals(CITY_DB_TYPE) || databaseType.equals(CITY_AFRICA_DB_TYPE) || databaseType.equals(CITY_ASIA_PACIFIC_DB_TYPE) || databaseType.equals(CITY_EUROPE_DB_TYPE) || databaseType.equals(CITY_NORTH_AMERICA_DB_TYPE) || databaseType.equals(CITY_SOUTH_AMERICA_DB_TYPE)) {
            desiredFields = Fields.DEFAULT_CITY_FIELDS;
        } else if (databaseType.equals(COUNTRY_LITE_DB_TYPE) || databaseType.equals(COUNTRY_DB_TYPE)) {
            desiredFields = Fields.DEFAULT_COUNTRY_FIELDS;
        } else if (databaseType.equals(ISP_DB_TYPE)) {
            desiredFields = Fields.DEFAULT_ISP_FIELDS;
        } else if (databaseType.equals(ASN_LITE_DB_TYPE)) {
            desiredFields = Fields.DEFAULT_ASN_LITE_FIELDS;
        }
        return desiredFields;
    }

    private Set<Fields> createAsnDesiredFields() {
        EnumSet<Fields> desiredFields = null;
        desiredFields = Fields.DEFAULT_ASN_LITE_FIELDS;
        return desiredFields;
    }

    public Map<String, Object> handleIpAsn(String ip) {
        if (ip.trim().isEmpty()) {
            return new HashMap<String, Object>();
        }
        HashMap<String, Object> geoData = new HashMap();
        try {
            InetAddress ipAddress = InetAddress.getByName(ip);
            geoData = this.retrieveAsnGeoData(ipAddress);
        }
        catch (UnknownHostException e) {
            logger.debug("IP Field contained invalid IP address or hostname. exception={}", (Throwable)e);
        }
        catch (AddressNotFoundException e) {
            logger.debug("IP not found! exception={}", (Throwable)e);
        }
        catch (GeoIp2Exception e) {
            logger.debug("GeoIP2 Exception. exception={}", (Throwable)e);
        }
        catch (IOException e) {
            logger.debug("GeoIP2 Exception. exception={}", (Throwable)e);
        }
        return geoData;
    }

    public Map<String, Object> handleIp(String ip) {
        Map<String, Object> geoData;
        block10: {
            if (ip.trim().isEmpty()) {
                return new HashMap<String, Object>();
            }
            geoData = new HashMap<String, Object>();
            try {
                InetAddress ipAddress = InetAddress.getByName(ip);
                String databaseType = this.databaseReader.getMetadata().getDatabaseType();
                if (databaseType.equals(CITY_LITE_DB_TYPE) || databaseType.equals(CITY_DB_TYPE) || databaseType.equals(CITY_AFRICA_DB_TYPE) || databaseType.equals(CITY_ASIA_PACIFIC_DB_TYPE) || databaseType.equals(CITY_EUROPE_DB_TYPE) || databaseType.equals(CITY_NORTH_AMERICA_DB_TYPE) || databaseType.equals(CITY_SOUTH_AMERICA_DB_TYPE)) {
                    geoData = this.retrieveCityGeoData(ipAddress);
                    break block10;
                }
                if (databaseType.equals(COUNTRY_LITE_DB_TYPE) || databaseType.equals(COUNTRY_DB_TYPE)) {
                    geoData = this.retrieveCountryGeoData(ipAddress);
                    break block10;
                }
                if (databaseType.equals(ASN_LITE_DB_TYPE)) {
                    geoData = this.retrieveAsnGeoData(ipAddress);
                    break block10;
                }
                if (databaseType.equals(ISP_DB_TYPE)) {
                    geoData = this.retrieveIspGeoData(ipAddress);
                    break block10;
                }
                throw new IllegalStateException("Unsupported database type " + this.databaseReader.getMetadata().getDatabaseType() + "");
            }
            catch (UnknownHostException e) {
                logger.debug("IP Field contained invalid IP address or hostname. exception={}", (Throwable)e);
            }
            catch (AddressNotFoundException e) {
                logger.debug("IP not found! exception={}", (Throwable)e);
            }
            catch (GeoIp2Exception e) {
                logger.debug("GeoIP2 Exception. exception={}", (Throwable)e);
            }
            catch (IOException e) {
                logger.debug("GeoIP2 Exception. exception={}", (Throwable)e);
            }
        }
        return geoData;
    }

    private Map<String, Object> retrieveCityGeoData(InetAddress ipAddress) throws GeoIp2Exception, IOException {
        CityResponse response = this.databaseReader.city(ipAddress);
        Country country = response.getCountry();
        City city = response.getCity();
        Location location = response.getLocation();
        Continent continent = response.getContinent();
        Postal postal = response.getPostal();
        Subdivision subdivision = response.getMostSpecificSubdivision();
        HashMap<String, Object> geoData = new HashMap<String, Object>();
        if (location.getLatitude() == null && location.getLongitude() == null) {
            return geoData;
        }
        for (Fields desiredField : this.desiredFields) {
            switch (desiredField) {
                case CITY_NAME: {
                    String cityName = (String)city.getNames().get("zh-CN");
                    if (cityName == null) break;
                    geoData.put(Fields.CITY_NAME.fieldName(), cityName);
                    break;
                }
                case CONTINENT_CODE: {
                    String continentCode = continent.getCode();
                    if (continentCode == null) break;
                    geoData.put(Fields.CONTINENT_CODE.fieldName(), continentCode);
                    break;
                }
                case CONTINENT_NAME: {
                    String continentName = (String)continent.getNames().get("zh-CN");
                    if (continentName == null) break;
                    geoData.put(Fields.CONTINENT_NAME.fieldName(), continentName);
                    break;
                }
                case COUNTRY_NAME: {
                    String countryName = (String)country.getNames().get("zh-CN");
                    if (countryName == null) break;
                    geoData.put(Fields.COUNTRY_NAME.fieldName(), countryName);
                    break;
                }
                case COUNTRY_CODE2: {
                    String countryCode2 = country.getIsoCode();
                    if (countryCode2 == null) break;
                    geoData.put(Fields.COUNTRY_CODE2.fieldName(), countryCode2);
                    break;
                }
                case COUNTRY_CODE3: {
                    String countryCode3 = country.getIsoCode();
                    if (countryCode3 == null) break;
                    geoData.put(Fields.COUNTRY_CODE3.fieldName(), countryCode3);
                    break;
                }
                case IP: {
                    geoData.put(Fields.IP.fieldName(), ipAddress.getHostAddress());
                    break;
                }
                case POSTAL_CODE: {
                    String postalCode = postal.getCode();
                    if (postalCode == null) break;
                    geoData.put(Fields.POSTAL_CODE.fieldName(), postalCode);
                    break;
                }
                case DMA_CODE: {
                    Integer dmaCode = location.getMetroCode();
                    if (dmaCode == null) break;
                    geoData.put(Fields.DMA_CODE.fieldName(), dmaCode);
                    break;
                }
                case REGION_NAME: {
                    String subdivisionName = (String)subdivision.getNames().get("zh-CN");
                    if (subdivisionName == null) break;
                    geoData.put(Fields.REGION_NAME.fieldName(), subdivisionName);
                    break;
                }
                case REGION_CODE: {
                    String subdivisionCode = subdivision.getIsoCode();
                    if (subdivisionCode == null) break;
                    geoData.put(Fields.REGION_CODE.fieldName(), subdivisionCode);
                    break;
                }
                case TIMEZONE: {
                    String locationTimeZone = location.getTimeZone();
                    if (locationTimeZone == null) break;
                    geoData.put(Fields.TIMEZONE.fieldName(), locationTimeZone);
                    break;
                }
                case LOCATION: {
                    Double latitude = location.getLatitude();
                    Double longitude = location.getLongitude();
                    if (latitude == null || longitude == null) break;
                    HashMap<String, Double> locationObject = new HashMap<String, Double>();
                    locationObject.put("lat", latitude);
                    locationObject.put("lon", longitude);
                    geoData.put(Fields.LOCATION.fieldName(), locationObject);
                    break;
                }
                case LATITUDE: {
                    Double lat = location.getLatitude();
                    if (lat == null) break;
                    geoData.put(Fields.LATITUDE.fieldName(), lat);
                    break;
                }
                case LONGITUDE: {
                    Double lon = location.getLongitude();
                    if (lon == null) break;
                    geoData.put(Fields.LONGITUDE.fieldName(), lon);
                }
            }
        }
        return geoData;
    }

    private Map<String, Object> retrieveCountryGeoData(InetAddress ipAddress) throws GeoIp2Exception, IOException {
        CountryResponse response = this.databaseReader.country(ipAddress);
        Country country = response.getCountry();
        Continent continent = response.getContinent();
        HashMap<String, Object> geoData = new HashMap<String, Object>();
        for (Fields desiredField : this.desiredFields) {
            switch (desiredField) {
                case IP: {
                    geoData.put(Fields.IP.fieldName(), ipAddress.getHostAddress());
                    break;
                }
                case COUNTRY_CODE2: {
                    String countryCode2 = country.getIsoCode();
                    if (countryCode2 == null) break;
                    geoData.put(Fields.COUNTRY_CODE2.fieldName(), countryCode2);
                    break;
                }
                case COUNTRY_NAME: {
                    String countryName = (String)country.getNames().get("zh-CN");
                    if (countryName == null) break;
                    geoData.put(Fields.COUNTRY_NAME.fieldName(), countryName);
                    break;
                }
                case CONTINENT_NAME: {
                    String continentName = (String)continent.getNames().get("zh-CN");
                    if (continentName == null) break;
                    geoData.put(Fields.CONTINENT_NAME.fieldName(), continentName);
                }
            }
        }
        return geoData;
    }

    private Map<String, Object> retrieveIspGeoData(InetAddress ipAddress) throws GeoIp2Exception, IOException {
        IspResponse response = this.databaseReader.isp(ipAddress);
        HashMap<String, Object> geoData = new HashMap<String, Object>();
        for (Fields desiredField : this.desiredFields) {
            switch (desiredField) {
                case IP: {
                    geoData.put(Fields.IP.fieldName(), ipAddress.getHostAddress());
                    break;
                }
                case AUTONOMOUS_SYSTEM_NUMBER: {
                    Integer asn = response.getAutonomousSystemNumber();
                    if (asn == null) break;
                    geoData.put(Fields.AUTONOMOUS_SYSTEM_NUMBER.fieldName(), asn);
                    break;
                }
                case AUTONOMOUS_SYSTEM_ORGANIZATION: {
                    String aso = response.getAutonomousSystemOrganization();
                    if (aso == null) break;
                    geoData.put(Fields.AUTONOMOUS_SYSTEM_ORGANIZATION.fieldName(), aso);
                    break;
                }
                case ISP: {
                    String isp = response.getIsp();
                    if (isp == null) break;
                    geoData.put(Fields.ISP.fieldName(), isp);
                    break;
                }
                case ORGANIZATION: {
                    String org = response.getOrganization();
                    if (org == null) break;
                    geoData.put(Fields.ORGANIZATION.fieldName(), org);
                }
            }
        }
        return geoData;
    }

    private Map<String, Object> retrieveAsnGeoData(InetAddress ipAddress) throws GeoIp2Exception, IOException {
        AsnResponse response = this.asnDatabaseReader.asn(ipAddress);
        HashMap<String, Object> geoData = new HashMap<String, Object>();
        for (Fields desiredField : this.asnDesiredFields) {
            switch (desiredField) {
                case IP: {
                    geoData.put(Fields.IP.fieldName(), ipAddress.getHostAddress());
                    break;
                }
                case AUTONOMOUS_SYSTEM_NUMBER: {
                    Integer asn = response.getAutonomousSystemNumber();
                    if (asn == null) break;
                    geoData.put(Fields.AUTONOMOUS_SYSTEM_NUMBER.fieldName(), asn);
                    break;
                }
                case AUTONOMOUS_SYSTEM_ORGANIZATION: {
                    String aso = response.getAutonomousSystemOrganization();
                    if (aso == null) break;
                    geoData.put(Fields.AUTONOMOUS_SYSTEM_ORGANIZATION.fieldName(), aso);
                    geoData.put("orinIsp", aso);
                }
            }
        }
        return geoData;
    }
}

