/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.spi.geoip;

import com.frameworkset.util.SimpleStringUtil;
import java.util.HashMap;
import java.util.Map;
import org.frameworkset.elasticsearch.ElasticSearchHelper;
import org.frameworkset.elasticsearch.entity.geo.GeoPoint;
import org.frameworkset.spi.geoip.DefaultIPConverter;
import org.frameworkset.spi.geoip.GeoIPFilter;
import org.frameworkset.spi.geoip.GeoIPHandlerException;
import org.frameworkset.spi.geoip.IPConverter;
import org.frameworkset.spi.geoip.IpInfo;
import org.frameworkset.spi.ip2region.IP2Region;
import org.frameworkset.spi.remote.http.HttpRequestUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoIPUtil {
    private GeoIPFilter geoIPFilter;
    private IP2Region ip2Region;
    private Object ispConverter;
    private IPConverter _IPConverter;
    private String database;
    private String ip2regionDatabase;
    private String asnDatabase;
    private int cachesize;
    private String ipUrl;
    private static final Logger logger = LoggerFactory.getLogger(GeoIPUtil.class);
    private static boolean getGeoIPUtil;
    private static GeoIPUtil geoIPUtil;

    public Object getIspConverter() {
        return this.ispConverter;
    }

    public void setIspConverter(Object ispConverter) {
        this.ispConverter = ispConverter;
    }

    public GeoIPFilter getGeoIPFilter() {
        return this.geoIPFilter;
    }

    private boolean assertEmpty() {
        return SimpleStringUtil.isEmpty((String)this.database) || SimpleStringUtil.isEmpty((String)this.asnDatabase);
    }

    public void init() {
        if (!this.assertEmpty()) {
            if (this.ispConverter != null) {
                if (this.ispConverter instanceof IPConverter) {
                    this._IPConverter = (IPConverter)this.ispConverter;
                } else {
                    String cls = ((String)this.ispConverter).trim();
                    if (!cls.equals("")) {
                        try {
                            Class<?> clazz = Class.forName(cls);
                            this._IPConverter = (IPConverter)clazz.newInstance();
                        }
                        catch (ClassNotFoundException e) {
                            logger.warn(cls, (Throwable)e);
                            this._IPConverter = new DefaultIPConverter();
                        }
                        catch (IllegalAccessException e) {
                            logger.warn(cls, (Throwable)e);
                            this._IPConverter = new DefaultIPConverter();
                        }
                        catch (InstantiationException e) {
                            logger.warn(cls, (Throwable)e);
                            this._IPConverter = new DefaultIPConverter();
                        }
                    } else {
                        this._IPConverter = new DefaultIPConverter();
                    }
                }
            } else {
                this._IPConverter = new DefaultIPConverter();
            }
            this.geoIPFilter = new GeoIPFilter(this.database, this.asnDatabase, this.cachesize);
        }
        if (this.ip2regionDatabase != null && !this.ip2regionDatabase.equals("")) {
            IP2Region ip2Region = new IP2Region();
            ip2Region.init(this.ip2regionDatabase, false);
            this.ip2Region = ip2Region;
        }
    }

    public void setGeoIPFilter(GeoIPFilter geoIPFilter) {
        this.geoIPFilter = geoIPFilter;
    }

    public String getAsnDatabase() {
        return this.asnDatabase;
    }

    public void setAsnDatabase(String asnDatabase) {
        this.asnDatabase = asnDatabase;
    }

    public String getIpUrl() {
        return this.ipUrl;
    }

    public void setIpUrl(String ipUrl) {
        this.ipUrl = ipUrl;
    }

    public String getAddressResult(String ip) {
        StringBuilder url = new StringBuilder();
        url.append(this.ipUrl).append("?ip=").append(ip);
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "text/html;charset=UTF-8");
        header.put("User-Agent", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.121 Safari/537.36");
        try {
            return HttpRequestUtil.httpGetforString((String)url.toString(), header);
        }
        catch (Exception e) {
            url.setLength(0);
            url.append("\u83b7\u53d6\u8fd0\u8425\u5546\u533a\u57df\u4fe1\u606f\u5f02\u5e38:").append(this.ipUrl).append("?ip=").append(ip).append(",User-Agent:Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.121 Safari/537.36").append(",Content-Type:text/html;charset=UTF-8");
            throw new GeoIPHandlerException("\u83b7\u53d6\u8fd0\u8425\u5546\u533a\u57df\u4fe1\u606f\u5f02\u5e38:" + url.toString(), e);
        }
    }

    public IpInfo getAddressMapResult(String ip) {
        Map<Object, Object> geoData_;
        IpInfo ipInfo = null;
        if (this.ip2Region != null) {
            ipInfo = this.ip2Region.getAddressMapResult(ip);
        }
        Map<Object, Object> map = geoData_ = this.geoIPFilter != null ? this.geoIPFilter.handleIp(ip) : new HashMap();
        if (geoData_ != null && geoData_.size() > 0) {
            Map<String, Object> asnData_ = this.geoIPFilter.handleIpAsn(ip);
            if (ipInfo == null) {
                ipInfo = new IpInfo();
                ipInfo.setIp(ip);
            }
            if (ipInfo.getArea() == null || ipInfo.getArea().equals("0")) {
                ipInfo.setArea("");
                ipInfo.setAreaId("");
            }
            if (ipInfo.getCity() == null || ipInfo.getCity().equals("0")) {
                ipInfo.setCity((String)geoData_.get("cityName"));
                ipInfo.setCityId("");
            }
            if (ipInfo.getCountry() == null || ipInfo.getCountry().equals("0")) {
                ipInfo.setCountry((String)geoData_.get("countryName"));
            }
            ipInfo.setCountryId((String)geoData_.get("countryCode2"));
            if (ipInfo.getIsp() == null || ipInfo.getIsp().equals("0")) {
                ipInfo.setIsp((String)asnData_.get("asOrg"));
                ipInfo.setOrinIsp((String)asnData_.get("orinIsp"));
                ipInfo.setIspId((Integer)asnData_.get("asn"));
            }
            if (ipInfo.getRegion() == null || ipInfo.getRegion().equals("0")) {
                ipInfo.setRegion((String)geoData_.get("regionName"));
                ipInfo.setRegionId((String)geoData_.get("regionCode"));
            }
            Double latitude = (Double)geoData_.get("latitude");
            Double longitude = (Double)geoData_.get("longitude");
            GeoPoint geoPoint = new GeoPoint();
            geoPoint.setLat(latitude.doubleValue());
            geoPoint.setLon(longitude.doubleValue());
            ipInfo.setGeoPoint(geoPoint);
            this._IPConverter.convert(ipInfo);
            return ipInfo;
        }
        if (ipInfo == null) {
            ipInfo = new IpInfo();
            ipInfo.setArea("");
            ipInfo.setAreaId("");
            ipInfo.setCity("\u672a\u77e5");
            ipInfo.setCityId("\u672a\u77e5");
            ipInfo.setCountry("\u672a\u77e5");
            ipInfo.setCountryId("\u672a\u77e5");
            ipInfo.setCounty("\u672a\u77e5");
            ipInfo.setCountyId("\u672a\u77e5");
            ipInfo.setIp(ip);
            ipInfo.setIsp("\u672a\u77e5");
            ipInfo.setIspId(null);
            ipInfo.setRegion("\u672a\u77e5");
            ipInfo.setRegionId("\u672a\u77e5");
            return ipInfo;
        }
        if (ipInfo.getIsp() == null || ipInfo.getIsp().equals("0")) {
            ipInfo.setIsp("\u672a\u77e5");
        }
        if (ipInfo.getArea() == null || ipInfo.getArea().equals("0")) {
            ipInfo.setArea("\u672a\u77e5");
        }
        if (ipInfo.getCountry() == null || ipInfo.getCountry().equals("0")) {
            ipInfo.setCountry("\u672a\u77e5");
        }
        if (ipInfo.getRegion() == null || ipInfo.getRegion().equals("0")) {
            ipInfo.setRegion("\u672a\u77e5");
        }
        if (ipInfo.getCity() == null || ipInfo.getCity().equals("0")) {
            ipInfo.setCity("\u672a\u77e5");
        }
        this._IPConverter.convert(ipInfo);
        return ipInfo;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public int getCachesize() {
        return this.cachesize;
    }

    public void setCachesize(int cachesize) {
        this.cachesize = cachesize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GeoIPUtil getGeoIPUtil(Map<String, Object> geoipConfig) {
        if (getGeoIPUtil) {
            return geoIPUtil;
        }
        Class<GeoIPUtil> clazz = GeoIPUtil.class;
        synchronized (GeoIPUtil.class) {
            if (getGeoIPUtil) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return geoIPUtil;
            }
            getGeoIPUtil = true;
            if (geoIPUtil == null) {
                try {
                    if (geoipConfig == null) {
                        geoipConfig = ElasticSearchHelper.getGeoipConfig();
                    }
                    if (geoipConfig == null || geoipConfig.size() == 0) {
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return null;
                    }
                    GeoIPUtil geoIPUtil = new GeoIPUtil();
                    geoIPUtil.setDatabase((String)geoipConfig.get("ip.database"));
                    geoIPUtil.setAsnDatabase((String)geoipConfig.get("ip.asnDatabase"));
                    geoIPUtil.setIp2regionDatabase((String)geoipConfig.get("ip.ip2regionDatabase"));
                    geoIPUtil.setIspConverter(geoipConfig.get("ip.ispConverter"));
                    String _cachsize = (String)geoipConfig.get("ip.cachesize");
                    if (_cachsize != null) {
                        try {
                            geoIPUtil.setCachesize(Integer.parseInt(_cachsize));
                        }
                        catch (Exception e) {
                            logger.info("getGeoIPUtil ip.cachesize must be a number:" + _cachsize, (Throwable)e);
                        }
                    }
                    geoIPUtil.setIpUrl((String)geoipConfig.get("ip.serviceUrl"));
                    geoIPUtil.init();
                    GeoIPUtil.geoIPUtil = geoIPUtil;
                }
                catch (Exception e) {
                    logger.info("getGeoIPUtil failed:", (Throwable)e);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return geoIPUtil;
        }
    }

    public String getIp2regionDatabase() {
        return this.ip2regionDatabase;
    }

    public void setIp2regionDatabase(String ip2regionDatabase) {
        this.ip2regionDatabase = ip2regionDatabase;
    }
}

